/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourcePrefixDetector
extends ResourceXmlDetector
implements Detector.BinaryResourceScanner {
    public static final Issue ISSUE = Issue.create((String)"ResourceName", (String)"Resource with Wrong Prefix", (String)"In Gradle projects you can specify a resource prefix that all resources in the project must conform to. This makes it easier to ensure that you don't accidentally combine resources from different libraries, since they all end up in the same shared app namespace.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(ResourcePrefixDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.BINARY_RESOURCE_FILE), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.BINARY_RESOURCE_FILE_SCOPE}));
    private String mPrefix;

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("resources", "declare-styleable");
    }

    private static String computeResourcePrefix(Project project) {
        if (project.isGradleProject()) {
            return LintUtils.computeResourcePrefix((AndroidProject)project.getGradleProjectModel());
        }
        return null;
    }

    public void beforeCheckProject(Context context) {
        this.mPrefix = ResourcePrefixDetector.computeResourcePrefix(context.getProject());
    }

    public void beforeCheckLibraryProject(Context context) {
        this.mPrefix = ResourcePrefixDetector.computeResourcePrefix(context.getProject());
    }

    public void afterCheckProject(Context context) {
        this.mPrefix = null;
    }

    public void afterCheckLibraryProject(Context context) {
        this.mPrefix = null;
    }

    public void beforeCheckFile(Context context) {
        String name;
        XmlContext xmlContext;
        ResourceFolderType folderType;
        if (this.mPrefix != null && context instanceof XmlContext && (folderType = (xmlContext = (XmlContext)context).getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !(name = LintUtils.getBaseName((String)context.file.getName())).startsWith(this.mPrefix)) {
            Element root;
            if (xmlContext.document != null && (root = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(ISSUE, (Node)root, xmlContext.getLocation((Node)root), this.getErrorMessage(name));
                return;
            }
            context.report(ISSUE, Location.create((File)context.file), this.getErrorMessage(name));
        }
    }

    private String getErrorMessage(String name) {
        assert (this.mPrefix != null && !name.startsWith(this.mPrefix));
        return String.format("Resource named '`%1$s`' does not start with the project's resource prefix '`%2$s`'; rename to '`%3$s`' ?", name, this.mPrefix, LintUtils.computeResourceName((String)this.mPrefix, (String)name));
    }

    public void visitElement(XmlContext context, Element element) {
        if (this.mPrefix == null || context.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        for (Element item : LintUtils.getChildren((Node)element)) {
            String name;
            Attr nameAttribute = item.getAttributeNode("name");
            if (nameAttribute == null || (name = nameAttribute.getValue()).startsWith(this.mPrefix)) continue;
            String message = this.getErrorMessage(name);
            context.report(ISSUE, (Node)nameAttribute, context.getLocation((Node)nameAttribute), message);
        }
    }

    public void checkBinaryResource(ResourceContext context) {
        String name;
        ResourceFolderType folderType;
        if (this.mPrefix != null && (folderType = context.getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !(name = LintUtils.getBaseName((String)context.file.getName())).startsWith(this.mPrefix)) {
            Location location = Location.create((File)context.file);
            context.report(ISSUE, location, this.getErrorMessage(name));
        }
    }
}

