/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners;

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/EventDispatcher", "create"));
        }
        return new EventDispatcher<T>(listenerClass);
    }

    private EventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerClass", "com/intellij/util/EventDispatcher", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        LOG.assertTrue(listenerClass.isInterface(), "listenerClass must be an interface");
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                EventDispatcher.this.dispatch(method, args);
                return null;
            }
        };
        this.myMulticaster = (EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
    }

    @NotNull
    public T getMulticaster() {
        T t = this.myMulticaster;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EventDispatcher", "getMulticaster"));
        }
        return t;
    }

    private void dispatch(@NotNull Method method, Object[] args) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/util/EventDispatcher", "dispatch"));
        }
        method.setAccessible(true);
        for (EventListener listener : this.myListeners) {
            try {
                method.invoke((Object)listener, args);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof AbstractMethodError) continue;
                LOG.error(cause);
            }
        }
    }

    public void addListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/EventDispatcher", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void addListener(@NotNull T listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/EventDispatcher", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/EventDispatcher", "addListener"));
        }
        this.addListener(listener);
        Disposer.register(parentDisposable, new Disposable((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            @Override
            public void dispose() {
                EventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public void removeListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/EventDispatcher", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    @NotNull
    public List<T> getListeners() {
        List<T> list = this.myListeners;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EventDispatcher", "getListeners"));
        }
        return list;
    }
}

