/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;

public abstract class AtomicNullableLazyValue<T>
extends NullableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("AtomicNullableLazyValue");
    private volatile T myValue;
    private volatile boolean myComputed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getValue() {
        boolean computed = this.myComputed;
        T value = this.myValue;
        if (computed) {
            return value;
        }
        AtomicNullableLazyValue atomicNullableLazyValue = this;
        synchronized (atomicNullableLazyValue) {
            computed = this.myComputed;
            value = this.myValue;
            if (!computed) {
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                value = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value;
                    this.myComputed = true;
                }
            }
        }
        return value;
    }
}

