/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.progress.OperationIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationsHierarchy {
    final AtomicLong sharedCounter;
    final LinkedList<Long> hierarchy;
    private OperationIdentifier id;

    public OperationsHierarchy(AtomicLong sharedCounter, LinkedList<Long> hierarchy) {
        assert (sharedCounter != null);
        assert (hierarchy != null);
        this.sharedCounter = sharedCounter;
        this.hierarchy = hierarchy;
    }

    public OperationIdentifier start() {
        if (this.id == null) {
            Long parent = this.hierarchy.isEmpty() ? null : this.hierarchy.getLast();
            long operationId = this.sharedCounter.incrementAndGet();
            this.hierarchy.addLast(operationId);
            this.id = new OperationIdentifier(operationId, parent);
        }
        return this.id;
    }

    public OperationIdentifier currentOperationId() {
        this.assertOperationStarted();
        return this.id;
    }

    public OperationIdentifier completeCurrentOperation() {
        OperationIdentifier currentOp = this.currentOperationId();
        this.assertHierarchyNotEmpty();
        Long last = this.hierarchy.getLast();
        if (currentOp.getId() == last.longValue()) {
            this.hierarchy.removeLast();
        } else {
            this.hierarchy.remove(currentOp.getId());
        }
        this.id = null;
        return currentOp;
    }

    private void assertOperationStarted() {
        if (this.id == null) {
            throw new NoActiveOperationFound("Cannot provide current operation id because the operation was not started or it was already completed.");
        }
    }

    private void assertHierarchyNotEmpty() {
        if (this.hierarchy.isEmpty()) {
            throw new HierarchyEmptyException("Unable to provide operation id because there are no active operations in the hierarchy. Was the hierarchy list tinkered with?");
        }
    }

    static class NoActiveOperationFound
    extends IllegalStateException {
        public NoActiveOperationFound(String message) {
            super(message);
        }
    }

    static class HierarchyEmptyException
    extends IllegalStateException {
        public HierarchyEmptyException(String message) {
            super(message);
        }
    }
}

