/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;

@ThreadSafe
public class ScriptUsageLocationReporter
implements ScriptExecutionListener,
UsageLocationReporter {
    private final Lock lock = new ReentrantLock();
    private final Map<String, ScriptSource> scripts = new HashMap<String, ScriptSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeScript(Script script) {
        this.lock.lock();
        try {
            ScriptSource scriptSource = script.getScriptSource();
            this.scripts.put(scriptSource.getFileName(), scriptSource);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void afterScript(Script script, Throwable result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLocation(DeprecatedFeatureUsage usage, StringBuilder target) {
        this.lock.lock();
        try {
            this.doReportLocation(usage, target);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doReportLocation(DeprecatedFeatureUsage usage, StringBuilder target) {
        int caller;
        List<StackTraceElement> stack = usage.getStack();
        if (stack.isEmpty()) {
            return;
        }
        StackTraceElement directCaller = stack.get(0);
        if (this.scripts.containsKey(directCaller.getFileName())) {
            this.reportStackTraceElement(directCaller, target);
            return;
        }
        for (caller = 1; caller < stack.size() && stack.get(caller).getClassName().equals(directCaller.getClassName()); ++caller) {
        }
        if (caller == stack.size()) {
            return;
        }
        StackTraceElement indirectCaller = stack.get(caller);
        if (this.scripts.containsKey(indirectCaller.getFileName())) {
            this.reportStackTraceElement(indirectCaller, target);
        }
    }

    private void reportStackTraceElement(StackTraceElement stackTraceElement, StringBuilder target) {
        ScriptSource scriptSource = this.scripts.get(stackTraceElement.getFileName());
        target.append(StringUtils.capitalize((String)scriptSource.getDisplayName()));
        if (stackTraceElement.getLineNumber() > 0) {
            target.append(": line ");
            target.append(stackTraceElement.getLineNumber());
        }
    }
}

