/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.Closeable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ReportedException;
import org.gradle.initialization.SettingsHandler;
import org.gradle.initialization.TasksCompletionListener;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.BuildOperationType;
import org.gradle.internal.progress.OperationIdGenerator;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncher
extends GradleLauncher {
    private final GradleInternal gradle;
    private final InitScriptHandler initScriptHandler;
    private final SettingsHandler settingsHandler;
    private final BuildLoader buildLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final LoggingManagerInternal loggingManager;
    private final BuildListener buildListener;
    private final ModelConfigurationListener modelConfigurationListener;
    private final TasksCompletionListener tasksCompletionListener;
    private final BuildCompletionListener buildCompletionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildExecuter buildExecuter;
    private final Closeable buildServices;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsHandler settingsHandler, BuildLoader buildLoader, BuildConfigurer buildConfigurer, ExceptionAnalyser exceptionAnalyser, LoggingManagerInternal loggingManager, BuildListener buildListener, ModelConfigurationListener modelConfigurationListener, TasksCompletionListener tasksCompletionListener, BuildCompletionListener buildCompletionListener, BuildOperationExecutor operationExecutor, BuildExecuter buildExecuter, Closeable buildServices) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsHandler = settingsHandler;
        this.buildLoader = buildLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.loggingManager = loggingManager;
        this.modelConfigurationListener = modelConfigurationListener;
        this.tasksCompletionListener = tasksCompletionListener;
        this.buildOperationExecutor = operationExecutor;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildServices = buildServices;
    }

    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public BuildResult run() {
        return this.doBuild(Stage.Build);
    }

    @Override
    public BuildResult getBuildAnalysis() {
        return this.doBuild(Stage.Configure);
    }

    private BuildResult doBuild(final Stage upTo) {
        this.loggingManager.start();
        return this.runRootBuildOperation(BuildOperationType.RUNNING_BUILD, new Factory<BuildResult>(){

            public BuildResult create() {
                DefaultGradleLauncher.this.buildListener.buildStarted(DefaultGradleLauncher.this.gradle);
                Throwable failure = null;
                try {
                    DefaultGradleLauncher.this.doBuildStages(upTo);
                }
                catch (Throwable t) {
                    failure = DefaultGradleLauncher.this.exceptionAnalyser.transform(t);
                }
                BuildResult buildResult = new BuildResult(DefaultGradleLauncher.this.gradle, failure);
                DefaultGradleLauncher.this.buildListener.buildFinished(buildResult);
                if (failure != null) {
                    throw new ReportedException(failure);
                }
                return buildResult;
            }
        });
    }

    private void doBuildStages(Stage upTo) {
        this.runBuildOperation(BuildOperationType.EVALUATING_INIT_SCRIPTS, new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.initScriptHandler.executeScripts(DefaultGradleLauncher.this.gradle);
            }
        });
        this.runBuildOperation(BuildOperationType.EVALUATING_SETTINGS, new Runnable(){

            public void run() {
                SettingsInternal settings = DefaultGradleLauncher.this.settingsHandler.findAndLoadSettings(DefaultGradleLauncher.this.gradle);
                DefaultGradleLauncher.this.buildListener.settingsEvaluated(settings);
                DefaultGradleLauncher.this.buildLoader.load(settings.getRootProject(), settings.getDefaultProject(), DefaultGradleLauncher.this.gradle, settings.getRootClassLoaderScope());
                DefaultGradleLauncher.this.buildListener.projectsLoaded(DefaultGradleLauncher.this.gradle);
            }
        });
        this.runBuildOperation(BuildOperationType.CONFIGURING_BUILD, new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.buildConfigurer.configure(DefaultGradleLauncher.this.gradle);
                if (!DefaultGradleLauncher.this.gradle.getStartParameter().isConfigureOnDemand()) {
                    DefaultGradleLauncher.this.buildListener.projectsEvaluated(DefaultGradleLauncher.this.gradle);
                }
                DefaultGradleLauncher.this.modelConfigurationListener.onConfigure(DefaultGradleLauncher.this.gradle);
            }
        });
        if (upTo == Stage.Configure) {
            return;
        }
        this.runBuildOperation(BuildOperationType.POPULATING_TASK_GRAPH, new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.buildExecuter.select(DefaultGradleLauncher.this.gradle);
                if (DefaultGradleLauncher.this.gradle.getStartParameter().isConfigureOnDemand()) {
                    DefaultGradleLauncher.this.buildListener.projectsEvaluated(DefaultGradleLauncher.this.gradle);
                }
            }
        });
        this.runBuildOperation(BuildOperationType.EXECUTING_TASKS, new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.buildExecuter.execute();
                DefaultGradleLauncher.this.tasksCompletionListener.onTasksFinished(DefaultGradleLauncher.this.gradle);
            }
        });
        assert (upTo == Stage.Build);
    }

    private <T> T runRootBuildOperation(BuildOperationType operationType, Factory<T> factory) {
        Object id = OperationIdGenerator.generateId(this.gradle);
        return this.buildOperationExecutor.run(id, operationType, factory);
    }

    private void runBuildOperation(BuildOperationType operationType, Runnable action) {
        Object id = OperationIdGenerator.generateId(operationType, this.gradle);
        this.buildOperationExecutor.run(id, operationType, action);
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    @Override
    public void addStandardOutputListener(StandardOutputListener listener) {
        this.loggingManager.addStandardOutputListener(listener);
    }

    @Override
    public void addStandardErrorListener(StandardOutputListener listener) {
        this.loggingManager.addStandardErrorListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.loggingManager.stop();
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Configure,
        Build;

    }
}

