/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.collect.Maps;
import groovy.lang.Script;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingScriptClassCompiler
implements ScriptClassCompiler {
    private final Map<Key, CompiledScript<?, ?>> cachedCompiledScripts = Maps.newHashMap();
    private final ScriptClassCompiler scriptClassCompiler;

    public CachingScriptClassCompiler(ScriptClassCompiler scriptClassCompiler) {
        this.scriptClassCompiler = scriptClassCompiler;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, ClassLoader classLoader, ClassLoaderId classLoaderId, CompileOperation<M> operation, String classpathClosureName, Class<T> scriptBaseClass, Action<? super ClassNode> verifier) {
        Key key = new Key(source.getClassName(), classLoader, operation.getId(), scriptBaseClass.getName());
        CompiledScript<T, M> compiledScript = (CompiledScript<T, M>)Cast.uncheckedCast(this.cachedCompiledScripts.get(key));
        if (compiledScript == null) {
            compiledScript = this.scriptClassCompiler.compile(source, classLoader, classLoaderId, operation, classpathClosureName, scriptBaseClass, verifier);
            this.cachedCompiledScripts.put(key, compiledScript);
        }
        return compiledScript;
    }

    private static class Key {
        private final String className;
        private final ClassLoader classLoader;
        private final String transformerId;
        private final String baseClassName;

        public Key(String className, ClassLoader classLoader, String transformerId, String baseClassName) {
            this.className = className;
            this.classLoader = classLoader;
            this.transformerId = transformerId;
            this.baseClassName = baseClassName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.baseClassName.equals(key.baseClassName) && this.classLoader.equals(key.classLoader) && this.className.equals(key.className) && this.transformerId.equals(key.transformerId);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.classLoader.hashCode();
            result = 31 * result + this.transformerId.hashCode();
            result = 31 * result + this.baseClassName.hashCode();
            return result;
        }
    }
}

