/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.coerce;

import groovy.lang.MetaProperty;
import java.lang.reflect.Method;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.api.internal.coerce.PropertySetTransformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToEnumTransformer
implements MethodArgumentsTransformer,
PropertySetTransformer {
    public static final StringToEnumTransformer INSTANCE = new StringToEnumTransformer();

    @Override
    public Object[] transform(Object target, final String methodName, Object ... args) {
        if (args.length != 1 || !(args[0] instanceof CharSequence)) {
            return args;
        }
        CharSequence charSequenceArg = (CharSequence)args[0];
        Method enumMethod = JavaReflectionUtil.findMethod(target.getClass(), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method method) {
                Class<?> parameterType;
                Class<?>[] parameterTypes = method.getParameterTypes();
                return method.getName().equals(methodName) && parameterTypes.length == 1 && (parameterType = parameterTypes[0]).isEnum();
            }
        });
        if (enumMethod == null) {
            return args;
        }
        Class<?> enumType = enumMethod.getParameterTypes()[0];
        return new Object[]{StringToEnumTransformer.toEnumValue(enumType, charSequenceArg)};
    }

    @Override
    public Object transformValue(Object target, MetaProperty property, Object value) {
        if (value instanceof CharSequence && property.getType().isEnum()) {
            Class enumType = property.getType();
            final String setterName = MetaProperty.getSetterName((String)property.getName());
            Method setter = JavaReflectionUtil.findMethod(target.getClass(), (Spec)new Spec<Method>(){

                public boolean isSatisfiedBy(Method element) {
                    return element.getName().equals(setterName) && element.getParameterTypes().length == 1;
                }
            });
            if (setter == null || setter.getParameterTypes()[0].equals(enumType)) {
                return StringToEnumTransformer.toEnumValue(enumType, (CharSequence)value);
            }
        }
        return value;
    }

    public static <T extends Enum<T>> T toEnumValue(Class<T> enumType, CharSequence charSequence) {
        EnumFromCharSequenceNotationParser<T> notationParser = new EnumFromCharSequenceNotationParser<T>(enumType);
        return notationParser.parseNotation(charSequence);
    }
}

