/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.DefaultFileSnapshotterSerializer;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.changedetection.state.MapMergeChangeListener;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;
import org.gradle.util.ChangeListener;
import org.gradle.util.NoOpChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileSnapshotter snapshotter;
    private TaskArtifactStateCacheAccess cacheAccess;

    public DefaultFileCollectionSnapshotter(FileSnapshotter snapshotter, TaskArtifactStateCacheAccess cacheAccess) {
        this.snapshotter = snapshotter;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void registerSerializers(SerializerRegistry<FileCollectionSnapshot> registry) {
        registry.register(FileCollectionSnapshotImpl.class, (Serializer)new DefaultFileSnapshotterSerializer());
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new FileCollectionSnapshotImpl(new HashMap<String, IncrementalFileSnapshot>());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection input) {
        final Set<File> files = input.getAsFileTree().getFiles();
        if (files.isEmpty()) {
            return new FileCollectionSnapshotImpl(Collections.<String, IncrementalFileSnapshot>emptyMap());
        }
        final HashMap<String, IncrementalFileSnapshot> snapshots = new HashMap<String, IncrementalFileSnapshot>();
        this.cacheAccess.useCache("Create file snapshot", new Runnable(){

            public void run() {
                for (File file : files) {
                    if (file.isFile()) {
                        snapshots.put(file.getAbsolutePath(), new FileHashSnapshot(DefaultFileCollectionSnapshotter.this.snapshotter.snapshot(file).getHash()));
                        continue;
                    }
                    if (file.isDirectory()) {
                        snapshots.put(file.getAbsolutePath(), new DirSnapshot());
                        continue;
                    }
                    snapshots.put(file.getAbsolutePath(), new MissingFileSnapshot());
                }
            }
        });
        return new FileCollectionSnapshotImpl(snapshots);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileCollectionSnapshotImpl
    implements FileCollectionSnapshot {
        final Map<String, IncrementalFileSnapshot> snapshots;

        public FileCollectionSnapshotImpl(Map<String, IncrementalFileSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        @Override
        public FileCollection getFiles() {
            ArrayList<File> files = new ArrayList<File>();
            for (Map.Entry<String, IncrementalFileSnapshot> entry : this.snapshots.entrySet()) {
                if (!(entry.getValue() instanceof FileHashSnapshot)) continue;
                files.add(new File(entry.getKey()));
            }
            return new SimpleFileCollection(files);
        }

        @Override
        public FilesSnapshotSet getSnapshot() {
            return new FilesSnapshotSet(){

                public FileSnapshot findSnapshot(File file) {
                    IncrementalFileSnapshot s = FileCollectionSnapshotImpl.this.snapshots.get(file.getAbsolutePath());
                    if (s instanceof FileSnapshot) {
                        return (FileSnapshot)((Object)s);
                    }
                    return null;
                }
            };
        }

        @Override
        public FileCollectionSnapshot.ChangeIterator<String> iterateChangesSince(FileCollectionSnapshot oldSnapshot) {
            FileCollectionSnapshotImpl other = (FileCollectionSnapshotImpl)oldSnapshot;
            final HashMap<String, IncrementalFileSnapshot> otherSnapshots = new HashMap<String, IncrementalFileSnapshot>(other.snapshots);
            final Iterator<String> currentFiles = this.snapshots.keySet().iterator();
            return new FileCollectionSnapshot.ChangeIterator<String>(){
                private Iterator<String> removedFiles;

                @Override
                public boolean next(ChangeListener<String> listener) {
                    while (currentFiles.hasNext()) {
                        String currentFile = (String)currentFiles.next();
                        IncrementalFileSnapshot otherFile = (IncrementalFileSnapshot)otherSnapshots.remove(currentFile);
                        if (otherFile == null) {
                            listener.added(currentFile);
                            return true;
                        }
                        if (FileCollectionSnapshotImpl.this.snapshots.get(currentFile).isUpToDate(otherFile)) continue;
                        listener.changed(currentFile);
                        return true;
                    }
                    if (this.removedFiles == null) {
                        this.removedFiles = otherSnapshots.keySet().iterator();
                    }
                    if (this.removedFiles.hasNext()) {
                        listener.removed(this.removedFiles.next());
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot oldSnapshot) {
            final FileCollectionSnapshotImpl other = (FileCollectionSnapshotImpl)oldSnapshot;
            return new FileCollectionSnapshot.Diff(){

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot) {
                    return this.applyTo(snapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
                }

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot, ChangeListener<FileCollectionSnapshot.Merge> listener) {
                    FileCollectionSnapshotImpl target = (FileCollectionSnapshotImpl)snapshot;
                    HashMap<String, IncrementalFileSnapshot> newSnapshots = new HashMap<String, IncrementalFileSnapshot>(target.snapshots);
                    FileCollectionSnapshotImpl.this.diff(FileCollectionSnapshotImpl.this.snapshots, other.snapshots, new MapMergeChangeListener<String, IncrementalFileSnapshot>(listener, newSnapshots));
                    return new FileCollectionSnapshotImpl(newSnapshots);
                }
            };
        }

        private void diff(Map<String, IncrementalFileSnapshot> snapshots, Map<String, IncrementalFileSnapshot> oldSnapshots, ChangeListener<Map.Entry<String, IncrementalFileSnapshot>> listener) {
            HashMap<String, IncrementalFileSnapshot> otherSnapshots = new HashMap<String, IncrementalFileSnapshot>(oldSnapshots);
            for (Map.Entry<String, IncrementalFileSnapshot> entry : snapshots.entrySet()) {
                IncrementalFileSnapshot otherFile = (IncrementalFileSnapshot)otherSnapshots.remove(entry.getKey());
                if (otherFile == null) {
                    listener.added(entry);
                    continue;
                }
                if (entry.getValue().isUpToDate(otherFile)) continue;
                listener.changed(entry);
            }
            for (Map.Entry<String, IncrementalFileSnapshot> entry : otherSnapshots.entrySet()) {
                listener.removed(entry);
            }
        }
    }

    static class MissingFileSnapshot
    implements IncrementalFileSnapshot {
        MissingFileSnapshot() {
        }

        public boolean isUpToDate(IncrementalFileSnapshot snapshot) {
            return snapshot instanceof MissingFileSnapshot;
        }
    }

    static class DirSnapshot
    implements IncrementalFileSnapshot {
        DirSnapshot() {
        }

        public boolean isUpToDate(IncrementalFileSnapshot snapshot) {
            return snapshot instanceof DirSnapshot;
        }
    }

    static class FileHashSnapshot
    implements IncrementalFileSnapshot,
    FileSnapshot {
        final byte[] hash;

        public FileHashSnapshot(byte[] hash) {
            this.hash = hash;
        }

        public boolean isUpToDate(IncrementalFileSnapshot snapshot) {
            if (!(snapshot instanceof FileHashSnapshot)) {
                return false;
            }
            FileHashSnapshot other = (FileHashSnapshot)snapshot;
            return Arrays.equals(this.hash, other.hash);
        }

        public String toString() {
            return new BigInteger(1, this.hash).toString(16);
        }

        public byte[] getHash() {
            return this.hash;
        }
    }

    static interface IncrementalFileSnapshot {
        public boolean isUpToDate(IncrementalFileSnapshot var1);
    }
}

