/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action.mq;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.mq.HgMqAppliedPatchAction;
import org.zmlx.hg4idea.action.mq.HgShowUnAppliedPatchesAction;
import org.zmlx.hg4idea.command.mq.HgQGotoCommand;
import org.zmlx.hg4idea.command.mq.HgQPopCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgQGotoFromLogAction
extends HgMqAppliedPatchAction {
    protected void actionPerformed(final @NotNull HgRepository repository, @NotNull VcsFullCommitDetails commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction", "actionPerformed"));
        }
        final Project project = repository.getProject();
        final Hash parentHash = (Hash)commit.getParents().get(0);
        final HgNameWithHashInfo parentPatchName = (HgNameWithHashInfo)ContainerUtil.find(repository.getMQAppliedPatches(), (Condition)new Condition<HgNameWithHashInfo>(){

            public boolean value(HgNameWithHashInfo info) {
                return info.getHash().equals(parentHash);
            }
        });
        new Task.Backgroundable(repository.getProject(), parentPatchName != null ? HgVcsMessages.message("hg4idea.mq.progress.goto", parentPatchName) : HgVcsMessages.message("hg4idea.mq.progress.pop", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/mq/HgQGotoFromLogAction$2", "run"));
                }
                if (parentPatchName != null) {
                    new HgQGotoCommand(repository).executeInCurrentThread(parentPatchName.getName());
                } else {
                    new HgQPopCommand(repository).executeInCurrentThread();
                }
            }

            public void onSuccess() {
                HgShowUnAppliedPatchesAction.showUnAppliedPatches(project, repository);
            }
        }.queue();
    }
}

