/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.internal.repository.CanceledByUserException;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.UrlOpener;
import com.android.utils.Pair;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;

@Deprecated
public class DownloadCache {
    private static final boolean DEBUG = System.getenv("SDKMAN_DEBUG_CACHE") != null;
    private static final String KEY_STATUS_CODE = "Status-Code";
    private static final String KEY_URL = "URL";
    private static final String BIN_FILE_PREFIX = "sdkbin";
    private static final String INFO_FILE_PREFIX = "sdkinf";
    private static final String REV_FILE_PREFIX = "-1_";
    private static final long MIN_TIME_EXPIRED_MS = 600000L;
    private static final long MAX_TIME_EXPIRED_MS = 14400000L;
    private static final int MAX_SMALL_FILE_SIZE = 655360;
    private static final String[] INFO_HTTP_HEADERS = new String[]{"Last-Modified", "ETag", "Content-Length", "Date"};
    private final FileOp mFileOp;
    private final File mCacheRoot;
    private final Strategy mStrategy;

    public DownloadCache(Strategy strategy) {
        this(FileOpUtils.create(), strategy);
    }

    public DownloadCache(FileOp fileOp, Strategy strategy) {
        this.mFileOp = fileOp;
        this.mCacheRoot = this.initCacheRoot();
        if (System.getenv("SDKMAN_DISABLE_CACHE") != null) {
            strategy = Strategy.DIRECT;
        }
        this.mStrategy = this.mCacheRoot == null ? Strategy.DIRECT : strategy;
    }

    public Strategy getStrategy() {
        return this.mStrategy;
    }

    public File getCacheRoot() {
        return this.mCacheRoot;
    }

    public long getCurrentSize() {
        long size = 0L;
        if (this.mCacheRoot != null) {
            File[] files;
            for (File f : files = this.mFileOp.listFiles(this.mCacheRoot)) {
                String name;
                if (!this.mFileOp.isFile(f) || !(name = f.getName()).startsWith(BIN_FILE_PREFIX) && !name.startsWith(INFO_FILE_PREFIX)) continue;
                size += f.length();
            }
        }
        return size;
    }

    public void clearCache() {
        if (this.mCacheRoot != null) {
            File[] files;
            for (File f : files = this.mFileOp.listFiles(this.mCacheRoot)) {
                String name;
                if (!this.mFileOp.isFile(f) || !(name = f.getName()).startsWith(BIN_FILE_PREFIX) && !name.startsWith(INFO_FILE_PREFIX)) continue;
                this.mFileOp.delete(f);
            }
        }
    }

    public void clearOldCache() {
        String prefix1 = "sdkbin-1_";
        String prefix2 = "sdkinf-1_";
        if (this.mCacheRoot != null) {
            File[] files;
            for (File f : files = this.mFileOp.listFiles(this.mCacheRoot)) {
                String name;
                if (!this.mFileOp.isFile(f) || !(name = f.getName()).startsWith(BIN_FILE_PREFIX) && !name.startsWith(INFO_FILE_PREFIX) || name.startsWith(prefix1) || name.startsWith(prefix2)) continue;
                this.mFileOp.delete(f);
            }
        }
    }

    protected File initCacheRoot() {
        try {
            File root = new File(AndroidLocation.getFolder());
            root = new File(root, "cache");
            if (!this.mFileOp.exists(root)) {
                this.mFileOp.mkdirs(root);
            }
            return root;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            return null;
        }
    }

    protected Pair<InputStream, HttpResponse> openUrl(String url, boolean needsMarkResetSupport, ITaskMonitor monitor, Header[] headers) throws IOException, CanceledByUserException {
        return UrlOpener.openUrl(url, needsMarkResetSupport, monitor, headers);
    }

    public Pair<InputStream, HttpResponse> openDirectUrl(String urlString, Header[] headers, ITaskMonitor monitor) throws IOException, CanceledByUserException {
        if (DEBUG) {
            System.out.println(String.format("%s : Direct download", urlString));
        }
        return this.openUrl(urlString, false, monitor, headers);
    }

    public Pair<InputStream, Integer> openDirectUrl(String urlString, ITaskMonitor monitor) throws IOException, CanceledByUserException {
        if (DEBUG) {
            System.out.println(String.format("%s : Direct download", urlString));
        }
        Pair<InputStream, HttpResponse> result = this.openUrl(urlString, false, monitor, null);
        return Pair.of((Object)result.getFirst(), (Object)((HttpResponse)result.getSecond()).getStatusLine().getStatusCode());
    }

    public InputStream openCachedUrl(String urlString, ITaskMonitor monitor) throws IOException, CanceledByUserException {
        if (this.mStrategy == Strategy.DIRECT) {
            Pair<InputStream, HttpResponse> result = this.openUrl(urlString, true, monitor, null);
            return (InputStream)result.getFirst();
        }
        File cached = new File(this.mCacheRoot, this.getCacheFilename(urlString));
        File info = new File(this.mCacheRoot, this.getInfoFilename(cached.getName()));
        boolean useCached = this.mFileOp.exists(cached);
        if (useCached && this.mStrategy == Strategy.FRESH_CACHE) {
            long cacheModifiedMs = this.mFileOp.lastModified(cached);
            boolean checkCache = true;
            Properties props = this.readInfo(info);
            if (props == null) {
                useCached = false;
            } else {
                long minExpiration = System.currentTimeMillis() - 600000L;
                boolean bl = checkCache = cacheModifiedMs < minExpiration;
                if (!checkCache && DEBUG) {
                    System.out.println(String.format("%s : Too fresh [%,d ms], not checking yet.", urlString, cacheModifiedMs - minExpiration));
                }
            }
            if (useCached && checkCache) {
                assert (props != null);
                String code = props.getProperty(KEY_STATUS_CODE, "");
                useCached = Integer.toString(200).equals(code);
                if (!useCached && DEBUG) {
                    System.out.println(String.format("%s : cache disabled by code %s", urlString, code));
                }
                if (useCached) {
                    try {
                        long length = Long.parseLong(props.getProperty("Content-Length", "-1"));
                        if (length >= 0L) {
                            boolean bl = useCached = length == this.mFileOp.length(cached);
                            if (!useCached && DEBUG) {
                                System.out.println(String.format("%s : cache disabled by length mismatch %d, expected %d", urlString, length, cached.length()));
                            }
                        }
                    }
                    catch (NumberFormatException length) {
                        // empty catch block
                    }
                }
                if (useCached) {
                    String etag = props.getProperty("ETag");
                    String lastMod = props.getProperty("Last-Modified");
                    if (etag != null || lastMod != null) {
                        AtomicInteger statusCode = new AtomicInteger(0);
                        InputStream is = null;
                        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(2);
                        if (etag != null) {
                            headers.add(new BasicHeader("If-None-Match", etag));
                        }
                        if (lastMod != null) {
                            headers.add(new BasicHeader("If-Modified-Since", lastMod));
                        }
                        if (!headers.isEmpty()) {
                            is = this.downloadAndCache(urlString, monitor, cached, info, headers.toArray(new Header[headers.size()]), statusCode);
                        }
                        if (is != null && statusCode.get() == 200) {
                            return is;
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            is = null;
                        }
                        if (statusCode.get() == 304) {
                            cached.setLastModified(System.currentTimeMillis());
                        } else {
                            useCached = false;
                            if (statusCode.get() == 404) {
                                return null;
                            }
                        }
                    } else {
                        long maxExpiration = System.currentTimeMillis() - 14400000L;
                        boolean bl = useCached = cacheModifiedMs >= maxExpiration;
                        if (!useCached && DEBUG) {
                            System.out.println(String.format("[%1$s] cache disabled by timestamp %2$tD %2$tT < %3$tD %3$tT", urlString, cacheModifiedMs, maxExpiration));
                        }
                    }
                }
            }
        }
        if (useCached) {
            try {
                InputStream is = this.readCachedFile(cached);
                if (is != null) {
                    if (DEBUG) {
                        System.out.println(String.format("%s : Use cached file", urlString));
                    }
                    return is;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!useCached && this.mStrategy == Strategy.ONLY_CACHE) {
            if (DEBUG) {
                System.out.println(String.format("%s : file not in cache", urlString));
            }
            return null;
        }
        try {
            this.mFileOp.delete(cached);
            this.mFileOp.delete(info);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.downloadAndCache(urlString, monitor, cached, info, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream readCachedFile(File cached) throws IOException {
        InputStream is = null;
        int inc = 65536;
        int curr = 0;
        long len = cached.length();
        assert (len < Integer.MAX_VALUE);
        if (len >= 655360L) {
            return null;
        }
        byte[] result = new byte[(int)(len > 0L ? len : (long)inc)];
        try {
            int n;
            is = this.mFileOp.newFileInputStream(cached);
            while ((n = is.read(result, curr, result.length - curr)) != -1) {
                if ((curr += n) != result.length) continue;
                byte[] temp = new byte[curr + inc];
                System.arraycopy(result, 0, temp, 0, curr);
                result = temp;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
            return byteArrayInputStream;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream downloadAndCache(String urlString, ITaskMonitor monitor, File cached, File info, Header[] headers, AtomicInteger outStatusCode) throws FileNotFoundException, IOException, CanceledByUserException {
        int n;
        InputStream is = null;
        OutputStream os = null;
        int inc = 65536;
        int curr = 0;
        byte[] result = new byte[inc];
        Pair<InputStream, HttpResponse> r = this.openUrl(urlString, true, monitor, headers);
        is = (InputStream)r.getFirst();
        HttpResponse response = (HttpResponse)r.getSecond();
        if (DEBUG) {
            System.out.println(String.format("%s : fetch: %s => %s", urlString, headers == null ? "" : Arrays.toString(headers), response.getStatusLine()));
        }
        int code = response.getStatusLine().getStatusCode();
        if (outStatusCode != null) {
            outStatusCode.set(code);
        }
        if (code != 200) {
            InputStream inputStream = null;
            return inputStream;
        }
        os = this.mFileOp.newFileOutputStream(cached);
        while ((n = is.read(result, curr, result.length - curr)) != -1) {
            if (os != null && n > 0) {
                os.write(result, curr, n);
            }
            if (os != null && (curr += n) > 655360) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    cached.delete();
                    info.delete();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                os = null;
            }
            if (curr != result.length) continue;
            byte[] temp = new byte[curr + inc];
            System.arraycopy(result, 0, temp, 0, curr);
            result = temp;
        }
        if (os != null) {
            try {
                os.close();
                os = null;
                this.saveInfo(urlString, response, info);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result, 0, curr);
        return byteArrayInputStream;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                try {
                    this.mFileOp.delete(cached);
                    this.mFileOp.delete(info);
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    private void saveInfo(String urlString, HttpResponse response, File info) throws IOException {
        Properties props = new Properties();
        props.setProperty(KEY_URL, urlString);
        props.setProperty(KEY_STATUS_CODE, Integer.toString(response.getStatusLine().getStatusCode()));
        for (String name : INFO_HTTP_HEADERS) {
            Header h = response.getFirstHeader(name);
            if (h == null) continue;
            props.setProperty(name, h.getValue());
        }
        this.mFileOp.saveProperties(info, props, "## Meta data for SDK Manager cache. Do not modify.");
    }

    private Properties readInfo(File info) {
        if (this.mFileOp.exists(info)) {
            return this.mFileOp.loadProperties(info);
        }
        return null;
    }

    private String getCacheFilename(String urlString) {
        int code = 0;
        int j = urlString.length();
        for (int i = 0; i < j; ++i) {
            code = code * 31 + urlString.charAt(i);
        }
        String hash = String.format("%08x", code);
        String leaf = urlString.toLowerCase(Locale.US);
        if (leaf.length() >= 2) {
            int index = urlString.lastIndexOf(47, leaf.length() - 2);
            leaf = urlString.substring(index + 1);
        }
        leaf = leaf.replaceAll("[^a-z0-9_-]+", "_");
        leaf = leaf.replaceAll("__+", "_");
        leaf = hash + '-' + leaf;
        String prefix = "sdkbin-1_";
        int n = 64 - prefix.length();
        if (leaf.length() > n) {
            leaf = leaf.substring(0, n);
        }
        return prefix + leaf;
    }

    private String getInfoFilename(String cacheFilename) {
        return cacheFilename.replaceFirst(BIN_FILE_PREFIX, INFO_FILE_PREFIX);
    }

    public static enum Strategy {
        ONLY_CACHE,
        SERVE_CACHE,
        FRESH_CACHE,
        DIRECT;

    }
}

