/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;

public class JpsPathVariablesConfigurationImpl
extends JpsElementBase<JpsPathVariablesConfigurationImpl>
implements JpsPathVariablesConfiguration {
    private Map<String, String> myPathVariables;

    public JpsPathVariablesConfigurationImpl() {
        this.myPathVariables = new LinkedHashMap<String, String>();
    }

    private JpsPathVariablesConfigurationImpl(Map<String, String> pathVariables) {
        this.myPathVariables = new LinkedHashMap<String, String>(pathVariables);
    }

    @NotNull
    public JpsPathVariablesConfigurationImpl createCopy() {
        JpsPathVariablesConfigurationImpl jpsPathVariablesConfigurationImpl = new JpsPathVariablesConfigurationImpl(this.myPathVariables);
        if (jpsPathVariablesConfigurationImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "createCopy"));
        }
        return jpsPathVariablesConfigurationImpl;
    }

    public void applyChanges(@NotNull JpsPathVariablesConfigurationImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "applyChanges"));
        }
    }

    @Override
    public void addPathVariable(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "addPathVariable"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "addPathVariable"));
        }
        this.myPathVariables.put(name, value);
    }

    @Override
    public void removePathVariable(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "removePathVariable"));
        }
        this.myPathVariables.remove(name);
    }

    @Override
    @Nullable
    public String getPathVariable(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "getPathVariable"));
        }
        return this.getUserVariableValue(name);
    }

    @Override
    @Nullable
    public String getUserVariableValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "getUserVariableValue"));
        }
        return this.myPathVariables.get(name);
    }

    @Override
    @NotNull
    public Map<String, String> getAllVariables() {
        Map<String, String> map = this.getAllUserVariables();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "getAllVariables"));
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, String> getAllUserVariables() {
        Map<String, String> map = Collections.unmodifiableMap(this.myPathVariables);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/serialization/impl/JpsPathVariablesConfigurationImpl", "getAllUserVariables"));
        }
        return map;
    }
}

