/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.openapi.util.Comparing;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.impl.JpsProjectElementReference;
import org.jetbrains.jps.model.impl.JpsRootElementBase;
import org.jetbrains.jps.model.impl.runConfiguration.JpsRunConfigurationImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.impl.JpsModuleImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfiguration;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.runConfiguration.JpsTypedRunConfiguration;

public class JpsProjectImpl
extends JpsRootElementBase<JpsProjectImpl>
implements JpsProject {
    private static final JpsElementCollectionRole<JpsElementReference<?>> EXTERNAL_REFERENCES_COLLECTION_ROLE = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"external reference"));
    private static final JpsElementCollectionRole<JpsRunConfiguration> RUN_CONFIGURATIONS_ROLE = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"run configuration"));
    private final JpsLibraryCollection myLibraryCollection;
    private String myName;

    public JpsProjectImpl(@NotNull JpsModel model, JpsEventDispatcher eventDispatcher) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/model/impl/JpsProjectImpl", "<init>"));
        }
        super(model, eventDispatcher);
        this.myName = "";
        this.myContainer.setChild(JpsModuleRole.MODULE_COLLECTION_ROLE);
        this.myContainer.setChild(EXTERNAL_REFERENCES_COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
        this.myContainer.setChild(RUN_CONFIGURATIONS_ROLE);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    public JpsProjectImpl(JpsProjectImpl original, JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(original, model, eventDispatcher);
        this.myName = "";
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/impl/JpsProjectImpl", "setName"));
        }
        if (!Comparing.equal((String)this.myName, (String)name)) {
            this.myName = name;
            this.fireElementChanged();
        }
    }

    public void addExternalReference(@NotNull JpsElementReference<?> reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addExternalReference"));
        }
        ((JpsElementCollection)this.myContainer.getChild(EXTERNAL_REFERENCES_COLLECTION_ROLE)).addChild(reference);
    }

    @NotNull
    public <P extends JpsElement, ModuleType extends JpsModuleType<P> & JpsElementTypeWithDefaultProperties<P>> JpsModule addModule(@NotNull String name, @NotNull ModuleType moduleType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addModule"));
        }
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addModule"));
        }
        JpsElementCollection collection = (JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE);
        JpsModule jpsModule = (JpsModule)collection.addChild(new JpsModuleImpl<JpsElement>((JpsModuleType<JpsElement>)moduleType, name, (JpsElement)((JpsElementTypeWithDefaultProperties<P>)moduleType).createDefaultProperties()));
        if (jpsModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addModule"));
        }
        return jpsModule;
    }

    @NotNull
    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(@NotNull String name, @NotNull LibraryType libraryType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addLibrary"));
        }
        if (libraryType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryType", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addLibrary"));
        }
        JpsLibrary jpsLibrary = this.myLibraryCollection.addLibrary(name, libraryType);
        if (jpsLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addLibrary"));
        }
        return jpsLibrary;
    }

    @NotNull
    public List<JpsModule> getModules() {
        List list = ((JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE)).getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getModules"));
        }
        return list;
    }

    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModule<P>> getModules(JpsModuleType<P> type) {
        Iterable iterable = ((JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE)).getElementsOfType(type);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getModules"));
        }
        return iterable;
    }

    public void addModule(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addModule"));
        }
        ((JpsElementCollection)this.myContainer.getChild(JpsModuleRole.MODULE_COLLECTION_ROLE)).addChild((JpsElement)module);
    }

    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        JpsLibraryCollection jpsLibraryCollection = this.myLibraryCollection;
        if (jpsLibraryCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getLibraryCollection"));
        }
        return jpsLibraryCollection;
    }

    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        JpsSdkReferencesTable jpsSdkReferencesTable = (JpsSdkReferencesTable)this.myContainer.getChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
        if (jpsSdkReferencesTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getSdkReferencesTable"));
        }
        return jpsSdkReferencesTable;
    }

    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedRunConfiguration<P>> getRunConfigurations(JpsRunConfigurationType<P> type) {
        Iterable iterable = this.getRunConfigurationsCollection().getElementsOfType(type);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getRunConfigurations"));
        }
        return iterable;
    }

    @NotNull
    public List<JpsRunConfiguration> getRunConfigurations() {
        List list = this.getRunConfigurationsCollection().getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "getRunConfigurations"));
        }
        return list;
    }

    @NotNull
    public <P extends JpsElement> JpsTypedRunConfiguration<P> addRunConfiguration(@NotNull String name, @NotNull JpsRunConfigurationType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addRunConfiguration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addRunConfiguration"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addRunConfiguration"));
        }
        JpsTypedRunConfiguration jpsTypedRunConfiguration = (JpsTypedRunConfiguration)this.getRunConfigurationsCollection().addChild(new JpsRunConfigurationImpl<P>(name, type, properties));
        if (jpsTypedRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "addRunConfiguration"));
        }
        return jpsTypedRunConfiguration;
    }

    private JpsElementCollection<JpsRunConfiguration> getRunConfigurationsCollection() {
        return (JpsElementCollection)this.myContainer.getChild(RUN_CONFIGURATIONS_ROLE);
    }

    @NotNull
    public JpsElementReference<JpsProject> createReference() {
        JpsProjectElementReference jpsProjectElementReference = new JpsProjectElementReference();
        if (jpsProjectElementReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsProjectImpl", "createReference"));
        }
        return jpsProjectElementReference;
    }
}

