/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WildcardFileNameMatcher
extends FileNameMatcherEx {
    private final String myPattern;
    private final MaskMatcher myMatcher;

    public WildcardFileNameMatcher(@NotNull @NonNls String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/openapi/fileTypes/WildcardFileNameMatcher", "<init>"));
        }
        this.myPattern = pattern;
        this.myMatcher = WildcardFileNameMatcher.createMatcher(pattern);
    }

    private static MaskMatcher createMatcher(String pattern) {
        int len = pattern.length();
        if (len > 1 && pattern.indexOf(63) < 0) {
            if (pattern.charAt(0) == '*' && pattern.indexOf(42, 1) < 0) {
                return new SuffixMatcher(pattern.substring(1));
            }
            if (pattern.indexOf(42) == len - 1) {
                return new PrefixMatcher(pattern.substring(0, len - 1));
            }
            if (len > 2 && pattern.charAt(0) == '*' && pattern.indexOf(42, 1) == len - 1) {
                return new InfixMatcher(pattern.substring(1, len - 1));
            }
        }
        return new RegexpMatcher(pattern);
    }

    public boolean acceptsCharSequence(@NonNls @NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/WildcardFileNameMatcher", "acceptsCharSequence"));
        }
        return this.myMatcher.matches(fileName);
    }

    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myPattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/WildcardFileNameMatcher", "getPresentableString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WildcardFileNameMatcher that = (WildcardFileNameMatcher)((Object)o);
        return this.myPattern.equals(that.myPattern);
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public String getPattern() {
        return this.myPattern;
    }

    private static final class InfixMatcher
    implements MaskMatcher {
        private final String myInfix;

        private InfixMatcher(String infix) {
            this.myInfix = infix;
        }

        @Override
        public boolean matches(CharSequence filename) {
            return StringUtil.contains((CharSequence)filename, (CharSequence)this.myInfix);
        }
    }

    private static final class PrefixMatcher
    implements MaskMatcher {
        private final String myPrefix;

        private PrefixMatcher(String prefix) {
            this.myPrefix = prefix;
        }

        @Override
        public boolean matches(CharSequence filename) {
            return StringUtil.startsWith((CharSequence)filename, (CharSequence)this.myPrefix);
        }
    }

    private static final class SuffixMatcher
    implements MaskMatcher {
        private final String mySuffix;

        private SuffixMatcher(String suffix) {
            this.mySuffix = suffix;
        }

        @Override
        public boolean matches(CharSequence filename) {
            return StringUtil.endsWith((CharSequence)filename, (CharSequence)this.mySuffix);
        }
    }

    private static final class RegexpMatcher
    implements MaskMatcher {
        private final Matcher myMatcher;

        private RegexpMatcher(String pattern) {
            this.myMatcher = PatternUtil.fromMask((String)pattern).matcher("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(CharSequence filename) {
            Matcher matcher = this.myMatcher;
            synchronized (matcher) {
                this.myMatcher.reset(filename);
                return this.myMatcher.matches();
            }
        }
    }

    private static interface MaskMatcher {
        public boolean matches(CharSequence var1);
    }
}

