/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.scala.AntScalaCompiler;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompiler;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompiler;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaCompilerFactory
implements CompilerFactory<ScalaJavaJointCompileSpec> {
    private final IsolatedAntBuilder antBuilder;
    private final JavaCompilerFactory javaCompilerFactory;
    private final CompilerDaemonFactory compilerDaemonFactory;
    private FileCollection scalaClasspath;
    private FileCollection zincClasspath;
    private final File rootProjectDirectory;

    public ScalaCompilerFactory(File rootProjectDirectory, IsolatedAntBuilder antBuilder, JavaCompilerFactory javaCompilerFactory, CompilerDaemonFactory compilerDaemonFactory, FileCollection scalaClasspath, FileCollection zincClasspath) {
        this.rootProjectDirectory = rootProjectDirectory;
        this.antBuilder = antBuilder;
        this.javaCompilerFactory = javaCompilerFactory;
        this.compilerDaemonFactory = compilerDaemonFactory;
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
    }

    public Compiler<ScalaJavaJointCompileSpec> newCompiler(ScalaJavaJointCompileSpec spec) {
        ScalaCompileOptions scalaOptions = (ScalaCompileOptions)spec.getScalaCompileOptions();
        Set scalaClasspathFiles = this.scalaClasspath.getFiles();
        if (scalaOptions.isUseAnt()) {
            AntScalaCompiler scalaCompiler = new AntScalaCompiler(this.antBuilder, scalaClasspathFiles);
            Compiler javaCompiler = this.javaCompilerFactory.createForJointCompilation(spec.getClass());
            return new NormalizingScalaCompiler((Compiler)new DefaultScalaJavaJointCompiler(scalaCompiler, (Compiler<JavaCompileSpec>)javaCompiler));
        }
        if (!scalaOptions.isFork()) {
            throw new GradleException("The Zinc based Scala compiler ('scalaCompileOptions.useAnt=false') requires forking ('scalaCompileOptions.fork=true'), but the latter is set to 'false'.");
        }
        Set zincClasspathFiles = this.zincClasspath.getFiles();
        DaemonScalaCompiler scalaCompiler = new DaemonScalaCompiler(this.rootProjectDirectory, (Compiler)new ZincScalaCompiler((Iterable)scalaClasspathFiles, (Iterable)zincClasspathFiles), this.compilerDaemonFactory, (Iterable)zincClasspathFiles);
        return new NormalizingScalaCompiler((Compiler)scalaCompiler);
    }
}

