/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.KeepClassSpecification;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public abstract class BaseProguardAction
extends ProguardConfigurable {
    protected static final List<String> JAR_FILTER = ImmutableList.of((Object)"!META-INF/MANIFEST.MF");
    protected final Configuration configuration = new Configuration();

    public BaseProguardAction() {
        this.configuration.useMixedCaseClassNames = false;
        this.configuration.programJars = new ClassPath();
        this.configuration.libraryJars = new ClassPath();
    }

    public void runProguard() throws IOException {
        new ProGuard(this.configuration).execute();
    }

    @Override
    public void keep(String keep) {
        ClassSpecification classSpecification;
        if (this.configuration.keep == null) {
            this.configuration.keep = Lists.newArrayList();
        }
        try {
            ConfigurationParser parser = new ConfigurationParser(new String[]{keep}, null);
            classSpecification = parser.parseClassSpecificationArguments();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        this.configuration.keep.add(new KeepClassSpecification(true, false, false, false, false, false, classSpecification));
    }

    public void dontshrink() {
        this.configuration.shrink = false;
    }

    public void dontobfuscate() {
        this.configuration.obfuscate = false;
    }

    public void dontoptimize() {
        this.configuration.optimize = false;
    }

    public void dontpreverify() {
        this.configuration.preverify = false;
    }

    public void keepattributes() {
        this.configuration.keepAttributes = Lists.newArrayListWithExpectedSize((int)0);
    }

    @Override
    public void dontwarn(String dontwarn) {
        if (this.configuration.warn == null) {
            this.configuration.warn = Lists.newArrayList();
        }
        dontwarn = ClassUtil.internalClassName((String)dontwarn);
        this.configuration.warn.addAll(ListUtil.commaSeparatedList((String)dontwarn));
    }

    public void dontwarn() {
        this.configuration.warn = Lists.newArrayList((Object[])new String[]{"**"});
    }

    public void dontnote() {
        this.configuration.note = Lists.newArrayList((Object[])new String[]{"**"});
    }

    public void forceprocessing() {
        this.configuration.lastModified = Long.MAX_VALUE;
    }

    protected void applyMapping(File testedMappingFile) {
        this.configuration.applyMapping = testedMappingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfigurationFile(File file) throws IOException, ParseException {
        ConfigurationParser parser = new ConfigurationParser(file, System.getProperties());
        try {
            parser.parse(this.configuration);
        }
        finally {
            parser.close();
        }
    }

    public void printconfiguration(File file) {
        this.configuration.printConfiguration = file;
    }

    protected void inJar(File jarFile) {
        BaseProguardAction.inputJar(this.configuration.programJars, jarFile, null);
    }

    protected void outJar(File file) {
        ClassPathEntry classPathEntry = new ClassPathEntry(file, true);
        this.configuration.programJars.add(classPathEntry);
    }

    protected void libraryJar(File jarFile) {
        BaseProguardAction.inputJar(this.configuration.libraryJars, jarFile, null);
    }

    protected static void inputJar(ClassPath classPath, File file, List<String> filter) {
        ClassPathEntry classPathEntry = new ClassPathEntry(file, false);
        if (filter != null) {
            classPathEntry.setFilter(filter);
        }
        classPath.add(classPathEntry);
    }
}

