/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingProcessLayoutsTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.BinaryFileProviderTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.JackTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class VariantScopeImpl
implements VariantScope {
    private GlobalScope globalScope;
    private BaseVariantData<? extends BaseVariantOutputData> variantData;
    private TransformManager transformManager;
    private Collection<Object> ndkBuildable;
    private Collection<File> ndkSoFolder;
    private File ndkObjFolder;
    private Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private File mergeResourceOutputDir;
    private AndroidTask<Task> preBuildTask;
    private AndroidTask<PrepareDependenciesTask> prepareDependenciesTask;
    private AndroidTask<ProcessAndroidResources> generateRClassTask;
    private AndroidTask<Task> sourceGenTask;
    private AndroidTask<Task> resourceGenTask;
    private AndroidTask<Task> assetGenTask;
    private AndroidTask<CheckManifest> checkManifestTask;
    private AndroidTask<RenderscriptCompile> renderscriptCompileTask;
    private AndroidTask<AidlCompile> aidlCompileTask;
    private AndroidTask<MergeResources> mergeResourcesTask;
    private AndroidTask<MergeSourceSetFolders> mergeAssetsTask;
    private AndroidTask<GenerateBuildConfig> generateBuildConfigTask;
    private AndroidTask<GenerateResValues> generateResValuesTask;
    private AndroidTask<ShaderCompile> shaderCompileTask;
    private AndroidTask<Sync> processJavaResourcesTask;
    private AndroidTask<TransformTask> mergeJavaResourcesTask;
    private AndroidTask<MergeSourceSetFolders> mergeJniLibsFolderTask;
    private AndroidTask<NdkCompile> ndkCompileTask;
    private AndroidTask<DataBindingExportBuildInfoTask> dataBindingExportInfoTask;
    private AndroidTask<DataBindingProcessLayoutsTask> dataBindingProcessLayoutsTask;
    private AndroidTask<? extends AbstractCompile> javaCompilerTask;
    private AndroidTask<? extends JavaCompile> javacTask;
    private AndroidTask<JackTask> jackTask;
    private AndroidTask<Task> compileTask;
    private AndroidTask<?> coverageReportTask;
    private FileSupplier mappingFileProviderTask;
    private AndroidTask<BinaryFileProviderTask> binayFileProviderTask;
    private File resourceOutputDir;
    InstantRunBuildContext instantRunBuildContext = new InstantRunBuildContext();
    private AndroidTask<InstantRunWrapperTask> instantRunWrapperTask;
    private AndroidTask<InstantRunAnchorTask> instantRunAllActions;
    private AndroidTask<TransformTask> instantRunVerifierTask;

    public VariantScopeImpl(GlobalScope globalScope, TransformManager transformManager, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        this.globalScope = globalScope;
        this.transformManager = transformManager;
        this.variantData = variantData;
    }

    @Override
    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    public BaseVariantData<? extends BaseVariantOutputData> getVariantData() {
        return this.variantData;
    }

    @Override
    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantData.getVariantConfiguration();
    }

    @Override
    public String getDirName() {
        return this.variantData.getVariantConfiguration().getDirName();
    }

    @Override
    public Collection<String> getDirectorySegments() {
        return this.variantData.getVariantConfiguration().getDirectorySegments();
    }

    @Override
    public TransformManager getTransformManager() {
        return this.transformManager;
    }

    @Override
    public String getTaskName(String prefix) {
        return this.getTaskName(prefix, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return prefix + StringHelper.capitalize((String)this.getVariantConfiguration().getFullName()) + suffix;
    }

    @Override
    public Collection<Object> getNdkBuildable() {
        return this.ndkBuildable;
    }

    @Override
    public void setNdkBuildable(Collection<Object> ndkBuildable) {
        this.ndkBuildable = ndkBuildable;
    }

    @Override
    public AndroidTask<DataBindingExportBuildInfoTask> getDataBindingExportInfoTask() {
        return this.dataBindingExportInfoTask;
    }

    @Override
    public void setDataBindingExportInfoTask(AndroidTask<DataBindingExportBuildInfoTask> dataBindingExportInfoTask) {
        this.dataBindingExportInfoTask = dataBindingExportInfoTask;
    }

    @Override
    public AndroidTask<DataBindingProcessLayoutsTask> getDataBindingProcessLayoutsTask() {
        return this.dataBindingProcessLayoutsTask;
    }

    @Override
    public void setDataBindingProcessLayoutsTask(AndroidTask<DataBindingProcessLayoutsTask> dataBindingProcessLayoutsTask) {
        this.dataBindingProcessLayoutsTask = dataBindingProcessLayoutsTask;
    }

    @Override
    public Collection<File> getNdkSoFolder() {
        return this.ndkSoFolder;
    }

    @Override
    public void setNdkSoFolder(Collection<File> ndkSoFolder) {
        this.ndkSoFolder = ndkSoFolder;
    }

    @Override
    public File getNdkObjFolder() {
        return this.ndkObjFolder;
    }

    @Override
    public void setNdkObjFolder(File ndkObjFolder) {
        this.ndkObjFolder = ndkObjFolder;
    }

    @Override
    public File getNdkDebuggableLibraryFolders(Abi abi) {
        return this.ndkDebuggableLibraryFolders.get((Object)abi);
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public BaseVariantData getTestedVariantData() {
        return this.variantData instanceof TestVariantData ? (BaseVariantData)((Object)((TestVariantData)this.variantData).getTestedVariantData()) : null;
    }

    @Override
    public File getDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getReloadDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/reload-dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRestartDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/restart-dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/split-apk/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunPastIterationsFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/builds/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public FileCollection getJavaClasspath() {
        return this.getGlobalScope().getProject().files(new Object[]{this.getGlobalScope().getAndroidBuilder().getCompileClasspath((VariantConfiguration)this.getVariantData().getVariantConfiguration())});
    }

    @Override
    public File getJavaOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/classes/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/instant-run-support/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSliceSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/instant-run-slices/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalRuntimeSupportJar() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-runtime-classes/" + this.variantData.getVariantConfiguration().getDirName() + "/instant-run.jar");
    }

    @Override
    public File getIncrementalApplicationSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-classes/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalVerifierDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-verifier/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public Iterable<File> getJavaOuptuts() {
        return Iterables.concat((Iterable)this.getJavaClasspath(), (Iterable)ImmutableList.of((Object)this.getJavaOutputDir(), (Object)this.getJavaDependencyCache()));
    }

    @Override
    public File getJavaDependencyCache() {
        return new File(this.globalScope.getIntermediatesDir(), "/dependency-cache/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getPreDexOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/pre-dexed/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getProguardOutputFile() {
        return this.variantData instanceof LibraryVariantData ? new File(this.globalScope.getIntermediatesDir(), "bundles/" + this.getVariantConfiguration().getDirName() + "/classes.jar") : new File(this.globalScope.getIntermediatesDir(), "/classes-proguard/" + this.getVariantConfiguration().getDirName() + "/classes.jar");
    }

    @Override
    public File getProguardComponentsJarFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/componentClasses.jar");
    }

    @Override
    public File getJarMergingOutputFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/allclasses.jar");
    }

    @Override
    public File getManifestKeepListFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/manifest_keep.txt");
    }

    @Override
    public File getMainDexListFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/maindexlist.txt");
    }

    @Override
    public File getRenderscriptSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/rs/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRenderscriptLibOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "rs/" + this.variantData.getVariantConfiguration().getDirName() + "/lib");
    }

    @Override
    public File getSymbolLocation() {
        return new File(this.globalScope.getIntermediatesDir() + "/symbols/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getFinalResourcesDir() {
        return (File)Objects.firstNonNull((Object)this.resourceOutputDir, (Object)this.getDefaultMergeResourcesOutputDir());
    }

    @Override
    public void setResourceOutputDir(File resourceOutputDir) {
        this.resourceOutputDir = resourceOutputDir;
    }

    @Override
    public File getDefaultMergeResourcesOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/res/merged/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getMergeResourcesOutputDir() {
        if (this.mergeResourceOutputDir == null) {
            return this.getDefaultMergeResourcesOutputDir();
        }
        return this.mergeResourceOutputDir;
    }

    @Override
    public void setMergeResourceOutputDir(File mergeResourceOutputDir) {
        this.mergeResourceOutputDir = mergeResourceOutputDir;
    }

    @Override
    public File getResourceBlameLogDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"blame", "res", this.getDirectorySegments()}));
    }

    @Override
    public File getMergeAssetsOutputDir() {
        return this.getVariantConfiguration().getType() == VariantType.LIBRARY ? new File(this.globalScope.getIntermediatesDir(), "bundles/" + this.getVariantConfiguration().getDirName() + "/assets") : new File(this.globalScope.getIntermediatesDir(), "/assets/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getMergeNativeLibsOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"/jniLibs/" + this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getMergeShadersOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"/shaders/" + this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getBuildConfigSourceOutputDir() {
        return new File(this.globalScope.getBuildDir() + "/" + "generated" + "/source/buildConfig/" + this.variantData.getVariantConfiguration().getDirName());
    }

    private File getGeneratedResourcesDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"res", name, this.getDirectorySegments()}));
    }

    private File getGeneratedAssetsDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"assets", name, this.getDirectorySegments()}));
    }

    @Override
    public File getGeneratedResOutputDir() {
        return this.getGeneratedResourcesDir("resValues");
    }

    @Override
    public File getGeneratedPngsOutputDir() {
        return this.getGeneratedResourcesDir("pngs");
    }

    @Override
    public File getRenderscriptResOutputDir() {
        return this.getGeneratedResourcesDir("rs");
    }

    @Override
    public File getShadersOutputDir() {
        return this.getGeneratedAssetsDir("shaders");
    }

    @Override
    public File getPackagedJarsJavaResDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "packagedJarsJavaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getSourceFoldersJavaResDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "sourceFolderJavaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getJavaResourcesDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "javaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRClassSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/r/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getAidlSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/aidl/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalDir(String name) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"incremental", name});
    }

    @Override
    public File getPackagedAidlDir() {
        return new File(this.globalScope.getIntermediatesDir(), "bundles/" + this.getVariantConfiguration().getDirName() + "/aidl");
    }

    @Override
    public File getJillPackagedLibrariesDir() {
        return new File(this.globalScope.getIntermediatesDir(), "jill/" + this.getVariantConfiguration().getDirName() + "/packaged");
    }

    @Override
    public File getJillRuntimeLibrariesDir() {
        return new File(this.globalScope.getIntermediatesDir(), "jill/" + this.getVariantConfiguration().getDirName() + "/runtime");
    }

    @Override
    public File getJackDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getJackClassesZip() {
        return new File(this.globalScope.getIntermediatesDir(), "packaged/" + this.getVariantConfiguration().getDirName() + "/classes.zip");
    }

    @Override
    public File getClassOutputForDataBinding() {
        return new File(this.globalScope.getGeneratedDir(), "source/dataBinding/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getLayoutInfoOutputForDataBinding() {
        return new File(this.globalScope.getIntermediatesDir() + "/data-binding-info/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getLayoutFolderOutputForDataBinding() {
        return new File(this.globalScope.getIntermediatesDir() + "/data-binding-layout-out/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getGeneratedClassListOutputFileForDataBinding() {
        return new File(this.getLayoutInfoOutputForDataBinding(), "_generated.txt");
    }

    @Override
    public File getProguardOutputFolder() {
        return new File(this.globalScope.getBuildDir(), "/outputs/mapping/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getProcessAndroidResourcesProguardOutputFile() {
        return new File(this.globalScope.getIntermediatesDir(), "/proguard-rules/" + this.getVariantConfiguration().getDirName() + "/aapt_rules.txt");
    }

    @Override
    public File getMappingFile() {
        return new File(this.globalScope.getOutputsDir(), "/mapping/" + this.getVariantConfiguration().getDirName() + "/mapping.txt");
    }

    @Override
    public File getGenerateSplitAbiResOutputDirectory() {
        return new File(this.globalScope.getIntermediatesDir(), "abi/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getSplitOutputDirectory() {
        return new File(this.globalScope.getIntermediatesDir(), "splits/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public List<File> getSplitAbiResOutputFiles() {
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.globalScope.getExtension().getSplits().getAbiFilters());
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (String split : filters) {
            outputFiles.add(this.getOutputFileForSplit(split));
        }
        return outputFiles;
    }

    private File getOutputFileForSplit(String split) {
        return new File(this.getGenerateSplitAbiResOutputDirectory(), "resources-" + this.getVariantConfiguration().getBaseName() + "-" + split + ".ap_");
    }

    @Override
    public List<File> getPackageSplitAbiOutputFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String split : this.globalScope.getExtension().getSplits().getAbiFilters()) {
            String apkName = this.getApkName(split);
            builder.add((Object)new File(this.getSplitOutputDirectory(), apkName));
        }
        return builder.build();
    }

    private String getApkName(String split) {
        String archivesBaseName = this.globalScope.getArchivesBaseName();
        String apkName = archivesBaseName + "-" + this.getVariantConfiguration().getBaseName() + "_" + split;
        return apkName + (this.getVariantConfiguration().getSigningConfig() == null ? "-unsigned.apk" : "-unaligned.apk");
    }

    @Override
    public File getAaptFriendlyManifestOutputFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"bundles", this.getVariantConfiguration().getDirName(), "aapt", "AndroidManifest.xml"});
    }

    @Override
    public File getInstantRunManifestOutputFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"bundles", this.getVariantConfiguration().getDirName(), "instant-run", "AndroidManifest.xml"});
    }

    @Override
    public File getManifestReportFile() {
        return FileUtils.join((File)this.getGlobalScope().getOutputsDir(), (String[])new String[]{"logs", "manifest-merger-" + this.variantData.getVariantConfiguration().getBaseName() + "-report.txt"});
    }

    @Override
    public AndroidTask<Task> getPreBuildTask() {
        return this.preBuildTask;
    }

    @Override
    public void setPreBuildTask(AndroidTask<Task> preBuildTask) {
        this.preBuildTask = preBuildTask;
    }

    @Override
    public AndroidTask<PrepareDependenciesTask> getPrepareDependenciesTask() {
        return this.prepareDependenciesTask;
    }

    @Override
    public void setPrepareDependenciesTask(AndroidTask<PrepareDependenciesTask> prepareDependenciesTask) {
        this.prepareDependenciesTask = prepareDependenciesTask;
    }

    @Override
    public AndroidTask<ProcessAndroidResources> getGenerateRClassTask() {
        return this.generateRClassTask;
    }

    @Override
    public void setGenerateRClassTask(AndroidTask<ProcessAndroidResources> generateRClassTask) {
        this.generateRClassTask = generateRClassTask;
    }

    @Override
    public AndroidTask<Task> getSourceGenTask() {
        return this.sourceGenTask;
    }

    @Override
    public void setSourceGenTask(AndroidTask<Task> sourceGenTask) {
        this.sourceGenTask = sourceGenTask;
    }

    @Override
    public AndroidTask<Task> getResourceGenTask() {
        return this.resourceGenTask;
    }

    @Override
    public void setResourceGenTask(AndroidTask<Task> resourceGenTask) {
        this.resourceGenTask = resourceGenTask;
    }

    @Override
    public AndroidTask<Task> getAssetGenTask() {
        return this.assetGenTask;
    }

    @Override
    public void setAssetGenTask(AndroidTask<Task> assetGenTask) {
        this.assetGenTask = assetGenTask;
    }

    @Override
    public AndroidTask<CheckManifest> getCheckManifestTask() {
        return this.checkManifestTask;
    }

    @Override
    public void setCheckManifestTask(AndroidTask<CheckManifest> checkManifestTask) {
        this.checkManifestTask = checkManifestTask;
    }

    @Override
    public AndroidTask<RenderscriptCompile> getRenderscriptCompileTask() {
        return this.renderscriptCompileTask;
    }

    @Override
    public void setRenderscriptCompileTask(AndroidTask<RenderscriptCompile> renderscriptCompileTask) {
        this.renderscriptCompileTask = renderscriptCompileTask;
    }

    @Override
    public AndroidTask<AidlCompile> getAidlCompileTask() {
        return this.aidlCompileTask;
    }

    @Override
    public void setAidlCompileTask(AndroidTask<AidlCompile> aidlCompileTask) {
        this.aidlCompileTask = aidlCompileTask;
    }

    @Override
    public AndroidTask<ShaderCompile> getShaderCompileTask() {
        return this.shaderCompileTask;
    }

    @Override
    public void setShaderCompileTask(AndroidTask<ShaderCompile> shaderCompileTask) {
        this.shaderCompileTask = shaderCompileTask;
    }

    @Override
    public AndroidTask<MergeResources> getMergeResourcesTask() {
        return this.mergeResourcesTask;
    }

    @Override
    public void setMergeResourcesTask(AndroidTask<MergeResources> mergeResourcesTask) {
        this.mergeResourcesTask = mergeResourcesTask;
    }

    @Override
    public AndroidTask<MergeSourceSetFolders> getMergeAssetsTask() {
        return this.mergeAssetsTask;
    }

    @Override
    public void setMergeAssetsTask(AndroidTask<MergeSourceSetFolders> mergeAssetsTask) {
        this.mergeAssetsTask = mergeAssetsTask;
    }

    @Override
    public AndroidTask<MergeSourceSetFolders> getMergeJniLibFoldersTask() {
        return this.mergeJniLibsFolderTask;
    }

    @Override
    public void setMergeJniLibFoldersTask(AndroidTask<MergeSourceSetFolders> mergeJniLibsFolderTask) {
        this.mergeJniLibsFolderTask = mergeJniLibsFolderTask;
    }

    @Override
    public AndroidTask<GenerateBuildConfig> getGenerateBuildConfigTask() {
        return this.generateBuildConfigTask;
    }

    @Override
    public void setGenerateBuildConfigTask(AndroidTask<GenerateBuildConfig> generateBuildConfigTask) {
        this.generateBuildConfigTask = generateBuildConfigTask;
    }

    @Override
    public AndroidTask<GenerateResValues> getGenerateResValuesTask() {
        return this.generateResValuesTask;
    }

    @Override
    public void setGenerateResValuesTask(AndroidTask<GenerateResValues> generateResValuesTask) {
        this.generateResValuesTask = generateResValuesTask;
    }

    @Override
    public AndroidTask<Sync> getProcessJavaResourcesTask() {
        return this.processJavaResourcesTask;
    }

    @Override
    public void setProcessJavaResourcesTask(AndroidTask<Sync> processJavaResourcesTask) {
        this.processJavaResourcesTask = processJavaResourcesTask;
    }

    @Override
    public void setMergeJavaResourcesTask(AndroidTask<TransformTask> mergeJavaResourcesTask) {
        this.mergeJavaResourcesTask = mergeJavaResourcesTask;
    }

    @Override
    public AndroidTask<TransformTask> getMergeJavaResourcesTask() {
        return this.mergeJavaResourcesTask;
    }

    @Override
    public AndroidTask<? extends AbstractCompile> getJavaCompilerTask() {
        return this.javaCompilerTask;
    }

    @Override
    public AndroidTask<JackTask> getJackTask() {
        return this.jackTask;
    }

    @Override
    public void setJackTask(AndroidTask<JackTask> jackTask) {
        this.jackTask = jackTask;
    }

    @Override
    public AndroidTask<? extends JavaCompile> getJavacTask() {
        return this.javacTask;
    }

    @Override
    public void setJavacTask(AndroidTask<? extends JavaCompile> javacTask) {
        this.javacTask = javacTask;
    }

    @Override
    public void setJavaCompilerTask(AndroidTask<? extends AbstractCompile> javaCompileTask) {
        this.javaCompilerTask = javaCompileTask;
    }

    @Override
    public AndroidTask<Task> getCompileTask() {
        return this.compileTask;
    }

    @Override
    public void setCompileTask(AndroidTask<Task> compileTask) {
        this.compileTask = compileTask;
    }

    @Override
    public AndroidTask<?> getCoverageReportTask() {
        return this.coverageReportTask;
    }

    @Override
    public void setCoverageReportTask(AndroidTask<?> coverageReportTask) {
        this.coverageReportTask = coverageReportTask;
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.instantRunBuildContext;
    }

    @Override
    public AndroidTask<InstantRunWrapperTask> getInstantRunIncrementalTask() {
        return this.instantRunWrapperTask;
    }

    @Override
    public void setInstantRunIncrementalTask(AndroidTask<InstantRunWrapperTask> instantRunWrapperTask) {
        this.instantRunWrapperTask = instantRunWrapperTask;
    }

    @Override
    public AndroidTask<InstantRunAnchorTask> getInstantRunAnchorTask() {
        return this.instantRunAllActions;
    }

    @Override
    public void setInstantRunAnchorTask(AndroidTask<InstantRunAnchorTask> instantAllActionsTask) {
        this.instantRunAllActions = instantAllActionsTask;
    }

    @Override
    public AndroidTask<TransformTask> getInstantRunVerifierTask() {
        return this.instantRunVerifierTask;
    }

    @Override
    public void setInstantRunVerifierTask(AndroidTask<TransformTask> verifierTask) {
        this.instantRunVerifierTask = verifierTask;
    }
}

