/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.OutputFile;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.OptionalCompilationStep;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.coverage.JacocoReportTask;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.build.gradle.internal.dependency.ManifestDependencyImpl;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.ApkPublishArtifact;
import com.android.build.gradle.internal.publishing.MappingPublishArtifact;
import com.android.build.gradle.internal.publishing.MetadataPublishArtifact;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.InstallVariantTask;
import com.android.build.gradle.internal.tasks.MockableAndroidJarTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.tasks.SourceSetsTask;
import com.android.build.gradle.internal.tasks.TestServerTask;
import com.android.build.gradle.internal.tasks.UninstallTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingProcessLayoutsTask;
import com.android.build.gradle.internal.tasks.multidex.CreateManifestKeepList;
import com.android.build.gradle.internal.test.TestDataImpl;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.android.build.gradle.internal.transforms.InstantRunDex;
import com.android.build.gradle.internal.transforms.InstantRunSlicer;
import com.android.build.gradle.internal.transforms.InstantRunTransform;
import com.android.build.gradle.internal.transforms.InstantRunVerifierTransform;
import com.android.build.gradle.internal.transforms.JacocoTransform;
import com.android.build.gradle.internal.transforms.JarMergingTransform;
import com.android.build.gradle.internal.transforms.MergeJavaResourcesTransform;
import com.android.build.gradle.internal.transforms.MultiDexTransform;
import com.android.build.gradle.internal.transforms.NewShrinkerTransform;
import com.android.build.gradle.internal.transforms.NoChangesVerifierTransform;
import com.android.build.gradle.internal.transforms.ProGuardTransform;
import com.android.build.gradle.internal.transforms.ProguardConfigurable;
import com.android.build.gradle.internal.transforms.ShrinkResourcesTransform;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.AndroidJarTask;
import com.android.build.gradle.tasks.ColdswapArtifactsKickerTask;
import com.android.build.gradle.tasks.CompatibleScreensManifest;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.GenerateSplitAbiRes;
import com.android.build.gradle.tasks.JackTask;
import com.android.build.gradle.tasks.JillTask;
import com.android.build.gradle.tasks.Lint;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PackageSplitAbi;
import com.android.build.gradle.tasks.PackageSplitRes;
import com.android.build.gradle.tasks.PrePackageApplication;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.build.gradle.tasks.SplitZipAlign;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.build.gradle.tasks.factory.IncrementalSafeguard;
import com.android.build.gradle.tasks.factory.JavaCompileConfigAction;
import com.android.build.gradle.tasks.factory.ProcessJavaResConfigAction;
import com.android.build.gradle.tasks.factory.UnitTestConfigAction;
import com.android.build.gradle.tasks.fd.FastDeployRuntimeExtractorTask;
import com.android.build.gradle.tasks.fd.GenerateInstantRunAppInfoTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.BuilderConstants;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.manifmerger.ManifestMerger2;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class TaskManager {
    public static final String FILE_JACOCO_AGENT = "jacocoagent.jar";
    public static final String DEFAULT_PROGUARD_CONFIG_FILE = "proguard-android.txt";
    public static final String DIR_BUNDLES = "bundles";
    public static final String INSTALL_GROUP = "Install";
    public static final String BUILD_GROUP = "build";
    public static final String ANDROID_GROUP = "Android";
    protected Project project;
    protected AndroidBuilder androidBuilder;
    protected DataBindingBuilder dataBindingBuilder;
    private DependencyManager dependencyManager;
    protected SdkHandler sdkHandler;
    protected AndroidConfig extension;
    protected ToolingModelBuilderRegistry toolingRegistry;
    private final GlobalScope globalScope;
    private final AndroidTaskRegistry androidTasks = new AndroidTaskRegistry();
    private Logger logger;
    protected boolean isComponentModelPlugin = false;
    private static final String MAIN_PREBUILD = "preBuild";
    private static final String UNINSTALL_ALL = "uninstallAll";
    private static final String DEVICE_CHECK = "deviceCheck";
    protected static final String CONNECTED_CHECK = "connectedCheck";
    private static final String ASSEMBLE_ANDROID_TEST = "assembleAndroidTest";
    private static final String SOURCE_SETS = "sourceSets";
    private static final String LINT = "lint";
    protected static final String LINT_COMPILE = "compileLint";
    private static final Revision MIN_REVISION_RS_COMPAT_64 = Revision.parseRevision((String)"23.0.3");
    private Copy jacocoAgentTask;
    public AndroidTask<MockableAndroidJarTask> createMockableJar;

    public TaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        this.project = project;
        this.androidBuilder = androidBuilder;
        this.dataBindingBuilder = dataBindingBuilder;
        this.sdkHandler = sdkHandler;
        this.extension = extension;
        this.toolingRegistry = toolingRegistry;
        this.dependencyManager = dependencyManager;
        this.logger = Logging.getLogger(this.getClass());
        this.globalScope = new GlobalScope(project, androidBuilder, extension, sdkHandler, ndkHandler, toolingRegistry);
    }

    private boolean isVerbose() {
        return this.project.getLogger().isEnabled(LogLevel.INFO);
    }

    private boolean isDebugLog() {
        return this.project.getLogger().isEnabled(LogLevel.DEBUG);
    }

    public DataBindingBuilder getDataBindingBuilder() {
        return this.dataBindingBuilder;
    }

    public abstract void createTasksForVariantData(TaskFactory var1, BaseVariantData<? extends BaseVariantOutputData> var2);

    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    protected Collection<Object> getNdkBuildable(BaseVariantData variantData) {
        return Collections.singleton(variantData.ndkCompileTask);
    }

    public void configureScopeForNdk(VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setNdkSoFolder(Collections.singleton(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/lib")));
        File objFolder = new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj");
        scope.setNdkObjFolder(objFolder);
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getName()));
        }
    }

    protected AndroidConfig getExtension() {
        return this.extension;
    }

    public void resolveDependencies(VariantDependencies variantDeps, VariantDependencies testedVariantDeps, String testedProjectPath) {
        this.dependencyManager.resolveDependencies(variantDeps, testedVariantDeps, testedProjectPath);
    }

    public void createTasksBeforeEvaluate(TaskFactory tasks) {
        tasks.create(UNINSTALL_ALL, (Action<? super Task>)new Action<Task>(){

            public void execute(Task uninstallAllTask) {
                uninstallAllTask.setDescription("Uninstall all applications.");
                uninstallAllTask.setGroup(TaskManager.INSTALL_GROUP);
            }
        });
        tasks.create(DEVICE_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task deviceCheckTask) {
                deviceCheckTask.setDescription("Runs all device checks using Device Providers and Test Servers.");
                deviceCheckTask.setGroup("verification");
            }
        });
        tasks.create(CONNECTED_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task connectedCheckTask) {
                connectedCheckTask.setDescription("Runs all device checks on currently connected devices.");
                connectedCheckTask.setGroup("verification");
            }
        });
        tasks.create(MAIN_PREBUILD);
        tasks.create(SOURCE_SETS, SourceSetsTask.class, new Action<SourceSetsTask>(){

            public void execute(SourceSetsTask sourceSetsTask) {
                sourceSetsTask.setConfig(TaskManager.this.extension);
                sourceSetsTask.setDescription("Prints out all the source sets defined in this project.");
                sourceSetsTask.setGroup(TaskManager.ANDROID_GROUP);
            }
        });
        tasks.create(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)new Action<Task>(){

            public void execute(Task assembleAndroidTestTask) {
                assembleAndroidTestTask.setGroup(TaskManager.BUILD_GROUP);
                assembleAndroidTestTask.setDescription("Assembles all the Test applications.");
            }
        });
        tasks.create(LINT, Lint.class, new Action<Lint>(){

            public void execute(Lint lintTask) {
                lintTask.setDescription("Runs lint on all variants.");
                lintTask.setVariantName("");
                lintTask.setGroup("verification");
                lintTask.setLintOptions(TaskManager.this.getExtension().getLintOptions());
                lintTask.setSdkHome(TaskManager.this.sdkHandler.getSdkFolder());
                lintTask.setToolingRegistry(TaskManager.this.toolingRegistry);
                lintTask.setAndroidBuilder(TaskManager.this.androidBuilder);
            }
        });
        tasks.named("check", (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{TaskManager.LINT});
            }
        });
        this.createLintCompileTask(tasks);
    }

    public void createMockableJarTask(TaskFactory tasks) {
        this.createMockableJar = this.androidTasks.create(tasks, new MockableAndroidJarTask.ConfigAction(this.globalScope));
    }

    protected void createDependencyStreams(final VariantScope variantScope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = variantScope.getVariantData();
        final GradleVariantConfiguration config = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        ImmutableSet fullJar = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES, (Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS));
        transformManager.addStream(OriginalStream.builder().addContentTypes((Set<QualifiedContent.ContentType>)fullJar).addScope(QualifiedContent.Scope.PROJECT_LOCAL_DEPS).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getLocalPackagedJars();
            }
        }).build());
        IncrementalMode incrementalMode = this.getIncrementalMode(config);
        boolean skipDependency = incrementalMode == IncrementalMode.LOCAL_JAVA_ONLY || incrementalMode == IncrementalMode.LOCAL_RES_ONLY;
        ImmutableList dependencies = skipDependency ? ImmutableList.of() : ImmutableList.of((Object)((Object)variantData.prepareDependenciesTask), (Object)variantData.getVariantDependency().getPackageConfiguration().getBuildDependencies());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_JARS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                ImmutableSet files = config.getExternalPackagedJars();
                Set additions = variantScope.getGlobalScope().getAndroidBuilder().getAdditionalPackagedJars((VariantConfiguration)config);
                if (!additions.isEmpty()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    return builder.addAll((Iterable)files).addAll((Iterable)additions).build();
                }
                return files;
            }
        }).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                ImmutableSet files = config.getExternalPackagedJniJars();
                Set additions = variantScope.getGlobalScope().getAndroidBuilder().getAdditionalPackagedJars((VariantConfiguration)config);
                if (!additions.isEmpty()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    return builder.addAll((Iterable)files).addAll((Iterable)additions).build();
                }
                return files;
            }
        }).setFolders(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getExternalAarJniLibFolders();
            }
        }).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_JARS).addScope(QualifiedContent.Scope.SUB_PROJECTS).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getSubProjectPackagedJars();
            }
        }).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getSubProjectLocalPackagedJars();
            }
        }).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_NATIVE_LIBS).addScope(QualifiedContent.Scope.SUB_PROJECTS).setFolders(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getSubProjectJniLibFolders();
            }
        }).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getSubProjectPackagedJniJars();
            }
        }).setDependencies((List<? extends Object>)dependencies).build());
        transformManager.addStream(OriginalStream.builder().addContentTypes((Set<QualifiedContent.ContentType>)fullJar).addScope(QualifiedContent.Scope.PROVIDED_ONLY).setJars(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                return config.getProvidedOnlyJars();
            }
        }).build());
        if (variantScope.getTestedVariantData() != null) {
            final BaseVariantData testedVariantData = variantScope.getTestedVariantData();
            VariantScope testedVariantScope = testedVariantData.getScope();
            transformManager.addStream(OriginalStream.builder().addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope(QualifiedContent.Scope.TESTED_CODE).setFolders((Supplier<Collection<File>>)Suppliers.ofInstance((Object)ImmutableList.of((Object)testedVariantScope.getJavaOutputDir()))).setDependency(testedVariantScope.getJavacTask().getName()).build());
            transformManager.addStream(OriginalStream.builder().addContentTypes(new QualifiedContent.ContentType[]{QualifiedContent.DefaultContentType.CLASSES}).addScope(QualifiedContent.Scope.TESTED_CODE).setJars(new Supplier<Collection<File>>(){

                public Collection<File> get() {
                    return variantScope.getGlobalScope().getAndroidBuilder().getAllPackagedJars((VariantConfiguration)testedVariantData.getVariantConfiguration());
                }
            }).setDependency(ImmutableList.of((Object)((Object)testedVariantData.prepareDependenciesTask), (Object)testedVariantData.getVariantDependency().getPackageConfiguration().getBuildDependencies())).build());
        }
        this.handleJacocoDependencies(variantScope);
    }

    public void createMergeAppManifestsTask(TaskFactory tasks, VariantScope variantScope) {
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantScope.getVariantData();
        Set<String> screenSizes = appVariantData.getCompatibleScreens();
        for (ApkVariantOutputData vod : appVariantData.getOutputs()) {
            VariantOutputScope scope = vod.getScope();
            AndroidTask<CompatibleScreensManifest> csmTask = null;
            if (vod.getMainOutputFile().getFilter(OutputFile.DENSITY) != null) {
                csmTask = this.androidTasks.create(tasks, new CompatibleScreensManifest.ConfigAction(scope, screenSizes));
                scope.setCompatibleScreensManifestTask(csmTask);
            }
            ImmutableList optionalFeatures = this.getIncrementalMode(variantScope.getVariantConfiguration()) != IncrementalMode.NONE ? ImmutableList.of((Object)ManifestMerger2.Invoker.Feature.INSTANT_RUN_REPLACEMENT) : ImmutableList.of();
            scope.setManifestProcessorTask(this.androidTasks.create(tasks, new MergeManifests.ConfigAction(scope, (List<ManifestMerger2.Invoker.Feature>)optionalFeatures)));
            if (csmTask == null) continue;
            scope.getManifestProcessorTask().dependsOn(tasks, csmTask);
        }
    }

    public void createMergeLibManifestsTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<ProcessManifest> processManifest = this.androidTasks.create(tasks, new ProcessManifest.ConfigAction(scope));
        processManifest.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
        BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
        variantOutputData.getScope().setManifestProcessorTask(processManifest);
    }

    protected void createProcessTestManifestTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<ProcessTestManifest> processTestManifestTask = this.androidTasks.create(tasks, new ProcessTestManifest.ConfigAction(scope));
        processTestManifestTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
        BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
        variantOutputData.getScope().setManifestProcessorTask(processTestManifestTask);
    }

    public void createRenderscriptTask(TaskFactory tasks, VariantScope scope) {
        Revision rev;
        scope.setRenderscriptCompileTask(this.androidTasks.create(tasks, new RenderscriptCompile.ConfigAction(scope)));
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        if (config.getRenderscriptSupportModeEnabled() && config.getRenderscriptTarget() >= 21 && (rev = this.androidBuilder.getTargetInfo().getBuildTools().getRevision()).compareTo(MIN_REVISION_RS_COMPAT_64) < 0) {
            this.androidBuilder.getErrorReporter().handleSyncError(rev.toString(), 13, "Renderscript support mode is not supported with renderscript target 21+ in BuildTools " + rev.toString() + '\n' + "Please update to BuildTools " + MIN_REVISION_RS_COMPAT_64.toString() + " or above.");
        }
        BaseVariantOutputData variantOutputData = variantData.getOutputs().get(0);
        scope.getRenderscriptCompileTask().dependsOn(tasks, new Object[]{variantData.prepareDependenciesTask});
        if (config.getType().isForTesting()) {
            scope.getRenderscriptCompileTask().dependsOn(tasks, variantOutputData.getScope().getManifestProcessorTask());
        } else {
            scope.getRenderscriptCompileTask().dependsOn(tasks, scope.getCheckManifestTask());
        }
        scope.getResourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        if (!config.getRenderscriptNdkModeEnabled()) {
            scope.getSourceGenTask().dependsOn(tasks, scope.getRenderscriptCompileTask());
        }
    }

    public AndroidTask<MergeResources> createMergeResourcesTask(TaskFactory tasks, VariantScope scope) {
        return this.basicCreateMergeResourcesTask(tasks, scope, "merge", null, true, true);
    }

    public AndroidTask<MergeResources> basicCreateMergeResourcesTask(TaskFactory tasks, VariantScope scope, String taskNamePrefix, File outputLocation, boolean includeDependencies, boolean process9Patch) {
        AndroidTask<MergeResources> mergeResourcesTask = this.androidTasks.create(tasks, new MergeResources.ConfigAction(scope, taskNamePrefix, outputLocation, includeDependencies, process9Patch));
        if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.LOCAL_RES_ONLY) {
            mergeResourcesTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask, scope.getResourceGenTask()});
        }
        scope.setMergeResourcesTask(mergeResourcesTask);
        scope.setResourceOutputDir((File)Objects.firstNonNull((Object)outputLocation, (Object)scope.getDefaultMergeResourcesOutputDir()));
        scope.setMergeResourceOutputDir(outputLocation);
        return scope.getMergeResourcesTask();
    }

    public void createMergeAssetsTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<MergeSourceSetFolders> mergeAssetsTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeAssetConfigAction(scope));
        mergeAssetsTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask, scope.getAssetGenTask()});
        scope.setMergeAssetsTask(mergeAssetsTask);
    }

    public void createMergeJniLibFoldersTasks(TaskFactory tasks, final VariantScope variantScope) {
        AndroidTask<MergeSourceSetFolders> mergeJniLibFoldersTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeJniLibFoldersConfigAction(variantScope));
        mergeJniLibFoldersTask.dependsOn(tasks, new Object[]{variantScope.getVariantData().prepareDependenciesTask, variantScope.getAssetGenTask()});
        variantScope.setMergeJniLibFoldersTask(mergeJniLibFoldersTask);
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolder(variantScope.getMergeNativeLibsOutputDir()).setDependency(mergeJniLibFoldersTask.getName()).build());
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolders((Supplier<Collection<File>>)Suppliers.ofInstance(variantScope.getNdkSoFolder())).setDependency(this.getNdkBuildable(variantScope.getVariantData())).build());
        if (variantScope.getVariantConfiguration().getRenderscriptSupportModeEnabled()) {
            variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolders(new Supplier<Collection<File>>(){

                public Collection<File> get() {
                    File rsLibs;
                    ImmutableList.Builder builder = ImmutableList.builder();
                    if (variantScope.getRenderscriptLibOutputDir().isDirectory()) {
                        builder.add((Object)variantScope.getRenderscriptLibOutputDir());
                    }
                    if ((rsLibs = variantScope.getGlobalScope().getAndroidBuilder().getSupportNativeLibFolder()) != null && rsLibs.isDirectory()) {
                        builder.add((Object)rsLibs);
                    }
                    return builder.build();
                }
            }).setDependency(variantScope.getRenderscriptCompileTask().getName()).build());
        }
        Set<QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, ExtendedContentType.NATIVE_LIBS, "mergeJniLibs");
        variantScope.getTransformManager().addTransform(tasks, variantScope, mergeTransform);
    }

    public void createBuildConfigTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<GenerateBuildConfig> generateBuildConfigTask = this.androidTasks.create(tasks, new GenerateBuildConfig.ConfigAction(scope));
        scope.setGenerateBuildConfigTask(generateBuildConfigTask);
        scope.getSourceGenTask().dependsOn(tasks, generateBuildConfigTask.getName());
        if (scope.getVariantConfiguration().getType().isForTesting()) {
            BaseVariantOutputData variantOutputData = scope.getVariantData().getOutputs().get(0);
            generateBuildConfigTask.dependsOn(tasks, variantOutputData.getScope().getManifestProcessorTask());
        } else {
            generateBuildConfigTask.dependsOn(tasks, scope.getCheckManifestTask());
        }
    }

    public void createGenerateResValuesTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<GenerateResValues> generateResValuesTask = this.androidTasks.create(tasks, new GenerateResValues.ConfigAction(scope));
        scope.getResourceGenTask().dependsOn(tasks, generateResValuesTask);
    }

    public void createApkProcessResTask(TaskFactory tasks, VariantScope scope) {
        this.createProcessResTask(tasks, scope, new File(this.globalScope.getIntermediatesDir(), "symbols/" + scope.getVariantData().getVariantConfiguration().getDirName()), true);
    }

    public void createProcessResTask(TaskFactory tasks, VariantScope scope, File symbolLocation, boolean generateResourcePackage) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        variantData.calculateFilters(scope.getGlobalScope().getExtension().getSplits());
        for (BaseVariantOutputData baseVariantOutputData : variantData.getOutputs()) {
            VariantOutputScope variantOutputScope = baseVariantOutputData.getScope();
            variantOutputScope.setProcessResourcesTask(this.androidTasks.create(tasks, new ProcessAndroidResources.ConfigAction(variantOutputScope, symbolLocation, generateResourcePackage)));
            variantOutputScope.getProcessResourcesTask().dependsOn(tasks, scope.getMergeResourcesTask());
            if (scope.getDataBindingProcessLayoutsTask() != null) {
                variantOutputScope.getProcessResourcesTask().dependsOn(tasks, scope.getDataBindingProcessLayoutsTask().getName());
            }
            if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.LOCAL_RES_ONLY) {
                variantOutputScope.getProcessResourcesTask().dependsOn(tasks, variantOutputScope.getManifestProcessorTask(), scope.getMergeAssetsTask());
            }
            if (baseVariantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY) != null) continue;
            scope.setGenerateRClassTask(variantOutputScope.getProcessResourcesTask());
            scope.getSourceGenTask().optionalDependsOn(tasks, variantOutputScope.getProcessResourcesTask());
        }
    }

    public AndroidTask<PackageSplitRes> createSplitResourcesTasks(TaskFactory tasks, VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getSplitHandlingPolicy().equals((Object)BaseVariantData.SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY), (Object)"Can only create split resources tasks for pure splits.");
        List<? extends BaseVariantOutputData> outputs = variantData.getOutputs();
        BaseVariantOutputData variantOutputData = outputs.get(0);
        if (outputs.size() != 1) {
            throw new RuntimeException("In release 21 and later, there can be only one main APK, found " + outputs.size());
        }
        VariantOutputScope variantOutputScope = variantOutputData.getScope();
        AndroidTask<PackageSplitRes> packageSplitRes = this.androidTasks.create(tasks, new PackageSplitRes.ConfigAction(scope));
        packageSplitRes.dependsOn(tasks, variantOutputScope.getProcessResourcesTask().getName());
        return packageSplitRes;
    }

    public AndroidTask<PackageSplitAbi> createSplitAbiTasks(TaskFactory tasks, VariantScope scope) {
        ApplicationVariantData variantData = (ApplicationVariantData)scope.getVariantData();
        Preconditions.checkState((boolean)variantData.getSplitHandlingPolicy().equals((Object)BaseVariantData.SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY), (Object)"split ABI tasks are only compatible with pure splits.");
        ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.getExtension().getSplits().getAbiFilters());
        if (filters.isEmpty()) {
            return null;
        }
        List outputs = variantData.getOutputs();
        if (outputs.size() != 1) {
            throw new RuntimeException("In release 21 and later, there can be only one main APK, found " + outputs.size());
        }
        BaseVariantOutputData variantOutputData = (BaseVariantOutputData)outputs.get(0);
        AndroidTask<GenerateSplitAbiRes> generateSplitAbiRes = this.androidTasks.create(tasks, new GenerateSplitAbiRes.ConfigAction(scope));
        generateSplitAbiRes.dependsOn(tasks, variantOutputData.getScope().getProcessResourcesTask().getName());
        AndroidTask<PackageSplitAbi> packageSplitAbiTask = this.androidTasks.create(tasks, new PackageSplitAbi.ConfigAction(scope));
        packageSplitAbiTask.dependsOn(tasks, generateSplitAbiRes);
        packageSplitAbiTask.dependsOn(tasks, scope.getNdkBuildable());
        for (TransformStream stream : scope.getTransformManager().getStreams(PackageApplication.sNativeLibsFilter)) {
            packageSplitAbiTask.dependsOn(tasks, stream.getDependencies());
        }
        return packageSplitAbiTask;
    }

    public void createSplitTasks(TaskFactory tasks, final VariantScope scope) {
        AndroidTask<PackageSplitRes> packageSplitResourcesTask = this.createSplitResourcesTasks(tasks, scope);
        AndroidTask<PackageSplitAbi> packageSplitAbiTask = this.createSplitAbiTasks(tasks, scope);
        AndroidTask<SplitZipAlign> zipAlign = this.androidTasks.create(tasks, new SplitZipAlign.ConfigAction(scope));
        if (packageSplitAbiTask != null) {
            zipAlign.configure(tasks, new Action<Task>(){

                public void execute(Task task) {
                    ((SplitZipAlign)task).getAbiInputFiles().addAll(scope.getPackageSplitAbiOutputFiles());
                }
            });
        }
        zipAlign.dependsOn(tasks, packageSplitResourcesTask);
        zipAlign.optionalDependsOn(tasks, packageSplitAbiTask);
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        VariantOutputScope outputScope = variantData.getOutputs().get(0).getScope();
        outputScope.setSplitZipAlignTask(zipAlign);
    }

    protected abstract Set<QualifiedContent.Scope> getResMergingScopes(VariantScope var1);

    public void createProcessJavaResTasks(TaskFactory tasks, VariantScope variantScope) {
        TransformManager transformManager = variantScope.getTransformManager();
        AndroidTask<Sync> processJavaResourcesTask = this.androidTasks.create(tasks, new ProcessJavaResConfigAction(variantScope));
        variantScope.setProcessJavaResourcesTask(processJavaResourcesTask);
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope(QualifiedContent.Scope.PROJECT).setFolder(variantScope.getSourceFoldersJavaResDestinationDir()).setDependency(processJavaResourcesTask.getName()).build());
        Set<QualifiedContent.Scope> mergeScopes = this.getResMergingScopes(variantScope);
        MergeJavaResourcesTransform mergeTransform = new MergeJavaResourcesTransform(variantScope.getGlobalScope().getExtension().getPackagingOptions(), mergeScopes, (QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES, "mergeJavaRes");
        variantScope.setMergeJavaResourcesTask(transformManager.addTransform(tasks, variantScope, mergeTransform));
    }

    public void createAidlTask(TaskFactory tasks, VariantScope scope) {
        scope.setAidlCompileTask(this.androidTasks.create(tasks, new AidlCompile.ConfigAction(scope)));
        scope.getSourceGenTask().dependsOn(tasks, scope.getAidlCompileTask());
        scope.getAidlCompileTask().dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
    }

    public void createShaderTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<MergeSourceSetFolders> mergeShadersTask = this.androidTasks.create(tasks, new MergeSourceSetFolders.MergeShaderSourceFoldersConfigAction(scope));
        AndroidTask<ShaderCompile> shaderCompileTask = this.androidTasks.create(tasks, new ShaderCompile.ConfigAction(scope));
        scope.setShaderCompileTask(shaderCompileTask);
        shaderCompileTask.dependsOn(tasks, mergeShadersTask);
        scope.getAssetGenTask().dependsOn(tasks, shaderCompileTask);
    }

    public AndroidTask<? extends JavaCompile> createJavacTask(TaskFactory tasks, final VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        AndroidTask<IncrementalSafeguard> javacIncrementalSafeguard = this.androidTasks.create(tasks, new IncrementalSafeguard.ConfigAction(scope));
        final AndroidTask<AndroidJavaCompile> javacTask = this.androidTasks.create(tasks, new JavaCompileConfigAction(scope));
        scope.setJavacTask(javacTask);
        javacTask.dependsOn(tasks, javacIncrementalSafeguard);
        this.setupCompileTaskDependencies(tasks, scope, javacTask);
        scope.getTransformManager().addStream(OriginalStream.builder().addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES).addScope(QualifiedContent.Scope.PROJECT).setFolder(scope.getJavaOutputDir()).setDependency(javacTask.getName()).build());
        if (variantData.getVariantDependency().getClassesConfiguration() != null) {
            tasks.create(scope.getTaskName("package", "JarArtifact"), Jar.class, new Action<Jar>(){

                public void execute(Jar jar) {
                    variantData.classesJarTask = jar;
                    jar.dependsOn(new Object[]{javacTask.getName()});
                    jar.from(new Object[]{scope.getJavaOutputDir()});
                    jar.setDestinationDir(new File(scope.getGlobalScope().getIntermediatesDir(), "classes-jar/" + variantData.getVariantConfiguration().getDirName()));
                    jar.setArchiveName("classes.jar");
                }
            });
        }
        return javacTask;
    }

    private void setupCompileTaskDependencies(TaskFactory tasks, VariantScope scope, AndroidTask<?> compileTask) {
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        IncrementalMode incrementalMode = this.getIncrementalMode(scope.getVariantConfiguration());
        if (incrementalMode == IncrementalMode.LOCAL_RES_ONLY) {
            compileTask.optionalDependsOn(tasks, scope.getGenerateRClassTask());
        } else if (incrementalMode != IncrementalMode.LOCAL_JAVA_ONLY) {
            compileTask.optionalDependsOn(tasks, scope.getSourceGenTask());
            compileTask.dependsOn(tasks, new Object[]{scope.getVariantData().prepareDependenciesTask});
            compileTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getCompileConfiguration().getBuildDependencies());
        }
    }

    public static void setJavaCompilerTask(AndroidTask<? extends AbstractCompile> javaCompilerTask, TaskFactory tasks, VariantScope scope) {
        scope.getCompileTask().dependsOn(tasks, javaCompilerTask);
        scope.setJavaCompilerTask(javaCompilerTask);
        if (scope.getVariantData().javacTask != null) {
            scope.getVariantData().javaCompilerTask = (AbstractCompile)tasks.named(javaCompilerTask.getName());
        }
    }

    public void createGenerateMicroApkDataTask(TaskFactory tasks, VariantScope scope, Configuration config) {
        AndroidTask<GenerateApkDataTask> generateMicroApkTask = this.androidTasks.create(tasks, new GenerateApkDataTask.ConfigAction(scope, config));
        generateMicroApkTask.dependsOn(tasks, config);
        scope.getResourceGenTask().dependsOn(tasks, generateMicroApkTask);
    }

    public void createNdkTasks(VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        NdkCompile ndkCompile = (NdkCompile)this.project.getTasks().create(scope.getTaskName("compile", "Ndk"), NdkCompile.class);
        ndkCompile.dependsOn(new Object[]{variantData.preBuildTask});
        ndkCompile.setAndroidBuilder(this.androidBuilder);
        ndkCompile.setVariantName(variantData.getName());
        ndkCompile.setNdkDirectory(this.sdkHandler.getNdkFolder());
        ndkCompile.setIsForTesting(variantData.getType().isForTesting());
        variantData.ndkCompileTask = ndkCompile;
        variantData.compileTask.dependsOn(new Object[]{variantData.ndkCompileTask});
        final GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
            ndkCompile.setNdkRenderScriptMode(true);
            ndkCompile.dependsOn(new Object[]{variantData.renderscriptCompileTask});
        } else {
            ndkCompile.setNdkRenderScriptMode(false);
        }
        ConventionMappingHelper.map((Task)ndkCompile, "sourceFolders", new Callable<List<File>>(){

            @Override
            public List<File> call() {
                List sourceList = variantConfig.getJniSourceList();
                if (Boolean.TRUE.equals(variantConfig.getMergedFlavor().getRenderscriptNdkModeEnabled())) {
                    sourceList.add(variantData.renderscriptCompileTask.getSourceOutputDir());
                }
                return sourceList;
            }
        });
        ndkCompile.setGeneratedMakefile(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/Android.mk"));
        ConventionMappingHelper.map((Task)ndkCompile, "ndkConfig", new Callable<CoreNdkOptions>(){

            @Override
            public CoreNdkOptions call() {
                return variantConfig.getNdkConfig();
            }
        });
        ConventionMappingHelper.map((Task)ndkCompile, "debuggable", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ((CoreBuildType)variantConfig.getBuildType()).isJniDebuggable();
            }
        });
        ndkCompile.setObjFolder(new File(scope.getGlobalScope().getIntermediatesDir(), "ndk/" + variantData.getVariantConfiguration().getDirName() + "/obj"));
        Collection<File> ndkSoFolder = scope.getNdkSoFolder();
        if (ndkSoFolder != null && !ndkSoFolder.isEmpty()) {
            ndkCompile.setSoFolder(ndkSoFolder.iterator().next());
        }
    }

    public void createUnitTestVariantTasks(TaskFactory tasks, TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        Preconditions.checkState((testedVariantData != null ? 1 : 0) != 0);
        this.createPreBuildTasks(tasks, variantScope);
        this.createDependencyStreams(variantScope);
        this.createProcessJavaResTasks(tasks, variantScope);
        this.createCompileAnchorTask(tasks, variantScope);
        variantScope.getCompileTask().dependsOn(tasks, variantScope.getProcessJavaResourcesTask(), testedVariantData.getScope().getProcessJavaResourcesTask());
        AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
        TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
        javacTask.dependsOn(tasks, testedVariantData.getScope().getJavacTask());
        this.createRunUnitTestTask(tasks, variantScope);
        variantData.assembleVariantTask.dependsOn(new Object[]{this.createMockableJar.getName()});
        variantData.assembleVariantTask.setGroup(null);
    }

    public void createAndroidTestVariantTasks(TaskFactory tasks, TestVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        final BaseVariantOutputData variantOutputData = (BaseVariantOutputData)variantData.getOutputs().get(0);
        BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
        BaseVariantOutputData testedVariantOutputData = (BaseVariantOutputData)testedVariantData.getOutputs().get(0);
        this.createAnchorTasks(tasks, variantScope);
        this.createDependencyStreams(variantScope);
        this.createProcessTestManifestTask(tasks, variantScope);
        this.createGenerateResValuesTask(tasks, variantScope);
        this.createRenderscriptTask(tasks, variantScope);
        this.createMergeResourcesTask(tasks, variantScope);
        this.createMergeAssetsTask(tasks, variantScope);
        if (variantData.getTestedVariantData().getVariantConfiguration().getType().equals((Object)VariantType.LIBRARY) && testedVariantOutputData.assembleTask != null) {
            variantOutputData.getScope().getManifestProcessorTask().dependsOn(tasks, testedVariantOutputData.assembleTask);
            variantScope.getMergeResourcesTask().dependsOn(tasks, testedVariantOutputData.assembleTask);
        }
        this.createBuildConfigTask(tasks, variantScope);
        this.createApkProcessResTask(tasks, variantScope);
        this.createProcessJavaResTasks(tasks, variantScope);
        this.createAidlTask(tasks, variantScope);
        this.createShaderTask(tasks, variantScope);
        if (!this.isComponentModelPlugin) {
            this.createNdkTasks(variantScope);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createMergeJniLibFoldersTasks(tasks, variantScope);
        if (variantData.getVariantConfiguration().getUseJack()) {
            this.createJackTask(tasks, variantScope);
        } else {
            AndroidTask<? extends JavaCompile> javacTask = this.createJavacTask(tasks, variantScope);
            TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
            this.createPostCompilationTasks(tasks, variantScope);
        }
        Preconditions.checkNotNull(variantScope.getJavaCompilerTask());
        variantScope.getJavaCompilerTask().dependsOn(tasks, testedVariantData.getScope().getJavaCompilerTask());
        if (this.extension.getDataBinding().isEnabled()) {
            this.createDataBindingTasks(tasks, variantScope);
        }
        this.createPackagingTask(tasks, variantScope, false, null);
        tasks.named(ASSEMBLE_ANDROID_TEST, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{variantOutputData.assembleTask});
            }
        });
        this.createConnectedTestForVariant(tasks, variantScope);
    }

    protected IncrementalMode getIncrementalMode(GradleVariantConfiguration config) {
        if (config.isInstantRunSupported() && TaskManager.targetDeviceSupportsInstantRun(config, this.project) && this.globalScope.isActive(OptionalCompilationStep.INSTANT_DEV)) {
            if (this.isComponentModelPlugin) {
                return IncrementalMode.FULL;
            }
            if (this.globalScope.isActive(OptionalCompilationStep.LOCAL_RES_ONLY)) {
                return IncrementalMode.LOCAL_RES_ONLY;
            }
            if (this.globalScope.isActive(OptionalCompilationStep.LOCAL_JAVA_ONLY)) {
                return IncrementalMode.LOCAL_JAVA_ONLY;
            }
            return IncrementalMode.FULL;
        }
        return IncrementalMode.NONE;
    }

    private static boolean targetDeviceSupportsInstantRun(GradleVariantConfiguration config, Project project) {
        if (config.isLegacyMultiDexMode()) {
            return AndroidGradleOptions.getTargetApiLevel(project).compareTo(AndroidVersion.ART_RUNTIME) >= 0;
        }
        return true;
    }

    private void createLintCompileTask(TaskFactory tasks) {
        tasks.create(LINT_COMPILE, Task.class, new Action<Task>(){

            public void execute(Task lintCompile) {
                final File outputDir = new File(TaskManager.this.getGlobalScope().getIntermediatesDir(), TaskManager.LINT);
                lintCompile.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        boolean mkdirs;
                        if (!outputDir.exists() && !(mkdirs = outputDir.mkdirs())) {
                            throw new GradleException("Unable to create lint output directory.");
                        }
                    }
                });
            }
        });
    }

    private static boolean isLintVariant(BaseVariantData<? extends BaseVariantOutputData> baseVariantData) {
        GradleVariantConfiguration config = baseVariantData.getVariantConfiguration();
        return !config.getType().isForTesting();
    }

    public void createLintTasks(TaskFactory tasks, final VariantScope scope) {
        BaseVariantData<? extends BaseVariantOutputData> baseVariantData = scope.getVariantData();
        if (!TaskManager.isLintVariant(baseVariantData)) {
            return;
        }
        tasks.named(LINT, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{TaskManager.LINT_COMPILE});
                it.dependsOn(new Object[]{scope.getJavacTask().getName()});
            }
        });
        AndroidTask<Lint> variantLintCheck = this.androidTasks.create(tasks, new Lint.ConfigAction(scope));
        variantLintCheck.dependsOn(tasks, LINT_COMPILE, scope.getJavacTask());
    }

    private void createLintVitalTask(ApkVariantData variantData) {
        Preconditions.checkState((boolean)this.getExtension().getLintOptions().isCheckReleaseBuilds());
        if (!((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isDebuggable() && !variantData.getVariantConfiguration().getUseJack()) {
            String variantName = variantData.getVariantConfiguration().getFullName();
            String capitalizedVariantName = StringHelper.capitalize((String)variantName);
            String taskName = "lintVital" + capitalizedVariantName;
            final Lint lintReleaseCheck = (Lint)this.project.getTasks().create(taskName, Lint.class);
            lintReleaseCheck.setAndroidBuilder(this.androidBuilder);
            TaskManager.optionalDependsOn((Task)lintReleaseCheck, new Task[]{variantData.javacTask});
            lintReleaseCheck.setLintOptions(this.getExtension().getLintOptions());
            lintReleaseCheck.setSdkHome((File)Preconditions.checkNotNull((Object)this.sdkHandler.getSdkFolder(), (Object)"SDK not set up."));
            lintReleaseCheck.setVariantName(variantName);
            lintReleaseCheck.setToolingRegistry(this.toolingRegistry);
            lintReleaseCheck.setFatalOnly(true);
            lintReleaseCheck.setDescription("Runs lint on just the fatal issues in the " + capitalizedVariantName + " build.");
            variantData.assembleVariantTask.dependsOn(new Object[]{lintReleaseCheck});
            this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

                public void doCall(TaskExecutionGraph taskGraph) {
                    if (taskGraph.hasTask(TaskManager.LINT)) {
                        lintReleaseCheck.setEnabled(false);
                    }
                }
            });
        }
    }

    private void createRunUnitTestTask(TaskFactory tasks, VariantScope variantScope) {
        final AndroidTask<Test> runtTestsTask = this.androidTasks.create(tasks, new UnitTestConfigAction(variantScope));
        runtTestsTask.dependsOn(tasks, variantScope.getVariantData().assembleVariantTask);
        tasks.named("test", (Action<? super Task>)new Action<Task>(){

            public void execute(Task test) {
                test.dependsOn(new Object[]{runtTestsTask.getName()});
            }
        });
    }

    public void createTopLevelTestTasks(final TaskFactory tasks, boolean hasFlavors) {
        this.createMockableJarTask(tasks);
        final ArrayList reportTasks = Lists.newArrayListWithExpectedSize((int)2);
        List<DeviceProvider> providers = this.getExtension().getDeviceProviders();
        final String connectedRootName = "connected" + VariantType.ANDROID_TEST.getSuffix();
        final String defaultReportsDir = this.getGlobalScope().getReportsDir().getAbsolutePath() + "/" + "androidTests";
        final String defaultResultsDir = this.getGlobalScope().getOutputsDir().getAbsolutePath() + "/" + BuilderConstants.FD_ANDROID_RESULTS;
        if (hasFlavors) {
            tasks.create(connectedRootName, AndroidReportTask.class, new Action<AndroidReportTask>(){

                public void execute(AndroidReportTask mainConnectedTask) {
                    mainConnectedTask.setGroup("verification");
                    mainConnectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
                    mainConnectedTask.setReportType(ReportType.MULTI_FLAVOR);
                    ConventionMappingHelper.map((Task)mainConnectedTask, "resultsDir", new Callable<File>(){

                        @Override
                        public File call() {
                            String dir = TaskManager.this.extension.getTestOptions().getResultsDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultResultsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/connected/" + "all"));
                        }
                    });
                    ConventionMappingHelper.map((Task)mainConnectedTask, "reportsDir", new Callable<File>(){

                        @Override
                        public File call() {
                            String dir = TaskManager.this.extension.getTestOptions().getReportDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultReportsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/connected/" + "all"));
                        }
                    });
                }
            });
            reportTasks.add(connectedRootName);
        } else {
            tasks.create(connectedRootName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task connectedTask) {
                    connectedTask.setGroup("verification");
                    connectedTask.setDescription("Installs and runs instrumentation tests for all flavors on connected devices.");
                }
            });
        }
        tasks.named(CONNECTED_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{connectedRootName});
            }
        });
        final String mainProviderTaskName = "device" + VariantType.ANDROID_TEST.getSuffix();
        if (providers.size() > 1 || hasFlavors) {
            tasks.create(mainProviderTaskName, AndroidReportTask.class, new Action<AndroidReportTask>(){

                public void execute(AndroidReportTask mainProviderTask) {
                    mainProviderTask.setGroup("verification");
                    mainProviderTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
                    mainProviderTask.setReportType(ReportType.MULTI_FLAVOR);
                    ConventionMappingHelper.map((Task)mainProviderTask, "resultsDir", new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            String dir = TaskManager.this.extension.getTestOptions().getResultsDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultResultsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/devices/" + "all"));
                        }
                    });
                    ConventionMappingHelper.map((Task)mainProviderTask, "reportsDir", new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            String dir = TaskManager.this.extension.getTestOptions().getReportDir();
                            String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultReportsDir;
                            return TaskManager.this.project.file((Object)(rootLocation + "/devices/" + "all"));
                        }
                    });
                }
            });
            reportTasks.add(mainProviderTaskName);
        } else {
            tasks.create(mainProviderTaskName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task providerTask) {
                    providerTask.setGroup("verification");
                    providerTask.setDescription("Installs and runs instrumentation tests using all Device Providers.");
                }
            });
        }
        tasks.named(DEVICE_CHECK, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{mainProviderTaskName});
            }
        });
        tasks.create("test", (Action<? super Task>)new Action<Task>(){

            public void execute(Task unitTestTask) {
                unitTestTask.setGroup("verification");
                unitTestTask.setDescription("Run unit tests for all variants.");
            }
        });
        tasks.named("check", (Action<? super Task>)new Action<Task>(){

            public void execute(Task check) {
                check.dependsOn(new Object[]{"test"});
            }
        });
        if (!reportTasks.isEmpty() && this.project.getGradle().getStartParameter().isContinueOnFailure()) {
            this.project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

                public void doCall(TaskExecutionGraph taskGraph) {
                    for (String reportTask : reportTasks) {
                        if (!taskGraph.hasTask(reportTask)) continue;
                        tasks.named(reportTask, (Action<? super Task>)new Action<Task>(){

                            public void execute(Task task) {
                                ((AndroidReportTask)task).setWillRun();
                            }
                        });
                    }
                }
            });
        }
    }

    protected void createConnectedTestForVariant(TaskFactory tasks, final VariantScope variantScope) {
        final BaseVariantData baseVariantData = variantScope.getTestedVariantData();
        final TestVariantData testVariantData = (TestVariantData)variantScope.getVariantData();
        final BaseVariantOutputData variantOutputData = (BaseVariantOutputData)baseVariantData.getOutputs().get(0);
        final BaseVariantOutputData testVariantOutputData = (BaseVariantOutputData)testVariantData.getOutputs().get(0);
        String connectedRootName = "connected" + VariantType.ANDROID_TEST.getSuffix();
        TestDataImpl testData = new TestDataImpl(testVariantData);
        testData.setExtraInstrumentationTestRunnerArgs(AndroidGradleOptions.getExtraInstrumentationTestRunnerArgs(this.project));
        ImmutableList artifactsTasks = ImmutableList.of((Object)((ApkVariantOutputData)testVariantData.getOutputs().get((int)0)).assembleTask, (Object)baseVariantData.assembleVariantTask);
        final AndroidTask<DeviceProviderInstrumentTestTask> connectedTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.globalScope.getExtension().getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.logger)), testData));
        connectedTask.dependsOn(tasks, artifactsTasks);
        tasks.named(connectedRootName, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{connectedTask.getName()});
            }
        });
        if (((CoreBuildType)baseVariantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled() && !baseVariantData.getVariantConfiguration().getUseJack()) {
            final AndroidTask<JacocoReportTask> reportTask = this.androidTasks.create(tasks, variantScope.getTaskName("create", "CoverageReport"), JacocoReportTask.class, new Action<JacocoReportTask>(){

                public void execute(JacocoReportTask reportTask) {
                    reportTask.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
                    reportTask.setReportName(baseVariantData.getVariantConfiguration().getFullName());
                    ConventionMappingHelper.map((Task)reportTask, "jacocoClasspath", new Callable<FileCollection>(){

                        @Override
                        public FileCollection call() throws Exception {
                            return TaskManager.this.project.getConfigurations().getAt("androidJacocoAnt");
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "coverageFile", new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(((TestVariantData)testVariantData.getScope().getVariantData()).connectedTestTask.getCoverageDir(), "coverage.ec");
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "classDir", new Callable<File>(){

                        @Override
                        public File call() {
                            return baseVariantData.javacTask.getDestinationDir();
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "sourceDir", new Callable<List<File>>(){

                        @Override
                        public List<File> call() {
                            return baseVariantData.getJavaSourceFoldersForCoverage();
                        }
                    });
                    ConventionMappingHelper.map((Task)reportTask, "reportDir", new Callable<File>(){

                        @Override
                        public File call() {
                            return new File(variantScope.getGlobalScope().getReportsDir(), "/coverage/" + baseVariantData.getVariantConfiguration().getDirName());
                        }
                    });
                    reportTask.dependsOn(new Object[]{connectedTask.getName()});
                }
            });
            variantScope.setCoverageReportTask(reportTask);
            baseVariantData.getScope().getCoverageReportTask().dependsOn(tasks, reportTask);
            tasks.named(connectedRootName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task it) {
                    it.dependsOn(new Object[]{reportTask.getName()});
                }
            });
        }
        String mainProviderTaskName = "device" + VariantType.ANDROID_TEST.getSuffix();
        List<DeviceProvider> providers = this.getExtension().getDeviceProviders();
        boolean hasFlavors = baseVariantData.getVariantConfiguration().hasFlavors();
        for (DeviceProvider deviceProvider : providers) {
            final AndroidTask<DeviceProviderInstrumentTestTask> providerTask = this.androidTasks.create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(testVariantData.getScope(), deviceProvider, testData));
            tasks.named(mainProviderTaskName, (Action<? super Task>)new Action<Task>(){

                public void execute(Task it) {
                    it.dependsOn(new Object[]{providerTask.getName()});
                }
            });
            providerTask.dependsOn(tasks, artifactsTasks);
        }
        List<TestServer> servers = this.getExtension().getTestServers();
        for (TestServer testServer : servers) {
            final TestServerTask serverTask = (TestServerTask)this.project.getTasks().create(hasFlavors ? baseVariantData.getScope().getTaskName(testServer.getName() + "Upload") : testServer.getName() + "Upload", TestServerTask.class);
            serverTask.setDescription("Uploads APKs for Build '" + baseVariantData.getVariantConfiguration().getFullName() + "' to Test Server '" + StringHelper.capitalize((String)testServer.getName()) + "'.");
            serverTask.setGroup("verification");
            serverTask.setVariantName(baseVariantData.getScope().getVariantConfiguration().getFullName());
            serverTask.dependsOn(new Object[]{testVariantOutputData.assembleTask, variantOutputData.assembleTask});
            serverTask.setTestServer(testServer);
            ConventionMappingHelper.map((Task)serverTask, "testApk", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return testVariantOutputData.getOutputFile();
                }
            });
            if (!(baseVariantData instanceof LibraryVariantData)) {
                ConventionMappingHelper.map((Task)serverTask, "testedApk", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return variantOutputData.getOutputFile();
                    }
                });
            }
            ConventionMappingHelper.map((Task)serverTask, "variantName", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return baseVariantData.getVariantConfiguration().getFullName();
                }
            });
            tasks.named(DEVICE_CHECK, (Action<? super Task>)new Action<Task>(){

                public void execute(Task it) {
                    it.dependsOn(new Object[]{serverTask});
                }
            });
            if (testServer.isConfigured()) continue;
            serverTask.setEnabled(false);
        }
    }

    public void createJarTasks(TaskFactory tasks, final VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        final GradleVariantConfiguration config = variantData.getVariantConfiguration();
        tasks.create(scope.getTaskName("jar", "Classes"), AndroidJarTask.class, new Action<AndroidJarTask>(){

            public void execute(AndroidJarTask jarTask) {
                jarTask.setArchiveName("classes.jar");
                jarTask.setDestinationDir(new File(scope.getGlobalScope().getIntermediatesDir(), "packaged/" + config.getDirName() + "/"));
                jarTask.from(new Object[]{scope.getJavaOutputDir()});
                jarTask.dependsOn(new Object[]{scope.getJavacTask().getName()});
                variantData.binaryFileProviderTask = jarTask;
            }
        });
    }

    public void createPostCompilationTasks(TaskFactory tasks, VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        Preconditions.checkNotNull(variantScope.getJavacTask());
        ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        TransformManager transformManager = variantScope.getTransformManager();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && !config.getType().isForTesting() && this.getIncrementalMode(variantScope.getVariantConfiguration()) == IncrementalMode.NONE;
        if (isTestCoverageEnabled) {
            this.createJacocoTransform(tasks, variantScope);
        }
        boolean isMinifyEnabled = config.isMinifyEnabled();
        boolean isMultiDexEnabled = config.isMultiDexEnabled();
        boolean isLegacyMultiDexMode = config.isLegacyMultiDexMode() && (this.getIncrementalMode(variantScope.getVariantConfiguration()) == IncrementalMode.NONE || variantScope.getInstantRunBuildContext().getPatchingPolicy() == InstantRunPatchingPolicy.PRE_LOLLIPOP);
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        List<Transform> customTransforms = extension.getTransforms();
        List<List<Object>> customTransformsDependencies = extension.getTransformsDependencies();
        int count = customTransforms.size();
        for (int i = 0; i < count; ++i) {
            Transform transform = customTransforms.get(i);
            AndroidTask<TransformTask> task = transformManager.addTransform(tasks, variantScope, transform);
            if (task == null) continue;
            List<Object> deps = customTransformsDependencies.get(i);
            if (!deps.isEmpty()) {
                task.dependsOn(tasks, deps);
            }
            if (!transform.getScopes().isEmpty()) continue;
            variantData.assembleVariantTask.dependsOn(new Object[]{tasks, task});
        }
        if (isMinifyEnabled) {
            boolean outputToJarFile = isMultiDexEnabled && isLegacyMultiDexMode;
            this.createMinifyTransform(tasks, variantScope, outputToJarFile);
        }
        AndroidTask<InstantRunWrapperTask> incrementalBuildWrapperTask = null;
        if (this.getIncrementalMode(variantScope.getVariantConfiguration()) != IncrementalMode.NONE) {
            variantScope.getInstantRunBuildContext().setInstantRunMode(true);
            AndroidTask<InstantRunAnchorTask> allActionsAnchorTask = this.createInstantRunAllActionsTasks(tasks, variantScope);
            variantScope.setInstantRunAnchorTask(allActionsAnchorTask);
            incrementalBuildWrapperTask = this.createInstantRunIncrementalTasks(tasks, variantScope);
            variantScope.setInstantRunIncrementalTask(incrementalBuildWrapperTask);
            incrementalBuildWrapperTask.dependsOn(tasks, allActionsAnchorTask);
            if (InstantRunPatchingPolicy.PRE_LOLLIPOP != variantScope.getInstantRunBuildContext().getPatchingPolicy()) {
                isMultiDexEnabled = true;
                extension.getDexOptions().setPreDexLibraries(true);
            }
            extension.getDexOptions().setJumboMode(true);
        }
        AndroidTask<TransformTask> multiDexClassListTask = null;
        if (isMultiDexEnabled && isLegacyMultiDexMode) {
            if (!((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isUseProguard()) {
                throw new IllegalStateException("Build-in class shrinker and multidex are not supported yet.");
            }
            if (!isMinifyEnabled) {
                JarMergingTransform jarMergingTransform = new JarMergingTransform(TransformManager.SCOPE_FULL_PROJECT);
                transformManager.addTransform(tasks, variantScope, jarMergingTransform);
            }
            AndroidTask<CreateManifestKeepList> manifestKeepListTask = this.androidTasks.create(tasks, new CreateManifestKeepList.ConfigAction(variantScope));
            manifestKeepListTask.dependsOn(tasks, ((ApkVariantOutputData)variantData.getOutputs().get(0)).getScope().getManifestProcessorTask());
            MultiDexTransform multiDexTransform = new MultiDexTransform(variantScope.getManifestKeepListFile(), variantScope, null);
            multiDexClassListTask = transformManager.addTransform(tasks, variantScope, multiDexTransform);
            multiDexClassListTask.dependsOn(tasks, manifestKeepListTask);
        }
        DexTransform dexTransform = new DexTransform(extension.getDexOptions(), ((CoreBuildType)config.getBuildType()).isDebuggable(), isMultiDexEnabled, isMultiDexEnabled && isLegacyMultiDexMode ? variantScope.getMainDexListFile() : null, variantScope.getPreDexOutputDir(), variantScope.getGlobalScope().getAndroidBuilder(), this.getLogger(), variantScope.getInstantRunBuildContext());
        AndroidTask<TransformTask> dexTask = transformManager.addTransform(tasks, variantScope, dexTransform);
        dexTask.optionalDependsOn(tasks, multiDexClassListTask);
        if (incrementalBuildWrapperTask != null && InstantRunPatchingPolicy.PRE_LOLLIPOP != variantScope.getInstantRunBuildContext().getPatchingPolicy()) {
            incrementalBuildWrapperTask.dependsOn(tasks, dexTask);
        }
    }

    protected AndroidTask<InstantRunAnchorTask> createInstantRunAllActionsTasks(TaskFactory tasks, VariantScope variantScope) {
        AndroidTask<InstantRunAnchorTask> allActionAnchorTask = this.getAndroidTasks().create(tasks, new InstantRunAnchorTask.ConfigAction(variantScope, "Tasks"));
        AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask = this.getAndroidTasks().create(tasks, new BuildInfoLoaderTask.ConfigAction(variantScope, this.getLogger()));
        TransformManager transformManager = variantScope.getTransformManager();
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.SUB_PROJECTS));
        AndroidTask<TransformTask> extractJarsTask = transformManager.addTransform(tasks, variantScope, extractJarsTransform);
        InstantRunVerifierTransform verifierTransform = new InstantRunVerifierTransform(variantScope);
        AndroidTask<TransformTask> verifierTask = variantScope.getTransformManager().addTransform(tasks, variantScope, verifierTransform);
        verifierTask.dependsOn(tasks, extractJarsTask);
        variantScope.setInstantRunVerifierTask(verifierTask);
        NoChangesVerifierTransform jniLibsVerifierTransform = new NoChangesVerifierTransform(variantScope, (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS)), this.getResMergingScopes(variantScope), InstantRunVerifierStatus.JAVA_RESOURCES_CHANGED, true);
        AndroidTask<TransformTask> jniLibsVerifierTask = variantScope.getTransformManager().addTransform(tasks, variantScope, jniLibsVerifierTransform);
        jniLibsVerifierTask.dependsOn(tasks, verifierTask);
        NoChangesVerifierTransform dependenciesVerifierTransform = new NoChangesVerifierTransform(variantScope, (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT_LOCAL_DEPS, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.EXTERNAL_LIBRARIES}), InstantRunVerifierStatus.DEPENDENCY_CHANGED, false);
        AndroidTask<TransformTask> dependenciesVerifierTask = variantScope.getTransformManager().addTransform(tasks, variantScope, dependenciesVerifierTransform);
        dependenciesVerifierTask.dependsOn(tasks, verifierTask);
        InstantRunTransform instantRunTransform = new InstantRunTransform(variantScope);
        AndroidTask<TransformTask> instantRunTask = transformManager.addTransform(tasks, variantScope, instantRunTransform);
        instantRunTask.dependsOn(tasks, buildInfoLoaderTask, verifierTask, jniLibsVerifierTask, dependenciesVerifierTask);
        AndroidTask<FastDeployRuntimeExtractorTask> extractorTask = this.getAndroidTasks().create(tasks, new FastDeployRuntimeExtractorTask.ConfigAction(variantScope));
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJar(variantScope.getIncrementalRuntimeSupportJar()).setDependency((Object)extractorTask.get(tasks)).build());
        AndroidTask<GenerateInstantRunAppInfoTask> generateAppInfoAndroidTask = this.getAndroidTasks().create(tasks, new GenerateInstantRunAppInfoTask.ConfigAction(variantScope));
        GenerateInstantRunAppInfoTask generateInstantRunAppInfoTask = generateAppInfoAndroidTask.get(tasks);
        VariantOutputScope outputScope = variantScope.getVariantData().getOutputs().get(0).getScope();
        generateAppInfoAndroidTask.dependsOn(tasks, outputScope.getManifestProcessorTask());
        variantScope.getTransformManager().addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJar(generateInstantRunAppInfoTask.getOutputFile()).setDependency((Object)generateInstantRunAppInfoTask).build());
        allActionAnchorTask.dependsOn(tasks, instantRunTask);
        DexOptions dexOptions = variantScope.getGlobalScope().getExtension().getDexOptions();
        InstantRunDex reloadDexTransform = new InstantRunDex(variantScope, InstantRunBuildType.RELOAD, this.androidBuilder, dexOptions, this.getLogger(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)((Object)ExtendedContentType.CLASSES_ENHANCED)));
        AndroidTask<TransformTask> reloadDexing = variantScope.getTransformManager().addTransform(tasks, variantScope, reloadDexTransform);
        allActionAnchorTask.dependsOn(tasks, reloadDexing);
        return allActionAnchorTask;
    }

    public AndroidTask<InstantRunWrapperTask> createInstantRunIncrementalTasks(TaskFactory tasks, VariantScope scope) {
        AndroidTask<InstantRunAnchorTask> incrementalAnchorTask = this.androidTasks.create(tasks, new InstantRunAnchorTask.ConfigAction(scope));
        AndroidTask<InstantRunWrapperTask> incrementalWrapperTask = this.getAndroidTasks().create(tasks, new InstantRunWrapperTask.ConfigAction(scope, InstantRunWrapperTask.TaskType.INCREMENTAL, this.getLogger()));
        incrementalAnchorTask.dependsOn(tasks, incrementalWrapperTask);
        scope.getInstantRunBuildContext().setApiLevel(AndroidGradleOptions.getTargetApiLevel(this.project), AndroidGradleOptions.getColdswapMode(this.project), AndroidGradleOptions.getBuildTargetAbi(this.project));
        scope.getInstantRunBuildContext().setDensity(AndroidGradleOptions.getBuildTargetDensity(this.project));
        InstantRunPatchingPolicy patchingPolicy = scope.getInstantRunBuildContext().getPatchingPolicy();
        DexOptions dexOptions = scope.getGlobalScope().getExtension().getDexOptions();
        AndroidTask<ColdswapArtifactsKickerTask> coldswapKickerTask = this.getAndroidTasks().create(tasks, new ColdswapArtifactsKickerTask.ConfigAction("coldswapKicker", scope));
        coldswapKickerTask.dependsOn(tasks, scope.getInstantRunVerifierTask());
        if (patchingPolicy == InstantRunPatchingPolicy.PRE_LOLLIPOP) {
            InstantRunDex classesTwoTransform = new InstantRunDex(scope, InstantRunBuildType.RESTART, this.androidBuilder, dexOptions, this.getLogger(), (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES));
            AndroidTask<TransformTask> classesTwoDexing = scope.getTransformManager().addTransform(tasks, scope, classesTwoTransform);
            classesTwoDexing.dependsOn(tasks, coldswapKickerTask);
            incrementalWrapperTask.dependsOn(tasks, classesTwoDexing);
        } else {
            InstantRunSlicer slicer = new InstantRunSlicer(this.getLogger(), scope);
            AndroidTask<TransformTask> slicing = scope.getTransformManager().addTransform(tasks, scope, slicer);
            slicing.dependsOn(tasks, coldswapKickerTask);
            incrementalWrapperTask.dependsOn(tasks, slicing);
        }
        return incrementalWrapperTask;
    }

    protected void handleJacocoDependencies(VariantScope variantScope) {
        boolean isTestCoverageEnabled;
        GradleVariantConfiguration config = variantScope.getVariantConfiguration();
        boolean bl = isTestCoverageEnabled = ((CoreBuildType)config.getBuildType()).isTestCoverageEnabled() && this.getIncrementalMode(variantScope.getVariantConfiguration()) == IncrementalMode.NONE && (!config.getType().isForTesting() || config.getTestedConfig() != null && config.getTestedConfig().getType() == VariantType.LIBRARY);
        if (isTestCoverageEnabled) {
            Copy agentTask = this.getJacocoAgentTask();
            variantScope.getTransformManager().addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_JARS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJar(new File(agentTask.getDestinationDir(), FILE_JACOCO_AGENT)).setDependency(agentTask).build());
        }
    }

    public void createJacocoTransform(TaskFactory taskFactory, VariantScope variantScope) {
        AndroidTask<TransformTask> task = variantScope.getTransformManager().addTransform(taskFactory, variantScope, new JacocoTransform(this.project.getConfigurations()));
        Copy agentTask = this.getJacocoAgentTask();
        task.dependsOn(taskFactory, agentTask);
    }

    public void createJackTask(TaskFactory tasks, VariantScope scope) {
        AndroidTask<JillTask> jillRuntimeTask = this.androidTasks.create(tasks, new JillTask.RuntimeTaskConfigAction(scope));
        AndroidTask<JillTask> jillPackagedTask = this.androidTasks.create(tasks, new JillTask.PackagedConfigAction(scope));
        jillPackagedTask.dependsOn(tasks, scope.getVariantData().getVariantDependency().getPackageConfiguration().getBuildDependencies());
        AndroidTask<JackTask> jackTask = this.androidTasks.create(tasks, new JackTask.ConfigAction(scope, this.isVerbose(), this.isDebugLog()));
        TaskManager.setJavaCompilerTask(jackTask, tasks, scope);
        this.setupCompileTaskDependencies(tasks, scope, jackTask);
        jackTask.optionalDependsOn(tasks, scope.getMergeJavaResourcesTask());
        jackTask.dependsOn(tasks, scope.getVariantData().sourceGenTask, jillRuntimeTask, jillPackagedTask, scope.getVariantData().getVariantDependency().getCompileConfiguration().getBuildDependencies());
    }

    protected void createDataBindingTasks(TaskFactory tasks, VariantScope scope) {
        if (scope.getVariantConfiguration().getUseJack()) {
            this.androidBuilder.getErrorReporter().handleSyncError(scope.getVariantConfiguration().getFullName(), 11, "Data Binding does not support Jack builds yet");
        }
        this.dataBindingBuilder.setDebugLogEnabled(this.getLogger().isDebugEnabled());
        AndroidTask<DataBindingProcessLayoutsTask> processLayoutsTask = this.androidTasks.create(tasks, new DataBindingProcessLayoutsTask.ConfigAction(scope));
        scope.setDataBindingProcessLayoutsTask(processLayoutsTask);
        scope.getGenerateRClassTask().dependsOn(tasks, processLayoutsTask);
        processLayoutsTask.dependsOn(tasks, scope.getMergeResourcesTask());
        AndroidTask<DataBindingExportBuildInfoTask> exportBuildInfo = this.androidTasks.create(tasks, new DataBindingExportBuildInfoTask.ConfigAction(scope, this.dataBindingBuilder.getPrintMachineReadableOutput()));
        scope.setDataBindingExportInfoTask(exportBuildInfo);
        exportBuildInfo.dependsOn(tasks, processLayoutsTask);
        AndroidTask<? extends AbstractCompile> javaCompilerTask = scope.getJavaCompilerTask();
        if (javaCompilerTask != null) {
            javaCompilerTask.dependsOn(tasks, exportBuildInfo);
        }
        this.setupCompileTaskDependencies(tasks, scope, exportBuildInfo);
        for (BaseVariantOutputData baseVariantOutputData : scope.getVariantData().getOutputs()) {
            ProcessAndroidResources processResTask = baseVariantOutputData.processResourcesTask;
            if (processResTask == null) continue;
            processResTask.dependsOn(new Object[]{processLayoutsTask.getName()});
        }
    }

    public void createPackagingTask(TaskFactory tasks, VariantScope variantScope, boolean publishApk, AndroidTask<InstantRunWrapperTask> fullBuildInfoGeneratorTask) {
        final ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
        GradleVariantConfiguration config = variantData.getVariantConfiguration();
        boolean signedApk = variantData.isSigned();
        final File apkLocation = new File(variantScope.getGlobalScope().getApkLocation());
        boolean multiOutput = variantData.getOutputs().size() > 1;
        GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
        AndroidTask<PrePackageApplication> prePackageApp = this.androidTasks.create(tasks, new PrePackageApplication.ConfigAction("prePackageMarkerFor", variantScope));
        IncrementalMode incrementalMode = this.getIncrementalMode(variantConfiguration);
        if (incrementalMode != IncrementalMode.NONE) {
            prePackageApp.dependsOn(tasks, variantScope.getInstantRunAnchorTask());
        }
        for (final ApkVariantOutputData variantOutputData : variantData.getOutputs()) {
            VariantOutputScope variantOutputScope = variantOutputData.getScope();
            String outputName = variantOutputData.getFullName();
            InstantRunPatchingPolicy instantRunPatchingPolicy = variantScope.getInstantRunBuildContext().getPatchingPolicy();
            PackageApplication.DexPackagingPolicy dexPackagingPolicy = incrementalMode == IncrementalMode.NONE || variantScope.getInstantRunBuildContext().getPatchingPolicy() == InstantRunPatchingPolicy.PRE_LOLLIPOP ? PackageApplication.DexPackagingPolicy.STANDARD : PackageApplication.DexPackagingPolicy.INSTANT_RUN;
            AndroidTask<PackageApplication> packageApp = this.androidTasks.create(tasks, new PackageApplication.ConfigAction(variantOutputScope, dexPackagingPolicy));
            packageApp.dependsOn(tasks, prePackageApp, variantOutputScope.getProcessResourcesTask());
            packageApp.optionalDependsOn(tasks, new Object[]{variantOutputScope.getShrinkResourcesTask(), variantOutputScope.getVariantScope().getJavaCompilerTask(), variantData.javaCompilerTask, variantOutputData.packageSplitResourcesTask, variantOutputData.packageSplitAbiTask});
            TransformManager transformManager = variantScope.getTransformManager();
            for (TransformStream stream : transformManager.getStreams(PackageApplication.sDexFilter)) {
                packageApp.dependsOn(tasks, stream.getDependencies());
            }
            for (TransformStream stream : transformManager.getStreams(PackageApplication.sResFilter)) {
                packageApp.dependsOn(tasks, stream.getDependencies());
            }
            for (TransformStream stream : transformManager.getStreams(PackageApplication.sNativeLibsFilter)) {
                packageApp.dependsOn(tasks, stream.getDependencies());
            }
            AndroidTask<DefaultTask> appTask = packageApp;
            if (signedApk && variantData.getZipAlignEnabled()) {
                AndroidTask<ZipAlign> zipAlignTask = this.androidTasks.create(tasks, new ZipAlign.ConfigAction(variantOutputScope));
                zipAlignTask.dependsOn(tasks, packageApp);
                if (variantOutputScope.getSplitZipAlignTask() != null) {
                    zipAlignTask.dependsOn(tasks, variantOutputScope.getSplitZipAlignTask());
                }
                appTask = zipAlignTask;
            }
            Preconditions.checkState((variantData.assembleVariantTask != null ? 1 : 0) != 0);
            if (fullBuildInfoGeneratorTask != null) {
                fullBuildInfoGeneratorTask.dependsOn(tasks, appTask);
                variantData.assembleVariantTask.dependsOn(new Object[]{fullBuildInfoGeneratorTask.getName()});
            }
            if (dexPackagingPolicy == PackageApplication.DexPackagingPolicy.INSTANT_RUN && instantRunPatchingPolicy == InstantRunPatchingPolicy.MULTI_APK) {
                variantScope.getInstantRunIncrementalTask().dependsOn(tasks, appTask);
            }
            if (multiOutput) {
                variantOutputData.assembleTask = this.createAssembleTask(variantOutputData);
                variantData.assembleVariantTask.dependsOn(new Object[]{variantOutputData.assembleTask});
            } else {
                variantOutputData.assembleTask = variantData.assembleVariantTask;
            }
            if (!signedApk && variantOutputData.packageSplitResourcesTask != null) {
                final String appTaskName = appTask.getName();
                AndroidTask<Copy> copySplitTask = this.androidTasks.create(tasks, variantOutputScope.getTaskName("copySplit"), Copy.class, new Action<Copy>(){

                    public void execute(Copy copyTask) {
                        copyTask.setDestinationDir(apkLocation);
                        copyTask.from(new Object[]{variantOutputData.packageSplitResourcesTask.getOutputDirectory()});
                        variantOutputData.assembleTask.dependsOn(new Object[]{copyTask});
                        copyTask.mustRunAfter(new Object[]{appTaskName});
                    }
                });
                variantOutputData.assembleTask.dependsOn(new Object[]{copySplitTask.getName()});
            }
            variantOutputData.assembleTask.dependsOn(new Object[]{appTask.getName()});
            if (!publishApk) continue;
            final String projectBaseName = this.globalScope.getProjectBaseName();
            if (this.getExtension().getDefaultPublishConfig().equals(outputName)) {
                appTask.configure(tasks, new Action<Task>(){

                    public void execute(Task packageTask) {
                        TaskManager.this.project.getArtifacts().add("default", (Object)new ApkPublishArtifact(projectBaseName, null, (FileSupplier)packageTask));
                    }
                });
                for (FileSupplier outputFileProvider : variantOutputData.getSplitOutputFileSuppliers()) {
                    this.project.getArtifacts().add("default", (Object)new ApkPublishArtifact(projectBaseName, null, outputFileProvider));
                }
                try {
                    if (variantOutputData.getMetadataFile() != null) {
                        this.project.getArtifacts().add("default-metadata", (Object)new MetadataPublishArtifact(projectBaseName, null, variantOutputData.getMetadataFile()));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (variantData.getMappingFileProvider() != null) {
                    this.project.getArtifacts().add("default-mapping", (Object)new MappingPublishArtifact(projectBaseName, null, variantData.getMappingFileProvider()));
                }
            }
            if (!this.getExtension().getPublishNonDefault()) continue;
            appTask.configure(tasks, new Action<Task>(){

                public void execute(Task packageTask) {
                    TaskManager.this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)new ApkPublishArtifact(projectBaseName, null, (FileSupplier)packageTask));
                }
            });
            for (FileSupplier outputFileProvider : variantOutputData.getSplitOutputFileSuppliers()) {
                this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)new ApkPublishArtifact(projectBaseName, null, outputFileProvider));
            }
            try {
                if (variantOutputData.getMetadataFile() != null) {
                    this.project.getArtifacts().add(variantData.getVariantDependency().getMetadataConfiguration().getName(), (Object)new MetadataPublishArtifact(projectBaseName, null, variantOutputData.getMetadataFile()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (variantData.getMappingFileProvider() != null) {
                this.project.getArtifacts().add(variantData.getVariantDependency().getMappingConfiguration().getName(), (Object)new MappingPublishArtifact(projectBaseName, null, variantData.getMappingFileProvider()));
            }
            if (variantData.classesJarTask == null) continue;
            this.project.getArtifacts().add(variantData.getVariantDependency().getClassesConfiguration().getName(), (Object)variantData.classesJarTask);
        }
        if (signedApk) {
            AndroidTask<InstallVariantTask> installTask = this.androidTasks.create(tasks, new InstallVariantTask.ConfigAction(variantScope));
            installTask.dependsOn(tasks, variantData.assembleVariantTask);
        }
        if (this.getExtension().getLintOptions().isCheckReleaseBuilds() && incrementalMode == IncrementalMode.NONE) {
            this.createLintVitalTask(variantData);
        }
        final AndroidTask<UninstallTask> uninstallTask = this.androidTasks.create(tasks, new UninstallTask.ConfigAction(variantScope));
        tasks.named(UNINSTALL_ALL, (Action<? super Task>)new Action<Task>(){

            public void execute(Task it) {
                it.dependsOn(new Object[]{uninstallTask.getName()});
            }
        });
    }

    public Task createAssembleTask(BaseVariantOutputData variantOutputData) {
        Task assembleTask = this.project.getTasks().create(variantOutputData.getScope().getTaskName("assemble"));
        return assembleTask;
    }

    public Task createAssembleTask(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        Task assembleTask = this.project.getTasks().create(variantData.getScope().getTaskName("assemble"));
        return assembleTask;
    }

    public Copy getJacocoAgentTask() {
        if (this.jacocoAgentTask == null) {
            this.jacocoAgentTask = (Copy)this.project.getTasks().create("unzipJacocoAgent", Copy.class);
            this.jacocoAgentTask.from(new Object[]{new Callable<List<FileTree>>(){

                @Override
                public List<FileTree> call() throws Exception {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)TaskManager.this.project.getConfigurations().getByName("androidJacocoAgent"), (Function)new Function<Object, FileTree>(){

                        public FileTree apply(Object it) {
                            return TaskManager.this.project.zipTree(it);
                        }
                    }));
                }
            }});
            this.jacocoAgentTask.include(new String[]{FILE_JACOCO_AGENT});
            this.jacocoAgentTask.into((Object)new File(this.getGlobalScope().getIntermediatesDir(), "jacoco"));
        }
        return this.jacocoAgentTask;
    }

    public ZipAlign createZipAlignTask(String name, InstantRunBuildContext buildContext, File inputFile, File outputFile) {
        ZipAlign zipAlignTask = (ZipAlign)this.project.getTasks().create(name, ZipAlign.class);
        zipAlignTask.setInputFile(inputFile);
        zipAlignTask.setOutputFile(outputFile);
        zipAlignTask.setInstantRunBuildContext(buildContext);
        ConventionMappingHelper.map((Task)zipAlignTask, "zipAlignExe", new Callable<File>(){

            @Override
            public File call() throws Exception {
                String path;
                TargetInfo info = TaskManager.this.androidBuilder.getTargetInfo();
                if (info != null && (path = info.getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN)) != null) {
                    return new File(path);
                }
                return null;
            }
        });
        return zipAlignTask;
    }

    protected void createMinifyTransform(TaskFactory taskFactory, VariantScope variantScope, boolean createJarFile) {
        this.doCreateMinifyTransform(taskFactory, variantScope, null, createJarFile);
    }

    protected final void doCreateMinifyTransform(TaskFactory taskFactory, VariantScope variantScope, Configuration mappingConfiguration, boolean createJarFile) {
        if (((CoreBuildType)variantScope.getVariantData().getVariantConfiguration().getBuildType()).isUseProguard()) {
            if (this.getIncrementalMode(variantScope.getVariantConfiguration()) != IncrementalMode.NONE) {
                this.logger.warn("Instant Run: Proguard is not compatible with instant run. It has been disabled for {}", (Object)variantScope.getVariantConfiguration().getFullName());
                return;
            }
            this.createProguardTransform(taskFactory, variantScope, mappingConfiguration, createJarFile);
            this.createShrinkResourcesTransform(taskFactory, variantScope);
        } else if (variantScope.getTestedVariantData() == null) {
            this.createNewShrinkerTransform(variantScope, taskFactory);
            this.createShrinkResourcesTransform(taskFactory, variantScope);
        }
    }

    private void createNewShrinkerTransform(VariantScope scope, TaskFactory taskFactory) {
        NewShrinkerTransform transform = new NewShrinkerTransform(scope);
        this.addProguardConfigFiles(transform, scope.getVariantData());
        if (scope.getVariantConfiguration().isTestCoverageEnabled()) {
            TaskManager.addJacocoShrinkerFlags(transform);
        }
        if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.NONE) {
            transform.keep("class ** extends android.app.Application {*;}");
            transform.keep("class com.android.tools.fd.** {*;}");
        }
        scope.getTransformManager().addTransform(taskFactory, scope, transform);
    }

    private void createProguardTransform(TaskFactory taskFactory, VariantScope variantScope, Configuration mappingConfiguration, boolean createJarFile) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = variantScope.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        BaseVariantData testedVariantData = variantScope.getTestedVariantData();
        ProGuardTransform transform = new ProGuardTransform(variantScope, createJarFile);
        if (testedVariantData != null) {
            transform.dontshrink();
            transform.dontoptimize();
            transform.keep("class * {*;}");
            transform.keep("interface * {*;}");
            transform.keep("enum * {*;}");
            transform.keepattributes();
            transform.setConfigurationFiles((Supplier<Collection<File>>)Suppliers.ofInstance((Object)testedVariantData.getVariantConfiguration().getTestProguardFiles()));
            transform.applyTestedMapping(testedVariantData.getMappingFile());
        } else {
            if (variantConfig.isTestCoverageEnabled()) {
                TaskManager.addJacocoShrinkerFlags(transform);
            }
            this.addProguardConfigFiles(transform, variantData);
            if (mappingConfiguration != null) {
                transform.applyTestedMapping(mappingConfiguration);
            }
        }
        AndroidTask<TransformTask> task = variantScope.getTransformManager().addTransform(taskFactory, variantScope, transform, new TransformTask.ConfigActionCallback<ProGuardTransform>(){

            @Override
            public void callback(final ProGuardTransform transform, final TransformTask task) {
                variantData.mappingFileProviderTask = new FileSupplier(){

                    @Override
                    public Task getTask() {
                        return task;
                    }

                    public File get() {
                        return transform.getMappingFile();
                    }
                };
            }
        });
        if (mappingConfiguration != null) {
            Verify.verifyNotNull(task);
            task.dependsOn(taskFactory, mappingConfiguration);
        }
    }

    private void createShrinkResourcesTransform(TaskFactory taskFactory, VariantScope scope) {
        if (!((CoreBuildType)scope.getVariantConfiguration().getBuildType()).isShrinkResources()) {
            return;
        }
        if (this.getIncrementalMode(scope.getVariantConfiguration()) != IncrementalMode.NONE) {
            this.logger.warn("Instant Run: Resource shrinker automatically disabled for {}", (Object)scope.getVariantConfiguration().getFullName());
            return;
        }
        if (!((CoreBuildType)scope.getVariantConfiguration().getBuildType()).isUseProguard()) {
            throw new IllegalArgumentException("Build-in class shrinker and resource shrinking are not supported yet.");
        }
        for (BaseVariantOutputData baseVariantOutputData : scope.getVariantData().getOutputs()) {
            VariantOutputScope variantOutputScope = baseVariantOutputData.getScope();
            ShrinkResourcesTransform shrinkResTransform = new ShrinkResourcesTransform(baseVariantOutputData, variantOutputScope.getProcessResourcePackageOutputFile(), variantOutputScope.getCompressedResourceFile(), this.androidBuilder, this.logger);
            AndroidTask<TransformTask> shrinkTask = scope.getTransformManager().addTransform(taskFactory, variantOutputScope, shrinkResTransform);
            variantOutputScope.setShrinkResourcesTask(shrinkTask);
        }
    }

    private static void addJacocoShrinkerFlags(ProguardConfigurable transform) {
        transform.keep("class com.vladium.** {*;}");
        transform.keep("class org.jacoco.** {*;}");
        transform.keep("interface org.jacoco.** {*;}");
        transform.dontwarn("org.jacoco.**");
    }

    private void addProguardConfigFiles(ProguardConfigurable transform, final BaseVariantData<? extends BaseVariantOutputData> variantData) {
        final GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        transform.setConfigurationFiles(new Supplier<Collection<File>>(){

            public Collection<File> get() {
                Set proguardFiles = variantConfig.getProguardFiles(true, Collections.singletonList(TaskManager.this.getDefaultProguardFile(TaskManager.DEFAULT_PROGUARD_CONFIG_FILE)));
                BaseVariantOutputData outputData = (BaseVariantOutputData)variantData.getOutputs().get(0);
                proguardFiles.add(outputData.processResourcesTask.getProguardOutputFile());
                return proguardFiles;
            }
        });
    }

    public void createReportTasks(List<BaseVariantData<? extends BaseVariantOutputData>> variantDataList) {
        DependencyReportTask dependencyReportTask = (DependencyReportTask)this.project.getTasks().create("androidDependencies", DependencyReportTask.class);
        dependencyReportTask.setDescription("Displays the Android dependencies of the project.");
        dependencyReportTask.setVariants(variantDataList);
        dependencyReportTask.setGroup(ANDROID_GROUP);
        SigningReportTask signingReportTask = (SigningReportTask)this.project.getTasks().create("signingReport", SigningReportTask.class);
        signingReportTask.setDescription("Displays the signing info for each variant.");
        signingReportTask.setVariants(variantDataList);
        signingReportTask.setGroup(ANDROID_GROUP);
    }

    public void createAnchorTasks(TaskFactory tasks, VariantScope scope) {
        this.createPreBuildTasks(tasks, scope);
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setSourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Sources"), Task.class, new Action<Task>(){

            public void execute(Task task) {
                variantData.sourceGenTask = task;
            }
        }));
        scope.setResourceGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Resources"), Task.class, new Action<Task>(){

            public void execute(Task task) {
                variantData.resourceGenTask = task;
            }
        }));
        scope.setAssetGenTask(this.androidTasks.create(tasks, scope.getTaskName("generate", "Assets"), Task.class, new Action<Task>(){

            public void execute(Task task) {
                variantData.assetGenTask = task;
            }
        }));
        if (!variantData.getType().isForTesting() && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isTestCoverageEnabled()) {
            scope.setCoverageReportTask(this.androidTasks.create(tasks, scope.getTaskName("create", "CoverageReport"), Task.class, new Action<Task>(){

                public void execute(Task task) {
                    task.setGroup("verification");
                    task.setDescription(String.format("Creates test coverage reports for the %s variant.", variantData.getName()));
                }
            }));
        }
        this.createCompileAnchorTask(tasks, scope);
    }

    private void createPreBuildTasks(TaskFactory tasks, VariantScope scope) {
        PrepareDependenciesTask prepareDependenciesTask;
        BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        variantData.preBuildTask = this.project.getTasks().create(scope.getTaskName("pre", "Build"));
        variantData.preBuildTask.dependsOn(new Object[]{MAIN_PREBUILD});
        variantData.prepareDependenciesTask = prepareDependenciesTask = (PrepareDependenciesTask)this.project.getTasks().create(scope.getTaskName("prepare", "Dependencies"), PrepareDependenciesTask.class);
        prepareDependenciesTask.dependsOn(new Object[]{variantData.preBuildTask});
        prepareDependenciesTask.setAndroidBuilder(this.androidBuilder);
        prepareDependenciesTask.setVariantName(scope.getVariantConfiguration().getFullName());
        prepareDependenciesTask.setVariant(variantData);
        VariantDependencies configurationDependencies = variantData.getVariantDependency();
        prepareDependenciesTask.addChecker(configurationDependencies.getChecker());
        for (LibraryDependencyImpl lib : configurationDependencies.getLibraries()) {
            this.dependencyManager.addDependencyToPrepareTask(variantData, prepareDependenciesTask, lib);
        }
    }

    private void createCompileAnchorTask(TaskFactory tasks, final VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        scope.setCompileTask(this.androidTasks.create(tasks, new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return scope.getTaskName("compile", "Sources");
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            @Override
            public void execute(Task task) {
                variantData.compileTask = task;
                variantData.compileTask.setGroup(TaskManager.BUILD_GROUP);
            }
        }));
        variantData.assembleVariantTask.dependsOn(new Object[]{scope.getCompileTask().getName()});
    }

    public void createCheckManifestTask(TaskFactory tasks, VariantScope scope) {
        final BaseVariantData<? extends BaseVariantOutputData> variantData = scope.getVariantData();
        final String name = variantData.getVariantConfiguration().getFullName();
        scope.setCheckManifestTask(this.androidTasks.create(tasks, scope.getTaskName("check", "Manifest"), CheckManifest.class, new Action<CheckManifest>(){

            public void execute(CheckManifest checkManifestTask) {
                variantData.checkManifestTask = checkManifestTask;
                checkManifestTask.setVariantName(name);
                ConventionMappingHelper.map((Task)checkManifestTask, "manifest", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return variantData.getVariantConfiguration().getDefaultSourceSet().getManifestFile();
                    }
                });
            }
        }));
        scope.getCheckManifestTask().dependsOn(tasks, variantData.preBuildTask);
        variantData.prepareDependenciesTask.dependsOn(new Object[]{scope.getCheckManifestTask().getName()});
    }

    public static void optionalDependsOn(Task main, Task ... dependencies) {
        for (Task dependency : dependencies) {
            if (dependency == null) continue;
            main.dependsOn(new Object[]{dependency});
        }
    }

    public static void optionalDependsOn(Task main, List<?> dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == null) continue;
            main.dependsOn(new Object[]{dependency});
        }
    }

    private static List<ManifestDependencyImpl> getManifestDependencies(List<LibraryDependency> libraries) {
        ArrayList list = Lists.newArrayListWithCapacity((int)libraries.size());
        for (LibraryDependency lib : libraries) {
            List<ManifestDependencyImpl> children = TaskManager.getManifestDependencies(lib.getDependencies());
            list.add(new ManifestDependencyImpl(lib.getName(), lib.getManifest(), children));
        }
        return list;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public AndroidTaskRegistry getAndroidTasks() {
        return this.androidTasks;
    }

    private File getDefaultProguardFile(String name) {
        File sdkDir = this.sdkHandler.getAndCheckSdkFolder();
        return new File(sdkDir, "tools" + File.separatorChar + "proguard" + File.separatorChar + name);
    }

    public void addDataBindingDependenciesIfNecessary(DataBindingOptions options) {
        if (!options.isEnabled()) {
            return;
        }
        String version = (String)Objects.firstNonNull((Object)options.getVersion(), (Object)this.dataBindingBuilder.getCompilerVersion());
        this.project.getDependencies().add("compile", (Object)("com.android.databinding:library:" + this.dataBindingBuilder.getLibraryVersion(version)));
        this.project.getDependencies().add("compile", (Object)("com.android.databinding:baseLibrary:" + this.dataBindingBuilder.getBaseLibraryVersion(version)));
        this.project.getDependencies().add("provided", (Object)("com.android.databinding:compiler:" + version));
        if (options.getAddDefaultAdapters()) {
            this.project.getDependencies().add("compile", (Object)("com.android.databinding:adapters:" + this.dataBindingBuilder.getBaseAdaptersVersion(version)));
        }
    }

    protected static enum IncrementalMode {
        NONE,
        FULL,
        LOCAL_JAVA_ONLY,
        LOCAL_RES_ONLY;

    }
}

