/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import com.android.build.gradle.ndk.internal.StlNativeToolSpecification;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.NativeBinarySpec;

public class StlConfiguration {
    private static final List<String> VALID_STL = ImmutableList.of((Object)"system", (Object)"stlport_static", (Object)"stlport_shared", (Object)"gnustl_static", (Object)"gnustl_shared", (Object)"gabi++_static", (Object)"gabi++_shared", (Object)"c++_static", (Object)"c++_shared");

    public static File getStlBaseDirectory(NdkHandler ndkHandler) {
        return new File(ndkHandler.getNdkDirectory(), "sources/cxx-stl/");
    }

    public static void checkStl(String stl) {
        if (!VALID_STL.contains(stl)) {
            throw new InvalidUserDataException("Invalid STL: " + stl);
        }
    }

    public static void createStlCopyTask(ModelMap<Task> tasks, final NativeBinarySpec binary, final File buildDir, NdkHandler ndkHandler, String stl, String stlVersion, String buildTaskName) {
        if (stl.endsWith("_shared")) {
            final StlNativeToolSpecification stlConfig = new StlNativeToolSpecification(ndkHandler, stl, stlVersion, binary.getTargetPlatform());
            final String copyTaskName = NdkNamingScheme.getTaskName(binary, "copy", "StlSo");
            tasks.create(copyTaskName, Copy.class, (Action)new Action<Copy>(){

                public void execute(Copy copy) {
                    copy.from(new Object[]{stlConfig.getStlLib(binary.getTargetPlatform().getName())});
                    copy.into((Object)new File(buildDir, NdkNamingScheme.getDebugLibraryDirectoryName(binary)));
                }
            });
            tasks.named(buildTaskName, (Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{copyTaskName});
                }
            });
        }
    }
}

