/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecHandleBuilder
extends AbstractExecHandleBuilder
implements ExecSpec {
    private final List<Object> arguments = new ArrayList<Object>();

    public ExecHandleBuilder() {
        super(new IdentityFileResolver());
    }

    public ExecHandleBuilder(FileResolver fileResolver) {
        super(fileResolver);
    }

    @Override
    public ExecHandleBuilder executable(Object executable) {
        super.executable(executable);
        return this;
    }

    @Override
    public ExecHandleBuilder commandLine(Object ... arguments) {
        this.commandLine(Arrays.asList(arguments));
        return this;
    }

    @Override
    public ExecHandleBuilder commandLine(Iterable<?> args) {
        ArrayList argsList = Lists.newArrayList(args);
        this.executable(argsList.get(0));
        this.setArgs((Iterable)argsList.subList(1, argsList.size()));
        return this;
    }

    @Override
    public void setCommandLine(Object ... args) {
        this.commandLine(args);
    }

    @Override
    public void setCommandLine(Iterable<?> args) {
        this.commandLine((Iterable)args);
    }

    @Override
    public ExecHandleBuilder args(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("args == null!");
        }
        this.arguments.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public ExecHandleBuilder args(Iterable<?> args) {
        GUtil.addToCollection(this.arguments, (Iterable[])new Iterable[]{args});
        return this;
    }

    @Override
    public ExecHandleBuilder setArgs(Iterable<?> arguments) {
        this.arguments.clear();
        GUtil.addToCollection(this.arguments, (Iterable[])new Iterable[]{arguments});
        return this;
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object argument : this.arguments) {
            args.add(argument.toString());
        }
        return args;
    }

    @Override
    public List<String> getAllArguments() {
        return this.getArgs();
    }

    @Override
    public ExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Override
    public ExecHandleBuilder workingDir(Object dir) {
        super.workingDir(dir);
        return this;
    }

    @Override
    public ExecHandleBuilder setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    public ExecHandleBuilder noStandardInput() {
        this.setStandardInput(new ByteArrayInputStream(new byte[0]));
        return this;
    }

    @Override
    public ExecHandleBuilder redirectErrorStream() {
        super.redirectErrorStream();
        return this;
    }

    @Override
    public ExecHandleBuilder setStandardOutput(OutputStream outputStream) {
        super.setStandardOutput(outputStream);
        return this;
    }

    @Override
    public ExecHandleBuilder setStandardInput(InputStream inputStream) {
        super.setStandardInput(inputStream);
        return this;
    }

    @Override
    public ExecHandleBuilder listener(ExecHandleListener listener) {
        super.listener(listener);
        return this;
    }

    @Override
    public ExecHandleBuilder setTimeout(int timeoutMillis) {
        super.setTimeout(timeoutMillis);
        return this;
    }

    public ExecHandleBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }
}

