/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.FileTreeElementComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeElementHasher {
    private static final byte HASH_PATH_SEPARATOR = 47;
    private static final byte HASH_RECORD_SEPARATOR = 10;

    public static final int calculateHashForFilePaths(Collection<FileTreeElement> allFileTreeElements) {
        SortedSet<FileTreeElement> sortedFileTreeElement = FileTreeElementHasher.asSortedSet(allFileTreeElements);
        Hasher hasher = Hashing.adler32().newHasher();
        for (FileTreeElement fileTreeElement : sortedFileTreeElement) {
            for (String pathPart : fileTreeElement.getRelativePath().getSegments()) {
                hasher.putUnencodedChars((CharSequence)pathPart);
                hasher.putByte((byte)47);
            }
            hasher.putByte((byte)10);
        }
        return hasher.hash().asInt();
    }

    private static SortedSet<FileTreeElement> asSortedSet(Collection<FileTreeElement> allFileTreeElements) {
        if (allFileTreeElements instanceof SortedSet) {
            return (SortedSet)allFileTreeElements;
        }
        TreeSet<FileTreeElement> sortedFileTreeElement = new TreeSet<FileTreeElement>(FileTreeElementComparator.INSTANCE);
        sortedFileTreeElement.addAll(allFileTreeElements);
        return sortedFileTreeElement;
    }
}

