/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.internal.serialize.StatefulSerializer;
import org.gradle.messaging.remote.internal.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSerializer<T>
implements StatefulSerializer<T> {
    private final ClassLoader classLoader;

    public JavaSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ObjectReader<T> newReader(Decoder decoder) {
        return new JavaReader(decoder, this.classLoader);
    }

    @Override
    public ObjectWriter<T> newWriter(Encoder encoder) {
        return new JavaWriter(encoder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaWriter<T>
    implements ObjectWriter<T> {
        private final Encoder encoder;

        public JavaWriter(Encoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public void write(T value) throws Exception {
            Message.send(value, this.encoder.getOutputStream());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaReader<T>
    implements ObjectReader<T> {
        private final Decoder decoder;
        private final ClassLoader classLoader;

        private JavaReader(Decoder decoder, ClassLoader classLoader) {
            this.decoder = decoder;
            this.classLoader = classLoader;
        }

        @Override
        public T read() throws Exception {
            return (T)Message.receive(this.decoder.getInputStream(), this.classLoader);
        }
    }
}

