/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializerRegistry<T>
implements SerializerRegistry<T> {
    private final Map<Class<?>, Serializer<?>> serializerMap = new TreeMap(new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });
    private final Set<Class<?>> javaSerialization = new HashSet();

    @Override
    public <U extends T> void register(Class<U> implementationType, Serializer<U> serializer) {
        this.serializerMap.put(implementationType, serializer);
    }

    @Override
    public <U extends T> void useJavaSerialization(Class<U> implementationType) {
        this.javaSerialization.add(implementationType);
    }

    @Override
    public Serializer<T> build() {
        if (this.serializerMap.size() == 1 && this.javaSerialization.isEmpty()) {
            return this.serializerMap.values().iterator().next();
        }
        return new TaggedTypeSerializer(this.serializerMap, this.javaSerialization);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaggedTypeSerializer<T>
    implements Serializer<T> {
        private static final int JAVA_TYPE = 1;
        private static final TypeInfo JAVA_SERIALIZATION = new TypeInfo(1, new DefaultSerializer());
        private final Map<Class<?>, TypeInfo> serializersByType = new HashMap();
        private final TypeInfo[] serializersByTag;
        private final Set<Class<?>> javaSerialization;

        public TaggedTypeSerializer(Map<Class<?>, Serializer<?>> serializerMap, Set<Class<?>> javaSerialization) {
            this.javaSerialization = new HashSet(javaSerialization);
            this.serializersByTag = new TypeInfo[2 + serializerMap.size()];
            this.serializersByTag[1] = JAVA_SERIALIZATION;
            int nextTag = 2;
            for (Map.Entry<Class<?>, Serializer<?>> entry : serializerMap.entrySet()) {
                this.add(nextTag, entry.getKey(), entry.getValue());
                ++nextTag;
            }
        }

        private void add(int tag, Class<?> type, Serializer<?> serializer) {
            TypeInfo typeInfo = new TypeInfo(tag, serializer);
            this.serializersByType.put(type, typeInfo);
            this.serializersByTag[typeInfo.tag] = typeInfo;
        }

        @Override
        public T read(Decoder decoder) throws Exception {
            TypeInfo typeInfo;
            int tag = decoder.readSmallInt();
            TypeInfo typeInfo2 = typeInfo = tag >= this.serializersByTag.length ? null : this.serializersByTag[tag];
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Unexpected type tag %d found.", tag));
            }
            return typeInfo.serializer.read(decoder);
        }

        @Override
        public void write(Encoder encoder, T value) throws Exception {
            TypeInfo typeInfo = this.map(value.getClass());
            encoder.writeSmallInt(typeInfo.tag);
            typeInfo.serializer.write(encoder, value);
        }

        private TypeInfo map(Class<?> valueType) {
            Class targetType = Throwable.class.isAssignableFrom(valueType) ? Throwable.class : valueType;
            TypeInfo typeInfo = this.serializersByType.get(targetType);
            if (typeInfo != null) {
                return typeInfo;
            }
            for (Class<Throwable> clazz : this.javaSerialization) {
                if (!clazz.isAssignableFrom(targetType)) continue;
                return JAVA_SERIALIZATION;
            }
            throw new IllegalArgumentException(String.format("Don't know how to serialize an object of type %s.", valueType.getName()));
        }
    }

    private static class TypeInfo {
        final int tag;
        final Serializer serializer;

        private TypeInfo(int tag, Serializer serializer) {
            this.tag = tag;
            this.serializer = serializer;
        }
    }
}

