/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.creators;

import com.android.tools.idea.structure.services.DeveloperServiceCreator;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableProperty;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.collections.ObservableList;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.ui.properties.expressions.list.MapExpression;
import com.android.tools.idea.ui.properties.expressions.list.SizeExpression;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.analytics.Analytics;
import com.google.api.services.analytics.model.Account;
import com.google.api.services.analytics.model.Accounts;
import com.google.api.services.analytics.model.Webproperties;
import com.google.api.services.analytics.model.Webproperty;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.services.GoogleServiceLoginListener;
import com.google.services.creators.GoogleServiceCreator;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class AnalyticsServiceCreator
extends GoogleServiceCreator {
    private final ObservableBool myLoggedIn = GoogleServiceLoginListener.getInstance().loggedIn();
    private final ObservableList<Account> myAccounts = new ObservableList();
    private final ObservableList<Webproperty> myProperties = new ObservableList();
    private final IntValueProperty myAccountIndex = new IntValueProperty(Integer.valueOf(-1));
    private final IntValueProperty myPropertyIndex = new IntValueProperty(Integer.valueOf(-1));
    private final StringValueProperty myPropertyId = new StringValueProperty();
    private final BoolValueProperty myAdsEnabled = new BoolValueProperty();
    private final ObservableList<String> myAccountNames = new ObservableList();
    private final ObservableList<String> myPropertyNames = new ObservableList();
    private final BindingsManager myBindings = new BindingsManager();
    private final InvalidationListener myLoginListener = new InvalidationListener(){

        public void onInvalidated(@NotNull ObservableValue<?> sender) {
            if (sender == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/services/creators/AnalyticsServiceCreator$1", "onInvalidated"));
            }
            if (((Boolean)AnalyticsServiceCreator.this.myLoggedIn.get()).booleanValue()) {
                AnalyticsServiceCreator.this.refreshProjects();
            } else {
                AnalyticsServiceCreator.this.myAccounts.clear();
                AnalyticsServiceCreator.this.myProperties.clear();
                AnalyticsServiceCreator.this.myAccountIndex.set((Object)-1);
                AnalyticsServiceCreator.this.myPropertyIndex.set((Object)-1);
            }
        }
    };

    public AnalyticsServiceCreator() {
        this.myLoggedIn.addWeakListener(this.myLoginListener);
        this.myBindings.bind(this.myAccountNames, (ObservableValue)new MapExpression<Account, String>(this.myAccounts){

            @NotNull
            protected String transform(@NotNull Account account) {
                if (account == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "account", "com/google/services/creators/AnalyticsServiceCreator$2", "transform"));
                }
                String string = account.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/services/creators/AnalyticsServiceCreator$2", "transform"));
                }
                return string;
            }
        });
        this.myBindings.bind(this.myPropertyNames, (ObservableValue)new MapExpression<Webproperty, String>(this.myProperties){

            @NotNull
            protected String transform(@NotNull Webproperty property) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/google/services/creators/AnalyticsServiceCreator$3", "transform"));
                }
                String string = property.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/services/creators/AnalyticsServiceCreator$3", "transform"));
                }
                return string;
            }
        });
        this.myAccountIndex.addListener(new InvalidationListener(){

            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/services/creators/AnalyticsServiceCreator$4", "onInvalidated"));
                }
                if (AnalyticsServiceCreator.this.myAccountIndex.get() >= 0) {
                    AnalyticsServiceCreator.this.refreshProperties();
                }
            }
        });
        this.myPropertyIndex.addListener(new InvalidationListener(){

            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/google/services/creators/AnalyticsServiceCreator$5", "onInvalidated"));
                }
                if (AnalyticsServiceCreator.this.myPropertyIndex.get() >= 0) {
                    AnalyticsServiceCreator.this.myPropertyId.set((Object)((Webproperty)AnalyticsServiceCreator.this.myProperties.get(AnalyticsServiceCreator.this.myPropertyIndex.get().intValue())).getId());
                }
            }
        });
    }

    @NotNull
    protected String getResourceRoot() {
        if ("/analytics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/services/creators/AnalyticsServiceCreator", "getResourceRoot"));
        }
        return "/analytics";
    }

    @NotNull
    protected String[] getResources() {
        String[] stringArray = new String[]{"AnalyticsTrackers.java.ftl", "AndroidManifest.xml", "app_tracker.xml.ftl", "logo_analytics_color_2x_web_32dp.png", "recipe.xml", "service.xml"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/services/creators/AnalyticsServiceCreator", "getResources"));
        }
        return stringArray;
    }

    @Override
    protected void initializeAdditionalContext(@NotNull ServiceContext serviceContext) {
        if (serviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceContext", "com/google/services/creators/AnalyticsServiceCreator", "initializeAdditionalContext"));
        }
        SizeExpression accountSize = new SizeExpression(this.myAccounts);
        serviceContext.putValue("google.analytics.accounts", this.myAccountNames);
        serviceContext.putValue("google.analytics.accountIndex", (ObservableValue)this.myAccountIndex);
        serviceContext.putValue("google.analytics.properties", this.myPropertyNames);
        serviceContext.putValue("google.analytics.propertyIndex", (ObservableValue)this.myPropertyIndex);
        serviceContext.putValue("google.analytics.hasNoAccount", (ObservableValue)accountSize.isEqualTo(0).and((ObservableValue)this.myLoggedIn));
        serviceContext.putValue("google.analytics.hasAccount", (ObservableValue)accountSize.isGreaterThan(0));
        serviceContext.putValue("google.analytics.canEditPropertyId", (ObservableValue)accountSize.isEqualTo(0));
        serviceContext.putAction("google.analytics.refreshProjects", new Runnable(){

            @Override
            public void run() {
                AnalyticsServiceCreator.this.refreshProjects();
            }
        });
        serviceContext.putAction("google.analytics.createProject", new Runnable(){

            @Override
            public void run() {
                AnalyticsServiceCreator.browse((String)"https://support.google.com/analytics/answer/1008015");
            }
        });
        serviceContext.putWatchedValue("google.analytics.propertyId", (ObservableProperty)this.myPropertyId);
        serviceContext.putWatchedValue("google.analytics.adsEnabled", (ObservableProperty)this.myAdsEnabled);
        serviceContext.setBeforeShownCallback(new Runnable(){

            @Override
            public void run() {
                if (((Boolean)AnalyticsServiceCreator.this.myLoggedIn.get()).booleanValue()) {
                    AnalyticsServiceCreator.this.refreshProjects();
                }
            }
        });
        serviceContext.setIsValidCallback((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !AnalyticsServiceCreator.this.myPropertyId.get().isEmpty();
            }
        });
    }

    private void refreshProjects() {
        final CredentialedUser user = GoogleLogin.getInstance().getActiveUser();
        assert (user != null);
        Callable<Accounts> fetchAccounts = new Callable<Accounts>(){

            @Override
            public Accounts call() throws Exception {
                Analytics analytics = new Analytics.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)user.getCredential()).setApplicationName("Android Studio").build();
                Accounts accounts = (Accounts)analytics.management().accounts().list().execute();
                if (accounts != null && accounts.getItems().size() > 0) {
                    return accounts;
                }
                return null;
            }
        };
        DeveloperServiceCreator.Dispatchable<Accounts> onAccountsFetched = new DeveloperServiceCreator.Dispatchable<Accounts>(){

            public void dispatch(@NotNull Accounts accounts) {
                if (accounts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accounts", "com/google/services/creators/AnalyticsServiceCreator$11", "dispatch"));
                }
                AnalyticsServiceCreator.this.myAccounts.setAll((Collection)accounts.getItems());
                AnalyticsServiceCreator.this.myAccountIndex.set((Object)0);
            }
        };
        AnalyticsServiceCreator.runInBackground((Callable)fetchAccounts, (DeveloperServiceCreator.Dispatchable)onAccountsFetched);
    }

    private void refreshProperties() {
        final Account account = (Account)this.myAccounts.get(this.myAccountIndex.get().intValue());
        assert (account != null);
        final CredentialedUser user = GoogleLogin.getInstance().getActiveUser();
        assert (user != null);
        this.myPropertyIndex.set((Object)-1);
        Callable<Webproperties> fetchProperties = new Callable<Webproperties>(){

            @Override
            public Webproperties call() throws Exception {
                Analytics analytics = new Analytics.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)user.getCredential()).setApplicationName("Android Studio").build();
                String id = account.getId();
                Webproperties properties = (Webproperties)analytics.management().webproperties().list(id).execute();
                if (properties != null && properties.getItems().size() > 0) {
                    return properties;
                }
                return null;
            }
        };
        DeveloperServiceCreator.Dispatchable<Webproperties> onPropertiesFetched = new DeveloperServiceCreator.Dispatchable<Webproperties>(){

            public void dispatch(@NotNull Webproperties properties) {
                if (properties == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/google/services/creators/AnalyticsServiceCreator$13", "dispatch"));
                }
                AnalyticsServiceCreator.this.myProperties.setAll((Collection)properties.getItems());
                AnalyticsServiceCreator.this.myPropertyIndex.set((Object)0);
            }
        };
        AnalyticsServiceCreator.runInBackground((Callable)fetchProperties, (DeveloperServiceCreator.Dispatchable)onPropertiesFetched);
    }
}

