/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WrongIdDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private final Set<String> mGlobalIds = new HashSet<String>(100);
    private Set<String> mFileIds;
    private Set<String> mDeclaredIds;
    private List<Pair<String, Location.Handle>> mHandles;
    private List<Element> mRelativeLayouts;
    public static final Issue UNKNOWN_ID = Issue.create("UnknownId", "Reference to an unknown id", "The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand. This check catches errors where you have renamed an id without updating all of the references to it.", Category.CORRECTNESS, 8, Severity.FATAL, new Implementation(WrongIdDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE));
    public static final Issue NOT_SIBLING = Issue.create("NotSibling", "RelativeLayout Invalid Constraints", "Layout constraints in a given `RelativeLayout` should reference other views within the same relative layout (but not itself!)", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue INVALID = Issue.create("InvalidId", "Invalid ID declaration", "An id definition *must* be of the form `@+id/yourname`. The tools have not rejected strings of the form `@+foo/bar` in the past, but that was an error, and could lead to tricky errors because of the way the id integers are assigned.\n\nIf you really want to have different \"scopes\" for your id's, use prefixes instead, such as `login_button1` and `login_button2`.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue UNKNOWN_ID_LAYOUT = Issue.create("UnknownIdInLayout", "Reference to an id that is not in the current layout", "The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand.\n\nThis is sometimes intentional, for example where you are referring to a view which is provided in a different layout via an include. However, it is usually an accident where you have a typo or you have renamed a view without updating all the references to it.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("RelativeLayout", "item", "android.support.percent.PercentRelativeLayout");
    }

    @Override
    public void beforeCheckFile(Context context) {
        this.mFileIds = new HashSet<String>();
        this.mRelativeLayouts = null;
    }

    @Override
    public void afterCheckFile(Context context) {
        if (this.mRelativeLayouts != null) {
            if (!context.getProject().getReportIssues()) {
                return;
            }
            for (Element layout : this.mRelativeLayouts) {
                List<Element> children = LintUtils.getChildren(layout);
                HashSet ids = Sets.newHashSetWithExpectedSize((int)children.size());
                for (Element child : children) {
                    String id = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
                    if (id == null || id.isEmpty()) continue;
                    ids.add(id);
                }
                for (Element element : children) {
                    String selfId = LintUtils.stripIdPrefix(element.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
                    NamedNodeMap attributes = element.getAttributes();
                    int n = attributes.getLength();
                    for (int i = 0; i < n; ++i) {
                        Location location;
                        String message;
                        XmlContext xmlContext;
                        Attr attr = (Attr)attributes.item(i);
                        String value = attr.getValue();
                        if (!value.startsWith("@+id/") && !value.startsWith("@id/") || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) || !attr.getLocalName().startsWith("layout_")) continue;
                        if (!WrongIdDetector.idDefined(this.mFileIds, value)) {
                            xmlContext = (XmlContext)context;
                            Location.Handle handle = xmlContext.createLocationHandle(attr);
                            handle.setClientData(attr);
                            if (this.mHandles == null) {
                                this.mHandles = new ArrayList<Pair<String, Location.Handle>>();
                            }
                            this.mHandles.add((Pair<String, Location.Handle>)Pair.of((Object)value, (Object)handle));
                            continue;
                        }
                        if (ids.contains(value)) {
                            if ("id".equals(attr.getLocalName()) || selfId.isEmpty() || !value.endsWith(selfId) || !LintUtils.stripIdPrefix(value).equals(selfId)) continue;
                            xmlContext = (XmlContext)context;
                            message = String.format("Cannot be relative to self: id=%1$s, %2$s=%3$s", selfId, attr.getLocalName(), selfId);
                            location = xmlContext.getLocation(attr);
                            xmlContext.report(NOT_SIBLING, attr, location, message);
                            continue;
                        }
                        if (value.startsWith("@+id/")) {
                            if (ids.contains("@id/" + LintUtils.stripIdPrefix(value))) {
                                continue;
                            }
                        } else {
                            assert (value.startsWith("@id/")) : value;
                            if (ids.contains("@+id/" + LintUtils.stripIdPrefix(value))) continue;
                        }
                        if (!context.isEnabled(NOT_SIBLING)) continue;
                        xmlContext = (XmlContext)context;
                        message = String.format("`%1$s` is not a sibling in the same `RelativeLayout`", value);
                        location = xmlContext.getLocation(attr);
                        xmlContext.report(NOT_SIBLING, attr, location, message);
                    }
                }
            }
        }
        this.mFileIds = null;
        if (!context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context);
        }
    }

    @Override
    public void afterCheckProject(Context context) {
        if (context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context);
        }
    }

    private void checkHandles(Context context) {
        if (this.mHandles != null) {
            boolean checkSameLayout = context.isEnabled(UNKNOWN_ID_LAYOUT);
            boolean checkExists = context.isEnabled(UNKNOWN_ID);
            boolean projectScope = context.getScope().contains((Object)Scope.ALL_RESOURCE_FILES);
            for (Pair<String, Location.Handle> pair : this.mHandles) {
                Location.Handle handle;
                String id = (String)pair.getFirst();
                boolean isBound = projectScope ? WrongIdDetector.idDefined(this.mGlobalIds, id) : this.idDefined(context, id, context.file);
                LintClient client = context.getClient();
                if (!isBound && checkExists && (projectScope || client.supportsProjectResources())) {
                    List<String> suggestions;
                    AbstractResourceRepository resources;
                    handle = (Location.Handle)pair.getSecond();
                    boolean isDeclared = WrongIdDetector.idDefined(this.mDeclaredIds, id);
                    id = LintUtils.stripIdPrefix(id);
                    HashSet spellingDictionary = this.mGlobalIds;
                    if (!projectScope && client.supportsProjectResources() && (resources = client.getProjectResources(context.getProject(), true)) != null) {
                        spellingDictionary = Sets.newHashSet((Iterable)resources.getItemsOfType(ResourceType.ID));
                        spellingDictionary.remove(id);
                    }
                    String suggestionMessage = (suggestions = WrongIdDetector.getSpellingSuggestions(id, spellingDictionary)).size() > 1 ? String.format(" Did you mean one of {%2$s} ?", id, Joiner.on((String)", ").join(suggestions)) : (!suggestions.isEmpty() ? String.format(" Did you mean %2$s ?", id, suggestions.get(0)) : "");
                    String message = isDeclared ? String.format("The id \"`%1$s`\" is defined but not assigned to any views.%2$s", id, suggestionMessage) : String.format("The id \"`%1$s`\" is not defined anywhere.%2$s", id, suggestionMessage);
                    WrongIdDetector.report(context, UNKNOWN_ID, handle, message);
                    continue;
                }
                if (!checkSameLayout || projectScope && !isBound || !id.startsWith("@+id/")) continue;
                handle = (Location.Handle)pair.getSecond();
                WrongIdDetector.report(context, UNKNOWN_ID_LAYOUT, handle, String.format("The id \"`%1$s`\" is not referring to any views in this layout", LintUtils.stripIdPrefix(id)));
            }
        }
    }

    private static void report(Context context, Issue issue, Location.Handle handle, String message) {
        Location location = handle.resolve();
        Object clientData = handle.getClientData();
        if (clientData instanceof Node && context.getDriver().isSuppressed(null, issue, (Node)clientData)) {
            return;
        }
        context.report(issue, location, message);
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String name;
            String type = element.getAttribute("type");
            if ("id".equals(type) && !(name = element.getAttribute("name")).isEmpty()) {
                if (this.mDeclaredIds == null) {
                    this.mDeclaredIds = Sets.newHashSet();
                }
                this.mDeclaredIds.add("@id/" + name);
            }
        } else {
            assert (tagName.equals("RelativeLayout") || tagName.equals("android.support.percent.PercentRelativeLayout"));
            if (this.mRelativeLayouts == null) {
                this.mRelativeLayouts = new ArrayList<Element>();
            }
            this.mRelativeLayouts.add(element);
        }
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        assert (attribute.getName().equals("id") || attribute.getLocalName().equals("id"));
        String id = attribute.getValue();
        this.mFileIds.add(id);
        this.mGlobalIds.add(id);
        if (id.equals("@+id/") || id.equals("@id/") || "@+id".equals("@id/")) {
            String message = "Invalid id: missing value";
            context.report(INVALID, attribute, context.getLocation(attribute), message);
        } else if (id.startsWith("@+") && !id.startsWith("@+id/") && !id.startsWith("@+android:id/") || id.startsWith("@+id/") && id.indexOf(47, "@+id/".length()) != -1) {
            int nameStart = id.startsWith("@+id/") ? "@+id/".length() : 2;
            String suggested = "@+id/" + id.substring(nameStart).replace('/', '_');
            String message = String.format("ID definitions *must* be of the form `@+id/name`; try using `%1$s`", suggested);
            context.report(INVALID, attribute, context.getLocation(attribute), message);
        }
    }

    private static boolean idDefined(Set<String> ids, String id) {
        if (ids == null) {
            return false;
        }
        boolean definedLocally = ids.contains(id);
        if (!definedLocally) {
            if (id.startsWith("@+id/")) {
                definedLocally = ids.contains("@id/" + id.substring("@+id/".length()));
            } else if (id.startsWith("@id/")) {
                definedLocally = ids.contains("@+id/" + id.substring("@id/".length()));
            }
        }
        return definedLocally;
    }

    private boolean idDefined(Context context, String id, File notIn) {
        AbstractResourceRepository resources = context.getClient().getProjectResources(context.getProject(), true);
        if (resources != null) {
            List items = resources.getResourceItem(ResourceType.ID, LintUtils.stripIdPrefix(id));
            if (items == null || items.isEmpty()) {
                return false;
            }
            for (ResourceItem item : items) {
                ResourceFile source = (ResourceFile)item.getSource();
                if (source == null) continue;
                File file = source.getFile();
                if (file.getParentFile().getName().startsWith("values")) {
                    if (this.mDeclaredIds == null) {
                        this.mDeclaredIds = Sets.newHashSet();
                    }
                    this.mDeclaredIds.add(id);
                    continue;
                }
                if (LintUtils.isSameResourceFile(file, notIn)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getSpellingSuggestions(String id, Collection<String> ids) {
        int maxDistance = id.length() >= 4 ? 2 : 1;
        ArrayListMultimap matches = ArrayListMultimap.create((int)2, (int)10);
        int count = 0;
        if (!ids.isEmpty()) {
            for (String matchWith : ids) {
                matchWith = LintUtils.stripIdPrefix(matchWith);
                if (Math.abs(id.length() - matchWith.length()) > maxDistance) continue;
                int distance = LintUtils.editDistance(id, matchWith);
                if (distance <= maxDistance) {
                    matches.put((Object)distance, (Object)matchWith);
                }
                if (count++ <= 100) continue;
                break;
            }
        }
        for (int i = 0; i < maxDistance; ++i) {
            Collection strings = matches.get((Object)i);
            if (strings == null || strings.isEmpty()) continue;
            ArrayList<String> suggestions = new ArrayList<String>(strings);
            Collections.sort(suggestions);
            return suggestions;
        }
        return Collections.emptyList();
    }
}

