/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chartlib;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Path2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class AnimatedComponent
extends JComponent
implements ActionListener,
HierarchyListener {
    protected static final Font DEFAULT_FONT = new Font("Sans", 0, 10);
    protected final Timer mTimer;
    protected float mFrameLength;
    protected long mLastRenderTime;
    protected boolean mDrawDebugInfo;
    protected boolean mUpdateData = true;
    protected boolean mStep;
    private List<String> mDebugInfo;

    public AnimatedComponent(int fps) {
        this.mTimer = new Timer(1000 / fps, this);
        this.mDebugInfo = new LinkedList<String>();
        this.addHierarchyListener(this);
    }

    protected final float lerp(float from, float to, float fraction) {
        float q = (float)Math.pow(1.0f - fraction, this.mFrameLength);
        return from * q + to * (1.0f - q);
    }

    public final boolean isDrawDebugInfo() {
        return this.mDrawDebugInfo;
    }

    public final void setDrawDebugInfo(boolean drawDebugInfo) {
        this.mDrawDebugInfo = drawDebugInfo;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        long now = System.nanoTime();
        this.mFrameLength = (float)(now - this.mLastRenderTime) / 1.0E9f;
        this.mLastRenderTime = now;
        if (this.mUpdateData || this.mStep) {
            this.mStep = false;
            this.updateData();
        }
        this.draw(g2d);
        if (this.mDrawDebugInfo) {
            this.doDebugDraw(g2d);
        }
        g2d.dispose();
    }

    protected final void addDebugInfo(String format, Object ... values) {
        if (this.mDrawDebugInfo) {
            this.mDebugInfo.add(String.format(format, values));
        }
    }

    private void doDebugDraw(Graphics2D g) {
        this.debugDraw(g);
        this.addDebugInfo("Render time: %.2fms", Float.valueOf((float)(System.nanoTime() - this.mLastRenderTime) / 1000000.0f));
        this.addDebugInfo("FPS: %.2f", Float.valueOf(1.0f / this.mFrameLength));
        g.setFont(DEFAULT_FONT);
        g.setColor(Color.BLACK);
        int i = 0;
        for (String s : this.mDebugInfo) {
            g.drawString(s, this.getSize().width - 150, this.getSize().height - 10 * i++ - 5);
        }
        this.mDebugInfo.clear();
    }

    protected abstract void updateData();

    protected abstract void draw(Graphics2D var1);

    protected void debugDraw(Graphics2D g) {
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }

    @Override
    public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.mTimer.isRunning() && !this.isShowing()) {
            this.mTimer.stop();
        } else if (!this.mTimer.isRunning() && this.isShowing()) {
            this.mTimer.start();
        }
    }

    public final void setUpdateData(boolean updateData) {
        this.mUpdateData = updateData;
    }

    public final void step() {
        this.mStep = true;
    }

    protected static void drawArrow(Graphics2D g, float x, float y, float dx, float dy, float len, Color color) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x, y);
        path.lineTo(x + dx * len, y + dy * len);
        path.lineTo(x + dx * (len - 10.0f) + dy * 10.0f, y + dy * (len - 10.0f) - dx * 10.0f);
        path.lineTo(x + dx * (len - 10.0f) - dy * 10.0f, y + dy * (len - 10.0f) + dx * 10.0f);
        g.setColor(color);
        g.draw(path);
    }

    protected static void drawMarker(Graphics2D g, float x, float y, Color color) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x - 10.0f, y);
        path.lineTo(x + 10.0f, y);
        path.moveTo(x, y - 10.0f);
        path.lineTo(x, y + 10.0f);
        g.setColor(color);
        g.draw(path);
    }
}

