/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public abstract class AbstractNativeCompileTask
extends DefaultTask {
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private boolean positionIndependentCode;
    private File objectFileDir;
    private ConfigurableFileCollection includes = this.getProject().files(new Object[0]);
    private ConfigurableFileCollection source = this.getProject().files(new Object[0]);
    private Map<String, String> macros;
    private List<String> compilerArgs;

    public AbstractNativeCompileTask() {
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return NativeToolChainInternal.Identifier.identify((NativeToolChainInternal)AbstractNativeCompileTask.this.toolChain, (NativePlatformInternal)AbstractNativeCompileTask.this.targetPlatform);
            }
        });
        this.dependsOn(new Object[]{this.includes});
    }

    @Inject
    public IncrementalCompilerBuilder getIncrementalCompilerBuilder() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void compile(IncrementalTaskInputs inputs) {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        NativeCompileSpec spec = this.createCompileSpec();
        spec.setTargetPlatform((NativePlatform)this.targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(this.getObjectFileDir());
        spec.include((Iterable)this.includes);
        spec.source((Iterable)this.getSource());
        spec.setMacros(this.getMacros());
        spec.args(this.getCompilerArgs());
        spec.setPositionIndependentCode(this.isPositionIndependentCode());
        spec.setIncrementalCompile(inputs.isIncremental());
        spec.setOperationLogger(operationLogger);
        spec.setIncrementalInputs(inputs);
        this.configureSpec(spec);
        PlatformToolProvider platformToolProvider = this.toolChain.select(this.targetPlatform);
        this.setDidWork(this.doCompile(spec, platformToolProvider).getDidWork());
    }

    protected void configureSpec(NativeCompileSpec spec) {
    }

    private <T extends NativeCompileSpec> WorkResult doCompile(T spec, PlatformToolProvider platformToolProvider) {
        Class specType = (Class)Cast.uncheckedCast(spec.getClass());
        Compiler baseCompiler = platformToolProvider.newCompiler(specType);
        Compiler incrementalCompiler = this.getIncrementalCompilerBuilder().createIncrementalCompiler((TaskInternal)this, baseCompiler, (NativeToolChain)this.toolChain);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(incrementalCompiler);
        return loggingCompiler.execute(spec);
    }

    protected abstract NativeCompileSpec createCompileSpec();

    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @Input
    public boolean isPositionIndependentCode() {
        return this.positionIndependentCode;
    }

    public void setPositionIndependentCode(boolean positionIndependentCode) {
        this.positionIndependentCode = positionIndependentCode;
    }

    @OutputDirectory
    public File getObjectFileDir() {
        return this.objectFileDir;
    }

    public void setObjectFileDir(File objectFileDir) {
        this.objectFileDir = objectFileDir;
    }

    @Input
    public FileCollection getIncludes() {
        return this.includes;
    }

    public void includes(Object includeRoots) {
        this.includes.from(new Object[]{includeRoots});
    }

    @InputFiles
    public FileCollection getSource() {
        return this.source;
    }

    public void source(Object sourceFiles) {
        this.source.from(new Object[]{sourceFiles});
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }
}

