/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report.unbound;

import com.google.common.base.Joiner;
import java.io.PrintWriter;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.report.unbound.UnboundRuleInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class UnboundRulesReporter {
    private final PrintWriter writer;
    private final String prefix;
    private static final String INDENT = "  ";

    public UnboundRulesReporter(PrintWriter writer, String prefix) {
        this.writer = writer;
        this.prefix = prefix;
    }

    public void reportOn(Iterable<? extends UnboundRule> rules) {
        boolean first = true;
        for (UnboundRule unboundRule : rules) {
            if (!first) {
                this.writer.println();
            }
            first = false;
            this.writer.print(this.prefix);
            this.writer.print(unboundRule.getDescriptor());
            if (unboundRule.getMutableInputs().size() > 0) {
                this.heading("Mutable:");
                this.reportInputs(unboundRule.getMutableInputs());
            }
            if (unboundRule.getImmutableInputs().size() <= 0) continue;
            this.heading("Immutable:");
            this.reportInputs(unboundRule.getImmutableInputs());
        }
    }

    private void reportInputs(Iterable<? extends UnboundRuleInput> inputs) {
        for (UnboundRuleInput unboundRuleInput : inputs) {
            this.item();
            this.writer.print(unboundRuleInput.isBound() ? "+ " : "- ");
            String path = unboundRuleInput.getPath() == null ? "<unspecified>" : unboundRuleInput.getPath();
            this.writer.print(String.format("%s (%s)", path, unboundRuleInput.getType()));
            if (unboundRuleInput.getDescription() != null) {
                this.writer.print(String.format(" %s", unboundRuleInput.getDescription()));
            }
            if (unboundRuleInput.getPath() == null && unboundRuleInput.getScope() != null) {
                this.writer.print(String.format(" in scope of '%s'", unboundRuleInput.getScope()));
            }
            if (unboundRuleInput.getSuggestedPaths().size() <= 0) continue;
            this.writer.print(" - suggestions: ");
            this.writer.print(Joiner.on((String)", ").join(unboundRuleInput.getSuggestedPaths()));
        }
    }

    private void item() {
        this.writer.println();
        this.writer.print(this.prefix);
        this.writer.print(INDENT);
        this.writer.print(INDENT);
    }

    private void heading(String heading) {
        this.writer.println();
        this.writer.print(this.prefix);
        this.writer.print(INDENT);
        this.writer.print(heading);
    }
}

