/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import net.jcip.annotations.NotThreadSafe;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultModelSchemaStore
implements ModelSchemaStore {
    private static final DefaultModelSchemaStore INSTANCE = new DefaultModelSchemaStore();
    final ModelSchemaCache cache = new ModelSchemaCache();
    final ModelSchemaExtractor extractor = new ModelSchemaExtractor();

    public static DefaultModelSchemaStore getInstance() {
        return INSTANCE;
    }

    DefaultModelSchemaStore() {
    }

    @Override
    public <T> ModelSchema<T> getSchema(ModelType<T> type) {
        return this.extractor.extract(type, this.cache);
    }

    @Override
    public <T> ModelSchema<T> getSchema(Class<T> type) {
        return this.getSchema(ModelType.of(type));
    }

    @Override
    public void cleanUp() {
        this.cache.cleanUp();
    }

    public long size() {
        return this.cache.size();
    }
}

