/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.MethodDescription;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.DefaultMethodRuleDefinition;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelRuleExtractor {
    final LoadingCache<Class<?>, List<ExtractedModelRule>> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, List<ExtractedModelRule>>(){

        public List<ExtractedModelRule> load(Class<?> source) throws Exception {
            return ModelRuleExtractor.this.doExtract(source);
        }
    });
    private final Iterable<MethodModelRuleExtractor> handlers;

    public ModelRuleExtractor(Iterable<MethodModelRuleExtractor> handlers) {
        this.handlers = handlers;
    }

    private String describeHandlers() {
        String desc = Joiner.on((String)", ").join((Iterable)CollectionUtils.collect(this.handlers, (Transformer)new Transformer<String, MethodModelRuleExtractor>(){

            public String transform(MethodModelRuleExtractor original) {
                return original.getDescription();
            }
        }));
        return "[" + desc + "]";
    }

    private static RuntimeException invalid(Class<?> source, String reason) {
        return ModelRuleExtractor.invalid(source, reason, null);
    }

    private static RuntimeException invalid(Class<?> source, String reason, Throwable throwable) {
        return new InvalidModelRuleDeclarationException("Type " + source.getName() + " is not a valid model rule source: " + reason, throwable);
    }

    private static RuntimeException invalidMethod(Method method, String reason) {
        String description = MethodDescription.name((String)method.getName()).owner(method.getDeclaringClass()).takes(method.getGenericParameterTypes()).toString();
        return ModelRuleExtractor.invalid(description, reason);
    }

    private static RuntimeException invalid(ModelRuleDescriptor rule, String reason) {
        StringBuilder sb = new StringBuilder();
        rule.describeTo(sb);
        return ModelRuleExtractor.invalid(sb.toString(), reason);
    }

    private static RuntimeException invalid(String ruleDescription, String reason) {
        StringBuilder sb = new StringBuilder();
        sb.append(ruleDescription).append(" is not a valid model rule method").append(": ").append(reason);
        return new InvalidModelRuleDeclarationException(sb.toString());
    }

    public Iterable<ExtractedModelRule> extract(Class<?> source) {
        try {
            return (Iterable)this.cache.get(source);
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (UncheckedExecutionException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
        }
    }

    private List<ExtractedModelRule> doExtract(Class<?> source) {
        this.validate(source);
        Method[] methods = source.getDeclaredMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        ImmutableList.Builder registrations = ImmutableList.builder();
        for (Method method : methods) {
            if (method.getTypeParameters().length > 0) {
                throw ModelRuleExtractor.invalidMethod(method, "cannot have type variables (i.e. cannot be a generic method)");
            }
            MethodRuleDefinition<?, ?> ruleDefinition = DefaultMethodRuleDefinition.create(source, method);
            MethodModelRuleExtractor handler = this.getMethodHandler(ruleDefinition);
            if (handler == null) continue;
            this.validateMethod(method);
            ExtractedModelRule registration = handler.registration(ruleDefinition);
            if (registration == null) continue;
            registrations.add((Object)registration);
        }
        return registrations.build();
    }

    private MethodModelRuleExtractor getMethodHandler(MethodRuleDefinition<?, ?> ruleDefinition) {
        MethodModelRuleExtractor handler = null;
        for (MethodModelRuleExtractor candidateHandler : this.handlers) {
            if (!candidateHandler.getSpec().isSatisfiedBy(ruleDefinition)) continue;
            if (handler == null) {
                handler = candidateHandler;
                continue;
            }
            throw ModelRuleExtractor.invalid(ruleDefinition.getDescriptor(), "can only be one of " + this.describeHandlers());
        }
        return handler;
    }

    public void validate(Class<?> source) throws InvalidModelRuleDeclarationException {
        Field[] fields;
        Constructor<?>[] constructors;
        int modifiers = source.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            throw ModelRuleExtractor.invalid(source, "must be a class, not an interface");
        }
        if (!RuleSource.class.isAssignableFrom(source) || !source.getSuperclass().equals(RuleSource.class)) {
            throw ModelRuleExtractor.invalid(source, "rule source classes must directly extend " + RuleSource.class.getName());
        }
        if (Modifier.isAbstract(modifiers)) {
            throw ModelRuleExtractor.invalid(source, "class cannot be abstract");
        }
        if (source.getEnclosingClass() != null) {
            if (Modifier.isStatic(modifiers)) {
                if (Modifier.isPrivate(modifiers)) {
                    throw ModelRuleExtractor.invalid(source, "class cannot be private");
                }
            } else {
                throw ModelRuleExtractor.invalid(source, "enclosed classes must be static and non private");
            }
        }
        for (Constructor<?> constructor : constructors = source.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length <= 0) continue;
            throw ModelRuleExtractor.invalid(source, "cannot declare a constructor that takes arguments");
        }
        try {
            Constructor<?> constructor = constructors[0];
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw ModelRuleExtractor.invalid(source, "instance creation failed", e.getCause());
        }
        catch (InstantiationException e) {
            throw ModelRuleExtractor.invalid(source, "instance creation failed", e);
        }
        catch (IllegalAccessException e) {
            throw ModelRuleExtractor.invalid(source, "must have an accessible constructor", e);
        }
        for (Field field : fields = source.getDeclaredFields()) {
            int fieldModifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(fieldModifiers) && Modifier.isFinal(fieldModifiers)) continue;
            throw ModelRuleExtractor.invalid(source, "field " + field.getName() + " is not static final");
        }
    }

    private void validateMethod(Method ruleMethod) {
        ModelType returnType = ModelType.returnType(ruleMethod);
        if (returnType.isRawClassOfParameterizedType()) {
            throw ModelRuleExtractor.invalidMethod(ruleMethod, "raw type " + returnType + " used for return type (all type parameters must be specified of parameterized type)");
        }
        int i = 0;
        for (Type type : ruleMethod.getGenericParameterTypes()) {
            ++i;
            ModelType<?> modelType = ModelType.of(type);
            if (!modelType.isRawClassOfParameterizedType()) continue;
            throw ModelRuleExtractor.invalidMethod(ruleMethod, "raw type " + modelType + " used for parameter " + i + " (all type parameters must be specified of parameterized type)");
        }
    }
}

