/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.List;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodBackedModelAction<T>
implements ModelAction<T> {
    private final ModelRuleDescriptor descriptor;
    private final ModelReference<T> subject;
    private final List<ModelReference<?>> inputs;
    private final ModelRuleInvoker<?> ruleInvoker;

    public MethodBackedModelAction(MethodRuleDefinition<?, T> ruleDefinition) {
        this(ruleDefinition.getRuleInvoker(), ruleDefinition.getDescriptor(), ruleDefinition.getSubjectReference(), ruleDefinition.getTailReferences());
    }

    public MethodBackedModelAction(ModelRuleInvoker<?> ruleInvoker, ModelRuleDescriptor descriptor, ModelReference<T> subject, List<ModelReference<?>> inputs) {
        this.ruleInvoker = ruleInvoker;
        this.subject = subject;
        this.inputs = inputs;
        this.descriptor = descriptor;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ModelReference<T> getSubject() {
        return this.subject;
    }

    @Override
    public List<ModelReference<?>> getInputs() {
        return this.inputs;
    }

    @Override
    public void execute(MutableModelNode modelNode, T object, List<ModelView<?>> inputs) {
        Object[] args = new Object[1 + this.inputs.size()];
        args[0] = object;
        for (int i = 0; i < this.inputs.size(); ++i) {
            args[i + 1] = inputs.get(i).getInstance();
        }
        this.ruleInvoker.invoke(args);
    }

    public String toString() {
        return "MethodBackedModelAction{descriptor=" + this.descriptor + ", subject=" + this.subject + ", inputs=" + this.inputs + '}';
    }
}

