/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Nullable;
import org.gradle.internal.BiAction;
import org.gradle.internal.Cast;
import org.gradle.model.ModelSet;
import org.gradle.model.collection.ManagedSet;
import org.gradle.model.collection.internal.ModelMapModelProjection;
import org.gradle.model.internal.core.ChildNodeCreatorStrategy;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreatorFactory;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViewFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NoInputsModelAction;
import org.gradle.model.internal.core.NodeBackedModelSet;
import org.gradle.model.internal.core.TypedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.inspect.ManagedModelInitializer;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelCreatorFactory
implements ModelCreatorFactory {
    private final ModelSchemaStore schemaStore;
    private final ManagedProxyFactory proxyFactory;
    private ManagedChildNodeCreatorStrategy<?> managedChildCreatorStrategy;

    public DefaultModelCreatorFactory(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
        this.proxyFactory = new ManagedProxyFactory();
        this.managedChildCreatorStrategy = new ManagedChildNodeCreatorStrategy(this, schemaStore);
    }

    @Override
    public <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema) {
        return this.creator(descriptor, path, schema, (ModelAction)null);
    }

    @Override
    public <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema, Action<? super T> initializer) {
        ModelReference<T> modelReference = ModelReference.of(path, schema.getType());
        NoInputsModelAction<? super T> modelAction = new NoInputsModelAction<T>(modelReference, descriptor, initializer);
        return this.creator(descriptor, path, schema, modelAction);
    }

    @Override
    public <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema, List<ModelReference<?>> initializerInputs, BiAction<? super T, ? super List<ModelView<?>>> initializer) {
        ModelReference<T> modelReference = ModelReference.of(path, schema.getType());
        InputUsingModelAction<? super T> modelAction = new InputUsingModelAction<T>(modelReference, descriptor, initializerInputs, initializer);
        return this.creator(descriptor, path, schema, modelAction);
    }

    private <T> ModelCreator creator(ModelRuleDescriptor descriptor, ModelPath path, ModelSchema<T> schema, @Nullable ModelAction<T> initializer) {
        ModelCreators.Builder builder;
        ModelType<T> type = schema.getType();
        if (schema instanceof ModelCollectionSchema) {
            builder = ModelCreators.of(path);
            ModelCollectionSchema collectionSchema = (ModelCollectionSchema)schema;
            ModelType<?> elementType = collectionSchema.getElementType();
            this.addCollectionProjection(builder, collectionSchema, elementType);
        } else if (schema instanceof ModelStructSchema) {
            ModelStructSchema structSchema = (ModelStructSchema)schema;
            builder = ModelCreators.of(path, new ManagedModelInitializer(descriptor, structSchema, this.schemaStore, this)).withProjection(new ManagedModelProjection(structSchema, this.schemaStore, this.proxyFactory));
        } else {
            throw new IllegalArgumentException("Don't know how to create model element from schema for " + type);
        }
        builder.descriptor(descriptor);
        if (schema.getKind() == ModelSchema.Kind.STRUCT && Named.class.isAssignableFrom(type.getRawClass())) {
            builder.action(ModelActionRole.Initialize, new NamedInitializer(path, descriptor));
        }
        if (initializer != null) {
            builder.action(ModelActionRole.Initialize, initializer);
        }
        return builder.build();
    }

    private <T, E> void addCollectionProjection(ModelCreators.Builder builder, ModelCollectionSchema<T> collectionSchema, ModelType<E> elementType) {
        if (collectionSchema.isMap()) {
            builder.withProjection(this.modelMapProjection(elementType));
        } else {
            Class setType = collectionSchema.getType().getRawClass();
            if (setType.equals(ModelSet.class)) {
                builder.withProjection(TypedModelProjection.of(ModelTypes.modelSet(elementType), this.modelSetFactory(elementType)));
            } else if (setType.equals(ManagedSet.class)) {
                builder.withProjection(TypedModelProjection.of(ModelTypes.managedSet(elementType), this.managedSetFactory(elementType)));
            } else {
                throw new IllegalStateException("Expected ModelSet or ManagedSet");
            }
        }
    }

    private <T> ModelProjection modelMapProjection(ModelType<T> elementType) {
        return ModelMapModelProjection.managed(elementType, this.childCreator());
    }

    private <T> ChildNodeCreatorStrategy<T> childCreator() {
        return (ChildNodeCreatorStrategy)Cast.uncheckedCast(this.managedChildCreatorStrategy);
    }

    private <T> ChildNodeCreatorStrategy<T> childCreator(ModelType<T> modelType) {
        return (ChildNodeCreatorStrategy)Cast.uncheckedCast(this.managedChildCreatorStrategy);
    }

    private <T> ModelViewFactory<ManagedSet<T>> managedSetFactory(ModelType<T> elementType) {
        return new ManagedSetModelViewFactory<T>(elementType);
    }

    private <T> ModelViewFactory<ModelSet<T>> modelSetFactory(ModelType<T> elementType) {
        return new ModelSetModelViewFactory<T>(elementType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelSetModelViewFactory<T>
    implements ModelViewFactory<ModelSet<T>> {
        private final ModelType<T> elementType;

        public ModelSetModelViewFactory(ModelType<T> elementType) {
            this.elementType = elementType;
        }

        @Override
        public ModelView<ModelSet<T>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
            ModelType<ModelSet<T>> setType = ModelTypes.modelSet(this.elementType);
            DefaultModelViewState state = new DefaultModelViewState(setType, ruleDescriptor, writable, !writable);
            NodeBackedModelSet<T> set = new NodeBackedModelSet<T>(setType.toString() + " '" + modelNode.getPath() + "'", this.elementType, ruleDescriptor, modelNode, state, DefaultModelCreatorFactory.this.childCreator(this.elementType));
            return new InstanceModelView<Object>(modelNode.getPath(), setType, set, state.closer());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelSetModelViewFactory that = (ModelSetModelViewFactory)o;
            return this.elementType.equals(that.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ManagedSetModelViewFactory<T>
    implements ModelViewFactory<ManagedSet<T>> {
        private final ModelType<T> elementType;

        public ManagedSetModelViewFactory(ModelType<T> elementType) {
            this.elementType = elementType;
        }

        @Override
        public ModelView<ManagedSet<T>> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
            ModelType<ManagedSet<T>> setType = ModelTypes.managedSet(this.elementType);
            DefaultModelViewState state = new DefaultModelViewState(setType, ruleDescriptor, writable, !writable);
            NodeBackedModelSet<T> set = new NodeBackedModelSet<T>(setType.toString() + " '" + modelNode.getPath() + "'", this.elementType, ruleDescriptor, modelNode, state, DefaultModelCreatorFactory.this.childCreator(this.elementType));
            return new InstanceModelView<Object>(modelNode.getPath(), setType, set, state.closer());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManagedSetModelViewFactory that = (ManagedSetModelViewFactory)o;
            return this.elementType.equals(that.elementType);
        }

        public int hashCode() {
            return this.elementType.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedInitializer
    implements ModelAction<Object> {
        private final ModelPath modelPath;
        private final ModelRuleDescriptor parentDescriptor;

        public NamedInitializer(ModelPath modelPath, ModelRuleDescriptor parentDescriptor) {
            this.modelPath = modelPath;
            this.parentDescriptor = parentDescriptor;
        }

        @Override
        public ModelReference<Object> getSubject() {
            return ModelReference.of(this.modelPath);
        }

        @Override
        public void execute(MutableModelNode modelNode, Object object, List<ModelView<?>> inputs) {
            MutableModelNode nameLink = modelNode.getLink("name");
            if (nameLink == null) {
                throw new IllegalStateException("expected name node for " + modelNode.getPath());
            }
            nameLink.setPrivateData(ModelType.of(String.class), modelNode.getPath().getName());
        }

        @Override
        public List<ModelReference<?>> getInputs() {
            return Collections.emptyList();
        }

        @Override
        public ModelRuleDescriptor getDescriptor() {
            return new NestedModelRuleDescriptor(this.parentDescriptor, "<set name>");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedChildNodeCreatorStrategy<T>
    implements ChildNodeCreatorStrategy<T> {
        private final ModelCreatorFactory modelCreatorFactory;
        private final ModelSchemaStore modelSchemaStore;

        public ManagedChildNodeCreatorStrategy(ModelCreatorFactory modelCreatorFactory, ModelSchemaStore modelSchemaStore) {
            this.modelCreatorFactory = modelCreatorFactory;
            this.modelSchemaStore = modelSchemaStore;
        }

        @Override
        public <S extends T> ModelCreator creator(MutableModelNode parentNode, ModelRuleDescriptor sourceDescriptor, ModelType<S> type, String name) {
            ModelPath childPath = parentNode.getPath().child(name);
            return this.modelCreatorFactory.creator(sourceDescriptor, childPath, this.modelSchemaStore.getSchema(type));
        }
    }
}

