/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.Actions;
import org.gradle.internal.BiAction;
import org.gradle.internal.BiActions;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.model.internal.core.ChainingModelProjection;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.ProjectionBackedModelCreator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class ModelCreators {
    public static <T> Builder bridgedInstance(ModelReference<T> modelReference, T instance) {
        return ModelCreators.unmanagedInstance(modelReference, Factories.constant(instance), (Action<? super MutableModelNode>)Actions.doNothing());
    }

    public static <T> Builder unmanagedInstance(ModelReference<T> modelReference, Factory<? extends T> factory) {
        return ModelCreators.unmanagedInstance(modelReference, factory, (Action<? super MutableModelNode>)Actions.doNothing());
    }

    public static <T> Builder unmanagedInstance(ModelReference<T> modelReference, final Factory<? extends T> factory, final Action<? super MutableModelNode> initializer) {
        return ModelCreators.unmanagedInstanceOf(modelReference, new Transformer<T, MutableModelNode>(){

            public T transform(MutableModelNode modelNode) {
                Object t = factory.create();
                initializer.execute((Object)modelNode);
                return t;
            }
        });
    }

    public static <T> Builder unmanagedInstanceOf(final ModelReference<T> modelReference, final Transformer<? extends T, ? super MutableModelNode> factory) {
        return ModelCreators.of(modelReference.getPath(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                Object t = factory.transform((Object)modelNode);
                modelNode.setPrivateData(modelReference.getType(), t);
            }
        }).withProjection(UnmanagedModelProjection.of(modelReference.getType()));
    }

    public static Builder of(ModelPath path) {
        return new Builder(path, BiActions.doNothing());
    }

    public static Builder of(ModelPath path, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
        return new Builder(path, initializer);
    }

    public static Builder of(ModelPath path, Action<? super MutableModelNode> initializer) {
        return new Builder(path, BiActions.usingFirstArgument(initializer));
    }

    public static <T> Builder of(final ModelReference<T> modelReference, final Factory<? extends T> factory) {
        return ModelCreators.of(modelReference.getPath(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode modelNode) {
                Object value = factory.create();
                modelNode.setPrivateData(modelReference.getType(), value);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static class Builder {
        private final BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer;
        private final ModelPath path;
        private final List<ModelProjection> projections = new ArrayList<ModelProjection>();
        private final List<Pair<? extends ModelActionRole, ? extends ModelAction<?>>> actions = Lists.newArrayList();
        private boolean ephemeral;
        private boolean hidden;
        private ModelRuleDescriptor modelRuleDescriptor;
        private List<ModelReference<?>> inputs = Collections.emptyList();

        private Builder(ModelPath path, BiAction<? super MutableModelNode, ? super List<ModelView<?>>> initializer) {
            this.path = path;
            this.initializer = initializer;
        }

        public Builder descriptor(String descriptor) {
            this.modelRuleDescriptor = new SimpleModelRuleDescriptor(descriptor);
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor descriptor) {
            this.modelRuleDescriptor = descriptor;
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor parent, ModelRuleDescriptor child) {
            this.modelRuleDescriptor = new NestedModelRuleDescriptor(parent, child);
            return this;
        }

        public Builder descriptor(ModelRuleDescriptor parent, String child) {
            this.modelRuleDescriptor = new NestedModelRuleDescriptor(parent, new SimpleModelRuleDescriptor(child));
            return this;
        }

        public Builder action(ModelActionRole role, ModelAction<?> action) {
            this.actions.add(Pair.of((Object)((Object)role), action));
            return this;
        }

        public Builder inputs(List<ModelReference<?>> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder inputs(ModelReference<?> ... inputs) {
            this.inputs = Arrays.asList(inputs);
            return this;
        }

        public Builder withProjection(ModelProjection projection) {
            this.projections.add(projection);
            return this;
        }

        public Builder hidden(boolean flag) {
            this.hidden = flag;
            return this;
        }

        public Builder ephemeral(boolean flag) {
            this.ephemeral = flag;
            return this;
        }

        public ModelCreator build() {
            ModelProjection projection = this.projections.size() == 1 ? this.projections.get(0) : new ChainingModelProjection(this.projections);
            BiAction effectiveInitializer = this.initializer;
            if (!this.actions.isEmpty()) {
                effectiveInitializer = BiActions.composite((BiAction[])new BiAction[]{this.initializer, new BiAction<MutableModelNode, List<ModelView<?>>>(){

                    public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                        for (Pair action : Builder.this.actions) {
                            modelNode.applyToSelf((ModelActionRole)((Object)action.getLeft()), (ModelAction)action.getRight());
                        }
                    }
                }});
            }
            return new ProjectionBackedModelCreator(this.path, this.modelRuleDescriptor, this.ephemeral, this.hidden, this.inputs, projection, effectiveInitializer);
        }
    }
}

