/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader$WhenMappings;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBinaryClassAnnotationAndConstantLoader<A, C, T>
implements AnnotationAndConstantLoader<A, C, T> {
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Storage<A, C>> storage;
    private final KotlinClassFinder kotlinClassFinder;
    private final ErrorReporter errorReporter;

    @Nullable
    protected abstract C loadConstant(@NotNull String var1, @NotNull Object var2);

    @Nullable
    protected abstract KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId var1, @NotNull SourceElement var2, @NotNull List<A> var3);

    @NotNull
    protected abstract A loadTypeAnnotation(@NotNull ProtoBuf.Annotation var1, @NotNull NameResolver var2);

    private final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotationIfNotSpecial(ClassId annotationClassId, SourceElement source, List<A> result) {
        if (JvmAnnotationNames.isSpecialAnnotation(annotationClassId, true)) {
            return null;
        }
        return this.loadAnnotation(annotationClassId, source, result);
    }

    @Override
    @NotNull
    public List<A> loadClassAnnotations(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        ClassId classId;
        Intrinsics.checkParameterIsNotNull(classProto, "classProto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassId classId2 = classId = nameResolver.getClassId(classProto.getFqName());
        Intrinsics.checkExpressionValueIsNotNull(classId2, "classId");
        KotlinJvmBinaryClass kotlinClass = this.kotlinClassFinder.findKotlinClass(classId2);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading class annotations is not found: " + classId.asSingleFqName(), null);
            return CollectionsKt.listOf();
        }
        ArrayList result = new ArrayList(1);
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, result){
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;
            final /* synthetic */ ArrayList $result;

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
                Intrinsics.checkParameterIsNotNull(classId, "classId");
                Intrinsics.checkParameterIsNotNull(source, "source");
                return AbstractBinaryClassAnnotationAndConstantLoader.access$loadAnnotationIfNotSpecial(this.this$0, classId, source, this.$result);
            }

            public void visitEnd() {
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
            }
        });
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<T> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        if (Intrinsics.areEqual((Object)kind, (Object)AnnotatedCallableKind.PROPERTY)) {
            List<A> list;
            List list2;
            MemberSignature sig;
            MessageLite messageLite = proto;
            if (messageLite == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.serialization.ProtoBuf.Property");
            }
            ProtoBuf.Property cfr_ignored_0 = (ProtoBuf.Property)messageLite;
            NameResolver nameResolver = container.getNameResolver();
            MemberSignature syntheticFunctionSignature = AbstractBinaryClassAnnotationAndConstantLoader.getPropertySignature$default(this, (ProtoBuf.Property)proto, nameResolver, container.getTypeTable(), false, true, 8);
            MemberSignature fieldSignature = AbstractBinaryClassAnnotationAndConstantLoader.getPropertySignature$default(this, (ProtoBuf.Property)proto, nameResolver, container.getTypeTable(), true, false, 16);
            MemberSignature memberSignature = syntheticFunctionSignature;
            if (memberSignature != null) {
                void $receiver$iv;
                MemberSignature memberSignature2 = memberSignature;
                sig = (MemberSignature)$receiver$iv;
                list2 = AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, proto, sig, false, 8);
            } else {
                list2 = null;
            }
            List propertyAnnotations = CollectionsKt.orEmpty(list2);
            MemberSignature memberSignature3 = fieldSignature;
            if (memberSignature3 != null) {
                void $receiver$iv;
                sig = memberSignature3;
                MemberSignature sig2 = (MemberSignature)$receiver$iv;
                list = this.findClassAndLoadMemberAnnotations(container, proto, sig2, this.isStaticFieldInOuter(proto));
            } else {
                list = null;
            }
            List fieldAnnotations = CollectionsKt.orEmpty(list);
            return this.loadPropertyAnnotations(propertyAnnotations, fieldAnnotations);
        }
        MemberSignature memberSignature = this.getCallableSignature(proto, container.getNameResolver(), container.getTypeTable(), kind);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature signature = memberSignature;
        return this.transformAnnotations(AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, proto, signature, false, 8));
    }

    @Override
    @NotNull
    public List<A> loadEnumEntryAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.EnumEntry proto) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        String string = container.getNameResolver().getString(proto.getName());
        Intrinsics.checkExpressionValueIsNotNull(string, "container.nameResolver.getString(proto.name)");
        NameResolver nameResolver = container.getNameResolver();
        ProtoBuf.Class clazz = container.getClassProto();
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        ClassId classId = nameResolver.getClassId(clazz.getFqName());
        Intrinsics.checkExpressionValueIsNotNull(classId, "container.nameResolver.g\u2026iner.classProto!!.fqName)");
        MemberSignature signature = MemberSignature.Companion.fromFieldNameAndDesc(string, ClassMapperLite.mapClass(classId));
        return AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, proto, signature, false, 8);
    }

    @NotNull
    protected abstract List<T> loadPropertyAnnotations(@NotNull List<? extends A> var1, @NotNull List<? extends A> var2);

    @NotNull
    protected abstract List<T> transformAnnotations(@NotNull List<? extends A> var1);

    private final List<A> findClassAndLoadMemberAnnotations(ProtoContainer container, MessageLite proto, MemberSignature signature, boolean isStaticFieldInOuter) {
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, this.getImplClassName(proto, container.getNameResolver()), isStaticFieldInOuter);
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading member annotations is not found: " + container.getFqName(), null);
            return CollectionsKt.listOf();
        }
        List<Object> list = ((Storage)this.storage.invoke(kotlinClass)).getMemberAnnotations().get(signature);
        if (list == null) {
            list = CollectionsKt.listOf();
        }
        return list;
    }

    static /* bridge */ /* synthetic */ List findClassAndLoadMemberAnnotations$default(AbstractBinaryClassAnnotationAndConstantLoader abstractBinaryClassAnnotationAndConstantLoader, ProtoContainer protoContainer, MessageLite messageLite, MemberSignature memberSignature, boolean bl, int n) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return abstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations(protoContainer, messageLite, memberSignature, bl);
    }

    @Override
    @NotNull
    public List<A> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        MemberSignature methodSignature = this.getCallableSignature(message, container.getNameResolver(), container.getTypeTable(), kind);
        if (methodSignature != null) {
            Integer index = proto.hasExtension(JvmProtoBuf.index) ? proto.getExtension(JvmProtoBuf.index) : Integer.valueOf(parameterIndex);
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, ((Number)index).intValue());
            return AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, message, paramSignature, false, 8);
        }
        return CollectionsKt.listOf();
    }

    @Override
    @NotNull
    public List<A> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite message, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        MemberSignature methodSignature = this.getCallableSignature(message, container.getNameResolver(), container.getTypeTable(), kind);
        if (methodSignature != null) {
            MemberSignature paramSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(methodSignature, 0);
            return AbstractBinaryClassAnnotationAndConstantLoader.findClassAndLoadMemberAnnotations$default(this, container, message, paramSignature, false, 8);
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadTypeAnnotations(@NotNull ProtoBuf.Type type2, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable $receiver$iv = type2.getExtension(JvmProtoBuf.typeAnnotation);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item$iv$iv;
            void var9_9 = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            A a = this.loadTypeAnnotation((ProtoBuf.Annotation)v0, nameResolver);
            var9_9.add(a);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<A> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter typeParameter, @NotNull NameResolver nameResolver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Iterable $receiver$iv = typeParameter.getExtension(JvmProtoBuf.typeParameterAnnotation);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)item$iv$iv;
            void var9_9 = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            A a = this.loadTypeAnnotation((ProtoBuf.Annotation)v0, nameResolver);
            var9_9.add(a);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public C loadPropertyConstant(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto, @NotNull KotlinType expectedType) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        NameResolver nameResolver = container.getNameResolver();
        MemberSignature memberSignature = this.getCallableSignature(proto, nameResolver, container.getTypeTable(), AnnotatedCallableKind.PROPERTY);
        if (memberSignature == null) {
            return null;
        }
        MemberSignature signature = memberSignature;
        KotlinJvmBinaryClass kotlinClass = this.findClassWithAnnotationsAndInitializers(container, this.getImplClassName(proto, nameResolver), this.isStaticFieldInOuter(proto));
        if (kotlinClass == null) {
            this.errorReporter.reportLoadingError("Kotlin class for loading property constant is not found: " + container.getFqName(), null);
            return null;
        }
        return ((Storage)this.storage.invoke(kotlinClass)).getPropertyConstants().get(signature);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(ProtoContainer container, Name implClassName, boolean isStaticFieldInOuter) {
        void classProto;
        KotlinJvmBinaryClass kotlinJvmBinaryClass;
        void packageFqName;
        Object object = container;
        ProtoBuf.Class clazz = ((ProtoContainer)object).component1();
        FqName fqName2 = ((ProtoContainer)object).component2();
        object = null;
        if (packageFqName != null) {
            Name name = implClassName;
            if (name != null) {
                void $receiver$iv;
                object = name;
                Name it = (Name)$receiver$iv;
                kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(new ClassId((FqName)packageFqName, it));
            } else {
                kotlinJvmBinaryClass = null;
            }
        } else if (classProto != null) {
            ClassId classId = container.getNameResolver().getClassId(classProto.getFqName());
            if (implClassName != null) {
                ClassId implClassId = StringsKt.endsWith$default(implClassName.asString(), "$DefaultImpls", false, 2) ? new ClassId(classId.getPackageFqName(), new FqName(StringsKt.replace$default(implClassName.asString(), "$DefaultImpls", "." + "DefaultImpls", false, 4)), false) : new ClassId(classId.getPackageFqName(), implClassName);
                return this.kotlinClassFinder.findKotlinClass(implClassId);
            }
            if (isStaticFieldInOuter && classId.isNestedClass()) {
                ClassId classId2 = classId.getOuterClassId();
                Intrinsics.checkExpressionValueIsNotNull(classId2, "classId.outerClassId");
                return this.kotlinClassFinder.findKotlinClass(classId2);
            }
            ClassId classId3 = classId;
            Intrinsics.checkExpressionValueIsNotNull(classId3, "classId");
            kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId3);
        } else {
            kotlinJvmBinaryClass = null;
        }
        return kotlinJvmBinaryClass;
    }

    private final Name getImplClassName(MessageLite proto, NameResolver nameResolver) {
        return proto instanceof ProtoBuf.Function && ((ProtoBuf.Function)proto).hasExtension(JvmProtoBuf.methodImplClassName) ? nameResolver.getName(((Number)((ProtoBuf.Function)proto).getExtension(JvmProtoBuf.methodImplClassName)).intValue()) : (proto instanceof ProtoBuf.Property && ((ProtoBuf.Property)proto).hasExtension(JvmProtoBuf.propertyImplClassName) ? nameResolver.getName(((Number)((ProtoBuf.Property)proto).getExtension(JvmProtoBuf.propertyImplClassName)).intValue()) : (Name)null);
    }

    private final boolean isStaticFieldInOuter(MessageLite proto) {
        boolean bl;
        if (proto instanceof ProtoBuf.Property && ((ProtoBuf.Property)proto).hasExtension(JvmProtoBuf.propertySignature)) {
            JvmProtoBuf.JvmPropertySignature $receiver$iv = ((ProtoBuf.Property)proto).getExtension(JvmProtoBuf.propertySignature);
            JvmProtoBuf.JvmPropertySignature it = $receiver$iv;
            bl = it.hasField() && it.getField().getIsStaticInOuter();
        } else {
            bl = false;
        }
        return bl;
    }

    private final Storage<A, C> loadAnnotationsAndInitializers(KotlinJvmBinaryClass kotlinClass) {
        HashMap memberAnnotations = new HashMap();
        HashMap propertyConstants = new HashMap();
        kotlinClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, memberAnnotations, propertyConstants){
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;
            final /* synthetic */ HashMap $memberAnnotations;
            final /* synthetic */ HashMap $propertyConstants;

            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                Intrinsics.checkParameterIsNotNull(name, "name");
                Intrinsics.checkParameterIsNotNull(desc, "desc");
                String string = name.asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "name.asString()");
                return new loadAnnotationsAndInitializers.AnnotationVisitorForMethod(this, MemberSignature.Companion.fromMethodNameAndDesc(string, desc));
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer2) {
                C constant;
                Intrinsics.checkParameterIsNotNull(name, "name");
                Intrinsics.checkParameterIsNotNull(desc, "desc");
                String string = name.asString();
                Intrinsics.checkExpressionValueIsNotNull(string, "name.asString()");
                MemberSignature signature = MemberSignature.Companion.fromFieldNameAndDesc(string, desc);
                if (initializer2 != null && (constant = this.this$0.loadConstant(desc, initializer2)) != null) {
                    MapsKt.set(this.$propertyConstants, signature, constant);
                }
                return new loadAnnotationsAndInitializers.MemberAnnotationVisitor(this, signature);
            }
            {
                this.this$0 = $outer;
                this.$memberAnnotations = $captured_local_variable$1;
                this.$propertyConstants = $captured_local_variable$2;
            }
        });
        return new Storage(memberAnnotations, propertyConstants);
    }

    /*
     * WARNING - void declaration
     */
    private final MemberSignature getPropertySignature(ProtoBuf.Property proto, NameResolver nameResolver, TypeTable typeTable, boolean field, boolean synthetic) {
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature = proto.getExtension(JvmProtoBuf.propertySignature);
        if (field) {
            void desc;
            void name;
            JvmProtoBufUtil.PropertySignature propertySignature = JvmProtoBufUtil.INSTANCE.getJvmFieldSignature(proto, nameResolver, typeTable);
            if (propertySignature == null) {
                return null;
            }
            JvmProtoBufUtil.PropertySignature propertySignature2 = propertySignature;
            String string = propertySignature2.component1();
            String string2 = propertySignature2.component2();
            propertySignature2 = null;
            return MemberSignature.Companion.fromFieldNameAndDesc((String)name, (String)desc);
        }
        if (synthetic && signature.hasSyntheticMethod()) {
            JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature.getSyntheticMethod();
            Intrinsics.checkExpressionValueIsNotNull(jvmMethodSignature, "signature.syntheticMethod");
            return MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
        }
        return null;
    }

    static /* bridge */ /* synthetic */ MemberSignature getPropertySignature$default(AbstractBinaryClassAnnotationAndConstantLoader abstractBinaryClassAnnotationAndConstantLoader, ProtoBuf.Property property, NameResolver nameResolver, TypeTable typeTable, boolean bl, boolean bl2, int n) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return abstractBinaryClassAnnotationAndConstantLoader.getPropertySignature(property, nameResolver, typeTable, bl, bl2);
    }

    private final MemberSignature getCallableSignature(MessageLite proto, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind kind) {
        MemberSignature memberSignature;
        if (proto instanceof ProtoBuf.Constructor) {
            String string = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)proto, nameResolver, typeTable);
            if (string == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromMethodNameAndDesc(string);
        } else if (proto instanceof ProtoBuf.Function) {
            String string = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)proto, nameResolver, typeTable);
            if (string == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromMethodNameAndDesc(string);
        } else if (proto instanceof ProtoBuf.Property && ((ProtoBuf.Property)proto).hasExtension(JvmProtoBuf.propertySignature)) {
            JvmProtoBuf.JvmPropertySignature signature = ((ProtoBuf.Property)proto).getExtension(JvmProtoBuf.propertySignature);
            switch (AbstractBinaryClassAnnotationAndConstantLoader$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature.getGetter();
                    Intrinsics.checkExpressionValueIsNotNull(jvmMethodSignature, "signature.getter");
                    memberSignature = MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                    break;
                }
                case 2: {
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature.getSetter();
                    Intrinsics.checkExpressionValueIsNotNull(jvmMethodSignature, "signature.setter");
                    memberSignature = MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                    break;
                }
                case 3: {
                    memberSignature = this.getPropertySignature((ProtoBuf.Property)proto, nameResolver, typeTable, true, true);
                    break;
                }
                default: {
                    memberSignature = null;
                    break;
                }
            }
        } else {
            memberSignature = null;
        }
        return memberSignature;
    }

    public AbstractBinaryClassAnnotationAndConstantLoader(@NotNull StorageManager storageManager, @NotNull KotlinClassFinder kotlinClassFinder, @NotNull ErrorReporter errorReporter) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull(errorReporter, "errorReporter");
        this.kotlinClassFinder = kotlinClassFinder;
        this.errorReporter = errorReporter;
        this.storage = storageManager.createMemoizedFunction(new Function1<KotlinJvmBinaryClass, Storage<A, C>>(this){
            final /* synthetic */ AbstractBinaryClassAnnotationAndConstantLoader this$0;

            @NotNull
            public final Storage<A, C> invoke(@NotNull KotlinJvmBinaryClass kotlinClass) {
                Intrinsics.checkParameterIsNotNull(kotlinClass, "kotlinClass");
                return AbstractBinaryClassAnnotationAndConstantLoader.access$loadAnnotationsAndInitializers(this.this$0, kotlinClass);
            }
            {
                this.this$0 = abstractBinaryClassAnnotationAndConstantLoader;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor access$loadAnnotationIfNotSpecial(AbstractBinaryClassAnnotationAndConstantLoader $this, @NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List result) {
        return $this.loadAnnotationIfNotSpecial(annotationClassId, source, result);
    }

    @NotNull
    public static final /* synthetic */ Storage access$loadAnnotationsAndInitializers(AbstractBinaryClassAnnotationAndConstantLoader $this, @NotNull KotlinJvmBinaryClass kotlinClass) {
        return $this.loadAnnotationsAndInitializers(kotlinClass);
    }

    private static final class Storage<A, C> {
        @NotNull
        private final Map<MemberSignature, List<A>> memberAnnotations;
        @NotNull
        private final Map<MemberSignature, C> propertyConstants;

        @NotNull
        public final Map<MemberSignature, List<A>> getMemberAnnotations() {
            return this.memberAnnotations;
        }

        @NotNull
        public final Map<MemberSignature, C> getPropertyConstants() {
            return this.propertyConstants;
        }

        public Storage(@NotNull Map<MemberSignature, ? extends List<? extends A>> memberAnnotations, @NotNull Map<MemberSignature, ? extends C> propertyConstants) {
            Intrinsics.checkParameterIsNotNull(memberAnnotations, "memberAnnotations");
            Intrinsics.checkParameterIsNotNull(propertyConstants, "propertyConstants");
            this.memberAnnotations = memberAnnotations;
            this.propertyConstants = propertyConstants;
        }
    }
}

