/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.google.common.collect.Lists;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.speedSearch.FilteringListModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGrid
extends Box {
    @NotNull
    private final ArrayList<JList> myLists;
    @NotNull
    private final ArrayList<HideableDecorator> myHideables;

    public TreeGrid(final @NotNull AbstractTreeStructure model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/android/uipreview/TreeGrid", "<init>"));
        }
        super(1);
        Object root = model.getRootElement();
        Object[] sections = model.getChildElements(root);
        this.myLists = Lists.newArrayListWithCapacity((int)sections.length);
        this.myHideables = Lists.newArrayListWithCapacity((int)sections.length);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel sourceSelectionModel = (ListSelectionModel)e.getSource();
                if (!sourceSelectionModel.isSelectionEmpty()) {
                    for (JList aList : TreeGrid.this.myLists) {
                        if (sourceSelectionModel == aList.getSelectionModel()) continue;
                        aList.clearSelection();
                    }
                }
            }
        };
        for (final Object section : sections) {
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
                }
            };
            String name = section.toString();
            HideableDecorator hidyPanel = new HideableDecorator(panel, name, false);
            FilteringListModel listModel = new FilteringListModel((ListModel)new AbstractListModel(){

                @Override
                public int getSize() {
                    return model.getChildElements(section).length;
                }

                @Override
                public Object getElementAt(int index) {
                    return model.getChildElements(section)[index];
                }
            });
            listModel.refilter();
            JList list = new JList(listModel);
            list.setSelectionMode(0);
            list.setVisibleRowCount(-1);
            list.getSelectionModel().addListSelectionListener(listSelectionListener);
            list.setName(name);
            new ListSpeedSearch(list);
            this.myLists.add(list);
            this.myHideables.add(hidyPanel);
            hidyPanel.setContentComponent(list);
            this.add(panel);
        }
    }

    public void addListSelectionListener(@NotNull ListSelectionListener lsl) {
        if (lsl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lsl", "org/jetbrains/android/uipreview/TreeGrid", "addListSelectionListener"));
        }
        for (JList list : this.myLists) {
            list.getSelectionModel().addListSelectionListener(lsl);
        }
    }

    public void setCellRenderer(@NotNull ListCellRenderer cellRenderer) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "org/jetbrains/android/uipreview/TreeGrid", "setCellRenderer"));
        }
        for (JList list : this.myLists) {
            list.setCellRenderer(cellRenderer);
        }
    }

    public void setFixedCellWidth(int width) {
        for (JList list : this.myLists) {
            list.setFixedCellWidth(width);
        }
    }

    public void setFixedCellHeight(int height) {
        for (JList list : this.myLists) {
            list.setFixedCellHeight(height);
        }
    }

    public void expandAll() {
        for (HideableDecorator hidyPanel : this.myHideables) {
            hidyPanel.setOn(true);
        }
    }

    @Nullable
    public Object getSelectedElement() {
        for (JList list : this.myLists) {
            if (list.getSelectedIndex() <= -1) continue;
            return list.getSelectedValue();
        }
        return null;
    }

    public void setSelectedElement(@Nullable Object selectedElement) {
        for (final JList list : this.myLists) {
            if (selectedElement == null) {
                list.clearSelection();
                continue;
            }
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                if (list.getModel().getElementAt(i) != selectedElement) continue;
                list.setSelectedIndex(i);
                final int index = i;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        list.ensureIndexIsVisible(index);
                    }
                });
                return;
            }
        }
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "org/jetbrains/android/uipreview/TreeGrid", "addMouseListener"));
        }
        for (JList list : this.myLists) {
            list.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "org/jetbrains/android/uipreview/TreeGrid", "removeMouseListener"));
        }
        for (JList list : this.myLists) {
            list.removeMouseListener(l);
        }
    }

    public void setLayoutOrientation(int mode) {
        for (JList list : this.myLists) {
            list.setLayoutOrientation(mode);
        }
    }

    public void setFilter(@Nullable Condition condition) {
        for (JList list : this.myLists) {
            ((FilteringListModel)list.getModel()).setFilter(condition);
        }
    }
}

