/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.StateListPicker;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.android.tools.idea.ui.SearchField;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.uipreview.ColorPicker;
import org.jetbrains.android.uipreview.ResourceDialogSouthPanel;
import org.jetbrains.android.uipreview.TreeGrid;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public class ChooseResourceDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ChooseResourceDialog.class);
    private static final String TYPE_KEY = "ResourceType";
    private static final Icon RESOURCE_ITEM_ICON = AllIcons.Css.Property;
    public static final String APP_NAMESPACE_LABEL = "Project";
    @NotNull
    private final Module myModule;
    @Nullable
    private final XmlTag myTag;
    private final JComponent myContentPanel;
    private final JTabbedPane myTabbedPane;
    private final ResourcePanel[] myPanels;
    private final SearchTextField mySearchBox;
    private final JComponent myViewOption;
    private boolean isGridMode;
    @Nullable
    private EditResourcePanel myColorPickerPanel;
    @Nullable
    private ColorPicker myColorPicker;
    @Nullable
    private EditResourcePanel myStateListPickerPanel;
    @Nullable
    private StateListPicker myStateListPicker;
    @Nullable
    private ResourcePickerListener myResourcePickerListener;
    private boolean myAllowCreateResource;
    private final Action myNewResourceAction;
    private final AnAction myNewResourceValueAction;
    private final AnAction myNewResourceFileAction;
    private final AnAction myExtractStyleAction;
    private String myResultResourceName;
    private boolean myUseGlobalUndo;
    private RenderTask myRenderTask;

    public ChooseResourceDialog(@NotNull Module module, @NotNull ResourceType[] types, @Nullable String value, @Nullable XmlTag tag) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        this(module, types, value, false, tag, ResourceNameVisibility.SHOW, null);
    }

    public ChooseResourceDialog(@NotNull Module module, @NotNull ResourceType[] types, @NotNull String value, boolean isFrameworkValue, @NotNull ResourceNameVisibility resourceNameVisibility, @Nullable String resourceNameSuggestion) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (resourceNameVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNameVisibility", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        this(module, types, value, isFrameworkValue, null, resourceNameVisibility, resourceNameSuggestion);
    }

    private ChooseResourceDialog(@NotNull Module module, @NotNull ResourceType[] types, @Nullable String value, boolean isFrameworkValue, @Nullable XmlTag tag, @NotNull ResourceNameVisibility resourceNameVisibility, @Nullable String resourceNameSuggestion) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (resourceNameVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNameVisibility", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        super(module.getProject());
        this.myAllowCreateResource = true;
        this.myNewResourceAction = new AbstractAction("New Resource", AllIcons.General.ComboArrowDown){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent component = (JComponent)e.getSource();
                ActionPopupMenu popupMenu = ChooseResourceDialog.this.createNewResourcePopupMenu();
                popupMenu.getComponent().show(component, 0, component.getHeight());
            }
        };
        this.myNewResourceValueAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceType type = (ResourceType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceValue(type);
            }
        };
        this.myNewResourceFileAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceType type = (ResourceType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceFile(type);
            }
        };
        this.myExtractStyleAction = new AnAction("Extract Style..."){

            public void actionPerformed(AnActionEvent e) {
                ChooseResourceDialog.this.extractStyle();
            }
        };
        this.myModule = module;
        this.myTag = tag;
        if (resourceNameSuggestion != null && resourceNameSuggestion.startsWith("#")) {
            throw new IllegalArgumentException("invalid name suggestion " + resourceNameSuggestion);
        }
        this.setTitle("Resources");
        if (ArrayUtil.contains((Object)ResourceType.COLOR, (Object[])types) || ArrayUtil.contains((Object)ResourceType.DRAWABLE, (Object[])types)) {
            ResourceFolderType stateListFolderType;
            ResourcePanel[] stateListType;
            Configuration configuration = ThemeEditorUtils.getConfigurationForModule(this.myModule);
            ResourceResolver resolver = configuration.getResourceResolver();
            assert (resolver != null);
            com.android.ide.common.rendering.api.ResourceValue resValue = null;
            if (value != null) {
                resValue = resolver.findResValue(value, isFrameworkValue);
            }
            if (ArrayUtil.contains((Object)ResourceType.DRAWABLE, (Object[])types)) {
                stateListType = ResourceType.DRAWABLE;
                stateListFolderType = ResourceFolderType.DRAWABLE;
            } else {
                stateListType = ResourceType.COLOR;
                stateListFolderType = ResourceFolderType.COLOR;
            }
            ResourceHelper.StateList stateList = null;
            if (resValue != null && (stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resValue, this.myModule.getProject())) != null && stateList.getType() != stateListType) {
                LOG.warn("StateList type mismatch " + stateList.getType() + " " + stateListType);
                stateList = null;
            }
            this.myStateListPicker = new StateListPicker(stateList, this.myModule, configuration);
            this.myStateListPickerPanel = new EditResourcePanel(this.myStateListPicker){

                @Override
                @Nullable
                public ValidationInfo doValidate() {
                    ValidationInfo error = super.doValidate();
                    if (error == null) {
                        error = ChooseResourceDialog.this.myStateListPicker.getFrameworkResourceError();
                    }
                    if (error == null) {
                        assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                        int minDirectoriesApi = ThemeEditorUtils.getMinFolderApi(ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getDirNames(), ChooseResourceDialog.this.myModule);
                        error = ChooseResourceDialog.this.myStateListPicker.getApiError(minDirectoriesApi);
                    }
                    return error;
                }
            };
            this.myStateListPickerPanel.addResourceDialogSouthPanel(ResourceNameVisibility.FORCE, resourceNameSuggestion, true, stateListFolderType, false, (ResourceType)stateListType);
            Color color = null;
            if (resValue != null) {
                color = ResourceHelper.resolveColor((RenderResources)resolver, resValue, this.myModule.getProject());
            }
            if (color == null) {
                color = ResourceHelper.parseColor(value);
            }
            this.myColorPicker = new ColorPicker(this.myDisposable, color, true, new ColorPickerListener(){

                public void colorChanged(Color color) {
                    ChooseResourceDialog.this.notifyResourcePickerListeners(ResourceHelper.colorToString(color));
                }

                public void closed(@Nullable Color color) {
                }
            });
            this.myColorPicker.pickARGB();
            this.myColorPickerPanel = new EditResourcePanel(this.myColorPicker);
            if (resourceNameVisibility != ResourceNameVisibility.HIDE) {
                this.myColorPickerPanel.addResourceDialogSouthPanel(resourceNameVisibility, resourceNameSuggestion, false, ResourceFolderType.VALUES, true, ResourceType.COLOR);
            }
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        if (ArrayUtil.contains((Object)ResourceType.DRAWABLE, (Object[])types) && !ArrayUtil.contains((Object)ResourceType.COLOR, (Object[])types)) {
            this.myPanels = new ResourcePanel[types.length + 1];
            this.myPanels[types.length] = new ResourcePanel(facet, ResourceType.COLOR, false);
        } else {
            this.myPanels = new ResourcePanel[types.length];
        }
        for (int i = 0; i < types.length; ++i) {
            this.myPanels[i] = new ResourcePanel(facet, types[i], true);
        }
        ToggleAction listView = new ToggleAction(null, "list", AndroidIcons.Views.ListView){

            public boolean isSelected(AnActionEvent e) {
                return !ChooseResourceDialog.this.isGridMode;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ChooseResourceDialog.this.setGridMode(!state);
            }
        };
        ToggleAction gridView = new ToggleAction(null, "grid", AndroidIcons.Views.GridView){

            public boolean isSelected(AnActionEvent e) {
                return ChooseResourceDialog.this.isGridMode;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ChooseResourceDialog.this.setGridMode(state);
            }
        };
        this.mySearchBox = new SearchField(true);
        this.mySearchBox.setMaximumSize(new Dimension(JBUI.scale((int)300), this.mySearchBox.getMaximumSize().height));
        this.mySearchBox.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Condition condition = new Condition(){
                    private String text;
                    {
                        this.text = ChooseResourceDialog.this.mySearchBox.getText();
                    }

                    public boolean value(Object o) {
                        return StringUtil.containsIgnoreCase((String)o.toString(), (String)this.text);
                    }
                };
                for (ResourcePanel panel : ChooseResourceDialog.this.myPanels) {
                    panel.myList.setFilter(condition);
                }
            }
        });
        this.myViewOption = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)new DefaultActionGroup(new AnAction[]{listView, gridView}), true).getComponent();
        this.myViewOption.setBorder(null);
        this.myViewOption.setMaximumSize(new Dimension(JBUI.scale((int)100), this.myViewOption.getMaximumSize().height));
        this.myTabbedPane = new JTabbedPane(2);
        this.myTabbedPane.setUI(new SimpleTabUI());
        for (ResourcePanel panel : this.myPanels) {
            this.myTabbedPane.addTab(panel.getType().getDisplayName(), (Component)panel.myComponent);
            panel.expandAll();
        }
        if (value != null && value.startsWith("@")) {
            ResourceValue resourceValue = ResourceValue.reference(value);
            assert (resourceValue != null);
            String name = resourceValue.getResourceName();
            assert (name != null);
            String namespace = resourceValue.getNamespace();
            ResourceType type = resourceValue.getType();
            ResourcePanel panel = null;
            for (ResourcePanel aPanel : this.myPanels) {
                if (!aPanel.getType().equals((Object)type)) continue;
                panel = aPanel;
                break;
            }
            if (panel != null) {
                this.myTabbedPane.setSelectedComponent((Component)panel.myComponent);
                panel.select(namespace, name);
            }
        }
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChooseResourceDialog.this.setupViewOptions();
            }
        });
        Box toolbar = Box.createHorizontalBox();
        toolbar.add((Component)this.mySearchBox);
        toolbar.add(Box.createHorizontalStrut(JBUI.scale((int)20)));
        toolbar.add(this.myViewOption);
        toolbar.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0), JBUI.Borders.empty((int)8)));
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add(this.myTabbedPane);
        this.myContentPanel.add((Component)toolbar, "North");
        this.setupViewOptions();
        this.init();
        this.doValidate();
    }

    private void setupViewOptions() {
        this.myViewOption.setVisible(this.getSelectedPanel().supportsGridMode());
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog", "getStyle"));
        }
        return dialogStyle;
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackground, boolean displayWarning) {
        if (contrastColorsWithDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contrastColorsWithDescription", "org/jetbrains/android/uipreview/ChooseResourceDialog", "setContrastParameters"));
        }
        if (this.myColorPicker != null) {
            this.myColorPicker.setContrastParameters(contrastColorsWithDescription, isBackground, displayWarning);
        }
        if (this.myStateListPicker != null) {
            this.myStateListPicker.setContrastParameters(contrastColorsWithDescription, isBackground);
        }
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    private ResourcePanel getSelectedPanel() {
        Component selectedComponent = this.myTabbedPane.getSelectedComponent();
        for (ResourcePanel panel : this.myPanels) {
            if (panel.myComponent != selectedComponent) continue;
            ResourcePanel resourcePanel = panel;
            if (resourcePanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog", "getSelectedPanel"));
            }
            return resourcePanel;
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getSelectedPanel().doValidate();
    }

    public void setResourcePickerListener(@Nullable ResourcePickerListener resourcePickerListener) {
        this.myResourcePickerListener = resourcePickerListener;
    }

    protected void notifyResourcePickerListeners(@Nullable String resource) {
        if (this.myResourcePickerListener != null) {
            this.myResourcePickerListener.resourceChanged(resource);
        }
    }

    public void generateColorSuggestions(@NotNull Color primaryColor, @NotNull String attributeName) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "org/jetbrains/android/uipreview/ChooseResourceDialog", "generateColorSuggestions"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/android/uipreview/ChooseResourceDialog", "generateColorSuggestions"));
        }
        List<Color> suggestedColors = null;
        if ("colorPrimary".equals(attributeName)) {
            suggestedColors = MaterialColorUtils.suggestPrimaryColors();
        } else if ("colorPrimaryDark".equals(attributeName)) {
            suggestedColors = MaterialColorUtils.suggestPrimaryDarkColors(primaryColor);
        } else if ("colorAccent".equals(attributeName)) {
            suggestedColors = MaterialColorUtils.suggestAccentColors(primaryColor);
        }
        if (suggestedColors != null) {
            assert (this.myColorPicker != null);
            this.myColorPicker.setRecommendedColors(suggestedColors);
        }
    }

    private ActionPopupMenu createNewResourcePopupMenu() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ResourcePanel panel = this.getSelectedPanel();
        ResourceType resourceType = panel.getType();
        if (AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.contains(resourceType)) {
            this.myNewResourceFileAction.getTemplatePresentation().setText("New " + resourceType + " File...");
            this.myNewResourceFileAction.getTemplatePresentation().putClientProperty(TYPE_KEY, (Object)resourceType);
            actionGroup.add(this.myNewResourceFileAction);
        }
        if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceType)) {
            String title = "New " + resourceType + " Value...";
            if (resourceType == ResourceType.LAYOUT) {
                title = "New Layout Alias";
            }
            this.myNewResourceValueAction.getTemplatePresentation().setText(title);
            this.myNewResourceValueAction.getTemplatePresentation().putClientProperty(TYPE_KEY, (Object)resourceType);
            actionGroup.add(this.myNewResourceValueAction);
        }
        if (this.myTag != null && ResourceType.STYLE.equals((Object)resourceType)) {
            boolean enabled = AndroidBaseLayoutRefactoringAction.getLayoutViewElement(this.myTag) != null && AndroidExtractStyleAction.doIsEnabled(this.myTag);
            this.myExtractStyleAction.getTemplatePresentation().setEnabled(enabled);
            actionGroup.add(this.myExtractStyleAction);
        }
        return actionManager.createActionPopupMenu("unknown", (ActionGroup)actionGroup);
    }

    private void createNewResourceValue(ResourceType resourceType) {
        if (resourceType == ResourceType.COLOR) {
            ResourcePanel panel = this.getSelectedPanel();
            panel.showNewResource("Color");
            return;
        }
        CreateXmlResourceDialog dialog = new CreateXmlResourceDialog(this.myModule, resourceType, null, null, true);
        dialog.setTitle("New " + StringUtil.capitalize((String)resourceType.getDisplayName()) + " Value Resource");
        if (!dialog.showAndGet()) {
            return;
        }
        Module moduleToPlaceResource = dialog.getModule();
        if (moduleToPlaceResource == null) {
            return;
        }
        String fileName = dialog.getFileName();
        List<String> dirNames = dialog.getDirNames();
        String resValue = dialog.getValue();
        String resName = dialog.getResourceName();
        if (!AndroidResourceUtil.createValueResource(moduleToPlaceResource, resName, resourceType, fileName, dirNames, resValue)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myModule.getProject()).commitAllDocuments();
        this.myResultResourceName = "@" + resourceType.getName() + "/" + resName;
        this.close(0);
    }

    private void createNewResourceFile(ResourceType resourceType) {
        if (this.myStateListPickerPanel != null && resourceType == this.myStateListPickerPanel.getLocationSettings().getType() && !this.myStateListPickerPanel.isShowing() && this.myStateListPicker != null && this.myStateListPicker.getStateList() != null) {
            ResourcePanel panel = this.getSelectedPanel();
            panel.showNewResource("Statelist");
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet, resourceType, null, null, null, true, null);
        if (newFile != null) {
            String name = newFile.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            this.myResultResourceName = "@" + resourceType.getName() + "/" + name;
            this.close(0);
        }
    }

    private void extractStyle() {
        assert (this.myTag != null);
        String resName = AndroidExtractStyleAction.doExtractStyle(this.myModule, this.myTag, false, null);
        if (resName == null) {
            return;
        }
        this.myResultResourceName = "@style/" + resName;
        this.close(0);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanels[0].myList;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray;
        if (this.myAllowCreateResource) {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = this.myNewResourceAction;
        } else {
            actionArray = new Action[]{};
        }
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    public ChooseResourceDialog setAllowCreateResource(boolean allowCreateResource) {
        this.myAllowCreateResource = allowCreateResource;
        return this;
    }

    public boolean getAllowCreateResource() {
        return this.myAllowCreateResource;
    }

    public void openLocationSettings() {
        if (this.myColorPickerPanel != null) {
            this.myColorPickerPanel.openLocationSettings();
        }
        if (this.myStateListPickerPanel != null) {
            this.myStateListPickerPanel.openLocationSettings();
        }
    }

    public String getResourceName() {
        return this.myResultResourceName;
    }

    protected void doOKAction() {
        this.myResultResourceName = this.getSelectedPanel().getValueForLivePreview();
        this.notifyResourcePickerListeners(null);
        if (this.myColorPickerPanel != null && this.myColorPickerPanel.isShowing()) {
            if (this.myColorPickerPanel.myResourceNameVisibility == ResourceNameVisibility.FORCE || this.myColorPickerPanel.myResourceNameVisibility == ResourceNameVisibility.SHOW && !this.myColorPickerPanel.getResourceNameField().getText().isEmpty()) {
                String colorName = this.myColorPickerPanel.getResourceNameField().getText();
                Module module = this.myColorPickerPanel.getLocationSettings().getModule();
                String fileName = this.myColorPickerPanel.getLocationSettings().getFileName();
                List<String> dirNames = this.myColorPickerPanel.getLocationSettings().getDirNames();
                assert (module != null);
                AndroidFacet facet = AndroidFacet.getInstance(module);
                assert (facet != null);
                if (!AndroidResourceUtil.changeColorResource(facet, colorName, this.myResultResourceName, fileName, dirNames, this.myUseGlobalUndo)) {
                    AndroidResourceUtil.createValueResource(module, colorName, ResourceType.COLOR, fileName, dirNames, this.myResultResourceName);
                }
                this.myResultResourceName = "@color/" + colorName;
            }
        } else if (this.myStateListPickerPanel != null && this.myStateListPickerPanel.isShowing()) {
            String stateListName = this.myStateListPickerPanel.getResourceNameField().getText();
            Module module = this.myStateListPickerPanel.getLocationSettings().getModule();
            List<String> dirNames = this.myStateListPickerPanel.getLocationSettings().getDirNames();
            ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)dirNames.get(0));
            ResourceType resourceType = ResourceType.getEnum((String)resourceFolderType.getName());
            List<VirtualFile> files = null;
            if (resourceType != null) {
                assert (module != null);
                files = AndroidResourceUtil.findOrCreateStateListFiles(module, resourceFolderType, resourceType, stateListName, dirNames);
            }
            if (files != null) {
                assert (this.myStateListPicker != null);
                ResourceHelper.StateList stateList = this.myStateListPicker.getStateList();
                assert (stateList != null);
                AndroidResourceUtil.updateStateList(module, stateList, files);
            }
            if (resourceFolderType == ResourceFolderType.COLOR) {
                this.myResultResourceName = "@color/" + stateListName;
            } else if (resourceFolderType == ResourceFolderType.DRAWABLE) {
                this.myResultResourceName = "@drawable/" + stateListName;
            }
        }
        super.doOKAction();
    }

    void setGridMode(boolean gridMode) {
        this.isGridMode = gridMode;
        for (ResourcePanel panel : this.myPanels) {
            if (!panel.supportsGridMode()) continue;
            panel.setGridMode(this.isGridMode);
        }
    }

    public void setUseGlobalUndo(boolean useGlobalUndo) {
        this.myUseGlobalUndo = useGlobalUndo;
    }

    @NotNull
    private Icon getIcon(@NotNull ResourceItem item, int size) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/android/uipreview/ChooseResourceDialog", "getIcon"));
        }
        Icon icon = item.getIcon();
        if (icon != null && size == icon.getIconWidth()) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog", "getIcon"));
            }
            return icon2;
        }
        VirtualFile file = item.getFile();
        ResourceGroup group = item.getGroup();
        if (file != null && ImageFileTypeManager.getInstance().isImage(file)) {
            icon = new SizedIcon(size, new ImageIcon(file.getPath()));
        } else if (group.getType() == ResourceType.DRAWABLE || group.getType() == ResourceType.MIPMAP) {
            BufferedImage image;
            if (this.myRenderTask == null) {
                this.myRenderTask = DrawableRendererEditor.configureRenderTask(this.myModule, ThemeEditorUtils.getConfigurationForModule(this.myModule));
                this.myRenderTask.setMaxRenderSize(150, 150);
            }
            if ((image = this.myRenderTask.renderDrawable(item.getResourceValue())) != null) {
                icon = new SizedIcon(size, image);
            }
        } else if (group.getType() == ResourceType.COLOR) {
            Configuration config = ThemeEditorUtils.getConfigurationForModule(this.myModule);
            ResourceResolver resolver = config.getResourceResolver();
            assert (resolver != null);
            Color color = ResourceHelper.resolveColor((RenderResources)resolver, item.getResourceValue(), this.myModule.getProject());
            if (color != null) {
                icon = new ColorIcon(size, color);
            }
        }
        if (icon == null) {
            icon = file == null || file.getFileType().getIcon() == null ? RESOURCE_ITEM_ICON : file.getFileType().getIcon();
        }
        item.setIcon(icon);
        Icon icon3 = icon;
        if (icon3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog", "getIcon"));
        }
        return icon3;
    }

    private static String getResourceElementValue(ResourceElement element) {
        String text = element.getRawText();
        if (StringUtil.isEmpty((String)text)) {
            return element.getXmlTag().getText();
        }
        return text;
    }

    private static class SimpleTabUI
    extends BasicTabbedPaneUI {
        private SimpleTabUI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.tabInsets = JBUI.insets((int)8);
            this.selectedTabPadInsets = JBUI.emptyInsets();
            this.contentBorderInsets = JBUI.emptyInsets();
        }

        @Override
        protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        }

        @Override
        protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        }

        @Override
        protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
            int width = this.tabPane.getWidth();
            int height = this.tabPane.getHeight();
            Insets insets = this.tabPane.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = width - insets.right - insets.left;
            int h = height - insets.top - insets.bottom;
            int thickness = JBUI.scale((int)1);
            g.setColor(OnePixelDivider.BACKGROUND);
            switch (tabPlacement) {
                case 2: {
                    g.fillRect((x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - thickness, y, thickness, h);
                    break;
                }
                case 4: {
                    g.fillRect(x + (w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)), y, thickness, h);
                    break;
                }
                case 3: {
                    g.fillRect(x, y + (h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)), w, thickness);
                    break;
                }
                default: {
                    g.fillRect(x, (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - thickness, w, thickness);
                }
            }
        }

        @Override
        protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
            return super.getTabLabelShiftX(tabPlacement, tabIndex, false);
        }

        @Override
        protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
            return super.getTabLabelShiftY(tabPlacement, tabIndex, false);
        }

        @Override
        protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
            iconRect.y = 0;
            iconRect.x = 0;
            textRect.y = 0;
            textRect.x = 0;
            View v = this.getTextViewForTab(tabIndex);
            if (v != null) {
                this.tabPane.putClientProperty("html", v);
            }
            Insets insets = this.getTabInsets(tabPlacement, tabIndex);
            tabRect = new Rectangle(tabRect);
            tabRect.x += insets.left;
            tabRect.y += insets.top;
            tabRect.width = tabRect.width - insets.left - insets.right;
            tabRect.height = tabRect.height - insets.top - insets.bottom;
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 10, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
            this.tabPane.putClientProperty("html", null);
            int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
            int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
            iconRect.x += xNudge;
            iconRect.y += yNudge;
            textRect.x += xNudge;
            textRect.y += yNudge;
        }

        @Override
        protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
            g.setFont(font);
            View v = this.getTextViewForTab(tabIndex);
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
                if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                    JBColor selectedFG;
                    Color fg = this.tabPane.getForegroundAt(tabIndex);
                    if (isSelected && fg instanceof UIResource && (selectedFG = JBColor.BLUE) != null) {
                        fg = selectedFG;
                    }
                    g.setColor(fg);
                    SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                } else {
                    g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                    SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                    g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                    SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
                }
            }
        }
    }

    public static class SizedIcon
    implements Icon {
        private final int mySize;
        private final Image myImage;

        public SizedIcon(int size, Image image) {
            this.mySize = size;
            this.myImage = image;
        }

        public SizedIcon(int size, ImageIcon icon) {
            this(size, icon.getImage());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int i, int j) {
            double scale = Math.min((double)this.getIconHeight() / (double)this.myImage.getHeight(c), (double)this.getIconWidth() / (double)this.myImage.getWidth(c));
            int x = (int)((double)this.getIconWidth() - (double)this.myImage.getWidth(c) * scale) / 2;
            int y = (int)((double)this.getIconHeight() - (double)this.myImage.getHeight(c) * scale) / 2;
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(this.myImage, i + x, j + y, (int)((double)this.myImage.getWidth(c) * scale), (int)((double)this.myImage.getHeight(c) * scale), null);
        }

        @Override
        public int getIconWidth() {
            return this.mySize;
        }

        @Override
        public int getIconHeight() {
            return this.mySize;
        }
    }

    private static class TreeContentProvider
    extends AbstractTreeStructure {
        private final Object myTreeRoot = new Object();
        private final ResourceGroup[] myGroups;

        public TreeContentProvider(ResourceGroup[] groups) {
            this.myGroups = groups;
        }

        public Object getRootElement() {
            return this.myTreeRoot;
        }

        public Object[] getChildElements(Object element) {
            if (element == this.myTreeRoot) {
                return this.myGroups;
            }
            if (element instanceof ResourceGroup) {
                ResourceGroup group = (ResourceGroup)element;
                return group.getItems().toArray();
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public Object getParentElement(Object element) {
            if (element instanceof ResourceItem) {
                ResourceItem resource = (ResourceItem)element;
                return resource.getGroup();
            }
            return null;
        }

        @NotNull
        public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
            throw new UnsupportedOperationException();
        }

        public boolean hasSomethingToCommit() {
            return false;
        }

        public void commit() {
        }
    }

    public static class ResourceItem {
        private final ResourceGroup myGroup;
        private final String myName;
        private final VirtualFile myFile;
        private Icon myIcon;

        public ResourceItem(@NotNull ResourceGroup group, @NotNull String name, @Nullable VirtualFile file) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceItem", "<init>"));
            }
            this.myGroup = group;
            this.myName = name;
            this.myFile = file;
        }

        public ResourceGroup getGroup() {
            return this.myGroup;
        }

        public String getName() {
            return this.myName;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        @NotNull
        public String getResourceUrl() {
            String string = String.format("@%s%s/%s", this.getGroup().getNamespace() == null ? "" : this.getGroup().getNamespace() + ":", this.myGroup.getType().getName(), this.myName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceItem", "getResourceUrl"));
            }
            return string;
        }

        @NotNull
        public com.android.ide.common.rendering.api.ResourceValue getResourceValue() {
            com.android.ide.common.rendering.api.ResourceValue resourceValue = new com.android.ide.common.rendering.api.ResourceValue(this.myGroup.getType(), this.getName(), this.myFile == null ? this.getResourceUrl() : this.myFile.getPath(), this.myGroup.isFramework());
            if (resourceValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceItem", "getResourceValue"));
            }
            return resourceValue;
        }

        public String toString() {
            return this.getName();
        }

        @Nullable(value="if no icon has been set on this item")
        public Icon getIcon() {
            return this.myIcon;
        }

        public void setIcon(@Nullable Icon icon) {
            this.myIcon = icon;
        }
    }

    public static class ResourceGroup {
        private List<ResourceItem> myItems;
        private final String myNamespace;
        private final ResourceType myType;

        public ResourceGroup(@Nullable String namespace, @NotNull ResourceType type, @NotNull ResourceManager manager, boolean includeFileResources) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup", "<init>"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup", "<init>"));
            }
            this.myItems = new ArrayList<ResourceItem>();
            this.myType = type;
            this.myNamespace = namespace;
            String resourceType = type.getName();
            Collection<String> resourceNames = manager.getValueResourceNames(resourceType);
            for (String resourceName : resourceNames) {
                this.myItems.add(new ResourceItem(this, resourceName, null));
            }
            final HashSet fileNames = new HashSet();
            if (includeFileResources) {
                manager.processFileResources(resourceType, new FileResourceProcessor(){

                    @Override
                    public boolean process(@NotNull VirtualFile resFile, @NotNull String resName, @NotNull String resFolderType) {
                        if (resFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFile", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup$1", "process"));
                        }
                        if (resName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup$1", "process"));
                        }
                        if (resFolderType == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFolderType", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup$1", "process"));
                        }
                        if (fileNames.add(resName)) {
                            ResourceGroup.this.myItems.add(new ResourceItem(ResourceGroup.this, resName, resFile));
                        }
                        return true;
                    }
                });
            }
            if (type == ResourceType.ID) {
                for (String id : manager.getIds(true)) {
                    if (resourceNames.contains(id)) continue;
                    this.myItems.add(new ResourceItem(this, id, null));
                }
            }
            Collections.sort(this.myItems, new Comparator<ResourceItem>(){

                @Override
                public int compare(ResourceItem resource1, ResourceItem resource2) {
                    return resource1.getName().compareTo(resource2.getName());
                }
            });
        }

        @NotNull
        public ResourceType getType() {
            ResourceType resourceType = this.myType;
            if (resourceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup", "getType"));
            }
            return resourceType;
        }

        @Nullable(value="null for app namespace")
        public String getNamespace() {
            return this.myNamespace;
        }

        public List<ResourceItem> getItems() {
            return this.myItems;
        }

        public String toString() {
            return this.myNamespace == null ? ChooseResourceDialog.APP_NAMESPACE_LABEL : this.myNamespace;
        }

        public boolean isFramework() {
            return "android".equals(this.getNamespace());
        }
    }

    private class EditResourcePanel
    extends JBScrollPane {
        private ResourceDialogSouthPanel mySouthPanel;
        private ResourceNameValidator myValidator;
        private CreateXmlResourcePanel myLocationSettings;
        private ResourceNameVisibility myResourceNameVisibility;

        public EditResourcePanel(JPanel centerPanel) {
            if (centerPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "centerPanel", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "<init>"));
            }
            super((Component)new JPanel(new BorderLayout()));
            this.myResourceNameVisibility = ResourceNameVisibility.HIDE;
            this.getView().add(centerPanel);
            this.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        }

        @NotNull
        private JPanel getView() {
            JPanel jPanel = (JPanel)this.getViewport().getView();
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "getView"));
            }
            return jPanel;
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.getView().getMinimumSize().width + insets.left + insets.right, super.getMinimumSize().height);
        }

        public void addResourceDialogSouthPanel(@NotNull ResourceNameVisibility resourceNameVisibility, @Nullable String resourceName, final boolean allowXmlFile, @NotNull ResourceFolderType folderType, boolean changeFileNameVisible, final @NotNull ResourceType resourceType) {
            if (resourceNameVisibility == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNameVisibility", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "addResourceDialogSouthPanel"));
            }
            if (folderType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "addResourceDialogSouthPanel"));
            }
            if (resourceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "addResourceDialogSouthPanel"));
            }
            assert (resourceNameVisibility != ResourceNameVisibility.HIDE);
            this.myResourceNameVisibility = resourceNameVisibility;
            this.mySouthPanel = new ResourceDialogSouthPanel();
            this.myLocationSettings = new CreateXmlResourcePanel(ChooseResourceDialog.this.myModule, resourceType, null, folderType);
            if (resourceName != null) {
                this.mySouthPanel.getResourceNameField().setText(resourceName);
            }
            this.myLocationSettings.setChangeFileNameVisible(changeFileNameVisible);
            this.getView().add((Component)this.mySouthPanel.getFullPanel(), "South");
            this.mySouthPanel.setExpertPanel(this.myLocationSettings.getPanel());
            this.myLocationSettings.addModuleComboActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Module module = EditResourcePanel.this.myLocationSettings.getModule();
                    assert (module != null);
                    EditResourcePanel.this.myValidator = ResourceNameValidator.create(allowXmlFile, AppResourceRepository.getAppResources(module, true), resourceType, allowXmlFile);
                }
            });
            this.myValidator = ResourceNameValidator.create(allowXmlFile, AppResourceRepository.getAppResources(ChooseResourceDialog.this.myModule, true), resourceType, allowXmlFile);
            this.mySouthPanel.addVariantActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseResourceDialog.this.getSelectedPanel().editResourceItem(EditResourcePanel.this.mySouthPanel.getSelectedVariant());
                }
            });
        }

        @NotNull
        public JLabel getResourceNameMessage() {
            JBLabel jBLabel = this.mySouthPanel.getResourceNameMessage();
            if (jBLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "getResourceNameMessage"));
            }
            return jBLabel;
        }

        @NotNull
        public JTextField getResourceNameField() {
            JTextField jTextField = this.mySouthPanel.getResourceNameField();
            if (jTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "getResourceNameField"));
            }
            return jTextField;
        }

        @NotNull
        public CreateXmlResourcePanel getLocationSettings() {
            CreateXmlResourcePanel createXmlResourcePanel = this.myLocationSettings;
            if (createXmlResourcePanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$EditResourcePanel", "getLocationSettings"));
            }
            return createXmlResourcePanel;
        }

        public void openLocationSettings() {
            this.mySouthPanel.setOn(true);
        }

        @Nullable
        public ValidationInfo doValidate() {
            ValidationInfo error = null;
            String overwriteResource = "";
            if (this.myResourceNameVisibility == ResourceNameVisibility.FORCE || this.myResourceNameVisibility == ResourceNameVisibility.SHOW && !this.getResourceNameField().getText().isEmpty()) {
                if (this.myValidator != null) {
                    String enteredName = this.getResourceNameField().getText();
                    if (this.myValidator.doesResourceExist(enteredName)) {
                        overwriteResource = String.format("Saving this color will override existing resource %1$s.", enteredName);
                    } else {
                        String errorText = this.myValidator.getErrorText(enteredName);
                        if (errorText != null) {
                            error = new ValidationInfo(errorText, (JComponent)this.getResourceNameField());
                        }
                    }
                    if (!overwriteResource.equals(this.getResourceNameMessage().getText())) {
                        AndroidFacet facet = AndroidFacet.getInstance(ChooseResourceDialog.this.myModule);
                        assert (facet != null);
                        List resources = facet.getAppResources(true).getResourceItem(this.myLocationSettings.getType(), enteredName);
                        com.android.ide.common.res2.ResourceItem defaultValue = (com.android.ide.common.res2.ResourceItem)ThemeEditorUtils.getConfigurationForModule(ChooseResourceDialog.this.myModule).getFullConfig().findMatchingConfigurable(resources);
                        if (defaultValue != null) {
                            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(defaultValue.getFile());
                            assert (file != null);
                            this.myLocationSettings.resetFromFile(file, ChooseResourceDialog.this.myModule.getProject());
                        }
                        this.mySouthPanel.setVariant(resources == null ? Collections.emptyList() : resources, defaultValue);
                    }
                }
                if (error == null) {
                    error = this.getLocationSettings().doValidate();
                }
            }
            if (!overwriteResource.equals(this.getResourceNameMessage().getText())) {
                this.getResourceNameMessage().setText(overwriteResource);
            }
            return error;
        }
    }

    private class ResourcePanel {
        private static final String NONE = "None";
        private static final String TEXT = "Text";
        private static final String COMBO = "Combo";
        private static final String COLOR = "Color";
        private static final String STATELIST = "Statelist";
        private final String[] NAMESPACES;
        @NotNull
        public final JBSplitter myComponent;
        @NotNull
        private final TreeGrid myList;
        @NotNull
        private final JPanel myPreviewPanel;
        @NotNull
        private final JTextPane myHtmlTextArea;
        private final JTextArea myComboTextArea;
        private final JComboBox myComboBox;
        @NotNull
        private final JLabel myNoPreviewComponent;
        @NotNull
        private final ResourceGroup[] myGroups;
        @NotNull
        private final ResourceType myType;

        public ResourcePanel(@NotNull AndroidFacet facet, ResourceType type, boolean includeFileResources) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "<init>"));
            }
            this.NAMESPACES = new String[]{null, "android"};
            this.myType = type;
            this.myGroups = new ResourceGroup[this.NAMESPACES.length];
            for (int c = 0; c < this.NAMESPACES.length; ++c) {
                ResourceManager manager = facet.getResourceManager(this.NAMESPACES[c]);
                assert (manager != null);
                this.myGroups[c] = new ResourceGroup(this.NAMESPACES[c], type, manager, includeFileResources);
            }
            TreeContentProvider treeContentProvider = new TreeContentProvider(this.myGroups);
            this.myComponent = new JBSplitter(false, 0.5f);
            this.myComponent.setSplitterProportionKey("android.resource_dialog_splitter");
            this.myList = new TreeGrid(treeContentProvider);
            this.myList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ResourcePanel.this.showPreview(ResourcePanel.this.getSelectedElement(), true);
                    ChooseResourceDialog.this.notifyResourcePickerListeners(ResourcePanel.this.getValueForLivePreview());
                }
            });
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    ResourceItem selected = ResourcePanel.this.getSelectedElement();
                    if (selected != null) {
                        ChooseResourceDialog.this.myResultResourceName = selected.getResourceUrl();
                        ChooseResourceDialog.this.close(0);
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)this.myList);
            JScrollPane firstComponent = ScrollPaneFactory.createScrollPane((Component)this.myList, (int)22, (int)31);
            firstComponent.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)16));
            firstComponent.setBorder(null);
            firstComponent.setPreferredSize((Dimension)JBUI.size((int)200, (int)600));
            this.myComponent.setFirstComponent((JComponent)firstComponent);
            this.myPreviewPanel = new JPanel(new CardLayout());
            this.myComponent.setSecondComponent((JComponent)this.myPreviewPanel);
            this.myHtmlTextArea = new JTextPane();
            this.myHtmlTextArea.setEditable(false);
            this.myHtmlTextArea.setContentType("text/html");
            this.myPreviewPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myHtmlTextArea, (boolean)true), TEXT);
            this.myHtmlTextArea.setPreferredSize((Dimension)JBUI.size((int)400, (int)400));
            this.myComboTextArea = new JTextArea(5, 20);
            this.myComboTextArea.setEditable(false);
            this.myComboBox = new JComboBox();
            this.myComboBox.setMaximumRowCount(15);
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List resources = (List)ResourcePanel.this.myComboBox.getClientProperty(ResourcePanel.COMBO);
                    ResourcePanel.this.myComboTextArea.setText(ChooseResourceDialog.getResourceElementValue((ResourceElement)resources.get(ResourcePanel.this.myComboBox.getSelectedIndex())));
                }
            });
            JPanel comboPanel = new JPanel(new BorderLayout(0, 1){

                @Override
                public void layoutContainer(Container target) {
                    super.layoutContainer(target);
                    Rectangle bounds = ResourcePanel.this.myComboBox.getBounds();
                    Dimension size = ResourcePanel.this.myComboBox.getPreferredSize();
                    size.width += 20;
                    ResourcePanel.this.myComboBox.setBounds((int)bounds.getMaxX() - size.width, bounds.y, size.width, size.height);
                }
            });
            comboPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComboTextArea), "Center");
            comboPanel.add((Component)this.myComboBox, "South");
            this.myPreviewPanel.add((Component)comboPanel, COMBO);
            this.myNoPreviewComponent = new JLabel("No Preview");
            this.myNoPreviewComponent.setHorizontalAlignment(0);
            this.myNoPreviewComponent.setVerticalAlignment(0);
            this.myPreviewPanel.add((Component)this.myNoPreviewComponent, NONE);
            this.setGridMode(ChooseResourceDialog.this.isGridMode);
            if (this.myType == ResourceType.COLOR) {
                assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                this.myPreviewPanel.add((Component)((Object)ChooseResourceDialog.this.myColorPickerPanel), COLOR);
            }
            if (ChooseResourceDialog.this.myStateListPickerPanel != null && this.myType == ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType()) {
                this.myPreviewPanel.add((Component)((Object)ChooseResourceDialog.this.myStateListPickerPanel), STATELIST);
            }
            this.showPreview(null, true);
        }

        @NotNull
        public ResourceType getType() {
            ResourceType resourceType = this.myType;
            if (resourceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "getType"));
            }
            return resourceType;
        }

        public void showPreview(@Nullable ResourceItem element, boolean allowEditor) {
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            if (allowEditor) {
                if ((this.myType == ResourceType.COLOR || this.myType == ResourceType.DRAWABLE) && element != null) {
                    List items;
                    ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(ChooseResourceDialog.this.myModule, true);
                    assert (repository != null);
                    boolean inProject = repository.hasResourceItem(element.getGroup().getType(), element.getName());
                    if (inProject && (items = repository.getResourceItem(element.getGroup().getType(), element.getName())) != null && !items.isEmpty()) {
                        com.android.ide.common.res2.ResourceItem defaultValue = (com.android.ide.common.res2.ResourceItem)ThemeEditorUtils.getConfigurationForModule(ChooseResourceDialog.this.myModule).getFullConfig().findMatchingConfigurable(items);
                        this.editResourceItem(defaultValue == null ? (com.android.ide.common.res2.ResourceItem)items.get(0) : defaultValue);
                        return;
                    }
                }
                if (element == null && ChooseResourceDialog.this.myStateListPickerPanel != null && ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType() == this.myType && ChooseResourceDialog.this.myStateListPicker != null && ChooseResourceDialog.this.myStateListPicker.getStateList() != null) {
                    layout.show(this.myPreviewPanel, STATELIST);
                    return;
                }
                if (element == null && this.myType == ResourceType.COLOR) {
                    layout.show(this.myPreviewPanel, COLOR);
                    return;
                }
            }
            if (element == null || element.getGroup().getType() == ResourceType.ID) {
                layout.show(this.myPreviewPanel, NONE);
                return;
            }
            String doc = AndroidJavaDocRenderer.render(ChooseResourceDialog.this.myModule, element.getGroup().getType(), element.getName(), element.getGroup().isFramework());
            this.myHtmlTextArea.setText(doc);
            layout.show(this.myPreviewPanel, TEXT);
        }

        public void editResourceItem(@NotNull com.android.ide.common.res2.ResourceItem selected) {
            EditResourcePanel editResourcePanel;
            String panelName;
            if (selected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "editResourceItem"));
            }
            String name = selected.getName();
            com.android.ide.common.rendering.api.ResourceValue resourceValue = selected.getResourceValue(false);
            assert (resourceValue != null);
            Configuration configuration = ThemeEditorUtils.getConfigurationForModule(ChooseResourceDialog.this.myModule);
            ResourceResolver resolver = configuration.getResourceResolver();
            assert (resolver != null);
            ResourceHelper.StateList stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resourceValue, ChooseResourceDialog.this.myModule.getProject());
            if (stateList != null) {
                assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                assert (ChooseResourceDialog.this.myStateListPicker != null);
                if (stateList.getType() != ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType()) {
                    LOG.warn("StateList type mismatch " + stateList.getType() + " " + ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType());
                    this.showPreview(this.getSelectedElement(), false);
                    return;
                }
                ChooseResourceDialog.this.myStateListPicker.setStateList(stateList);
                panelName = STATELIST;
                editResourcePanel = ChooseResourceDialog.this.myStateListPickerPanel;
            } else {
                Color color = ResourceHelper.parseColor(resourceValue.getValue());
                if (color != null) {
                    assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                    assert (ChooseResourceDialog.this.myColorPicker != null);
                    ChooseResourceDialog.this.myColorPicker.setColor(color);
                    panelName = COLOR;
                    editResourcePanel = ChooseResourceDialog.this.myColorPickerPanel;
                } else {
                    this.showPreview(this.getSelectedElement(), false);
                    return;
                }
            }
            editResourcePanel.getResourceNameField().setText(name);
            editResourcePanel.doValidate();
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(selected.getFile());
            assert (file != null);
            editResourcePanel.mySouthPanel.setSelectedVariant(selected);
            editResourcePanel.myLocationSettings.resetFromFile(file, ChooseResourceDialog.this.myModule.getProject());
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, panelName);
        }

        @Nullable
        public ValidationInfo doValidate() {
            ValidationInfo error = null;
            boolean okActionEnabled = ChooseResourceDialog.this.myColorPickerPanel != null && ChooseResourceDialog.this.myColorPickerPanel.isShowing() ? (error = ChooseResourceDialog.this.myColorPickerPanel.doValidate()) == null : (ChooseResourceDialog.this.myStateListPickerPanel != null && ChooseResourceDialog.this.myStateListPickerPanel.isShowing() ? (error = ChooseResourceDialog.this.myStateListPickerPanel.doValidate()) == null : this.getSelectedElement() != null);
            ChooseResourceDialog.this.setOKActionEnabled(okActionEnabled);
            return error;
        }

        boolean supportsGridMode() {
            return this.myType == ResourceType.COLOR || this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.MIPMAP;
        }

        void setGridMode(boolean gridView) {
            if (gridView) {
                assert (this.supportsGridMode());
                DefaultListCellRenderer gridRenderer = new DefaultListCellRenderer(){
                    {
                        this.setHorizontalTextPosition(0);
                        this.setVerticalTextPosition(3);
                        this.setHorizontalAlignment(0);
                    }

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, false);
                        ResourceItem rItem = (ResourceItem)value;
                        this.setIcon(ChooseResourceDialog.this.getIcon(rItem, JBUI.scale((int)80)));
                        return component;
                    }
                };
                this.myList.setFixedCellWidth(JBUI.scale((int)90));
                this.myList.setFixedCellHeight(JBUI.scale((int)100));
                this.myList.setCellRenderer(gridRenderer);
                this.myList.setLayoutOrientation(2);
            } else {
                DefaultListCellRenderer listRenderer = new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, false);
                        ResourceItem rItem = (ResourceItem)value;
                        this.setIcon(ChooseResourceDialog.this.getIcon(rItem, JBUI.scale((int)28)));
                        return component;
                    }
                };
                this.myList.setFixedCellWidth(10);
                this.myList.setFixedCellHeight(JBUI.scale((int)32));
                this.myList.setCellRenderer(listRenderer);
                this.myList.setLayoutOrientation(0);
            }
        }

        void showNewResource(@NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "showNewResource"));
            }
            this.myList.setSelectedElement(null);
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, type);
        }

        private void select(@Nullable String namespace, @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "select"));
            }
            for (ResourceGroup group : this.myGroups) {
                if (!Objects.equal((Object)namespace, (Object)group.getNamespace())) continue;
                for (ResourceItem item : group.getItems()) {
                    if (!name.equals(item.getName())) continue;
                    this.myList.setSelectedElement(item);
                    return;
                }
            }
        }

        public void expandAll() {
            this.myList.expandAll();
        }

        public ResourceItem getSelectedElement() {
            return (ResourceItem)this.myList.getSelectedElement();
        }

        @Nullable
        public String getValueForLivePreview() {
            if (ChooseResourceDialog.this.myColorPickerPanel != null && ChooseResourceDialog.this.myColorPickerPanel.isShowing()) {
                assert (ChooseResourceDialog.this.myColorPicker != null);
                return ResourceHelper.colorToString(ChooseResourceDialog.this.myColorPicker.getColor());
            }
            ResourceItem element = this.getSelectedElement();
            return element != null ? element.getResourceUrl() : null;
        }

        private void showComboPreview(@NotNull ResourceItem item) {
            int index;
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourcePanel", "showComboPreview"));
            }
            long time = System.currentTimeMillis();
            AndroidFacet facet = AndroidFacet.getInstance(ChooseResourceDialog.this.myModule);
            assert (facet != null);
            ResourceManager manager = facet.getResourceManager(item.getGroup().getNamespace());
            assert (manager != null);
            ArrayList resources = manager.findValueResources(item.getGroup().getType().getName(), item.getName());
            if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                System.out.println("Time: " + (System.currentTimeMillis() - time));
            }
            assert (resources.size() > 1);
            resources = Lists.newArrayList(resources);
            Collections.sort(resources, new Comparator<ResourceElement>(){

                @Override
                public int compare(ResourceElement element1, ResourceElement element2) {
                    PsiDirectory directory1 = element1.getXmlTag().getContainingFile().getParent();
                    PsiDirectory directory2 = element2.getXmlTag().getContainingFile().getParent();
                    if (directory1 == null && directory2 == null) {
                        return 0;
                    }
                    if (directory2 == null) {
                        return 1;
                    }
                    if (directory1 == null) {
                        return -1;
                    }
                    return directory1.getName().compareTo(directory2.getName());
                }
            });
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            String defaultSelection = null;
            for (int i = 0; i < resources.size(); ++i) {
                String name;
                ResourceElement resource = (ResourceElement)resources.get(i);
                PsiDirectory directory = resource.getXmlTag().getContainingFile().getParent();
                String string = name = directory == null ? "unknown-" + i : directory.getName();
                if (model.getIndexOf(name) >= 0) {
                    Module module = resource.getModule();
                    if (module != null) {
                        name = name + " (" + module.getName() + ")";
                    }
                    if (model.getIndexOf(name) >= 0) {
                        name = name + " (" + i + ")";
                    }
                }
                model.addElement(name);
                if (defaultSelection != null || !"values".equalsIgnoreCase(name)) continue;
                defaultSelection = name;
            }
            String selection = (String)this.myComboBox.getSelectedItem();
            if (selection == null) {
                selection = defaultSelection;
            }
            if ((index = model.getIndexOf(selection)) == -1) {
                index = 0;
            }
            this.myComboBox.setModel(model);
            this.myComboBox.putClientProperty(COMBO, resources);
            this.myComboBox.setSelectedIndex(index);
            this.myComboTextArea.setText(ChooseResourceDialog.getResourceElementValue((ResourceElement)resources.get(index)));
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, COMBO);
        }
    }

    public static enum ResourceNameVisibility {
        HIDE,
        SHOW,
        FORCE;

    }

    public static interface ResourcePickerListener {
        public void resourceChanged(@Nullable String var1);
    }
}

