/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

class IntellijLintProject
extends Project {
    public static final boolean SUPPORT_CLASS_FILES = false;
    protected AndroidVersion mMinSdkVersion;
    protected AndroidVersion mTargetSdkVersion;

    IntellijLintProject(LintClient client, File dir, File referenceDir) {
        super(client, dir, referenceDir);
    }

    public static List<Project> create(IntellijLintClient client, @Nullable List<VirtualFile> files, Module ... modules) {
        ArrayList projects = Lists.newArrayList();
        HashMap projectMap = Maps.newHashMap();
        HashMap moduleMap = Maps.newHashMap();
        HashMap libraryMap = Maps.newHashMap();
        if (files != null && !files.isEmpty()) {
            files = Lists.newArrayList(files);
        }
        for (Module module : modules) {
            IntellijLintProject.addProjects(client, module, files, moduleMap, libraryMap, projectMap, projects);
        }
        client.setModuleMap(projectMap);
        if (projects.size() > 1) {
            HashSet roots = new HashSet(projects);
            for (Project project : projects) {
                roots.removeAll(project.getAllLibraries());
            }
            return Lists.newArrayList(roots);
        }
        return projects;
    }

    public static Pair<Project, Project> createForSingleFile(IntellijLintClient client, @Nullable VirtualFile file, Module module) {
        LintModuleProject project = IntellijLintProject.createModuleProject(client, module);
        LintModuleProject main = null;
        HashMap projectMap = Maps.newHashMap();
        if (project != null) {
            Module androidModule;
            project.setDirectLibraries(Collections.<Project>emptyList());
            if (file != null) {
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            projectMap.put(project, module);
            if (!project.isAndroidProject() && (androidModule = IntellijLintProject.findAndroidModule(module)) != null && (main = IntellijLintProject.createModuleProject(client, androidModule)) != null) {
                projectMap.put(main, androidModule);
                main.setDirectLibraries(Collections.singletonList(project));
            }
        }
        client.setModuleMap(projectMap);
        return Pair.create((Object)((Object)project), main);
    }

    @Nullable
    private static Module findAndroidModule(final Module module) {
        Graph graph = (Graph)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Graph<Module>>(){

            public Graph<Module> compute() {
                return ModuleManager.getInstance((com.intellij.openapi.project.Project)module.getProject()).moduleGraph();
            }
        });
        HashSet facets = Sets.newHashSet();
        HashSet seen = Sets.newHashSet();
        seen.add(module);
        IntellijLintProject.addAndroidModules(facets, seen, (Graph<Module>)graph, module);
        for (AndroidFacet facet : facets) {
            if (facet.isLibraryProject()) continue;
            return facet.getModule();
        }
        if (!facets.isEmpty()) {
            return ((AndroidFacet)((Object)facets.iterator().next())).getModule();
        }
        return null;
    }

    private static void addAndroidModules(Set<AndroidFacet> androidFacets, Set<Module> seen, Graph<Module> graph, Module module) {
        Iterator iterator = graph.getOut((Object)module);
        while (iterator.hasNext()) {
            Module dep = (Module)iterator.next();
            AndroidFacet facet = AndroidFacet.getInstance(dep);
            if (facet != null) {
                androidFacets.add(facet);
            }
            if (seen.contains(dep)) continue;
            seen.add(dep);
            IntellijLintProject.addAndroidModules(androidFacets, seen, graph, dep);
        }
    }

    private static void addProjects(LintClient client, Module module, @Nullable List<VirtualFile> files, Map<Module, Project> moduleMap, Map<AndroidLibrary, Project> libraryMap, Map<Project, Module> projectMap, List<Project> projects) {
        AndroidGradleModel androidGradleModel;
        if (moduleMap.containsKey(module)) {
            return;
        }
        LintModuleProject project = IntellijLintProject.createModuleProject(client, module);
        if (project == null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(module, false);
            for (AndroidFacet dependentFacet : dependentFacets) {
                IntellijLintProject.addProjects(client, dependentFacet.getModule(), files, moduleMap, libraryMap, projectMap, projects);
            }
            return;
        }
        projects.add(project);
        moduleMap.put(module, project);
        projectMap.put(project, module);
        if (IntellijLintProject.processFileFilter(module, files, project)) {
            return;
        }
        ArrayList dependencies = Lists.newArrayList();
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(module, true);
        for (AndroidFacet dependentFacet : dependentFacets) {
            Project p = moduleMap.get(dependentFacet.getModule());
            if (p != null) {
                dependencies.add(p);
                continue;
            }
            IntellijLintProject.addProjects(client, dependentFacet.getModule(), files, moduleMap, libraryMap, projectMap, dependencies);
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidGradleModel = AndroidGradleModel.get(facet)) != null) {
            IntellijLintProject.addGradleLibraryProjects(client, files, libraryMap, projects, facet, androidGradleModel, project, projectMap, dependencies);
        }
        project.setDirectLibraries(dependencies);
    }

    private static boolean processFileFilter(Module module, @Nullable List<VirtualFile> files, LintModuleProject project) {
        if (files != null && !files.isEmpty()) {
            ListIterator<VirtualFile> iterator = files.listIterator();
            while (iterator.hasNext()) {
                VirtualFile file = iterator.next();
                if (!module.getModuleContentScope().accept(file)) continue;
                project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                iterator.remove();
            }
            if (files.isEmpty()) {
                project.setDirectLibraries(Collections.<Project>emptyList());
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static LintModuleProject createModuleProject(LintClient client, Module module) {
        File dir;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot(facet);
            if (mainContentRoot == null) {
                return null;
            }
            dir = new File(FileUtil.toSystemDependentName((String)mainContentRoot.getPath()));
        } else {
            String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
            if (moduleDirPath == null) {
                return null;
            }
            dir = new File(FileUtil.toSystemDependentName((String)moduleDirPath));
        }
        LintModuleProject project = null;
        if (facet == null) {
            project = new LintModuleProject(client, dir, dir, module);
            AndroidFacet f = IntellijLintProject.findAndroidFacetInProject(module.getProject());
            if (f != null) {
                project.mGradleProject = f.requiresAndroidModel();
            }
        } else {
            AndroidModel androidModel;
            project = facet.requiresAndroidModel() ? ((androidModel = facet.getAndroidModel()) instanceof AndroidGradleModel ? new LintGradleProject(client, dir, dir, facet, (AndroidGradleModel)androidModel) : new LintAndroidProject(client, dir, dir, facet)) : new LintAndroidProject(client, dir, dir, facet);
        }
        if (project != null) {
            client.registerProject(dir, (Project)project);
        }
        return project;
    }

    public static boolean hasAndroidModule(com.intellij.openapi.project.Project project) {
        return IntellijLintProject.findAndroidFacetInProject(project) != null;
    }

    @Nullable
    private static AndroidFacet findAndroidFacetInProject(com.intellij.openapi.project.Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((com.intellij.openapi.project.Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            return facet;
        }
        return null;
    }

    private static void addGradleLibraryProjects(LintClient client, @Nullable List<VirtualFile> files, Map<AndroidLibrary, Project> libraryMap, List<Project> projects, AndroidFacet facet, AndroidGradleModel androidGradleModel, LintModuleProject project, Map<Project, Module> projectMap, List<Project> dependencies) {
        Collection libraries = androidGradleModel.getMainArtifact().getDependencies().getLibraries();
        for (AndroidLibrary library : libraries) {
            Project p = libraryMap.get(library);
            if (p == null) {
                File dir = library.getFolder();
                p = new LintGradleLibraryProject(client, dir, dir, library);
                libraryMap.put(library, p);
                projectMap.put(p, facet.getModule());
                projects.add(p);
                if (files != null) {
                    VirtualFile libraryDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
                    if (libraryDir != null) {
                        ListIterator<VirtualFile> iterator = files.listIterator();
                        while (iterator.hasNext()) {
                            VirtualFile file = iterator.next();
                            if (!VfsUtilCore.isAncestor((VirtualFile)libraryDir, (VirtualFile)file, (boolean)false)) continue;
                            project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                            iterator.remove();
                        }
                    }
                    if (files.isEmpty()) {
                        files = null;
                    }
                }
            }
            dependencies.add(p);
        }
    }

    protected void initialize() {
    }

    protected static boolean depsDependsOn(Project project, String artifact) {
        for (Project dependency : project.getDirectLibraries()) {
            Boolean b = dependency.dependsOn(artifact);
            if (b == null || !b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static class LintGradleLibraryProject
    extends IntellijLintProject {
        private final AndroidLibrary myLibrary;
        private static boolean sOptionalAvailable = true;

        private LintGradleLibraryProject(LintClient client, File dir, File referenceDir, AndroidLibrary library) {
            super(client, dir, referenceDir);
            this.myLibrary = library;
            this.mLibrary = true;
            this.mMergeManifests = true;
            this.mReportIssues = false;
            this.mGradleProject = true;
            this.mDirectLibraries = Collections.emptyList();
        }

        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifest = this.myLibrary.getManifest();
                this.mManifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                File proguardRules = this.myLibrary.getProguardRules();
                this.mProguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.mProguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                File folder = this.myLibrary.getResFolder();
                this.mResourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mResourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.mAssetFolders == null) {
                File folder = this.myLibrary.getAssetsFolder();
                this.mAssetFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mAssetFolders;
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        @Nullable
        public AndroidProject getGradleProjectModel() {
            return null;
        }

        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return this.myLibrary;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    this.mSupportLib = GradleUtil.dependsOn(this.myLibrary, artifact, true);
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = GradleUtil.dependsOn(this.myLibrary, artifact, true);
                }
                return this.mAppCompat;
            }
            if (GradleUtil.dependsOn(this.myLibrary, artifact, true)) {
                return true;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintGradleProject
    extends LintAndroidProject {
        private final AndroidGradleModel myAndroidGradleModel;
        private static boolean sProvidedAvailable = true;

        private LintGradleProject(LintClient client, File dir, File referenceDir, AndroidFacet facet, AndroidGradleModel androidGradleModel) {
            super(client, dir, referenceDir, facet);
            this.mGradleProject = true;
            this.mMergeManifests = true;
            this.myAndroidGradleModel = androidGradleModel;
        }

        @Override
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifestFile;
                SourceProvider variantProvider;
                SourceProvider buildTypeSourceProvider;
                File manifestFile2;
                SourceProvider multiProvider;
                File manifestFile3;
                List<SourceProvider> flavorSourceProviders;
                this.mManifestFiles = Lists.newArrayList();
                File mainManifest = this.myFacet.getMainSourceProvider().getManifestFile();
                if (mainManifest.exists()) {
                    this.mManifestFiles.add(mainManifest);
                }
                if ((flavorSourceProviders = this.myAndroidGradleModel.getFlavorSourceProviders()) != null) {
                    for (SourceProvider provider : flavorSourceProviders) {
                        manifestFile3 = provider.getManifestFile();
                        if (!manifestFile3.exists()) continue;
                        this.mManifestFiles.add(manifestFile3);
                    }
                }
                if ((multiProvider = this.myAndroidGradleModel.getMultiFlavorSourceProvider()) != null && (manifestFile2 = multiProvider.getManifestFile()).exists()) {
                    this.mManifestFiles.add(manifestFile2);
                }
                if ((buildTypeSourceProvider = this.myAndroidGradleModel.getBuildTypeSourceProvider()) != null && (manifestFile3 = buildTypeSourceProvider.getManifestFile()).exists()) {
                    this.mManifestFiles.add(manifestFile3);
                }
                if ((variantProvider = this.myAndroidGradleModel.getVariantSourceProvider()) != null && (manifestFile = variantProvider.getManifestFile()).exists()) {
                    this.mManifestFiles.add(manifestFile);
                }
            }
            return this.mManifestFiles;
        }

        public List<File> getAssetFolders() {
            if (this.mAssetFolders == null) {
                this.mAssetFolders = Lists.newArrayList();
                for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(this.myFacet)) {
                    Collection dirs = provider.getAssetsDirectories();
                    for (File dir : dirs) {
                        if (!dir.exists()) continue;
                        this.mAssetFolders.add(dir);
                    }
                }
            }
            return this.mAssetFolders;
        }

        @Override
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                AndroidGradleModel androidModel;
                if (this.myFacet.requiresAndroidModel() && (androidModel = AndroidGradleModel.get(this.myFacet)) != null) {
                    ProductFlavor flavor = androidModel.getAndroidProject().getDefaultConfig().getProductFlavor();
                    this.mProguardFiles = Lists.newArrayList();
                    for (File file : flavor.getProguardFiles()) {
                        if (!file.exists()) continue;
                        this.mProguardFiles.add(file);
                    }
                    try {
                        for (File file : flavor.getConsumerProguardFiles()) {
                            if (!file.exists()) continue;
                            this.mProguardFiles.add(file);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.mProguardFiles == null) {
                    this.mProguardFiles = Collections.emptyList();
                }
            }
            return this.mProguardFiles;
        }

        @Override
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @Override
        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }

        @Nullable
        public String getPackage() {
            String manifestPackage = super.getPackage();
            if (manifestPackage != null) {
                return manifestPackage;
            }
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getApplicationId();
            }
            return null;
        }

        public AndroidVersion getMinSdkVersion() {
            if (this.mMinSdkVersion == null) {
                this.mMinSdkVersion = AndroidModuleInfo.get(this.myFacet).getMinSdkVersion();
            }
            return this.mMinSdkVersion;
        }

        public AndroidVersion getTargetSdkVersion() {
            if (this.mTargetSdkVersion == null) {
                this.mTargetSdkVersion = AndroidModuleInfo.get(this.myFacet).getTargetSdkVersion();
            }
            return this.mTargetSdkVersion;
        }

        public int getBuildSdk() {
            String compileTarget;
            AndroidVersion version;
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel != null && (version = AndroidTargetHash.getPlatformVersion((String)(compileTarget = androidModel.getAndroidProject().getCompileTarget()))) != null) {
                return version.getApiLevel();
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                return platform.getApiLevel();
            }
            return super.getBuildSdk();
        }

        @Nullable
        public AndroidProject getGradleProjectModel() {
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel != null) {
                androidModel.getSelectedVariant();
                return androidModel.getAndroidProject();
            }
            return null;
        }

        @Nullable
        public Variant getCurrentVariant() {
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if (androidModel != null) {
                return androidModel.getSelectedVariant();
            }
            return null;
        }

        @Nullable
        public AndroidLibrary getGradleLibraryModel() {
            return null;
        }

        @Override
        @Nullable
        public Boolean dependsOn(String artifact) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    this.mSupportLib = this.myFacet.requiresAndroidModel() && this.myFacet.getAndroidModel() != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, artifact)) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, artifact));
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = this.myFacet.requiresAndroidModel() && this.myFacet.getAndroidModel() != null ? Boolean.valueOf(GradleUtil.dependsOn(androidModel, artifact)) : Boolean.valueOf(LintGradleProject.depsDependsOn(this, artifact));
                }
                return this.mAppCompat;
            }
            if (this.myFacet.requiresAndroidModel() && this.myFacet.getAndroidModel() != null && GradleUtil.dependsOn(androidModel, artifact)) {
                return true;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintAndroidProject
    extends LintModuleProject {
        protected final AndroidFacet myFacet;

        private LintAndroidProject(LintClient client, File dir, File referenceDir, AndroidFacet facet) {
            super(client, dir, referenceDir, facet.getModule());
            this.myFacet = facet;
            this.mGradleProject = false;
            this.mLibrary = this.myFacet.isLibraryProject();
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
            if (platform != null) {
                this.mBuildSdk = platform.getApiLevel();
            }
        }

        @Override
        public boolean isAndroidProject() {
            return true;
        }

        public String getName() {
            return this.myFacet.getModule().getName();
        }

        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
                this.mManifestFiles = manifestFile != null ? Collections.singletonList(VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile)) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                List urls;
                JpsAndroidModuleProperties properties = this.myFacet.getProperties();
                if (properties.RUN_PROGUARD && !(urls = properties.myProGuardCfgFiles).isEmpty()) {
                    this.mProguardFiles = new ArrayList();
                    for (String osPath : AndroidUtils.urlsToOsPaths(urls, null)) {
                        if (osPath.contains("%MODULE_SDK_HOME%")) continue;
                        this.mProguardFiles.add(new File(osPath));
                    }
                }
                if (this.mProguardFiles == null) {
                    this.mProguardFiles = Collections.emptyList();
                }
            }
            return this.mProguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                List<VirtualFile> folders = this.myFacet.getResourceFolderManager().getFolders();
                ArrayList dirs = Lists.newArrayListWithExpectedSize((int)folders.size());
                for (VirtualFile folder : folders) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)folder));
                }
                this.mResourceFolders = dirs;
            }
            return this.mResourceFolders;
        }

        @Nullable
        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    OrderEntry[] entries = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getOrderEntries();
                    block0: for (int i = entries.length - 1; i >= 0; --i) {
                        LibraryOrderEntry libraryOrderEntry;
                        VirtualFile[] classes;
                        OrderEntry orderEntry = entries[i];
                        if (!(orderEntry instanceof LibraryOrderEntry) || (classes = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES)) == null) continue;
                        for (VirtualFile file : classes) {
                            if (!file.getName().equals("android-support-v4.jar")) continue;
                            this.mSupportLib = true;
                            break block0;
                        }
                    }
                    if (this.mSupportLib == null) {
                        this.mSupportLib = LintAndroidProject.depsDependsOn(this, artifact);
                    }
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = false;
                    OrderEntry[] entries = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getOrderEntries();
                    for (int i = entries.length - 1; i >= 0; --i) {
                        ManifestInfo manifestInfo;
                        AndroidFacet facet;
                        ModuleOrderEntry moduleOrderEntry;
                        Module module;
                        OrderEntry orderEntry = entries[i];
                        if (!(orderEntry instanceof ModuleOrderEntry) || (module = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null || module == this.myFacet.getModule() || (facet = AndroidFacet.getInstance(module)) == null || !"android.support.v7.appcompat".equals((manifestInfo = ManifestInfo.get(module, false)).getPackage())) continue;
                        this.mAppCompat = true;
                        break;
                    }
                }
                return this.mAppCompat;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class LintModuleProject
    extends IntellijLintProject {
        private Module myModule;

        public void setDirectLibraries(List<Project> libraries) {
            this.mDirectLibraries = libraries;
        }

        private LintModuleProject(LintClient client, File dir, File referenceDir, Module module) {
            super(client, dir, referenceDir);
            this.myModule = module;
        }

        public boolean isAndroidProject() {
            return false;
        }

        public List<File> getJavaSourceFolders() {
            if (this.mJavaSourceFolders == null) {
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots(false);
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                for (VirtualFile root : sourceRoots) {
                    dirs.add(new File(root.getPath()));
                }
                this.mJavaSourceFolders = dirs;
            }
            return this.mJavaSourceFolders;
        }

        public List<File> getTestSourceFolders() {
            if (this.mTestSourceFolders == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.myModule);
                Object[] sourceRoots = manager.getSourceRoots(false);
                VirtualFile[] sourceAndTestRoots = manager.getSourceRoots(true);
                ArrayList<File> dirs = new ArrayList<File>(sourceAndTestRoots.length);
                for (VirtualFile root : sourceAndTestRoots) {
                    if (ArrayUtil.contains((Object)root, (Object[])sourceRoots)) continue;
                    dirs.add(new File(root.getPath()));
                }
                this.mTestSourceFolders = dirs;
            }
            return this.mTestSourceFolders;
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            return Collections.emptyList();
        }
    }
}

