/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomExtender
extends DomExtender<AndroidDomElement> {
    private static final Logger LOG = Logger.getInstance(AndroidDomExtender.class);
    private static final String[] LAYOUT_ATTRIBUTES_SUFS = new String[]{"_Layout", "_MarginLayout", "_Cell"};
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_TAG_NAMES = ImmutableSet.of((Object)"merge", (Object)"TableRow", (Object)"include", (Object)"requestFocus", (Object)"layout", (Object)"data", (Object[])new String[]{"import", "tag"});
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = ImmutableSet.of((Object)"TableRow", (Object)"TableLayout", (Object)"merge", (Object)"GridLayout", (Object)"android.support.v7.widget.GridLayout");

    public static boolean isLayoutAttributeRequired(@NotNull XmlName attributeName, @NotNull DomElement element) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/android/dom/AndroidDomExtender", "isLayoutAttributeRequired"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "isLayoutAttributeRequired"));
        }
        String localName = attributeName.getLocalName();
        if (!"layout_width".equals(localName) && !"layout_height".equals(localName)) {
            return false;
        }
        if ((element instanceof LayoutViewElement || element instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attributeName.getNamespaceKey())) {
            String tagName;
            XmlElement xmlElement = element.getXmlElement();
            XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
            String string = tagName = tag != null ? tag.getName() : null;
            if (!(SIZE_NOT_REQUIRED_TAG_NAMES.contains((Object)tagName) || tag != null && tag.getAttribute("style") != null)) {
                String parentTagName;
                XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                if (!SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains((Object)parentTagName)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean supportsStubs() {
        return false;
    }

    @Nullable
    public static String getNamespaceKeyByResourcePackage(@NotNull AndroidFacet facet, @Nullable String resPackage) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "getNamespaceKeyByResourcePackage"));
        }
        if (resPackage == null) {
            String aPackage;
            if (facet.getProperties().LIBRARY_PROJECT || facet.requiresAndroidModel()) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = facet.getManifest();
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && aPackage.length() > 0) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    private static void registerStyleableAttributes(DomElement element, @NotNull StyleableDefinition styleable, @Nullable String namespace, MyCallback callback, Set<XmlName> skippedAttributes) {
        if (styleable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleable", "org/jetbrains/android/dom/AndroidDomExtender", "registerStyleableAttributes"));
        }
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            String attrName = attrDef.getName();
            XmlName xmlName = new XmlName(attrName, namespace);
            if (skippedAttributes.contains(xmlName)) continue;
            skippedAttributes.add(xmlName);
            AndroidDomExtender.registerAttribute(attrDef, styleable.getName(), namespace, callback, element);
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, Collection<AttributeFormat> formats) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "org/jetbrains/android/dom/AndroidDomExtender", "mustBeSoft"));
        }
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName, String namespaceKey, MyCallback callback, @NotNull DomElement element) {
        XmlName xmlName;
        DomExtension extension;
        if (attrDef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttribute"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttribute"));
        }
        String name = attrDef.getName();
        if (!"http://schemas.android.com/apk/res/android".equals(namespaceKey) && name.startsWith("android:")) {
            name = name.substring("android:".length());
            namespaceKey = "http://schemas.android.com/apk/res/android";
        }
        if ((extension = callback.processAttribute(xmlName = new XmlName(name, namespaceKey), attrDef, parentStyleableName)) == null) {
            return;
        }
        Converter converter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter == null) {
            converter = "http://schemas.android.com/tools".equals(namespaceKey) ? ToolsAttributeUtil.getConverter(attrDef) : AndroidDomUtil.getConverter(attrDef);
        }
        if (converter != null) {
            extension.setConverter(converter, AndroidDomExtender.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (element instanceof LayoutElement && AndroidDomExtender.isLayoutAttributeRequired(xmlName, element) || element instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element)) {
            extension.addCustomAnnotation((Annotation)((Object)new MyRequired()));
        }
    }

    protected static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String[] styleableNames, MyCallback callback, Set<XmlName> skipNames) {
        if (styleableNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableNames", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttributes"));
        }
        AndroidDomExtender.registerAttributes(facet, element, styleableNames, null, callback, skipNames);
        AndroidDomExtender.registerAttributes(facet, element, styleableNames, "android", callback, skipNames);
    }

    protected static void registerAttributes(AndroidFacet facet, DomElement element, @NotNull String[] styleableNames, @Nullable String resPackage, MyCallback callback, Set<XmlName> skipNames) {
        if (styleableNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleableNames", "org/jetbrains/android/dom/AndroidDomExtender", "registerAttributes"));
        }
        ResourceManager manager = facet.getResourceManager(resPackage);
        if (manager == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        String namespace = AndroidDomExtender.getNamespaceKeyByResourcePackage(facet, resPackage);
        for (String name : styleableNames) {
            StyleableDefinition styleable = attrDefs.getStyleableByName(name);
            if (styleable == null) continue;
            AndroidDomExtender.registerStyleableAttributes(element, styleable, namespace, callback, skipNames);
        }
    }

    @NotNull
    private static Class getValueClass(@Nullable AttributeFormat format) {
        if (format == null) {
            if (String.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
            }
            return String.class;
        }
        switch (format) {
            case Boolean: {
                Class<Boolean> clazz = Boolean.TYPE;
                if (clazz == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
                }
                return clazz;
            }
            case Reference: 
            case Dimension: 
            case Color: {
                if (ResourceValue.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
                }
                return ResourceValue.class;
            }
        }
        if (String.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getValueClass"));
        }
        return String.class;
    }

    protected static void registerAttributesForClassAndSuperclasses(AndroidFacet facet, DomElement element, PsiClass c, MyCallback callback, Set<XmlName> skipNames) {
        while (c != null) {
            String styleableName = c.getName();
            if (styleableName != null) {
                AndroidDomExtender.registerAttributes(facet, element, new String[]{styleableName}, callback, skipNames);
            }
            c = AndroidDomExtender.getSuperclass(c);
        }
    }

    @Nullable
    protected static PsiClass getSuperclass(final @NotNull PsiClass c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/android/dom/AndroidDomExtender", "getSuperclass"));
        }
        return (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return c.isValid() ? c.getSuperClass() : null;
            }
        });
    }

    private static boolean isPreference(@NotNull Map<String, PsiClass> preferenceClassMap, @NotNull PsiClass c) {
        if (preferenceClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferenceClassMap", "org/jetbrains/android/dom/AndroidDomExtender", "isPreference"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/android/dom/AndroidDomExtender", "isPreference"));
        }
        PsiClass preferenceClass = preferenceClassMap.get("Preference");
        return preferenceClass != null && (preferenceClass == c || c.isInheritor(preferenceClass, true));
    }

    public static void registerExtensionsForXmlResources(AndroidFacet facet, XmlTag tag, XmlResourceElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skipAttrNames) {
        String tagName = tag.getName();
        String styleableName = (String)AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get((Object)tagName);
        if (styleableName != null) {
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            if (element instanceof Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            AndroidDomExtender.registerAttributes(facet, element, new String[]{styleableName}, "android", callback, newSkipAttrNames);
        }
        if (tagName.equals("searchable")) {
            AndroidDomExtender.registerSubtags("actionkey", XmlResourceElement.class, callback, registeredSubtags);
        }
        if (tagName.equals("Keyboard")) {
            AndroidDomExtender.registerSubtags("Row", XmlResourceElement.class, callback, registeredSubtags);
        } else if (tagName.equals("Row")) {
            AndroidDomExtender.registerSubtags("Key", XmlResourceElement.class, callback, registeredSubtags);
        }
        if (tagName.equals("device-admin")) {
            AndroidDomExtender.registerSubtags("uses-policies", XmlResourceElement.class, callback, registeredSubtags);
        } else if (tagName.equals("uses-policies")) {
            AndroidDomExtender.registerSubtags("limit-password", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("watch-login", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("reset-password", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("force-lock", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("wipe-data", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("set-global-proxy", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("expire-password", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("encrypted-storage", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("disable-camera", XmlResourceElement.class, callback, registeredSubtags);
            AndroidDomExtender.registerSubtags("disable-keyguard-features", XmlResourceElement.class, callback, registeredSubtags);
        }
        if (tagName.equals("preference-headers")) {
            AndroidDomExtender.registerSubtags("header", PreferenceElement.class, callback, registeredSubtags);
        }
        Map<String, PsiClass> prefClassMap = AndroidDomExtender.getPreferencesClassMap(facet);
        String prefClassName = element.getXmlTag().getName();
        PsiClass c = prefClassMap.get(prefClassName);
        AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, c, callback, skipAttrNames);
        String suffix = "Preference";
        if (prefClassName.endsWith(suffix)) {
            String widgetClassName = prefClassName.substring(0, prefClassName.length() - suffix.length());
            PsiClass widgetClass = SimpleClassMapConstructor.findClassByTagName(facet, widgetClassName, "android.view.View");
            AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, widgetClass, callback, skipAttrNames);
        }
        if (c != null && AndroidDomExtender.isPreference(prefClassMap, c)) {
            AndroidDomExtender.registerClassNameSubtags(tag, prefClassMap, PreferenceElement.class, registeredSubtags, callback);
        }
    }

    @NotNull
    public static Map<String, PsiClass> getPreferencesClassMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "getPreferencesClassMap"));
        }
        Map<String, PsiClass> map = facet.getClassMap("android.preference.Preference", SimpleClassMapConstructor.getInstance());
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "getPreferencesClassMap"));
        }
        return map;
    }

    public static Map<String, PsiClass> getViewClassMap(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "getViewClassMap"));
        }
        if (DumbService.isDumb((Project)facet.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return facet.getClassMap("android.view.View", SimpleClassMapConstructor.getInstance());
    }

    private static String[] getClassNames(@NotNull Collection<PsiClass> classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/android/dom/AndroidDomExtender", "getClassNames"));
        }
        ArrayList<String> names = new ArrayList<String>();
        for (PsiClass aClass : classes) {
            names.add(aClass.getName());
        }
        return ArrayUtil.toStringArray(names);
    }

    private static void registerLayoutAttributes(AndroidFacet facet, DomElement element, XmlTag tag, MyCallback callback, Set<XmlName> skipAttrNames) {
        String parentTagName;
        XmlTag parentTag = tag.getParentTag();
        Map<String, PsiClass> map = AndroidDomExtender.getViewClassMap(facet);
        if (parentTag != null && !"merge".equals(parentTagName = parentTag.getName())) {
            PsiClass c = map.get(parentTagName);
            while (c != null) {
                AndroidDomExtender.registerLayoutAttributes(facet, element, c, callback, skipAttrNames);
                c = AndroidDomExtender.getSuperclass(c);
            }
            return;
        }
        for (PsiClass c : map.values()) {
            AndroidDomExtender.registerLayoutAttributes(facet, element, c, callback, skipAttrNames);
        }
    }

    private static void registerLayoutAttributes(AndroidFacet facet, DomElement element, PsiClass c, MyCallback callback, Set<XmlName> skipAttrNames) {
        String styleableName = c.getName();
        if (styleableName != null) {
            String[] styleableNames = new String[LAYOUT_ATTRIBUTES_SUFS.length];
            for (int i = 0; i < LAYOUT_ATTRIBUTES_SUFS.length; ++i) {
                styleableNames[i] = styleableName + LAYOUT_ATTRIBUTES_SUFS[i];
            }
            AndroidDomExtender.registerAttributes(facet, element, styleableNames, callback, skipAttrNames);
        }
    }

    public static void registerExtensionsForLayout(AndroidFacet facet, XmlTag tag, LayoutElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skipAttrNames) {
        Map<String, PsiClass> map = AndroidDomExtender.getViewClassMap(facet);
        if (element instanceof Include) {
            for (String className : map.keySet()) {
                PsiClass c = map.get(className);
                AndroidDomExtender.registerLayoutAttributes(facet, (DomElement)element, c, callback, skipAttrNames);
            }
            for (PsiClass c : map.values()) {
                AndroidDomExtender.registerLayoutAttributes(facet, (DomElement)element, c, callback, skipAttrNames);
            }
            return;
        }
        if (element instanceof Fragment) {
            AndroidDomExtender.registerAttributes(facet, element, new String[]{"Fragment"}, callback, skipAttrNames);
        } else {
            if (element instanceof Tag) {
                AndroidDomExtender.registerAttributes(facet, element, new String[]{"ViewTag"}, "android", callback, skipAttrNames);
                return;
            }
            if (element instanceof Data) {
                return;
            }
            String tagName = tag.getName();
            if (!tagName.equals("view")) {
                PsiClass c = map.get(tagName);
                AndroidDomExtender.registerAttributesForClassAndSuperclasses(facet, element, c, callback, skipAttrNames);
            } else {
                String[] styleableNames = AndroidDomExtender.getClassNames(map.values());
                AndroidDomExtender.registerAttributes(facet, element, styleableNames, callback, skipAttrNames);
            }
        }
        AndroidDomExtender.registerLayoutAttributes(facet, (DomElement)element, tag, callback, skipAttrNames);
        AndroidDomExtender.registerClassNameSubtags(tag, map, LayoutViewElement.class, registeredSubtags, callback);
    }

    private static void registerClassNameSubtags(XmlTag tag, Map<String, PsiClass> classMap, Type type, Set<String> registeredSubtags, MyCallback callback) {
        HashSet<String> allAllowedTags = new HashSet<String>();
        HashMap class2Name = new HashMap();
        for (String tagName : classMap.keySet()) {
            PsiClass aClass = classMap.get(tagName);
            if (AndroidUtils.isAbstract(aClass)) continue;
            allAllowedTags.add(tagName);
            String qName = aClass.getQualifiedName();
            String prevTagName = (String)class2Name.get(qName);
            if (prevTagName != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        AndroidDomExtender.registerSubtags(callback, tag, allAllowedTags, class2Name.values(), registeredSubtags, type);
    }

    private static void registerSubtags(MyCallback callback, XmlTag tag, final Set<String> allowedTags, Collection<String> tagsToComplete, Set<String> registeredSubtags, Type type) {
        for (String tagName : tagsToComplete) {
            AndroidDomExtender.registerSubtags(tagName, type, callback, registeredSubtags);
        }
        AndroidDomExtender.registerExistingSubtags(tag, callback, new Processor<String>(){

            public boolean process(String s) {
                return allowedTags.contains(s);
            }
        }, type);
    }

    public static void registerExtensionsForManifest(AndroidFacet facet, String tagName, ManifestElement element, MyCallback callback, Set<String> registeredSubtags, Set<XmlName> skippedAttributes, boolean processStaticallyDefinedElements) {
        Set skippedTagNames;
        SystemResourceManager manager;
        String styleableName = AndroidManifestUtils.getStyleableNameForElement(element);
        if (styleableName == null) {
            styleableName = AndroidManifestUtils.getStyleableNameByTagName(tagName);
        }
        HashSet<XmlName> newSkippedNames = new HashSet<XmlName>(skippedAttributes);
        if (!processStaticallyDefinedElements) {
            for (String attrName : AndroidManifestUtils.getStaticallyDefinedAttrs(element)) {
                newSkippedNames.add(new XmlName(attrName, "http://schemas.android.com/apk/res/android"));
            }
        }
        if ((manager = facet.getSystemResourceManager()) == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable == null) {
            return;
        }
        AndroidDomExtender.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback, newSkippedNames);
        if (!processStaticallyDefinedElements) {
            skippedTagNames = new HashSet();
            Collections.addAll(skippedTagNames, AndroidManifestUtils.getStaticallyDefinedSubtags(element));
        } else {
            skippedTagNames = Collections.emptySet();
        }
        for (StyleableDefinition child : styleable.getChildren()) {
            String childTagName = AndroidManifestUtils.getTagNameByStyleableName(child.getName());
            if (childTagName == null || skippedTagNames.contains(childTagName)) continue;
            AndroidDomExtender.registerSubtags(childTagName, ManifestElement.class, callback, registeredSubtags);
        }
    }

    public static void processAttrsAndSubtags(@NotNull AndroidDomElement element, @NotNull MyCallback callback, @NotNull AndroidFacet facet, boolean processAllExistingAttrsFirst, boolean processStaticallyDefinedElements) {
        String styleableName;
        Styleable styleableAnnotation;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "processAttrsAndSubtags"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/android/dom/AndroidDomExtender", "processAttrsAndSubtags"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/AndroidDomExtender", "processAttrsAndSubtags"));
        }
        XmlTag tag = element.getXmlTag();
        HashSet<XmlName> skippedAttributes = processAllExistingAttrsFirst ? AndroidDomExtender.registerExistingAttributes(facet, tag, callback, element) : new HashSet<XmlName>();
        String tagName = tag.getName();
        HashSet<String> registeredSubtags = new HashSet<String>();
        if (element instanceof ManifestElement) {
            AndroidDomExtender.registerExtensionsForManifest(facet, tagName, (ManifestElement)element, callback, registeredSubtags, skippedAttributes, processStaticallyDefinedElements);
            if (tag.getParentTag() != null) {
                AndroidDomExtender.registerToolsAttribute("node", callback);
                AndroidDomExtender.registerToolsAttribute("strict", callback);
                AndroidDomExtender.registerToolsAttribute("remove", callback);
                AndroidDomExtender.registerToolsAttribute("replace", callback);
            }
            if (element instanceof UsesSdk) {
                AndroidDomExtender.registerToolsAttribute("overrideLibrary", callback);
            }
        } else if (element instanceof LayoutElement) {
            AndroidDomExtender.registerExtensionsForLayout(facet, tag, (LayoutElement)element, callback, registeredSubtags, skippedAttributes);
            if (!(element instanceof DataBindingElement)) {
                AndroidDomExtender.registerToolsAttribute("targetApi", callback);
                if (tag.getParentTag() == null) {
                    AndroidDomExtender.registerToolsAttribute("context", callback);
                    AndroidDomExtender.registerToolsAttribute("menu", callback);
                    AndroidDomExtender.registerToolsAttribute("actionBarNavMode", callback);
                    AndroidDomExtender.registerToolsAttribute("showIn", callback);
                }
                Map<String, PsiClass> classMap = AndroidDomExtender.getViewClassMap(facet);
                PsiClass adapterView = classMap.get("AdapterView");
                PsiClass psiClass = classMap.get(tag.getName());
                if (adapterView != null && psiClass != null && psiClass.isInheritor(adapterView, true)) {
                    AndroidDomExtender.registerToolsAttribute("listitem", callback);
                    AndroidDomExtender.registerToolsAttribute("listheader", callback);
                    AndroidDomExtender.registerToolsAttribute("listfooter", callback);
                }
            }
        } else if (element instanceof XmlResourceElement) {
            AndroidDomExtender.registerExtensionsForXmlResources(facet, tag, (XmlResourceElement)element, callback, registeredSubtags, skippedAttributes);
        }
        if ((styleableAnnotation = (Styleable)element.getAnnotation(Styleable.class)) == null) {
            return;
        }
        SystemResourceManager manager = facet.getSystemResourceManager();
        if (manager == null) {
            return;
        }
        AttributeDefinitions definitions = manager.getAttributeDefinitions();
        if (definitions == null) {
            return;
        }
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName2);
            if (styleable == null) {
                LOG.warn(String.format("@Styleable(%s) annotation doesn't point to existing styleable", styleableName2));
                continue;
            }
            AndroidDomExtender.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback, skippedAttributes);
        }
        if (element instanceof InterpolatorElement && (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) != null) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName);
            if (styleable == null) {
                LOG.warn(String.format("%s doesn't point to existing styleable for interpolator", styleableName));
            } else {
                AndroidDomExtender.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback, skippedAttributes);
            }
        }
    }

    private static void registerToolsAttribute(@NotNull String attributeName, @NotNull MyCallback callback) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/android/dom/AndroidDomExtender", "registerToolsAttribute"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/android/dom/AndroidDomExtender", "registerToolsAttribute"));
        }
        AttributeDefinition definition = ToolsAttributeUtil.getAttrDefByName(attributeName);
        if (definition != null) {
            XmlName name = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback.processAttribute(name, definition, null);
            ResolvingConverter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter((Converter)converter);
            }
        } else {
            LOG.warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    private static void registerSubtags(@NotNull String name, Type type, MyCallback callback, Set<String> registeredTags) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/AndroidDomExtender", "registerSubtags"));
        }
        callback.processSubtag(new XmlName(name), type);
        registeredTags.add(name);
    }

    private static void registerExistingSubtags(@NotNull XmlTag tag, @NotNull MyCallback callback, @Nullable Processor<String> filter, @NotNull Type type) {
        XmlTag[] subtags;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingSubtags"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingSubtags"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingSubtags"));
        }
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            String localName = subtag.getLocalName();
            if (filter != null && !filter.process((Object)localName) || localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            callback.processSubtag(new XmlName(localName), type);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(AndroidFacet facet, XmlTag tag, MyCallback callback, AndroidDomElement element) {
        XmlAttribute[] attrs;
        HashSet<XmlName> result = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet, attr)) == null) continue;
            String namespace = attr.getNamespace();
            result.add(new XmlName(attr.getLocalName(), attr.getNamespace()));
            AndroidDomExtender.registerAttribute(attrDef, null, namespace.length() > 0 ? namespace : null, callback, element);
        }
        HashSet<XmlName> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidDomExtender", "registerExistingAttributes"));
        }
        return hashSet;
    }

    public void registerExtensions(@NotNull AndroidDomElement element, final @NotNull DomExtensionsRegistrar registrar) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidDomExtender", "registerExtensions"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/android/dom/AndroidDomExtender", "registerExtensions"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return;
        }
        AndroidDomExtender.processAttrsAndSubtags(element, new MyCallback(){

            @Override
            @Nullable
            public DomExtension processAttribute(@NotNull XmlName xmlName, @NotNull AttributeDefinition attrDef, @Nullable String parentStyleableName) {
                if (xmlName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$3", "processAttribute"));
                }
                if (attrDef == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrDef", "org/jetbrains/android/dom/AndroidDomExtender$3", "processAttribute"));
                }
                Set<AttributeFormat> formats = attrDef.getFormats();
                Class valueClass = formats.size() == 1 ? AndroidDomExtender.getValueClass(formats.iterator().next()) : String.class;
                registrar.registerAttributeChildExtension(xmlName, GenericAttributeValue.class);
                return registrar.registerGenericAttributeValueChildExtension(xmlName, (Type)valueClass);
            }

            @Override
            public void processSubtag(@NotNull XmlName xmlName, @NotNull Type type) {
                if (xmlName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$3", "processSubtag"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/AndroidDomExtender$3", "processSubtag"));
                }
                registrar.registerCollectionChildrenExtension(xmlName, type);
            }
        }, facet, true, false);
    }

    public static abstract class MyCallback {
        @Nullable
        abstract DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);

        void processSubtag(@NotNull XmlName xmlName, @NotNull Type type) {
            if (xmlName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlName", "org/jetbrains/android/dom/AndroidDomExtender$MyCallback", "processSubtag"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/AndroidDomExtender$MyCallback", "processSubtag"));
            }
        }
    }

    private static class MyRequired
    implements Required {
        private MyRequired() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }
}

