/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable.editors;

import com.android.resources.ResourceType;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.android.designer.propertyTable.renderers.EventHandlerEditorRenderer;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadPropertyContext;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventHandlerEditor
extends ResourceEditor {
    private static final ResourceType[] TYPES = new ResourceType[]{ResourceType.STRING};
    private static final Set<AttributeFormat> FORMATS = EnumSet.of(AttributeFormat.String, AttributeFormat.Enum);

    public EventHandlerEditor() {
        super(TYPES, FORMATS, ArrayUtil.EMPTY_STRING_ARRAY);
        this.getCombo().setRenderer(new EventHandlerEditorRenderer());
    }

    @Override
    public Object getValue() {
        Object item = this.getCombo().getSelectedItem();
        if (item instanceof PsiMethodWrapper) {
            return item.toString();
        }
        return super.getValue();
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, @Nullable PropertyContext context, Object value, @Nullable InplaceContext inplaceContext) {
        this.myComponent = (RadComponent)container;
        this.myRootComponent = context instanceof RadPropertyContext ? ((RadPropertyContext)context).getRootComponent() : null;
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement("<unset>");
        JComboBox combo = this.getCombo();
        combo.setModel(model);
        Module module = RadModelBuilder.getModule(this.myRootComponent);
        HashSet<String> names = new HashSet<String>();
        if (module != null) {
            for (PsiClass psiClass : ChooseClassDialog.findInheritors(module, "android.app.Activity", true)) {
                for (PsiMethod method : psiClass.getMethods()) {
                    if (!OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method) || !names.add(method.getName())) continue;
                    model.addElement(new PsiMethodWrapper(method));
                }
            }
        }
        combo.setSelectedItem(value);
        ComponentWithBrowseButton componentWithBrowseButton = this.myEditor;
        if (componentWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/editors/EventHandlerEditor", "getComponent"));
        }
        return componentWithBrowseButton;
    }

    private JComboBox getCombo() {
        return (JComboBox)this.myEditor.getChildComponent();
    }

    public static final class PsiMethodWrapper {
        private final PsiMethod myMethod;

        public PsiMethodWrapper(PsiMethod method) {
            this.myMethod = method;
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean equals(Object object) {
            return object == this || this.myMethod.getName().equals(object);
        }

        public int hashCode() {
            return this.myMethod.getName().hashCode();
        }

        public String toString() {
            return this.myMethod.getName();
        }
    }
}

