/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.android.resources.ResourceType;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeLayoutProperty
extends Property<RadViewComponent>
implements IXmlAttributeLocator {
    public static final String NAME = "layout:xml";
    public static ResourceType[] TYPES = new ResourceType[]{ResourceType.LAYOUT};
    private static final Set<AttributeFormat> FORMATS = EnumSet.of(AttributeFormat.Reference);
    public static final Property INSTANCE = new IncludeLayoutProperty();
    private static final String JAVA_DOC = JavadocParser.build("layout:xml", "Reference to the layout file you wish to include.");
    private final PropertyRenderer myRenderer = new ResourceRenderer(FORMATS);
    private final PropertyEditor myEditor = new ResourceEditor(TYPES, FORMATS, null);

    private IncludeLayoutProperty() {
        super(null, NAME);
        this.setImportant(true);
    }

    public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/IncludeLayoutProperty", "createForNewPresentation"));
        }
        return null;
    }

    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/IncludeLayoutProperty", "getValue"));
        }
        String layout = component.getTag().getAttributeValue("layout");
        return layout == null ? "" : layout;
    }

    public void setValue(final @NotNull RadViewComponent component, final Object value) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/IncludeLayoutProperty", "setValue"));
        }
        if (!StringUtil.isEmpty((String)((String)value))) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    component.getTag().setAttribute("layout", (String)value);
                }
            });
        }
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/IncludeLayoutProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        return JAVA_DOC;
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return component.getTag().getAttribute("layout") == attribute;
    }
}

