/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AndroidSdk;
import com.android.tools.idea.welcome.install.AndroidVirtualDevice;
import com.android.tools.idea.welcome.install.CheckSdkOperation;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.DownloadOperation;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.Platform;
import com.android.tools.idea.welcome.install.UnpackOperation;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.welcome.wizard.SdkComponentsStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    @NotNull
    private final Map<String, RemotePackage> myRemotePackages;
    private final FileOp myFileOp;
    @NotNull
    private final FirstRunWizardMode myMode;
    private AndroidSdkHandler myLocalHandler;
    private ComponentTreeNode myComponentTree;
    private final ProgressStep myProgressStep;
    @NotNull
    private ComponentInstaller myComponentInstaller;
    private final boolean myInstallUpdates;

    public InstallComponentsPath(@NotNull Map<String, RemotePackage> remotePackages, @NotNull FirstRunWizardMode mode, @NotNull File sdkLocation, @NotNull ProgressStep progressStep, boolean installUpdates) {
        if (remotePackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePackages", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "<init>"));
        }
        if (sdkLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "<init>"));
        }
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "<init>"));
        }
        this.myRemotePackages = remotePackages;
        this.myFileOp = FileOpUtils.create();
        this.myMode = mode;
        this.myLocalHandler = AndroidSdkHandler.getInstance((File)sdkLocation);
        this.myProgressStep = progressStep;
        this.myComponentInstaller = new ComponentInstaller(remotePackages, installUpdates, this.myLocalHandler);
        this.myInstallUpdates = installUpdates;
    }

    private ComponentTreeNode createComponentTree(@NotNull FirstRunWizardMode reason, @NotNull ScopedStateStore stateStore, boolean createAvd) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "createComponentTree"));
        }
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "createComponentTree"));
        }
        ArrayList components = Lists.newArrayList();
        components.add(new AndroidSdk(stateStore));
        ComponentTreeNode platforms = Platform.createSubtree(stateStore, this.myRemotePackages);
        if (platforms != null) {
            components.add(platforms);
        }
        if (Haxm.canRun() && reason == FirstRunWizardMode.NEW_INSTALL) {
            components.add(new Haxm(stateStore, FirstRunWizard.KEY_CUSTOM_INSTALL));
        }
        if (createAvd) {
            components.add(new AndroidVirtualDevice(stateStore, this.myRemotePackages, this.myFileOp));
        }
        return new ComponentCategory("Root", "Root node that is not supposed to appear in the UI", components);
    }

    private static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }

    private static boolean hasPlatformsDir(@Nullable File[] files) {
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!InstallComponentsPath.isPlatformsDir(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPlatformsDir(File file) {
        return file.isDirectory() && file.getName().equalsIgnoreCase("platforms");
    }

    @NotNull
    private static File getSdkRoot(@NotNull File expandedLocation) {
        if (expandedLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expandedLocation", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "getSdkRoot"));
        }
        File[] files = expandedLocation.listFiles();
        if (InstallComponentsPath.hasPlatformsDir(files)) {
            File file = expandedLocation;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "getSdkRoot"));
            }
            return file;
        }
        if (files != null) {
            for (File file : files) {
                if (!InstallComponentsPath.hasPlatformsDir(file.listFiles())) continue;
                File file2 = file;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "getSdkRoot"));
                }
                return file2;
            }
        }
        File file = expandedLocation;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "getSdkRoot"));
        }
        return file;
    }

    @NotNull
    private static InstallOperation<File, File> downloadAndUnzipSdkSeed(@NotNull InstallContext context, @NotNull File destination, double progressShare) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        double DOWNLOAD_OPERATION_PROGRESS_SHARE = progressShare * 0.8;
        double UNZIP_OPERATION_PROGRESS_SHARE = progressShare * 0.15;
        double MOVE_OPERATION_PROGRESS_SHARE = progressShare - DOWNLOAD_OPERATION_PROGRESS_SHARE - UNZIP_OPERATION_PROGRESS_SHARE;
        DownloadOperation download = new DownloadOperation(context, FirstRunWizardDefaults.getSdkDownloadUrl(), DOWNLOAD_OPERATION_PROGRESS_SHARE);
        UnpackOperation unpack = new UnpackOperation(context, UNZIP_OPERATION_PROGRESS_SHARE);
        MoveSdkOperation move = new MoveSdkOperation(context, destination, MOVE_OPERATION_PROGRESS_SHARE);
        InstallOperation<File, File> installOperation = download.then(unpack).then(move);
        if (installOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "downloadAndUnzipSdkSeed"));
        }
        return installOperation;
    }

    @Nullable
    private File getHandoffAndroidSdkSource() {
        File androidSrc = this.myMode.getAndroidSrc();
        if (androidSrc != null) {
            File[] files = androidSrc.listFiles();
            if (androidSrc.isDirectory() && files != null && files.length > 0) {
                return androidSrc;
            }
        }
        return null;
    }

    private InstallOperation<File, File> createInitSdkOperation(InstallContext installContext, File destination, double progressRatio) {
        File handoffSource = this.getHandoffAndroidSdkSource();
        if (handoffSource != null) {
            return new MergeOperation(handoffSource, installContext, progressRatio);
        }
        if (InstallComponentsPath.isNonEmptyDirectory(destination) && AndroidSdkData.getSdkData(destination) != null) {
            return InstallOperation.wrap(installContext, new ReturnValue(), 0.0);
        }
        return InstallComponentsPath.downloadAndUnzipSdkSeed(installContext, destination, progressRatio);
    }

    private static boolean isNonEmptyDirectory(File file) {
        String[] contents = !file.isDirectory() ? null : file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equalsIgnoreCase(".DS_Store") && !name.equalsIgnoreCase("thumbs.db") && !name.equalsIgnoreCase("desktop.ini");
            }
        });
        return contents != null && contents.length > 0;
    }

    @Override
    protected void init() {
        File location = this.myLocalHandler.getLocation();
        assert (location != null);
        this.myState.put(WizardConstants.KEY_SDK_INSTALL_LOCATION, location.getAbsolutePath());
        this.myComponentTree = this.createComponentTree(this.myMode, this.myState, this.myMode.shouldCreateAvd());
        this.myComponentTree.init(this.myProgressStep);
        this.addStep(new SdkComponentsStep(this.myComponentTree, FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, this.myMode));
        this.myComponentTree.init(this.myProgressStep);
        this.myComponentTree.updateState(this.myLocalHandler);
        for (DynamicWizardStep step : this.myComponentTree.createSteps()) {
            this.addStep(step);
        }
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            Supplier<Collection<RemotePackage>> supplier = new Supplier<Collection<RemotePackage>>(){

                public Collection<RemotePackage> get() {
                    Collection<InstallableComponent> components = InstallComponentsPath.this.myComponentTree.getChildrenToInstall();
                    return InstallComponentsPath.this.myComponentInstaller.getPackagesToInstall(components);
                }
            };
            this.addStep(new InstallSummaryStep(FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, (Supplier<? extends Collection<RemotePackage>>)supplier));
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        String sdkPath;
        super.deriveValues(modified);
        if (modified.contains(WizardConstants.KEY_SDK_INSTALL_LOCATION) && (sdkPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION)) != null) {
            File sdkLocation = new File(sdkPath);
            if (!FileUtil.filesEqual((File)this.myLocalHandler.getLocation(), (File)sdkLocation)) {
                this.myLocalHandler = AndroidSdkHandler.getInstance((File)sdkLocation);
                this.myComponentInstaller = new ComponentInstaller(this.myRemotePackages, this.myInstallUpdates, this.myLocalHandler);
                this.myComponentTree.updateState(this.myLocalHandler);
            }
        }
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Setup Android Studio Components" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "getPathName"));
        }
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        double INIT_SDK_OPERATION_PROGRESS_SHARE = 0.3;
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 0.7;
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep);
        File destination = this.getDestination();
        InstallOperation<File, File> initialize = this.createInitSdkOperation(installContext, destination, 0.3);
        Collection<InstallableComponent> selectedComponents = this.myComponentTree.getChildrenToInstall();
        CheckSdkOperation checkSdk = new CheckSdkOperation(installContext);
        InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, this.myComponentInstaller, 0.7);
        SetPreference setPreference = new SetPreference(this.myMode.getInstallerTimestamp());
        try {
            initialize.then(checkSdk).then(install).then(setPreference).then(new ConfigureComponents(installContext, selectedComponents, this.myLocalHandler)).execute(destination);
        }
        catch (InstallationCancelledException e) {
            installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Nullable
    public static RemotePackage findLatestPlatform(@Nullable Map<String, RemotePackage> remotePackages) {
        if (remotePackages == null) {
            return null;
        }
        AndroidVersion max = null;
        RemotePackage latest = null;
        for (RemotePackage pkg : remotePackages.values()) {
            DetailsTypes.PlatformDetailsType platformDetails;
            AndroidVersion version;
            TypeDetails details = pkg.getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (version = DetailsTypes.getAndroidVersion((DetailsTypes.ApiDetailsType)(platformDetails = (DetailsTypes.PlatformDetailsType)details))).isPreview() || max != null && version.compareTo(max) <= 0) continue;
            latest = pkg;
            max = version;
        }
        return latest;
    }

    @NotNull
    private File getDestination() throws WizardException {
        String destinationPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        File file = destination;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath", "getDestination"));
        }
        return file;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    public boolean shouldDownloadingComponentsStepBeShown() {
        String path = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (path != null);
        return SdkLocationUtils.isWritable(this.myFileOp, new File(path));
    }

    private static class ConfigureComponents
    implements Function<File, File> {
        private final InstallContext myInstallContext;
        private final Collection<? extends InstallableComponent> mySelectedComponents;
        private final AndroidSdkHandler mySdkHandler;

        public ConfigureComponents(InstallContext installContext, Collection<? extends InstallableComponent> selectedComponents, AndroidSdkHandler sdkHandler) {
            this.myInstallContext = installContext;
            this.mySelectedComponents = selectedComponents;
            this.mySdkHandler = sdkHandler;
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            for (InstallableComponent installableComponent : this.mySelectedComponents) {
                installableComponent.configure(this.myInstallContext, this.mySdkHandler);
            }
            return input;
        }
    }

    private static class SetPreference
    implements Function<File, File> {
        @Nullable
        private final String myInstallerTimestamp;

        public SetPreference(@Nullable String installerTimestamp) {
            this.myInstallerTimestamp = installerTimestamp;
        }

        public File apply(final @Nullable File input) {
            assert (input != null);
            ApplicationUtils.invokeWriteActionAndWait(ModalityState.any(), new Runnable(){

                @Override
                public void run() {
                    IdeSdks.setAndroidSdkPath(input, ProjectManager.getInstance().getDefaultProject());
                    AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(SetPreference.this.myInstallerTimestamp);
                }
            });
            return input;
        }
    }

    private static class ReturnValue
    implements Function<File, File> {
        private ReturnValue() {
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            return input;
        }
    }

    private static class MoveSdkOperation
    extends InstallOperation<File, File> {
        @NotNull
        private final File myDestination;

        public MoveSdkOperation(@NotNull InstallContext context, @NotNull File destination, double progressShare) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MoveSdkOperation", "<init>"));
            }
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MoveSdkOperation", "<init>"));
            }
            super(context, progressShare);
            this.myDestination = destination;
        }

        @Override
        @NotNull
        protected File perform(@NotNull ProgressIndicator indicator, @NotNull File file) throws WizardException {
            File file2;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MoveSdkOperation", "perform"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MoveSdkOperation", "perform"));
            }
            indicator.setText("Moving downloaded SDK");
            indicator.start();
            try {
                File root = InstallComponentsPath.getSdkRoot(file);
                if (!root.renameTo(this.myDestination)) {
                    FileUtil.copyDir((File)root, (File)this.myDestination);
                    FileUtil.delete((File)root);
                }
                File file3 = this.myDestination;
                file2 = file3;
            }
            catch (IOException e) {
                throw new WizardException("Unable to move Android SDK", e);
            }
            finally {
                indicator.setFraction(1.0);
                indicator.stop();
            }
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MoveSdkOperation", "perform"));
            }
            return file2;
        }

        @Override
        public void cleanup(@NotNull File result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MoveSdkOperation", "cleanup"));
            }
        }
    }

    private static class MergeOperation
    extends InstallOperation<File, File> {
        private final File myRepo;
        private final InstallContext myContext;
        private boolean myRepoWasMerged = false;

        public MergeOperation(File repo, InstallContext context, double progressRatio) {
            super(context, progressRatio);
            this.myRepo = repo;
            this.myContext = context;
        }

        @Override
        @NotNull
        protected File perform(@NotNull ProgressIndicator indicator, @NotNull File destination) throws WizardException {
            File file;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MergeOperation", "perform"));
            }
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MergeOperation", "perform"));
            }
            indicator.setText("Installing Android SDK");
            try {
                FileUtil.ensureExists((File)destination);
                if (!FileUtil.filesEqual((File)destination.getCanonicalFile(), (File)this.myRepo.getCanonicalFile())) {
                    SdkMerger.mergeSdks(this.myRepo, destination, indicator);
                    this.myRepoWasMerged = true;
                }
                this.myContext.print(String.format("Android SDK was installed to %1$s\n", destination), ConsoleViewContentType.SYSTEM_OUTPUT);
                File file2 = destination;
                file = file2;
            }
            catch (IOException e) {
                throw new WizardException(e.getMessage(), e);
            }
            finally {
                indicator.stop();
            }
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MergeOperation", "perform"));
            }
            return file;
        }

        @Override
        public void cleanup(@NotNull File result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/wizard/InstallComponentsPath$MergeOperation", "cleanup"));
            }
            if (this.myRepoWasMerged && this.myRepo.exists()) {
                FileUtil.delete((File)this.myRepo);
            }
        }
    }
}

