/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ConsolidatedProgressStep
extends ProgressStep {
    private final AtomicBoolean myIsBusy;
    private final DynamicWizardHost myHost;
    private List<? extends AndroidStudioWizardPath> myPaths;

    public ConsolidatedProgressStep(@NotNull Disposable disposable, @NotNull DynamicWizardHost host) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/welcome/wizard/ConsolidatedProgressStep", "<init>"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/welcome/wizard/ConsolidatedProgressStep", "<init>"));
        }
        super(disposable);
        this.myIsBusy = new AtomicBoolean(false);
        this.myHost = host;
    }

    public void setPaths(@NotNull List<? extends AndroidStudioWizardPath> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/welcome/wizard/ConsolidatedProgressStep", "setPaths"));
        }
        this.myPaths = paths;
    }

    @Override
    public boolean canGoNext() {
        return super.canGoNext() && !this.myIsBusy.get();
    }

    @Override
    protected void execute() {
        this.myIsBusy.set(true);
        this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

            @Override
            public void run() {
                try {
                    ConsolidatedProgressStep.this.doLongRunningOperation(ConsolidatedProgressStep.this);
                }
                catch (WizardException e) {
                    Logger.getInstance(this.getClass()).error((Throwable)e);
                    ConsolidatedProgressStep.this.showConsole();
                    ConsolidatedProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                finally {
                    ConsolidatedProgressStep.this.myIsBusy.set(false);
                }
            }
        });
    }

    private void doLongRunningOperation(@NotNull ProgressStep progressStep) throws WizardException {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/wizard/ConsolidatedProgressStep", "doLongRunningOperation"));
        }
        for (AndroidStudioWizardPath androidStudioWizardPath : this.myPaths) {
            if (progressStep.isCanceled()) break;
            if (!(androidStudioWizardPath instanceof LongRunningOperationPath)) continue;
            ((LongRunningOperationPath)((Object)androidStudioWizardPath)).runLongOperation();
        }
    }

    @Override
    public boolean canGoPrevious() {
        return false;
    }

    @Override
    public boolean isStepVisible() {
        return this.myPaths != null && !this.myPaths.isEmpty();
    }
}

