/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.tools.idea.ui.wizard.StudioWizardLayout;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioWizardDialogBuilder {
    private static final Dimension DEFAULT_MIN_SIZE = JBUI.size((int)800, (int)650);
    private static final float SCREEN_PERCENT = 0.8f;
    @NotNull
    ModelWizard myWizard;
    @NotNull
    String myTitle;
    @Nullable
    Component myParent;
    @Nullable
    Project myProject;
    @NotNull
    DialogWrapper.IdeModalityType myModalityType;
    @NotNull
    Dimension myMinimumSize;

    public StudioWizardDialogBuilder(@NotNull ModelWizard wizard, @NotNull String title) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        this.myModalityType = DialogWrapper.IdeModalityType.IDE;
        this.myMinimumSize = DEFAULT_MIN_SIZE;
        this.myWizard = wizard;
        this.myTitle = title;
    }

    public StudioWizardDialogBuilder(@NotNull ModelWizard wizard, @NotNull String title, @Nullable Component parent) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        this(wizard, title);
        this.myParent = parent;
    }

    public StudioWizardDialogBuilder setProject(@Nullable Project project) {
        if (project != null) {
            this.myProject = project;
        }
        return this;
    }

    public StudioWizardDialogBuilder setModalityType(@Nullable DialogWrapper.IdeModalityType modalityType) {
        if (modalityType != null) {
            this.myModalityType = modalityType;
        }
        return this;
    }

    public StudioWizardDialogBuilder setMinimumSize(@NotNull Dimension minimumSize) {
        if (minimumSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSize", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "setMinimumSize"));
        }
        this.myMinimumSize = minimumSize;
        return this;
    }

    public ModelWizardDialog build() {
        StudioWizardLayout customLayout = new StudioWizardLayout();
        ModelWizardDialog dialog = this.myParent != null ? new ModelWizardDialog(this.myWizard, this.myTitle, this.myParent, customLayout) : new ModelWizardDialog(this.myWizard, this.myTitle, customLayout, this.myProject, this.myModalityType);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension clampedSize = new Dimension(Math.min(this.myMinimumSize.width, (int)((float)screenSize.width * 0.8f)), Math.min(this.myMinimumSize.height, (int)((float)screenSize.height * 0.8f)));
        dialog.setSize(clampedSize.width, clampedSize.height);
        return dialog;
    }
}

