/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterValueResolver {
    @NotNull
    private static final Deduplicator DO_NOTHING_DEDUPLICATOR = new Deduplicator(){

        @Override
        @Nullable
        public String deduplicate(@NotNull Parameter parameter, @Nullable String value) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/templates/ParameterValueResolver$1", "deduplicate"));
            }
            return value;
        }
    };
    @NotNull
    private final Set<Parameter> myComputedParameters;
    @NotNull
    private final Set<Parameter> myStaticParameters;
    @NotNull
    private final Deduplicator myDeduplicator;
    @NotNull
    private final StringEvaluator myStringEvaluator;
    @NotNull
    private final Map<Parameter, Object> myUserValues;
    @NotNull
    private final Map<String, Object> myAdditionalValues;

    @NotNull
    public static Map<Parameter, Object> resolve(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues) throws CircularParameterDependencyException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        if (userValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userValues", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        if (additionalValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalValues", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        Map<Parameter, Object> map = ParameterValueResolver.resolve(parameters, userValues, additionalValues, DO_NOTHING_DEDUPLICATOR);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        return map;
    }

    @NotNull
    public static Map<Parameter, Object> resolve(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues, @NotNull Deduplicator deduplicator) throws CircularParameterDependencyException {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        if (userValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userValues", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        if (additionalValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalValues", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        if (deduplicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deduplicator", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        ParameterValueResolver resolver = new ParameterValueResolver(parameters, userValues, additionalValues, deduplicator);
        Map<Parameter, Object> map = resolver.resolve();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        return map;
    }

    private ParameterValueResolver(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues, @NotNull Deduplicator deduplicator) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/idea/templates/ParameterValueResolver", "<init>"));
        }
        if (userValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userValues", "com/android/tools/idea/templates/ParameterValueResolver", "<init>"));
        }
        if (additionalValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalValues", "com/android/tools/idea/templates/ParameterValueResolver", "<init>"));
        }
        if (deduplicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deduplicator", "com/android/tools/idea/templates/ParameterValueResolver", "<init>"));
        }
        this.myComputedParameters = Sets.newHashSet();
        this.myStaticParameters = Sets.newHashSet();
        this.myStringEvaluator = new StringEvaluator();
        this.myUserValues = userValues;
        this.myAdditionalValues = additionalValues;
        for (Parameter parameter : parameters) {
            if (parameter == null || StringUtil.isEmptyOrSpaces((String)parameter.id)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)parameter.suggest) && !userValues.containsKey(parameter)) {
                this.myComputedParameters.add(parameter);
                continue;
            }
            this.myStaticParameters.add(parameter);
        }
        this.myDeduplicator = deduplicator;
    }

    @Nullable
    private static Object decodeInitialValue(@NotNull Parameter input, @Nullable String initial) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/android/tools/idea/templates/ParameterValueResolver", "decodeInitialValue"));
        }
        if (initial != null && input.type == Parameter.Type.BOOLEAN) {
            return Boolean.valueOf(initial);
        }
        return initial;
    }

    @NotNull
    public Map<Parameter, Object> resolve() throws CircularParameterDependencyException {
        Map<String, Object> staticValues = this.getStaticParameterValues(this.myUserValues, this.myAdditionalValues);
        Map<String, Object> computedValues = this.computeParameterValues(staticValues);
        HashMap allValues = Maps.newHashMapWithExpectedSize((int)(computedValues.size() + staticValues.size()));
        for (Parameter parameter : Iterables.concat(this.myStaticParameters, this.myComputedParameters)) {
            allValues.put(parameter, computedValues.get(parameter.id));
        }
        HashMap hashMap = allValues;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/ParameterValueResolver", "resolve"));
        }
        return hashMap;
    }

    @Nullable
    private Object computeParameterValue(@NotNull Parameter computedParameter, @NotNull Map<String, Object> currentValues) {
        if (computedParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computedParameter", "com/android/tools/idea/templates/ParameterValueResolver", "computeParameterValue"));
        }
        if (currentValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValues", "com/android/tools/idea/templates/ParameterValueResolver", "computeParameterValue"));
        }
        String suggest = computedParameter.suggest;
        assert (!StringUtil.isEmptyOrSpaces((String)suggest));
        String value = this.myStringEvaluator.evaluate(suggest, currentValues);
        value = this.myDeduplicator.deduplicate(computedParameter, value);
        return ParameterValueResolver.decodeInitialValue(computedParameter, value);
    }

    @NotNull
    private Map<String, Object> getStaticParameterValues(@NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues) {
        if (userValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userValues", "com/android/tools/idea/templates/ParameterValueResolver", "getStaticParameterValues"));
        }
        if (additionalValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalValues", "com/android/tools/idea/templates/ParameterValueResolver", "getStaticParameterValues"));
        }
        HashMap knownValues = Maps.newHashMapWithExpectedSize((int)(this.myStaticParameters.size() + additionalValues.size()));
        knownValues.putAll(additionalValues);
        for (Parameter parameter : this.myStaticParameters) {
            Object value;
            if (userValues.containsKey(parameter)) {
                value = userValues.get(parameter);
            } else if (additionalValues.containsKey(parameter.id)) {
                value = additionalValues.get(parameter.id);
            } else {
                String initial = parameter.initial;
                value = ParameterValueResolver.decodeInitialValue(parameter, initial);
            }
            knownValues.put(parameter.id, value);
        }
        HashMap hashMap = knownValues;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/ParameterValueResolver", "getStaticParameterValues"));
        }
        return hashMap;
    }

    @NotNull
    private Map<String, Object> computeParameterValues(@NotNull Map<String, Object> staticValues) throws CircularParameterDependencyException {
        if (staticValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticValues", "com/android/tools/idea/templates/ParameterValueResolver", "computeParameterValues"));
        }
        HashMap computedValues = Maps.newHashMapWithExpectedSize((int)(this.myComputedParameters.size() + staticValues.size()));
        computedValues.putAll(staticValues);
        for (Parameter parameter : this.myComputedParameters) {
            computedValues.put(parameter.id, "");
        }
        int maxIterations = 2 * this.myComputedParameters.size();
        Object updatedValues = ImmutableMap.of();
        for (int i = 0; i <= maxIterations; ++i) {
            updatedValues = this.computeUpdatedValues(computedValues);
            if (updatedValues.isEmpty()) {
                HashMap hashMap = computedValues;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/ParameterValueResolver", "computeParameterValues"));
                }
                return hashMap;
            }
            computedValues.putAll(updatedValues);
        }
        throw new CircularParameterDependencyException(updatedValues.keySet());
    }

    @NotNull
    private Map<String, Object> computeUpdatedValues(@NotNull Map<String, Object> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/templates/ParameterValueResolver", "computeUpdatedValues"));
        }
        HashMap updatedValues = Maps.newHashMapWithExpectedSize((int)this.myComputedParameters.size());
        for (Parameter computedParameter : this.myComputedParameters) {
            Object value = this.computeParameterValue(computedParameter, values);
            String id = computedParameter.id;
            if (Objects.equal((Object)values.get(id), (Object)value)) continue;
            updatedValues.put(id, value);
        }
        HashMap hashMap = updatedValues;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/ParameterValueResolver", "computeUpdatedValues"));
        }
        return hashMap;
    }

    public static interface Deduplicator {
        @Nullable
        public String deduplicate(@NotNull Parameter var1, @Nullable String var2);
    }
}

