/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdkv2;

import com.android.repository.Revision;
import com.android.repository.api.Channel;
import com.android.repository.api.Dependency;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.LayoutlibVersion;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.LegacyRepoUtils;
import com.android.sdklib.repositoryv2.targets.OptionalLibraryImpl;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.DownloadCache;
import com.android.tools.idea.sdk.remote.internal.archives.ArchFilter;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteAddonPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePlatformPkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkAddonSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkRepoSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSysImgSource;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.TaskMonitorProgressIndicatorAdapter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyRemoteRepoLoader
implements FallbackRemoteRepoLoader {
    private DownloadCache myDownloadCache;
    private SettingsController mySettingsController;

    public LegacyRemoteRepoLoader(@NotNull SettingsController settingsController) {
        if (settingsController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsController", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader", "<init>"));
        }
        this.mySettingsController = settingsController;
    }

    public void setDownloadCache(@Nullable DownloadCache cache) {
        this.myDownloadCache = cache;
    }

    private DownloadCache getDownloadCache() {
        if (this.myDownloadCache == null) {
            this.myDownloadCache = new DownloadCache(DownloadCache.Strategy.FRESH_CACHE);
        }
        return this.myDownloadCache;
    }

    @NotNull
    public Collection<RemotePackage> parseLegacyXml(@NotNull RepositorySource source, @NotNull ProgressIndicator progress) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader", "parseLegacyXml"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader", "parseLegacyXml"));
        }
        RemotePkgInfo[] packages = null;
        for (SchemaModule module : source.getPermittedModules()) {
            SdkSource legacySource = null;
            if (module.equals((Object)AndroidSdkHandler.getRepositoryModule())) {
                legacySource = new SdkRepoSource(source.getUrl(), "Legacy Repo Source");
            } else if (module.equals((Object)AndroidSdkHandler.getAddonModule())) {
                legacySource = new SdkAddonSource(source.getUrl(), "Legacy Addon Source");
            } else if (module.equals((Object)AndroidSdkHandler.getSysImgModule())) {
                legacySource = new SdkSysImgSource(source.getUrl(), "Legacy System Image Source");
            }
            if (legacySource == null) continue;
            legacySource.load(this.getDownloadCache(), new TaskMonitorProgressIndicatorAdapter(progress), this.mySettingsController.getForceHttp());
            if (legacySource.getFetchError() != null) {
                progress.logInfo(legacySource.getFetchError());
            }
            if ((packages = legacySource.getPackages()) == null) continue;
            break;
        }
        ArrayList result = Lists.newArrayList();
        if (packages != null) {
            for (void var9_9 : packages) {
                if (var9_9.getPkgDesc().getType() == PkgType.PKG_SAMPLE) continue;
                LegacyRemotePackage pkg = new LegacyRemotePackage((RemotePkgInfo)var9_9, source);
                result.add(pkg);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader", "parseLegacyXml"));
        }
        return arrayList;
    }

    private class LegacyRemotePackage
    implements RemotePackage {
        private final RemotePkgInfo myWrapped;
        private RepositorySource mySource;
        private TypeDetails myDetails;

        LegacyRemotePackage(RemotePkgInfo remote, RepositorySource source) {
            this.myWrapped = remote;
            this.mySource = source;
        }

        @NotNull
        public TypeDetails getTypeDetails() {
            if (this.myDetails == null) {
                LayoutlibVersion layoutlibVersion;
                int layoutlibApi = 0;
                if (this.myWrapped instanceof RemotePlatformPkgInfo && (layoutlibVersion = ((RemotePlatformPkgInfo)this.myWrapped).getLayoutLibVersion()) != null) {
                    layoutlibApi = layoutlibVersion.getApi();
                }
                ArrayList libs = Lists.newArrayList();
                if (this.myWrapped instanceof RemoteAddonPkgInfo) {
                    for (RemoteAddonPkgInfo.Lib wrappedLib : ((RemoteAddonPkgInfo)this.myWrapped).getLibs()) {
                        libs.add(new OptionalLibraryImpl(wrappedLib.getName(), new File(""), wrappedLib.getDescription(), false));
                    }
                }
                StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                this.myDetails = LegacyRepoUtils.createTypeDetails((IPkgDesc)this.myWrapped.getPkgDesc(), (int)layoutlibApi, (Collection)libs, null, (ProgressIndicator)progress, (FileOp)FileOpUtils.create());
            }
            TypeDetails typeDetails = this.myDetails;
            if (typeDetails == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getTypeDetails"));
            }
            return typeDetails;
        }

        @NotNull
        public Revision getVersion() {
            Revision revision = this.myWrapped.getRevision();
            if (revision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getVersion"));
            }
            return revision;
        }

        @NotNull
        public String getDisplayName() {
            String string = LegacyRepoUtils.getDisplayName((IPkgDesc)this.myWrapped.getPkgDesc());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getDisplayName"));
            }
            return string;
        }

        public License getLicense() {
            return this.myWrapped.getLicense();
        }

        @NotNull
        public Collection<Dependency> getAllDependencies() {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getAllDependencies"));
            }
            return immutableList;
        }

        @NotNull
        public String getPath() {
            String string = LegacyRepoUtils.getLegacyPath((IPkgDesc)this.myWrapped.getPkgDesc(), null);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getPath"));
            }
            return string;
        }

        @NotNull
        public CommonFactory createFactory() {
            CommonFactory commonFactory = (CommonFactory)AndroidSdkHandler.getCommonModule().createLatestFactory();
            if (commonFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "createFactory"));
            }
            return commonFactory;
        }

        public boolean obsolete() {
            return this.myWrapped.isObsolete();
        }

        public int compareTo(RepoPackage o) {
            int res = ComparisonChain.start().compare((Comparable)((Object)this.getPath()), (Comparable)((Object)o.getPath())).compare((Comparable)this.getVersion(), (Comparable)o.getVersion()).result();
            if (res != 0) {
                return res;
            }
            if (!(o instanceof RemotePackage)) {
                return this.getClass().getName().compareTo(o.getClass().getName());
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof RepoPackage && this.compareTo((RepoPackage)obj) == 0;
        }

        public int hashCode() {
            return this.getPath().hashCode() * 37 + this.getVersion().hashCode();
        }

        @NotNull
        public RepositorySource getSource() {
            RepositorySource repositorySource = this.mySource;
            if (repositorySource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getSource"));
            }
            return repositorySource;
        }

        public void setSource(@NotNull RepositorySource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "setSource"));
            }
            this.mySource = source;
        }

        public Archive getArchive() {
            for (com.android.tools.idea.sdk.remote.internal.archives.Archive archive : this.myWrapped.getArchives()) {
                if (!archive.isCompatible()) continue;
                CommonFactory f = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
                Archive arch = f.createArchiveType();
                Archive.CompleteType complete = f.createCompleteType();
                complete.setChecksum(archive.getChecksum());
                complete.setSize(archive.getSize());
                complete.setUrl(archive.getUrl());
                arch.setComplete(complete);
                ArchFilter filter = archive.getArchFilter();
                if (filter.getHostBits() != null) {
                    arch.setHostBits(Integer.valueOf(filter.getHostBits().ordinal()));
                }
                if (filter.getHostOS() != null) {
                    arch.setHostOs(filter.getHostOS().getXmlName());
                }
                if (filter.getJvmBits() != null) {
                    arch.setJvmBits(Integer.valueOf(filter.getJvmBits().ordinal()));
                }
                if (filter.getMinJvmVersion() != null) {
                    arch.setMinJvmVersion(f.createRevisionType(filter.getMinJvmVersion()));
                }
                return arch;
            }
            return null;
        }

        @NotNull
        public Channel getChannel() {
            if (this.getVersion().isPreview()) {
                Channel channel = Channel.create((int)1);
                if (channel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getChannel"));
                }
                return channel;
            }
            Channel channel = Channel.create((int)0);
            if (channel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdkv2/LegacyRemoteRepoLoader$LegacyRemotePackage", "getChannel"));
            }
            return channel;
        }

        public String toString() {
            return "Legacy package: " + this.myWrapped.toString();
        }
    }
}

