/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployTargetProvider<S extends DeployTargetState> {
    private static ExtensionPointName<DeployTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.android.run.deployTargetProvider");
    private static List<DeployTargetProvider> ourTargets;

    public static List<DeployTargetProvider> getProviders() {
        if (ourTargets == null) {
            ourTargets = Arrays.asList(EP_NAME.getExtensions());
        }
        return ourTargets;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract S createState();

    public boolean showInDevicePicker() {
        return false;
    }

    public boolean isApplicable(boolean isTestConfig) {
        return true;
    }

    public abstract DeployTargetConfigurable<S> createConfigurable(@NotNull Project var1, @NotNull Disposable var2, @NotNull DeployTargetConfigurableContext var3);

    public boolean requiresRuntimePrompt() {
        return false;
    }

    @Nullable
    public DeployTarget<S> showPrompt(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean androidTests, @NotNull Map<String, DeployTargetState> deployTargetStates, int runConfigId) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/DeployTargetProvider", "showPrompt"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/DeployTargetProvider", "showPrompt"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/DeployTargetProvider", "showPrompt"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/editor/DeployTargetProvider", "showPrompt"));
        }
        if (deployTargetStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetStates", "com/android/tools/idea/run/editor/DeployTargetProvider", "showPrompt"));
        }
        throw new IllegalStateException();
    }

    public abstract DeployTarget<S> getDeployTarget();

    public static class Renderer
    extends ColoredListCellRenderer<DeployTargetProvider> {
        protected void customizeCellRenderer(JList list, DeployTargetProvider value, int index, boolean selected, boolean hasFocus) {
            this.append(value.getDisplayName());
        }
    }
}

