/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceType;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.NestedConfiguration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.configurations.VaryingConfiguration;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.multi.PreviewBinPackingLayout;
import com.android.tools.idea.rendering.multi.PreviewRowLayout;
import com.android.tools.idea.rendering.multi.PreviewTileLayout;
import com.android.tools.idea.rendering.multi.RenderPreview;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderPreviewManager
implements Disposable {
    public static final boolean SUPPORTS_MANUAL_PREVIEWS = false;
    static final int VERTICAL_GAP = 18;
    static final int HORIZONTAL_GAP = 12;
    static final int TITLE_HEIGHT = 14;
    private static double ourScale = 1.0;
    private static final int RENDER_DELAY = 150;
    private static final int MAX_WIDTH = 200;
    private static final int MAX_HEIGHT = 200;
    private static boolean ZOOM_ENABLED = false;
    private static final int ZOOM_ICON_WIDTH = 16;
    private static final int ZOOM_ICON_HEIGHT = 16;
    @Nullable
    private List<RenderPreview> myPreviews;
    @NotNull
    private final RenderContext myRenderContext;
    @NotNull
    private RenderPreviewMode myMode;
    @Nullable
    private RenderPreview myActivePreview;
    @Nullable
    private VirtualFile myCurrentFile;
    @Nullable
    private SwapAnimation myAnimator;
    private int myLayoutHeight;
    private int myPrevCanvasWidth;
    private int myPrevCanvasHeight;
    private int myPrevImageWidth;
    private int myPrevImageHeight;
    private int myPendingRenderCount;
    private int myRevision;
    private static int ourRevision;
    private boolean myNeedLayout;
    private boolean myNeedRender;
    private static final boolean RENDER_ASYNC = true;
    @NotNull
    private final Alarm myAlarm;
    private MouseAdapter myPreviewMouseListener;
    private Dimension myFixedRenderSize;
    private RenderPreview myStashedPreview;
    private static boolean ourClassicLayout;
    private boolean myClassicLayout;

    public RenderPreviewManager(@NotNull RenderContext canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canvas", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "<init>"));
        }
        this.myMode = RenderPreviewMode.NONE;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myClassicLayout = false;
        this.myRenderContext = canvas;
    }

    public void unregisterMouseListener(@NotNull Component source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "unregisterMouseListener"));
        }
        source.removeMouseListener(this.myPreviewMouseListener);
        source.removeMouseMotionListener(this.myPreviewMouseListener);
    }

    public void registerMouseListener(@NotNull Component source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "registerMouseListener"));
        }
        if (this.myPreviewMouseListener == null) {
            this.myPreviewMouseListener = new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    super.mouseMoved(mouseEvent);
                    RenderPreviewManager.this.moved(mouseEvent);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    super.mouseClicked(mouseEvent);
                    RenderPreviewManager.this.click(mouseEvent);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    super.mouseEntered(mouseEvent);
                    RenderPreviewManager.this.enter(mouseEvent);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    super.mouseExited(mouseEvent);
                    RenderPreviewManager.this.exit(mouseEvent);
                }
            };
        }
        source.addMouseListener(this.myPreviewMouseListener);
        source.addMouseMotionListener(this.myPreviewMouseListener);
    }

    public static void bumpRevision() {
        ++ourRevision;
    }

    @NotNull
    public RenderContext getRenderContext() {
        RenderContext renderContext = this.myRenderContext;
        if (renderContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "getRenderContext"));
        }
        return renderContext;
    }

    public void zoomIn() {
        if (ZOOM_ENABLED) {
            RenderPreviewManager.setScale(ourScale * 1.1111111111111112);
            this.updatedZoom();
        }
    }

    public void zoomOut() {
        if (ZOOM_ENABLED) {
            RenderPreviewManager.setScale(ourScale * 0.9);
            this.updatedZoom();
        }
    }

    public void zoomReset() {
        if (ZOOM_ENABLED) {
            RenderPreviewManager.setScale(1.0);
            this.updatedZoom();
            this.myNeedLayout = true;
            this.redraw();
        }
    }

    private static void setScale(double newScale) {
        assert (ZOOM_ENABLED);
        ourScale = newScale;
        if (Math.abs(ourScale - 1.0) < 1.0E-4) {
            ourScale = 1.0;
        }
    }

    private void updatedZoom() {
        if (ZOOM_ENABLED) {
            if (this.hasPreviews()) {
                assert (this.myPreviews != null);
                for (RenderPreview preview : this.myPreviews) {
                    preview.disposeThumbnail();
                }
                RenderPreview preview = this.getStashedPreview();
                if (preview != null) {
                    preview.disposeThumbnail();
                }
            }
            this.myNeedRender = true;
            this.myNeedLayout = true;
            this.redraw();
        }
    }

    static int getMaxWidth() {
        return (int)(ourScale * 200.0);
    }

    static int getMaxHeight() {
        return (int)(ourScale * 200.0);
    }

    static double getScale() {
        return ourScale;
    }

    public boolean hasManualPreviews() {
        assert (this.myMode == RenderPreviewMode.CUSTOM);
        return false;
    }

    public void deleteManualPreviews() {
        this.disposePreviews();
        this.selectMode(RenderPreviewMode.NONE);
        this.myRenderContext.zoomFit(true, false);
    }

    public void disposePreviews() {
        if (this.myPreviews != null) {
            List<RenderPreview> old = this.myPreviews;
            this.myPreviews = null;
            for (RenderPreview preview : old) {
                preview.dispose();
            }
        }
    }

    public void deletePreview(@NotNull RenderPreview preview) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "deletePreview"));
        }
        assert (this.myPreviews != null);
        RenderPreviewMode.deleteId(preview.getId());
        this.myPreviews.remove(preview);
        preview.dispose();
        this.layout(true);
        this.redraw();
    }

    public int computePreviewWidth() {
        if (this.hasPreviews()) {
            assert (this.myPreviews != null);
            int minPreviewWidth = this.myPreviews.get(0).getLayoutWidth();
            for (RenderPreview preview : this.myPreviews) {
                minPreviewWidth = Math.min(minPreviewWidth, preview.getLayoutWidth());
            }
            if (minPreviewWidth > 0) {
                minPreviewWidth += 12;
                minPreviewWidth += 10;
            }
            return minPreviewWidth;
        }
        return 0;
    }

    void layout(boolean refresh) {
        this.myNeedLayout = false;
        if (this.myPreviews == null || this.myPreviews.isEmpty()) {
            return;
        }
        Rectangle clientArea = this.myRenderContext.getClientArea();
        Dimension scaledImageSize = this.myRenderContext.getScaledImageSize();
        int scaledImageWidth = scaledImageSize.width;
        int scaledImageHeight = scaledImageSize.height;
        if (!refresh && scaledImageWidth == this.myPrevImageWidth && scaledImageHeight == this.myPrevImageHeight && clientArea.width == this.myPrevCanvasWidth && clientArea.height == this.myPrevCanvasHeight) {
            return;
        }
        this.myPrevImageWidth = scaledImageWidth;
        this.myPrevImageHeight = scaledImageHeight;
        this.myPrevCanvasWidth = clientArea.width;
        this.myPrevCanvasHeight = clientArea.height;
        this.beginRenderScheduling();
        this.myLayoutHeight = 0;
        RenderContext.UsageType usageType = this.myRenderContext.getType();
        if (!(ourClassicLayout || usageType != RenderContext.UsageType.XML_PREVIEW && usageType != RenderContext.UsageType.LAYOUT_EDITOR)) {
            this.tiledLayout();
        } else if (this.previewsHaveIdenticalSize() || this.fixedOrder()) {
            this.rowLayout();
        } else if (this.previewsFit()) {
            this.layoutFullFit();
        } else {
            this.rowLayout();
        }
    }

    private void tiledLayout() {
        assert (this.myPreviews != null);
        PreviewTileLayout tileLayout = new PreviewTileLayout(this.myPreviews, this.myRenderContext, this.fixedOrder());
        tileLayout.performLayout();
        this.myFixedRenderSize = tileLayout.getFixedRenderSize();
        this.myLayoutHeight = tileLayout.getLayoutHeight();
    }

    @Nullable
    public Dimension getFixedRenderSize() {
        return this.myFixedRenderSize;
    }

    void redraw() {
        this.myRenderContext.getComponent().repaint();
    }

    private void rowLayout() {
        assert (this.myPreviews != null);
        PreviewRowLayout tileLayout = new PreviewRowLayout(this.myPreviews, this.myRenderContext, this.fixedOrder());
        tileLayout.performLayout();
        this.myLayoutHeight = tileLayout.getLayoutHeight();
    }

    private boolean fixedOrder() {
        return this.myMode == RenderPreviewMode.SCREENS;
    }

    private boolean previewsHaveIdenticalSize() {
        if (!this.hasPreviews()) {
            return true;
        }
        assert (this.myPreviews != null);
        Iterator<RenderPreview> iterator = this.myPreviews.iterator();
        RenderPreview first = iterator.next();
        int width = first.getLayoutWidth();
        int height = first.getLayoutHeight();
        while (iterator.hasNext()) {
            RenderPreview preview = iterator.next();
            if (width == preview.getLayoutWidth() && height == preview.getLayoutHeight()) continue;
            return false;
        }
        return true;
    }

    private boolean previewsFit() {
        assert (this.myPreviews != null);
        Rectangle clientArea = this.myRenderContext.getClientArea();
        Dimension scaledImageSize = this.myRenderContext.getScaledImageSize();
        int scaledImageWidth = scaledImageSize.width;
        int scaledImageHeight = scaledImageSize.height;
        int availableWidth = clientArea.x + clientArea.width - RenderPreviewManager.getX();
        int availableHeight = clientArea.y + clientArea.height - RenderPreviewManager.getY();
        int bottomBorder = scaledImageHeight + 20;
        int rightHandSide = scaledImageWidth + 12;
        long availableArea = rightHandSide * bottomBorder + availableWidth * Math.max(0, availableHeight - bottomBorder);
        long requiredArea = 0L;
        for (RenderPreview preview : this.myPreviews) {
            requiredArea += (long)preview.getArea();
        }
        return (double)requiredArea * ourScale < (double)availableArea;
    }

    private void layoutFullFit() {
        assert (this.myPreviews != null);
        PreviewBinPackingLayout tileLayout = new PreviewBinPackingLayout(this.myPreviews, this.myRenderContext, RenderPreviewManager.getX(), RenderPreviewManager.getY());
        if (tileLayout.performLayout()) {
            this.myLayoutHeight = tileLayout.getLayoutHeight();
        } else {
            this.rowLayout();
        }
    }

    public void paint(Graphics2D gc) {
        if (this.hasPreviews()) {
            assert (this.myPreviews != null);
            this.layout(this.myNeedLayout);
            if (this.myNeedRender) {
                this.renderPreviews();
            }
            int rootX = RenderPreviewManager.getX();
            int rootY = RenderPreviewManager.getY();
            Configuration canvasConfiguration = this.myRenderContext.getConfiguration();
            if (canvasConfiguration == null) {
                return;
            }
            Rectangle clientArea = this.myRenderContext.getClientArea();
            for (RenderPreview preview : this.myPreviews) {
                if (!preview.isVisible()) continue;
                int x = rootX + preview.getX();
                int y = rootY + preview.getY();
                gc.setClip(0, 0, clientArea.width, clientArea.height);
                preview.paint(gc, x, y);
            }
        }
        if (this.myAnimator != null) {
            this.myAnimator.paint(gc);
        }
    }

    private void addPreview(@NotNull RenderPreview preview) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "addPreview"));
        }
        String id = preview.getId();
        if (id == null) {
            id = preview.getDisplayName();
            preview.setId(id);
        }
        if (RenderPreviewMode.isDeletedId(id)) {
            return;
        }
        if (this.myPreviews == null) {
            this.myPreviews = Lists.newArrayList();
        }
        this.myPreviews.add(preview);
    }

    public void addAsThumbnail() {
    }

    private String getUniqueName() {
        return "Config1";
    }

    public void addDefaultPreviews() {
        Configuration parent = this.myRenderContext.getConfiguration();
        if (parent instanceof NestedConfiguration) {
            parent = ((NestedConfiguration)parent).getParent();
        }
        if (parent == null) {
            return;
        }
        this.createLocaleVariation(parent);
        this.createScreenVariations(parent);
        this.createStateVariation(parent);
        this.createRenderTargetVariation(parent);
        RenderPreview preview = RenderPreview.create(this, parent, false);
        this.setStashedPreview(preview);
        this.sortPreviewsByOrientation();
    }

    private void createRenderTargetVariation(@NotNull Configuration parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "createRenderTargetVariation"));
        }
    }

    private void createStateVariation(@NotNull Configuration parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "createStateVariation"));
        }
        State currentState = parent.getDeviceState();
        State nextState = parent.getNextDeviceState(currentState);
        if (nextState != currentState) {
            VaryingConfiguration configuration = VaryingConfiguration.create(parent);
            configuration.setAlternateDeviceState(true);
            this.addPreview(RenderPreview.create(this, configuration, false));
        }
    }

    private void createLocaleVariation(@NotNull Configuration parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "createLocaleVariation"));
        }
        LocaleQualifier currentLanguage = parent.getLocale().qualifier;
        for (Locale locale : parent.getConfigurationManager().getLocales()) {
            LocaleQualifier qualifier = locale.qualifier;
            if (qualifier.getLanguage().equals(currentLanguage.getLanguage())) continue;
            VaryingConfiguration configuration = VaryingConfiguration.create(parent);
            configuration.setAlternateLocale(true);
            this.addPreview(RenderPreview.create(this, configuration, false));
            break;
        }
    }

    private void createScreenVariations(@NotNull Configuration parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "createScreenVariations"));
        }
        VaryingConfiguration configuration = VaryingConfiguration.create(parent);
        configuration.setVariation(0);
        configuration.setAlternateDevice(true);
        this.addPreview(RenderPreview.create(this, configuration, false));
        configuration = VaryingConfiguration.create(parent);
        configuration.setVariation(1);
        configuration.setAlternateDevice(true);
        this.addPreview(RenderPreview.create(this, configuration, false));
    }

    @NotNull
    public RenderPreviewMode getMode() {
        RenderPreviewMode renderPreviewMode = this.myMode;
        if (renderPreviewMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "getMode"));
        }
        return renderPreviewMode;
    }

    public boolean recomputePreviews(boolean force) {
        RenderPreviewMode newMode = RenderPreviewMode.getCurrent();
        this.myCurrentFile = this.myRenderContext.getVirtualFile();
        if (!(newMode != this.myMode || force || this.myRevision != ourRevision && this.myMode != RenderPreviewMode.NONE && this.myMode != RenderPreviewMode.CUSTOM)) {
            return false;
        }
        this.myMode = newMode;
        this.myRevision = ourRevision;
        if (ZOOM_ENABLED) {
            RenderPreviewManager.setScale(1.0);
        }
        this.disposePreviews();
        this.myRenderContext.setDeviceFramesEnabled(this.myMode == RenderPreviewMode.NONE || this.myMode == RenderPreviewMode.SCREENS);
        switch (this.myMode) {
            case DEFAULT: {
                this.addDefaultPreviews();
                break;
            }
            case INCLUDES: {
                this.addIncludedInPreviews();
                break;
            }
            case LOCALES: {
                this.addLocalePreviews();
                break;
            }
            case RTL: {
                this.addRtlPreviews();
                break;
            }
            case API_LEVELS: {
                this.addApiLevelPreviews();
                break;
            }
            case SCREENS: {
                this.addScreenSizePreviews();
                break;
            }
            case VARIATIONS: {
                this.addVariationPreviews();
                break;
            }
            case CUSTOM: {
                this.addManualPreviews();
                break;
            }
            case NONE: {
                this.myRenderContext.zoomFit(false, false);
                this.myFixedRenderSize = null;
                this.myRenderContext.setMaxSize(0, 0);
                break;
            }
            default: {
                assert (false) : this.myMode;
                break;
            }
        }
        this.myNeedRender = true;
        this.myNeedLayout = true;
        this.myRenderContext.updateLayout();
        this.layout(true);
        this.redraw();
        return true;
    }

    public void selectMode(@NotNull RenderPreviewMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "selectMode"));
        }
        if (mode != this.myMode) {
            RenderPreviewMode.setCurrent(mode);
            this.recomputePreviews(false);
        }
    }

    public void addLocalePreviews() {
        Configuration parent = this.myRenderContext.getConfiguration();
        if (parent == null) {
            return;
        }
        List<Locale> locales = parent.getConfigurationManager().getLocales();
        for (Locale locale : locales) {
            if (!locale.hasLanguage() && !locale.hasRegion()) continue;
            NestedConfiguration configuration = NestedConfiguration.create(parent);
            configuration.setOverrideLocale(true);
            configuration.setLocale(locale);
            String displayName = RenderPreviewManager.getLocaleLabel(locale);
            configuration.setDisplayName(displayName);
            this.addPreview(RenderPreview.create(this, configuration, false));
        }
        Locale locale = parent.getLocale();
        String label = RenderPreviewManager.getLocaleLabel(locale);
        parent.setDisplayName(label);
        RenderPreview preview = RenderPreview.create(this, parent, false);
        this.setStashedPreview(preview);
    }

    private static String getLocaleLabel(Locale locale) {
        if (!locale.hasLanguage()) {
            return "Default";
        }
        String languageCode = locale.qualifier.getLanguage();
        String languageName = LocaleManager.getLanguageName((String)languageCode);
        if (!locale.hasRegion()) {
            if (languageName != null) {
                return String.format("%1$s (%2$s)", languageName, languageCode);
            }
            return languageCode;
        }
        String regionCode = locale.qualifier.getRegion();
        assert (regionCode != null);
        if (languageName != null) {
            return String.format("%1$s (%2$s/%3$s)", languageName, languageCode, regionCode);
        }
        return String.format("%1$s/%2$s", languageCode, regionCode);
    }

    public void addApiLevelPreviews() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return;
        }
        IAndroidTarget currentTarget = configuration.getTarget();
        if (currentTarget == null) {
            return;
        }
        int currentApi = currentTarget.getVersion().getFeatureLevel();
        IAndroidTarget[] targets = configuration.getConfigurationManager().getTargets();
        IAndroidTarget highestTarget = null;
        for (int i = targets.length - 1; i >= 0; --i) {
            IAndroidTarget target = targets[i];
            if (!ConfigurationManager.isLayoutLibTarget(target)) continue;
            highestTarget = target;
            break;
        }
        if (highestTarget == null) {
            return;
        }
        IntArrayList list = new IntArrayList();
        Module module = this.myRenderContext.getModule();
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        int highestApiLevel = highestTarget.getVersion().getFeatureLevel();
        int minSdkVersion = moduleInfo.getMinSdkVersion().getFeatureLevel();
        int min = Math.max(8, minSdkVersion);
        int max = Math.min(24, highestApiLevel);
        Device device = configuration.getDevice();
        if (HardwareConfigHelper.isWear((Device)device)) {
            min = 20;
        }
        AppResourceRepository resources = AppResourceRepository.getAppResources(facet, true);
        XmlFile xmlFile = this.myRenderContext.getXmlFile();
        if (xmlFile == null) {
            return;
        }
        String resourceName = ResourceHelper.getResourceName((PsiFile)xmlFile);
        List items = resources.getResourceItem(ResourceType.LAYOUT, resourceName);
        RenderPreviewManager.addIfWithinInclusive(min, max, 8, list, items);
        RenderPreviewManager.addIfWithinInclusive(min, max, 9, list, items);
        RenderPreviewManager.addIfWithinInclusive(min, max, 15, list, items);
        if (min > 15 && min < 21) {
            RenderPreviewManager.addIfWithinInclusive(min, max, min, list, items);
        }
        RenderPreviewManager.addIfWithinInclusive(min, max, 21, list, items);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int api = list.get(i);
            if (api == currentApi) continue;
            NestedConfiguration apiConfig = NestedConfiguration.create(configuration);
            apiConfig.setOverrideTarget(true);
            IAndroidTarget realTarget = null;
            for (int j = targets.length - 1; j >= 0; --j) {
                IAndroidTarget target = targets[j];
                if (target.getVersion().getFeatureLevel() != api || !ConfigurationManager.isLayoutLibTarget(target)) continue;
                realTarget = target;
                break;
            }
            Object target = realTarget == currentTarget ? currentTarget : new CompatibilityRenderTarget(api > currentApi ? highestTarget : currentTarget, api, realTarget);
            apiConfig.setTarget((IAndroidTarget)target);
            String label = SdkVersionInfo.getCodeName((int)api);
            if (label == null) {
                label = Integer.toString(api);
            }
            apiConfig.setDisplayName(label);
            apiConfig.setTheme(null);
            RenderPreview preview = RenderPreview.create(this, apiConfig, false);
            this.addPreview(preview);
        }
        RenderPreview preview = RenderPreview.create(this, configuration, false);
        String codeName = SdkVersionInfo.getCodeName((int)currentTarget.getVersion().getFeatureLevel());
        if (codeName == null) {
            codeName = currentTarget.getVersion().getApiString();
        }
        preview.setDisplayName(codeName);
        this.setStashedPreview(preview);
    }

    private static void addIfWithinInclusive(int min, int max, int value, IntArrayList list, @Nullable List<ResourceItem> items) {
        if (value >= min && value <= max) {
            boolean foundCompatible = true;
            if (items != null) {
                foundCompatible = false;
                for (ResourceItem item : items) {
                    FolderConfiguration configuration = item.getConfiguration();
                    VersionQualifier qualifier = configuration.getVersionQualifier();
                    if (qualifier != null && qualifier.getVersion() > value) continue;
                    foundCompatible = true;
                    break;
                }
            }
            if (foundCompatible) {
                list.add(value);
            }
        }
    }

    public void addRtlPreviews() {
        Configuration parent = this.myRenderContext.getConfiguration();
        if (parent == null) {
            return;
        }
        LayoutDirectionQualifier layoutDirectionQualifier = parent.getFullConfig().getLayoutDirectionQualifier();
        boolean isRtl = layoutDirectionQualifier != null && layoutDirectionQualifier.getValue() == LayoutDirection.RTL;
        NestedConfiguration configuration = NestedConfiguration.create(parent);
        configuration.getFullConfig().setLayoutDirectionQualifier(new LayoutDirectionQualifier(isRtl ? LayoutDirection.LTR : LayoutDirection.RTL));
        String displayName = isRtl ? "LTR" : "RTL";
        configuration.setDisplayName(displayName);
        this.addPreview(RenderPreview.create(this, configuration, false));
        String label = isRtl ? "RTL" : "LTR";
        parent.setDisplayName(label);
        RenderPreview preview = RenderPreview.create(this, parent, false);
        this.setStashedPreview(preview);
    }

    public void addScreenSizePreviews() {
        boolean useDefaultState;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return;
        }
        List<Device> devices = configuration.getConfigurationManager().getDevices();
        boolean canScaleNinePatch = configuration.supports(10);
        Device currentDevice = configuration.getDevice();
        boolean bl = useDefaultState = currentDevice == null || configuration.getDeviceState() == currentDevice.getDefaultState();
        if (configuration.getEditedConfig().getScreenOrientationQualifier() != null) {
            useDefaultState = false;
        }
        boolean isWear = HardwareConfigHelper.isWear((Device)currentDevice);
        EnumSet<ScreenSize> seenSizes = EnumSet.noneOf(ScreenSize.class);
        State currentState = configuration.getDeviceState();
        String currentStateName = currentState != null ? currentState.getName() : "";
        DeviceArtPainter framePainter = DeviceArtPainter.getInstance();
        for (Device device : devices) {
            String label;
            DensityQualifier density;
            boolean interesting = false;
            State state = device.getState(currentStateName);
            if (state == null) {
                state = (State)device.getAllStates().get(0);
            }
            if (isWear) {
                interesting = HardwareConfigHelper.isWear((Device)device);
            } else if (HardwareConfigHelper.isNexus((Device)device) && !HardwareConfigHelper.isGeneric((Device)device)) {
                interesting = true;
                if ("Nexus 7".equals(device.getId())) {
                    interesting = false;
                }
            }
            FolderConfiguration c = DeviceConfigHelper.getFolderConfig((State)state);
            if (c != null && (density = c.getDensityQualifier()) != null) {
                Density d = density.getValue();
                if (d == Density.LOW) {
                    interesting = false;
                }
                if (!canScaleNinePatch && d != null && !d.isRecommended()) {
                    interesting = false;
                }
            }
            if (!interesting || !framePainter.hasDeviceFrame(device) || device == currentDevice) continue;
            NestedConfiguration screenConfig = NestedConfiguration.create(configuration);
            screenConfig.setOverrideDevice(true);
            screenConfig.setDevice(device, false);
            if (useDefaultState) {
                screenConfig.setOverrideDeviceState(true);
                screenConfig.setDeviceState(device.getDefaultState());
            }
            if (HardwareConfigHelper.isNexus((Device)device)) {
                String name = device.getDisplayName();
                Screen screen = device.getDefaultHardware().getScreen();
                float length = (float)screen.getDiagonalLength();
                length = (float)Math.round(10.0f * length) / 10.0f;
                label = String.format(java.util.Locale.US, "%1$s (%2$s\")", name, Float.toString(length));
            } else {
                label = DeviceMenuAction.getDeviceLabel(device, true);
            }
            screenConfig.setDisplayName(label);
            RenderPreview preview = RenderPreview.create(this, screenConfig, true);
            this.addPreview(preview);
        }
        if (this.myPreviews != null && this.myPreviews.size() == 1) {
            this.myPreviews.get(0).setDisplayName("");
        }
        RenderPreview preview = RenderPreview.create(this, configuration, true);
        this.setStashedPreview(preview);
        this.sortPreviewsByScreenSize();
    }

    public void addIncludedInPreviews() {
        throw new RuntimeException("Not yet implemented");
    }

    public void addVariationPreviews() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return;
        }
        VirtualFile file = configuration.getFile();
        List<VirtualFile> variations = ResourceHelper.getResourceVariations(file, false);
        Collections.sort(variations, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                return file1.getParent().getName().compareTo(file2.getParent().getName());
            }
        });
        for (VirtualFile variation : variations) {
            String title = variation.getParent().getName();
            Configuration variationConfiguration = Configuration.create(configuration, variation);
            variationConfiguration.setTheme(configuration.getTheme());
            variationConfiguration.setActivity(configuration.getActivity());
            RenderPreview preview = RenderPreview.create(this, variationConfiguration, false);
            preview.setDisplayName(title);
            preview.setAlternateInput(variation);
            this.addPreview(preview);
        }
        this.sortPreviewsByOrientation();
    }

    public void addManualPreviews() {
    }

    public void configurationChanged(int flags) {
        if (this.hasPreviews()) {
            assert (this.myPreviews != null);
            this.beginRenderScheduling();
            for (RenderPreview preview : this.myPreviews) {
                if (!(preview.getScale() > 1.2)) continue;
                preview.configurationChanged(flags);
            }
            for (RenderPreview preview : this.myPreviews) {
                if (!(preview.getScale() <= 1.2)) continue;
                preview.configurationChanged(flags);
            }
            RenderPreview preview = this.getStashedPreview();
            if (preview != null) {
                preview.configurationChanged(flags);
                preview.dispose();
            }
            this.myNeedLayout = true;
            this.myNeedRender = true;
            this.redraw();
        }
    }

    public void renderPreviews() {
        if (!Comparing.equal((Object)this.myRenderContext.getVirtualFile(), (Object)this.myCurrentFile)) {
            this.recomputePreviews(true);
            return;
        }
        if (this.hasPreviews()) {
            assert (this.myPreviews != null);
            this.beginRenderScheduling();
            this.myAlarm.cancelAllRequests();
            ArrayList<RenderPreview> visualOrder = new ArrayList<RenderPreview>(this.myPreviews);
            Collections.sort(visualOrder, RenderPreview.VISUAL_ORDER);
            for (RenderPreview preview : visualOrder) {
                if (!(preview.getScale() > 1.2) || !preview.isVisible()) continue;
                this.scheduleRender(preview);
            }
            for (RenderPreview preview : visualOrder) {
                if (!(preview.getScale() <= 1.2) || !preview.isVisible()) continue;
                this.scheduleRender(preview);
            }
        }
        this.myNeedRender = false;
        if (this.myClassicLayout != ourClassicLayout) {
            this.setClassicLayout(ourClassicLayout);
        }
    }

    public void beginRenderScheduling() {
        this.myPendingRenderCount = 0;
    }

    public void scheduleRender(@NotNull RenderPreview preview) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "scheduleRender"));
        }
        ++this.myPendingRenderCount;
        this.scheduleRender(preview, this.myPendingRenderCount * 150);
    }

    public void scheduleRender(final @NotNull RenderPreview preview, long delay) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "scheduleRender"));
        }
        Runnable pending = preview.getPendingRendering();
        if (pending != null) {
            this.myAlarm.cancelRequest(pending);
        }
        Runnable request = new Runnable(){

            @Override
            public void run() {
                preview.setPendingRendering(null);
                preview.updateSize();
                preview.renderSync();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RenderPreviewManager.this.redraw();
                    }
                });
            }
        };
        preview.setPendingRendering(request);
        this.myAlarm.addRequest(request, delay);
    }

    public void switchTo(@NotNull RenderPreview preview) {
        RenderPreview newPreview;
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "switchTo"));
        }
        assert (this.myPreviews != null);
        Configuration originalConfiguration = this.myRenderContext.getConfiguration();
        if (originalConfiguration == null) {
            return;
        }
        VirtualFile input = preview.getAlternateInput();
        if (input != null) {
            Configuration configuration = preview.getConfiguration();
            if (configuration instanceof NestedConfiguration) {
                NestedConfiguration nestedConfig = (NestedConfiguration)configuration;
                boolean setSize = nestedConfig.isOverridingDevice();
                if (configuration instanceof VaryingConfiguration) {
                    VaryingConfiguration c = (VaryingConfiguration)configuration;
                    setSize |= c.isAlternatingDevice();
                }
                if (setSize) {
                    ConfigurationManager configurationManager = originalConfiguration.getConfigurationManager();
                    VirtualFile editedFile = originalConfiguration.getFile();
                    assert (editedFile != null);
                    configurationManager.syncToVariations(6, editedFile, configuration, false, false);
                }
            }
            Project project = configuration.getModule().getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, input, -1);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            return;
        }
        Configuration previewConfiguration = preview.getConfiguration();
        Configuration newConfiguration = previewConfiguration;
        if (newConfiguration instanceof NestedConfiguration) {
            newConfiguration = previewConfiguration.clone();
            for (RenderPreview p : this.myPreviews) {
                Configuration configuration = p.getConfiguration();
                if (!(configuration instanceof NestedConfiguration)) continue;
                NestedConfiguration nested = (NestedConfiguration)configuration;
                nested.setParent(newConfiguration);
            }
        }
        if ((newPreview = this.getStashedPreview()) == null) {
            newPreview = RenderPreview.create(this, originalConfiguration, false);
        }
        if (previewConfiguration instanceof VaryingConfiguration) {
            VaryingConfiguration varying = VaryingConfiguration.create((VaryingConfiguration)previewConfiguration, newConfiguration);
            varying.updateDisplayName();
            originalConfiguration = varying;
            newPreview.setConfiguration(originalConfiguration);
        } else if (previewConfiguration instanceof NestedConfiguration) {
            NestedConfiguration nested = NestedConfiguration.create((NestedConfiguration)previewConfiguration, originalConfiguration, newConfiguration);
            nested.setDisplayName(nested.computeDisplayName());
            originalConfiguration = nested;
            newPreview.setConfiguration(originalConfiguration);
        }
        int n = this.myPreviews.size();
        for (int i = 0; i < n; ++i) {
            if (preview != this.myPreviews.get(i)) continue;
            this.myPreviews.set(i, newPreview);
            break;
        }
        this.setStashedPreview(preview);
        preview.setVisible(false);
        this.myRenderContext.setConfiguration(newConfiguration);
        this.myNeedLayout = true;
        this.redraw();
        this.animateTransition(preview, newPreview);
    }

    private void animateTransition(RenderPreview preview, RenderPreview newPreview) {
        this.myAnimator = new SwapAnimation(preview, newPreview);
        this.myAnimator.resume();
    }

    @Nullable
    RenderPreview getPreview(MouseEvent mouseEvent) {
        if (this.hasPreviews()) {
            assert (this.myPreviews != null);
            int rootX = RenderPreviewManager.getX();
            int mouseX = mouseEvent.getX();
            if (mouseX < rootX) {
                return null;
            }
            int rootY = RenderPreviewManager.getY();
            int mouseY = mouseEvent.getY();
            for (RenderPreview preview : this.myPreviews) {
                int x = rootX + preview.getX();
                int y = rootY + preview.getY();
                if (mouseX < x || mouseX > x + preview.getWidth() || mouseY < y || mouseY > y + preview.getHeight()) continue;
                return preview;
            }
        }
        return null;
    }

    private static int getX() {
        return 0;
    }

    private static int getY() {
        return 0;
    }

    private int getZoomX() {
        if (ZOOM_ENABLED) {
            Rectangle clientArea = this.myRenderContext.getClientArea();
            int x = clientArea.x + clientArea.width - 16;
            return x - 6;
        }
        return 0;
    }

    private int getZoomY() {
        if (ZOOM_ENABLED) {
            Rectangle clientArea = this.myRenderContext.getClientArea();
            return clientArea.y + 5;
        }
        return 0;
    }

    public int getHeight() {
        return this.myLayoutHeight;
    }

    public void moved(MouseEvent mouseEvent) {
        RenderPreview hovered = this.getPreview(mouseEvent);
        if (hovered != this.myActivePreview) {
            if (this.myActivePreview != null) {
                this.myActivePreview.setActive(false);
            }
            this.myActivePreview = hovered;
            if (this.myActivePreview != null) {
                this.myActivePreview.setActive(true);
            }
            this.redraw();
        }
    }

    public void enter(MouseEvent mouseEvent) {
        this.moved(mouseEvent);
    }

    public void exit(MouseEvent mouseEvent) {
        if (this.myActivePreview != null) {
            this.myActivePreview.setActive(false);
        }
        this.myActivePreview = null;
        this.redraw();
    }

    public boolean click(MouseEvent mouseEvent) {
        boolean handled;
        int y;
        int x;
        int mouseX = mouseEvent.getX();
        int mouseY = mouseEvent.getY();
        if (ZOOM_ENABLED && (x = this.getZoomX()) > 0 && mouseX >= x && mouseX <= x + 16 && mouseY >= (y = this.getZoomY()) && mouseY <= y + 64) {
            if (mouseY < y + 16) {
                this.zoomIn();
                mouseEvent.consume();
            } else if (mouseY < y + 32) {
                this.zoomOut();
                mouseEvent.consume();
            } else if (mouseY < y + 48) {
                this.zoomReset();
                mouseEvent.consume();
            } else {
                this.selectMode(RenderPreviewMode.NONE);
                mouseEvent.consume();
            }
            return true;
        }
        RenderPreview preview = this.getPreview(mouseEvent);
        if (preview != null && (handled = preview.click(mouseX - RenderPreviewManager.getX() - preview.getX(), mouseY - RenderPreviewManager.getY() - preview.getY()))) {
            this.moved(mouseEvent);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public boolean hasPreviews() {
        return this.myPreviews != null && !this.myPreviews.isEmpty();
    }

    private void sortPreviewsByScreenSize() {
        if (this.myPreviews != null) {
            Collections.sort(this.myPreviews, new Comparator<RenderPreview>(){

                @Override
                public int compare(RenderPreview preview1, RenderPreview preview2) {
                    State state2;
                    State state1;
                    Configuration config1 = preview1.getConfiguration();
                    Configuration config2 = preview2.getConfiguration();
                    Device device1 = config1.getDevice();
                    Device device2 = config2.getDevice();
                    if (device1 != null && device2 != null) {
                        Screen screen1 = device1.getDefaultHardware().getScreen();
                        Screen screen2 = device2.getDefaultHardware().getScreen();
                        if (screen1 != null && screen2 != null) {
                            double delta = screen1.getDiagonalLength() - screen2.getDiagonalLength();
                            if (delta != 0.0) {
                                return (int)Math.signum(delta);
                            }
                            if (screen1.getPixelDensity() != screen2.getPixelDensity()) {
                                return screen1.getPixelDensity().compareTo((Enum)screen2.getPixelDensity());
                            }
                        }
                    }
                    if ((state1 = config1.getDeviceState()) != (state2 = config2.getDeviceState()) && state1 != null && state2 != null) {
                        return state1.getName().compareTo(state2.getName());
                    }
                    return preview1.getDisplayName().compareTo(preview2.getDisplayName());
                }
            });
        }
    }

    private void sortPreviewsByOrientation() {
        if (this.myPreviews != null) {
            Collections.sort(this.myPreviews, new Comparator<RenderPreview>(){

                @Override
                public int compare(RenderPreview preview1, RenderPreview preview2) {
                    State state2;
                    Configuration config1 = preview1.getConfiguration();
                    Configuration config2 = preview2.getConfiguration();
                    State state1 = config1.getDeviceState();
                    if (state1 != (state2 = config2.getDeviceState()) && state1 != null && state2 != null) {
                        return state1.getName().compareTo(state2.getName());
                    }
                    return preview1.getDisplayName().compareTo(preview2.getDisplayName());
                }
            });
        }
    }

    public void updateMasterConfiguration(@NotNull Configuration oldConfiguration, @NotNull Configuration newConfiguration) {
        if (oldConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldConfiguration", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "updateMasterConfiguration"));
        }
        if (newConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfiguration", "com/android/tools/idea/rendering/multi/RenderPreviewManager", "updateMasterConfiguration"));
        }
        if (this.hasPreviews()) {
            assert (this.myPreviews != null);
            for (RenderPreview preview : this.myPreviews) {
                NestedConfiguration nestedConfig;
                Configuration configuration = preview.getConfiguration();
                if (!(configuration instanceof NestedConfiguration) || (nestedConfig = (NestedConfiguration)configuration).getParent() != oldConfiguration) continue;
                nestedConfig.setParent(newConfiguration);
            }
        }
    }

    private void setStashedPreview(RenderPreview preview) {
        this.myStashedPreview = preview;
    }

    RenderPreview getStashedPreview() {
        return this.myStashedPreview;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        this.disposePreviews();
        this.myAlarm.cancelAllRequests();
        this.myAlarm.dispose();
        if (this.myAnimator != null) {
            this.myAnimator.dispose();
            this.myAnimator = null;
        }
    }

    public static void toggleLayoutMode(RenderContext context) {
        ourClassicLayout = !ourClassicLayout;
        RenderPreviewManager previewManager = context.getPreviewManager(false);
        if (previewManager != null && previewManager.myClassicLayout != ourClassicLayout) {
            previewManager.setClassicLayout(ourClassicLayout);
        }
    }

    private void setClassicLayout(boolean classicLayout) {
        this.myClassicLayout = classicLayout;
        if (classicLayout) {
            this.myFixedRenderSize = null;
            this.myRenderContext.setMaxSize(0, 0);
            this.myRenderContext.zoomFit(false, false);
            if (this.myPreviews != null) {
                for (RenderPreview preview : this.myPreviews) {
                    preview.setMaxSize(RenderPreviewManager.getMaxWidth(), RenderPreviewManager.getMaxHeight());
                }
            }
        }
        this.myRenderContext.updateLayout();
        this.layout(true);
        this.redraw();
    }

    @Nullable
    public List<RenderPreview> getPreviews() {
        return this.myPreviews;
    }

    static {
        ourClassicLayout = false;
    }

    private class SwapAnimation
    extends Animator {
        private static final int DURATION = 400;
        private Rectangle initialRect1;
        private Rectangle targetRect1;
        private Rectangle initialRect2;
        private Rectangle targetRect2;
        private RenderPreview preview;
        private Rectangle currentRectangle1;
        private Rectangle currentRectangle2;

        SwapAnimation(RenderPreview preview1, RenderPreview preview2) {
            super("Switch Configurations", 16, 400, false);
            this.initialRect1 = new Rectangle(preview1.getX(), preview1.getY(), preview1.getWidth(), preview1.getHeight());
            Dimension scaledImageSize = RenderPreviewManager.this.myRenderContext.getScaledImageSize();
            this.initialRect2 = new Rectangle(0, 0, scaledImageSize.width, scaledImageSize.height);
            this.preview = preview2;
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            if (this.targetRect1 == null) {
                Dimension scaledImageSize = RenderPreviewManager.this.myRenderContext.getScaledImageSize();
                this.targetRect1 = new Rectangle(0, 0, scaledImageSize.width, scaledImageSize.height);
            }
            double portion = (double)frame / (double)totalFrames;
            Rectangle rect1 = new Rectangle((int)(portion * (double)(this.targetRect1.x - this.initialRect1.x) + (double)this.initialRect1.x), (int)(portion * (double)(this.targetRect1.y - this.initialRect1.y) + (double)this.initialRect1.y), (int)(portion * (double)(this.targetRect1.width - this.initialRect1.width) + (double)this.initialRect1.width), (int)(portion * (double)(this.targetRect1.height - this.initialRect1.height) + (double)this.initialRect1.height));
            if (this.targetRect2 == null) {
                this.targetRect2 = new Rectangle(this.preview.getX(), this.preview.getY(), this.preview.getWidth(), this.preview.getHeight());
            }
            Rectangle rect2 = new Rectangle((int)(portion * (double)(this.targetRect2.x - this.initialRect2.x) + (double)this.initialRect2.x), (int)(portion * (double)(this.targetRect2.y - this.initialRect2.y) + (double)this.initialRect2.y), (int)(portion * (double)(this.targetRect2.width - this.initialRect2.width) + (double)this.initialRect2.width), (int)(portion * (double)(this.targetRect2.height - this.initialRect2.height) + (double)this.initialRect2.height));
            this.currentRectangle1 = rect1;
            this.currentRectangle2 = rect2;
            RenderPreviewManager.this.redraw();
        }

        private void paint(Graphics gc) {
            Rectangle rect2;
            gc.setColor(Color.DARK_GRAY);
            Rectangle rect1 = this.currentRectangle1;
            if (rect1 != null) {
                gc.drawRect(rect1.x, rect1.y, rect1.width, rect1.height);
            }
            if ((rect2 = this.currentRectangle2) != null) {
                gc.drawRect(rect2.x, rect2.y, rect2.width, rect2.height);
            }
        }

        protected void paintCycleEnd() {
            Disposer.dispose((Disposable)this);
            RenderPreviewManager.this.redraw();
        }

        public void dispose() {
            super.dispose();
            RenderPreviewManager.this.myAnimator = null;
        }
    }
}

