/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMissingAttributesFix
extends WriteCommandAction<Void> {
    @NotNull
    private final XmlFile myFile;
    @Nullable
    private final ResourceResolver myResourceResolver;

    public AddMissingAttributesFix(@NotNull Project project, @NotNull XmlFile file, @Nullable ResourceResolver resourceResolver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/AddMissingAttributesFix", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/AddMissingAttributesFix", "<init>"));
        }
        super(project, "Add Size Attributes", new PsiFile[]{file});
        this.myFile = file;
        this.myResourceResolver = resourceResolver;
    }

    @NotNull
    public List<XmlTag> findViewsMissingSizes() {
        final ArrayList missing = Lists.newArrayList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)AddMissingAttributesFix.this.myFile, XmlTag.class);
                for (XmlTag tag : xmlTags) {
                    if (!AddMissingAttributesFix.requiresSize(tag) || AddMissingAttributesFix.definesWidth(tag, AddMissingAttributesFix.this.myResourceResolver) && AddMissingAttributesFix.definesHeight(tag, AddMissingAttributesFix.this.myResourceResolver)) continue;
                    missing.add(tag);
                }
            }
        });
        ArrayList arrayList = missing;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AddMissingAttributesFix", "findViewsMissingSizes"));
        }
        return arrayList;
    }

    protected void run(@NotNull Result<Void> result) throws Throwable {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/AddMissingAttributesFix", "run"));
        }
        List<XmlTag> missing = this.findViewsMissingSizes();
        for (XmlTag tag : missing) {
            if (!AddMissingAttributesFix.definesWidth(tag, this.myResourceResolver)) {
                tag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", AddMissingAttributesFix.getDefaultWidth(tag));
            }
            if (AddMissingAttributesFix.definesHeight(tag, this.myResourceResolver)) continue;
            tag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", AddMissingAttributesFix.getDefaultHeight(tag));
        }
    }

    public static boolean definesHeight(@NotNull XmlTag tag, @Nullable ResourceResolver resourceResolver) {
        ResourceValue st;
        String style;
        boolean definesHeight;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/AddMissingAttributesFix", "definesHeight"));
        }
        XmlAttribute height = tag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android");
        boolean bl = definesHeight = height != null;
        if (definesHeight) {
            String value = height.getValue();
            if (value == null || value.isEmpty()) {
                return false;
            }
            return value.equals("wrap_content") || value.equals("fill_parent") || value.equals("match_parent") || value.startsWith("@") || value.startsWith("?") || Character.isDigit(value.charAt(0));
        }
        if (resourceResolver != null && (style = tag.getAttributeValue("style")) != null && (st = resourceResolver.findResValue(style, false)) instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)st;
            definesHeight = resourceResolver.findItemInStyle(styleValue, "layout_height", true) != null;
        }
        return definesHeight;
    }

    public static boolean definesWidth(@NotNull XmlTag tag, @Nullable ResourceResolver resourceResolver) {
        ResourceValue st;
        String style;
        boolean definesWidth;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/AddMissingAttributesFix", "definesWidth"));
        }
        XmlAttribute width = tag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android");
        boolean bl = definesWidth = width != null;
        if (definesWidth) {
            String value = width.getValue();
            if (value == null || value.isEmpty()) {
                return false;
            }
            return value.equals("wrap_content") || value.equals("fill_parent") || value.equals("match_parent") || value.startsWith("@") || value.startsWith("?") || Character.isDigit(value.charAt(0));
        }
        if (resourceResolver != null && (style = tag.getAttributeValue("style")) != null && (st = resourceResolver.findResValue(style, false)) instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)st;
            definesWidth = resourceResolver.findItemInStyle(styleValue, "layout_width", true) != null;
        }
        return definesWidth;
    }

    @NotNull
    private static String getDefaultWidth(@NotNull XmlTag tag) {
        String parent;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getDefaultWidth"));
        }
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && ((parent = parentTag.getName()).equals("FrameLayout") || parent.equals("TableLayout") || parent.equals("TableRow"))) {
            if ("match_parent" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getDefaultWidth"));
            }
            return "match_parent";
        }
        if ("wrap_content" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getDefaultWidth"));
        }
        return "wrap_content";
    }

    @NotNull
    private static String getDefaultHeight(@NotNull XmlTag tag) {
        String parent;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getDefaultHeight"));
        }
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && (parent = parentTag.getName()).equals("FrameLayout")) {
            if ("match_parent" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getDefaultHeight"));
            }
            return "match_parent";
        }
        if ("wrap_content" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getDefaultHeight"));
        }
        return "wrap_content";
    }

    @Nullable
    private static XmlTag getParentTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/AddMissingAttributesFix", "getParentTag"));
        }
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    private static boolean requiresSize(XmlTag tag) {
        String parentName;
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && ("GridLayout".equals(parentName = parentTag.getName()) || "android.support.v7.widget.GridLayout".equals(parentName))) {
            return false;
        }
        String tagName = tag.getName();
        return !tagName.equals("requestFocus") && !tagName.equals("merge") && !tagName.equals("include");
    }
}

