/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.ddmlib.Client;
import com.android.tools.idea.profiling.capture.AsyncWriterDelegate;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureService {
    public static final String FD_CAPTURES = "captures";
    @NotNull
    private final Project myProject;
    @NotNull
    private Multimap<CaptureType, Capture> myCaptures;
    private List<CaptureListener> myListeners;
    @Nullable
    private AsyncWriterDelegate myAsyncWriterDelegate;
    @NotNull
    private Set<CaptureHandle> myOpenCaptureHandles;

    public CaptureService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/capture/CaptureService", "<init>"));
        }
        this.myProject = project;
        this.myCaptures = LinkedListMultimap.create();
        this.myListeners = new LinkedList<CaptureListener>();
        this.myOpenCaptureHandles = new HashSet<CaptureHandle>();
        this.update();
    }

    @NotNull
    public static CaptureService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/capture/CaptureService", "getInstance"));
        }
        CaptureService captureService = (CaptureService)ServiceManager.getService((Project)project, CaptureService.class);
        if (captureService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getInstance"));
        }
        return captureService;
    }

    private static Set<VirtualFile> findCaptureFiles(@NotNull VirtualFile[] files, @NotNull CaptureType type) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/profiling/capture/CaptureService", "findCaptureFiles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/profiling/capture/CaptureService", "findCaptureFiles"));
        }
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            if (!type.isValidCapture(file)) continue;
            set.add(file);
        }
        return set;
    }

    @NotNull
    public String getSuggestedName(@Nullable Client client) {
        String name;
        String timestamp = new SimpleDateFormat("yyyy.MM.dd_HH.mm").format(new Date());
        if (client != null && (name = client.getClientData().getClientDescription()) != null && name.length() > 0) {
            String string = name + "_" + timestamp;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getSuggestedName"));
            }
            return string;
        }
        String string = this.myProject.getName() + "_" + timestamp;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getSuggestedName"));
        }
        return string;
    }

    public void update() {
        CaptureTypeService service = CaptureTypeService.getInstance();
        VirtualFile dir = this.getCapturesDirectory();
        LinkedListMultimap updated = LinkedListMultimap.create();
        if (dir != null) {
            VirtualFile[] children = VfsUtil.getChildren((VirtualFile)dir);
            for (CaptureType type : service.getCaptureTypes()) {
                Set<VirtualFile> files = CaptureService.findCaptureFiles(children, type);
                for (Capture capture : this.myCaptures.get((Object)type)) {
                    if (!files.remove(capture.getFile())) continue;
                    updated.put((Object)type, (Object)capture);
                }
                for (VirtualFile newFile : files) {
                    updated.put((Object)type, (Object)type.createCapture(newFile));
                }
            }
        }
        this.myCaptures = updated;
    }

    @NotNull
    public VirtualFile createCapturesDirectory() throws IOException {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        if (projectDir != null) {
            VirtualFile dir = projectDir.findChild(FD_CAPTURES);
            if (dir == null) {
                dir = projectDir.createChildDirectory(null, FD_CAPTURES);
            }
            VirtualFile virtualFile = dir;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "createCapturesDirectory"));
            }
            return virtualFile;
        }
        throw new IOException("Unable to create the captures directory: Project directory not found.");
    }

    @Nullable
    public VirtualFile getCapturesDirectory() {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        return projectDir != null ? projectDir.findChild(FD_CAPTURES) : null;
    }

    @NotNull
    public Multimap<CaptureType, Capture> getCapturesByType() {
        Multimap<CaptureType, Capture> multimap = this.myCaptures;
        if (multimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getCapturesByType"));
        }
        return multimap;
    }

    @NotNull
    public Collection<Capture> getCaptures() {
        Collection collection = this.myCaptures.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getCaptures"));
        }
        return collection;
    }

    @NotNull
    public Collection<CaptureType> getTypes() {
        Set set = this.myCaptures.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getTypes"));
        }
        return set;
    }

    public CaptureHandle startCaptureFile(@NotNull Class<? extends CaptureType> clazz, @NotNull String name) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/profiling/capture/CaptureService", "startCaptureFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/profiling/capture/CaptureService", "startCaptureFile"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAsyncWriterDelegate == null) {
            this.myAsyncWriterDelegate = new AsyncWriterDelegate();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myAsyncWriterDelegate);
        }
        CaptureHandle handle = this.startCaptureFileSynchronous(clazz, name);
        this.myOpenCaptureHandles.add(handle);
        return handle;
    }

    public void appendDataCopy(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "appendDataCopy"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/profiling/capture/CaptureService", "appendDataCopy"));
        }
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, Arrays.copyOf(data, data.length));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void appendData(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "appendData"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/profiling/capture/CaptureService", "appendData"));
        }
        try {
            assert (this.myAsyncWriterDelegate != null);
            this.myAsyncWriterDelegate.queueWrite(captureHandle, data);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void cancelCaptureFile(@NotNull CaptureHandle captureHandle) {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "cancelCaptureFile"));
        }
        this.finalizeCaptureFileAsynchronous(captureHandle, null, null);
    }

    Capture finalizeCaptureFileSynchronous(@NotNull CaptureHandle captureHandle) throws InterruptedException, IOException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "finalizeCaptureFileSynchronous"));
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        return this.createCapture(captureHandle);
    }

    public void finalizeCaptureFileAsynchronous(final @NotNull CaptureHandle captureHandle, @Nullable FutureCallback<Capture> onCompletion, @Nullable Executor executor) {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "finalizeCaptureFileAsynchronous"));
        }
        final ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Capture>(){

            @Override
            public Capture call() throws Exception {
                ApplicationManager.getApplication().assertIsDispatchThread();
                return CaptureService.this.createCapture(captureHandle);
            }
        });
        if (onCompletion != null) {
            assert (executor != null);
            Futures.addCallback((ListenableFuture)task, onCompletion, (Executor)executor);
        }
        this.closeCaptureFileInternal(captureHandle, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)task);
            }
        });
    }

    public boolean captureExists(String name) throws IOException {
        VirtualFile dir = this.createCapturesDirectory();
        return dir.findChild(name) != null;
    }

    private void closeCaptureFileInternal(@NotNull CaptureHandle captureHandle, @NotNull Runnable postCloseTask) {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "closeCaptureFileInternal"));
        }
        if (postCloseTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCloseTask", "com/android/tools/idea/profiling/capture/CaptureService", "closeCaptureFileInternal"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myOpenCaptureHandles.contains(captureHandle));
        assert (captureHandle.isWritable());
        assert (this.myAsyncWriterDelegate != null);
        try {
            this.myAsyncWriterDelegate.closeFileAndRunTaskAsynchronously(captureHandle, postCloseTask);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myOpenCaptureHandles.remove(captureHandle);
        if (this.myOpenCaptureHandles.isEmpty()) {
            try {
                assert (this.myAsyncWriterDelegate != null);
                this.myAsyncWriterDelegate.queueExit();
                this.myAsyncWriterDelegate = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Capture createCapture(Class<? extends CaptureType> clazz, byte[] data, @NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/profiling/capture/CaptureService", "createCapture"));
        }
        CaptureHandle captureHandle = this.startCaptureFileSynchronous(clazz, name);
        try {
            CaptureService.appendDataSynchronous(captureHandle, data);
        }
        finally {
            captureHandle.closeFileOutputStream();
        }
        Capture capture = this.createCapture(captureHandle);
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "createCapture"));
        }
        return capture;
    }

    public void addListener(@NotNull CaptureListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/profiling/capture/CaptureService", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void notifyCaptureReady(@NotNull Capture capture) {
        if (capture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capture", "com/android/tools/idea/profiling/capture/CaptureService", "notifyCaptureReady"));
        }
        for (CaptureListener listener : this.myListeners) {
            listener.onReady(capture);
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, capture.getFile());
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
    }

    @NotNull
    private CaptureHandle startCaptureFileSynchronous(@NotNull Class<? extends CaptureType> clazz, final @Nullable String name) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/profiling/capture/CaptureService", "startCaptureFileSynchronous"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final CaptureType type = CaptureTypeService.getInstance().getType(clazz);
        assert (type != null);
        UsageTracker.getInstance().trackEvent("profiling", "captureCreated", type.getName(), null);
        File file = (File)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<File, IOException>(){

            public File compute() throws IOException {
                VirtualFile dir = CaptureService.this.createCapturesDirectory();
                return new File(dir.createChildData(null, CaptureService.this.getCaptureFileName(name, type.getCaptureExtension())).getPath());
            }
        });
        CaptureHandle captureHandle = new CaptureHandle(file, type);
        if (captureHandle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "startCaptureFileSynchronous"));
        }
        return captureHandle;
    }

    @NotNull
    private String getCaptureFileName(@Nullable String name, @NotNull String extension) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/android/tools/idea/profiling/capture/CaptureService", "getCaptureFileName"));
        }
        String filename = name + extension;
        if (!this.captureExists(filename)) {
            String string = filename;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getCaptureFileName"));
            }
            return string;
        }
        int i = 1;
        while (true) {
            if (!this.captureExists(filename = String.format("%s-%d%s", name, i, extension))) {
                String string = filename;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "getCaptureFileName"));
                }
                return string;
            }
            ++i;
        }
    }

    static void appendDataSynchronous(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws IOException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "appendDataSynchronous"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/profiling/capture/CaptureService", "appendDataSynchronous"));
        }
        CaptureService.appendDataSynchronous(captureHandle, data, 0, data.length);
    }

    public static void appendDataSynchronous(@NotNull CaptureHandle captureHandle, @NotNull byte[] data, int offset, int length) throws IOException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "appendDataSynchronous"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/profiling/capture/CaptureService", "appendDataSynchronous"));
        }
        FileOutputStream localFileOutputStream = captureHandle.getFileOutputStream();
        assert (localFileOutputStream != null);
        localFileOutputStream.write(data, offset, length);
    }

    @NotNull
    private Capture createCapture(@NotNull CaptureHandle captureHandle) throws IOException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/CaptureService", "createCapture"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!captureHandle.isWritable());
        final File file = captureHandle.getFile();
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return VfsUtil.findFileByIoFile((File)file, (boolean)true);
            }
        });
        if (vf == null) {
            throw new IOException("Cannot find virtual file for capture file \"" + file.getPath() + "\"");
        }
        CaptureType type = captureHandle.getCaptureType();
        for (Capture capture : this.myCaptures.get((Object)type)) {
            if (!vf.equals(capture.getFile())) continue;
            Capture capture2 = capture;
            if (capture2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "createCapture"));
            }
            return capture2;
        }
        Capture capture = type.createCapture(vf);
        this.myCaptures.put((Object)type, (Object)capture);
        Capture capture3 = capture;
        if (capture3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/CaptureService", "createCapture"));
        }
        return capture3;
    }

    public static interface CaptureListener {
        public void onReady(Capture var1);
    }
}

