/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.model.ArtifactDependencyMergedModel;
import com.android.tools.idea.gradle.structure.configurables.model.Coordinates;
import com.android.tools.idea.gradle.structure.configurables.model.DependencyMergedModel;
import com.android.tools.idea.structure.dialog.HeaderPanel;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

class DependenciesTreePanel
extends JPanel {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DependenciesTreeBuilder myTreeBuilder;
    private volatile boolean myProgrammaticSelection;

    DependenciesTreePanel(final @NotNull DependenciesPanel dependenciesPanel) {
        if (dependenciesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesPanel", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreePanel", "<init>"));
        }
        super(new BorderLayout());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myTree = new Tree((TreeModel)treeModel);
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.setRootVisible(false);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (DependenciesTreePanel.this.myProgrammaticSelection) {
                    DependenciesTreePanel.this.myProgrammaticSelection = false;
                    return;
                }
                Set selection = DependenciesTreePanel.this.myTreeBuilder.getSelectedElements(DependenciesTreeStructure.ArtifactNode.class);
                if (selection.size() == 1) {
                    DependenciesTreeStructure.ArtifactNode selected = (DependenciesTreeStructure.ArtifactNode)((Object)ContainerUtil.getFirstItem((Collection)selection));
                    assert (selected != null);
                    ArtifactDependencyMergedModel dependency = selected.dependencyModel;
                    if (dependency == null) {
                        DependenciesTreePanel.this.select(selected.coordinate);
                    } else {
                        dependenciesPanel.select(dependency);
                    }
                }
            }
        });
        this.myTreeBuilder = new DependenciesTreeBuilder(dependenciesPanel, this.myTree, treeModel);
        this.add((Component)new HeaderPanel("Variants"), "North");
        this.add((Component)new JBScrollPane((Component)this.myTree), "Center");
        ActionCallback initialized = this.myTreeBuilder.getInitialized();
        initialized.doWhenDone(new Runnable(){

            @Override
            public void run() {
                dependenciesPanel.selectInTreeView();
            }
        });
    }

    void clearSelection() {
        this.myTree.getSelectionModel().clearSelection();
    }

    void select(@NotNull DependencyMergedModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreePanel", "select"));
        }
        if (dependency instanceof ArtifactDependencyMergedModel) {
            ArtifactDependencyMergedModel artifactDependency = (ArtifactDependencyMergedModel)dependency;
            this.select(artifactDependency.getCoordinate());
        }
    }

    private void select(@NotNull GradleCoordinate coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreePanel", "select"));
        }
        DefaultMutableTreeNode rootNode = this.myTreeBuilder.getRootNode();
        if (rootNode != null) {
            ArrayList selectionPaths = Lists.newArrayList();
            int variantCount = rootNode.getChildCount();
            for (int i = 0; i < variantCount; ++i) {
                DefaultMutableTreeNode variantNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                DependenciesTreePanel.collectMatchingDependencies(coordinate, variantNode, selectionPaths);
            }
            if (!selectionPaths.isEmpty()) {
                this.clearSelection();
                this.myProgrammaticSelection = true;
                this.myTree.setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
            }
        }
    }

    private static void collectMatchingDependencies(@NotNull GradleCoordinate coordinate, @NotNull DefaultMutableTreeNode parentNode, @NotNull List<TreePath> selectionPaths) {
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreePanel", "collectMatchingDependencies"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreePanel", "collectMatchingDependencies"));
        }
        if (selectionPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionPaths", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreePanel", "collectMatchingDependencies"));
        }
        int dependencyCount = parentNode.getChildCount();
        for (int i = 0; i < dependencyCount; ++i) {
            DefaultMutableTreeNode dependencyNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Object userObject = dependencyNode.getUserObject();
            if (!(userObject instanceof DependenciesTreeStructure.ArtifactNode)) continue;
            DependenciesTreeStructure.ArtifactNode artifactNode = (DependenciesTreeStructure.ArtifactNode)((Object)userObject);
            if (Coordinates.areEqual(artifactNode.coordinate, coordinate)) {
                TreePath path = new TreePath(dependencyNode.getPath());
                selectionPaths.add(path);
            }
            DependenciesTreePanel.collectMatchingDependencies(coordinate, dependencyNode, selectionPaths);
        }
    }
}

